/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;
import javax.management.monitor.StringAlarmClock;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private static final String[] types = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
    private String stringToCompare = "";
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private transient String derivedGauge = "";
    private transient long derivedGaugeTimestamp = new Date().getTime();
    private transient int status = 2;
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;
    private transient StringAlarmClock alarmClock = null;

    String makeDebugTag() {
        return "StringMonitor";
    }

    public StringMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the string monitor");
        }
        if (!this.isActive()) {
            this.isActive = true;
            this.status = 2;
            this.alarmClock = new StringAlarmClock(this);
            this.alarmClock.start();
        } else if (this.isTraceOn()) {
            this.trace("start", "the string monitor is already activated");
        }
    }

    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the string monitor");
        }
        if (this.isActive()) {
            if (this.alarmClock != null) {
                this.alarmClock.interrupt();
                try {
                    this.alarmClock.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.alarmClock = null;
            }
            this.isActive = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "the string monitor is already deactivated");
        }
    }

    public synchronized String getDerivedGauge() {
        return this.derivedGauge;
    }

    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp;
    }

    public synchronized String getStringToCompare() {
        return this.stringToCompare;
    }

    public synchronized void setStringToCompare(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("The string to compare cannot be null.");
        }
        this.stringToCompare = string;
        this.status = 2;
    }

    public synchronized boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public synchronized void setNotifyMatch(boolean bl) {
        this.notifyMatch = bl;
    }

    public synchronized boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public synchronized void setNotifyDiffer(boolean bl) {
        this.notifyDiffer = bl;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    private void updateDerivedGauge(Object object) {
        this.derivedGaugeTimestamp = new Date().getTime();
        this.derivedGauge = (String)object;
    }

    private void updateNotifications() {
        if (this.status == 2) {
            if (this.derivedGauge.equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.stringToCompare);
                }
                this.status = 1;
            } else {
                if (this.notifyDiffer) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.stringToCompare);
                }
                this.status = 0;
            }
        } else if (this.status == 0) {
            if (this.derivedGauge.equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.stringToCompare);
                }
                this.status = 1;
            }
        } else if (this.status == 1 && !this.derivedGauge.equals(this.stringToCompare)) {
            if (this.notifyDiffer) {
                this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.stringToCompare);
            }
            this.status = 0;
        }
    }

    void notifyAlarmClock() {
        block17: {
            Object object = null;
            String string = null;
            try {
                if (!this.isActive()) break block17;
                if (this.getObservedObject() == null || this.getObservedAttribute() == null) {
                    return;
                }
                try {
                    object = this.server.getAttribute(this.getObservedObject(), this.getObservedAttribute());
                    if (object == null) {
                        return;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if ((this.alreadyNotified & 8) != 0) {
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.alreadyNotified |= 8;
                    throw new MonitorSettingException("The string monitor must be registered in the MBean server.");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.alreadyNotified & 1) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_OBJECT_ERROR;
                    this.alreadyNotified |= 1;
                    throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if ((this.alreadyNotified & 2) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.alreadyNotified |= 2;
                    throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                }
                catch (MBeanException mBeanException) {
                    if ((this.alreadyNotified & 8) != 0) {
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.alreadyNotified |= 8;
                    throw new MonitorSettingException(mBeanException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    if ((this.alreadyNotified & 2) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.alreadyNotified |= 2;
                    throw new MonitorSettingException(reflectionException.getMessage());
                }
                if (!(object instanceof String)) {
                    if ((this.alreadyNotified & 4) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                    this.alreadyNotified |= 4;
                    throw new MonitorSettingException("The observed attribute type must be a string type.");
                }
                this.alreadyNotified = 0;
                this.updateDerivedGauge(object);
                this.updateNotifications();
            }
            catch (MonitorSettingException monitorSettingException) {
                this.sendNotification(string, this.derivedGaugeTimestamp, monitorSettingException.getMessage(), this.derivedGauge, null);
                this.status = 2;
            }
        }
    }
}

