/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm.usmmib;

import com.sun.jdmk.internal.snmp.SnmpTools;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.usm.SnmpUsmAlgorithm;
import com.sun.jdmk.snmp.usm.SnmpUsmException;
import com.sun.jdmk.snmp.usm.SnmpUsmLcd;
import com.sun.jdmk.snmp.usm.SnmpUsmSecureUser;
import com.sun.jdmk.snmp.usm.usmmib.EnumUsmUserStatus;
import com.sun.jdmk.snmp.usm.usmmib.EnumUsmUserStorageType;
import com.sun.jdmk.snmp.usm.usmmib.TableUsmUserTableImpl;
import com.sun.jdmk.snmp.usm.usmmib.UsmUserEntry;
import com.sun.jdmk.trace.Trace;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;

public class UsmUserEntryImpl
extends UsmUserEntry {
    SnmpUsmSecureUser user = null;
    SnmpUsmLcd lcd = null;
    UsmUserEntryImpl original = null;
    TableUsmUserTableImpl table = null;
    private String dbgTag = "UsmUserEntryImpl";
    SnmpOid oid = null;
    private String prefix = null;

    public UsmUserEntryImpl(SnmpEngine snmpEngine, SnmpMib snmpMib, SnmpUsmLcd snmpUsmLcd, SnmpUsmSecureUser snmpUsmSecureUser, TableUsmUserTableImpl tableUsmUserTableImpl) {
        super(snmpMib);
        this.prefix = snmpEngine.getEngineId().toString() + "/UsmUserTable:";
        this.user = snmpUsmSecureUser;
        this.table = tableUsmUserTableImpl;
        this.UsmUserAuthKeyChange = null;
        this.UsmUserPrivKeyChange = null;
        this.lcd = snmpUsmLcd;
    }

    synchronized void setUser(SnmpUsmSecureUser snmpUsmSecureUser) {
        this.user = snmpUsmSecureUser;
    }

    synchronized SnmpUsmSecureUser getUser() {
        return this.user;
    }

    private String convertAuthAlgorithm(SnmpUsmAlgorithm snmpUsmAlgorithm) {
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            return "1.3.6.1.6.3.10.1.1.1";
        }
        return this.getUser().getAuthPair().algo.getOid();
    }

    private String convertPrivAlgorithm() {
        if ((this.getUser().getSecurityLevel() & 2) == 0) {
            return "1.3.6.1.6.3.10.1.2.1";
        }
        return this.getUser().getPrivPair().algo.getOid();
    }

    protected ObjectName createObjectName() throws MalformedObjectNameException {
        String string = this.user.getEngineId().toString();
        return new ObjectName(this.prefix + "name=" + this.user.getName());
    }

    public void addInMBeanServer(MBeanServer mBeanServer) {
        block2: {
            try {
                mBeanServer.registerMBean(this, this.createObjectName());
            }
            catch (Exception exception) {
                if (!this.isTraceOn()) break block2;
                this.trace("addInMBeanServer", exception.toString());
            }
        }
    }

    public void removeFromMBeanServer(MBeanServer mBeanServer) {
        block2: {
            try {
                mBeanServer.unregisterMBean(this.createObjectName());
            }
            catch (Exception exception) {
                if (!this.isTraceOn()) break block2;
                this.trace("addInMBeanServer", exception.toString());
            }
        }
    }

    public String getUsmUserSecurityName() throws SnmpStatusException {
        return this.getUser().getSecurityName();
    }

    public Byte[] getUsmUserPrivKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public void setUsmUserPrivKeyChange(Byte[] byteArray) throws SnmpStatusException {
        if ((this.getUser().getSecurityLevel() & 2) == 0) {
            if (this.isDebugOn()) {
                this.debug("setUsmUserPrivKeyChange", "No privacy, return.");
            }
            return;
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserPrivKeyChange", "Will do priv key change.");
        }
        Byte[] byteArray2 = this.getUsmUserPublic();
        if (this.isDebugOn()) {
            this.debug("setUsmUserPrivKeyChange", "Random is : " + byteArray2);
        }
        byte[] byArray = new byte[byteArray.length + byteArray2.length];
        int n = 0;
        while (n < byteArray2.length) {
            byArray[n] = byteArray2[n];
            ++n;
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserPrivKeyChange", "Random is : " + SnmpTools.binary2ascii((byte[])byArray, (int)byteArray2.length));
        }
        int n2 = 0;
        while (n2 < byteArray.length) {
            byArray[n2 + byteArray2.length] = byteArray[n2];
            ++n2;
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserPrivKeyChange", "Received key change : " + SnmpTools.binary2ascii((byte[])byArray));
        }
        this.lcd.setUserPrivKeyChange(this.user, byArray);
        super.setUsmUserPrivKeyChange(byteArray);
    }

    public Byte[] getUsmUserAuthKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public void setUsmUserAuthKeyChange(Byte[] byteArray) throws SnmpStatusException {
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            if (this.isDebugOn()) {
                this.debug("setUsmUserAuthKeyChange", "No authentication, return.");
            }
            return;
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserAuthKeyChange", "Will do auth key change.");
        }
        Byte[] byteArray2 = this.getUsmUserPublic();
        if (this.isDebugOn()) {
            this.debug("setUsmUserAuthKeyChange", "Random is : " + byteArray2);
        }
        byte[] byArray = new byte[byteArray.length + byteArray2.length];
        int n = 0;
        while (n < byteArray2.length) {
            byArray[n] = byteArray2[n];
            ++n;
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserAuthKeyChange", "Random is : " + SnmpTools.binary2ascii((byte[])byArray, (int)byteArray2.length));
        }
        int n2 = 0;
        while (n2 < byteArray.length) {
            byArray[n2 + byteArray2.length] = byteArray[n2];
            ++n2;
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserAuthKeyChange", "Received key change : " + SnmpTools.binary2ascii((byte[])byArray));
        }
        this.lcd.setUserAuthKeyChange(this.user, byArray);
        super.setUsmUserAuthKeyChange(byteArray);
    }

    public void setUsmUserOwnPrivKeyChange(Byte[] byteArray) throws SnmpStatusException {
        this.setUsmUserPrivKeyChange(byteArray);
    }

    public Byte[] getUsmUserOwnPrivKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public Byte[] getUsmUserOwnAuthKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public void setUsmUserOwnAuthKeyChange(Byte[] byteArray) throws SnmpStatusException {
        this.setUsmUserAuthKeyChange(byteArray);
    }

    public String getUsmUserPrivProtocol() throws SnmpStatusException {
        return this.convertPrivAlgorithm();
    }

    public void setUsmUserPrivProtocol(String string) throws SnmpStatusException {
        super.setUsmUserPrivProtocol(string);
        if (this.isDebugOn()) {
            this.debug("setUsmUserPrivProtocol", "priv protocol : " + string);
        }
        this.user.setPrivAlgorithm(string);
    }

    public void checkUsmUserPrivProtocol(String string) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("checkUsmUserPrivProtocol", "priv protocol : " + string);
        }
        if (string.equals("1.3.6.1.6.3.10.1.2.1")) {
            if (this.isDebugOn()) {
                this.debug("checkUsmUserPrivProtocol", "priv protocol will be set to no protocol");
            }
            return;
        }
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            if (this.isDebugOn()) {
                this.debug("checkUsmUserPrivProtocol", "Unsupported security level. Security level is : " + (this.getUser().getSecurityLevel() & 2));
            }
            throw new SnmpStatusException(12);
        }
        if (this.getUsmUserStatus().intValue() == 1) {
            if (this.isDebugOn()) {
                this.debug("checkUsmUserPrivProtocol", "Status already active, failed");
            }
            throw new SnmpStatusException(12);
        }
        if (this.lcd.getAlgorithmManager().getAlgorithm(string) == null) {
            if (this.isDebugOn()) {
                this.debug("checkUsmUserPrivProtocol", "Unknown algo : " + string);
            }
            throw new SnmpStatusException(10);
        }
    }

    public String getUsmUserAuthProtocol() throws SnmpStatusException {
        return this.convertAuthAlgorithm((SnmpUsmAlgorithm)this.user.getAuthPair().algo);
    }

    public void setUsmUserAuthProtocol(String string) throws SnmpStatusException {
        super.setUsmUserAuthProtocol(string);
        if (this.isDebugOn()) {
            this.debug("setUsmUserAuthProtocol", "auth protocol : " + string);
        }
        this.user.setAuthAlgorithm(string);
    }

    public void checkUsmUserAuthProtocol(String string) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("checkUsmUserAuthProtocol", "auth protocol : " + string);
        }
        if (string.equals("1.3.6.1.6.3.10.1.1.1")) {
            if ((this.getUser().getSecurityLevel() & 2) != 0) {
                if (this.isDebugOn()) {
                    this.debug("checkUsmUserAuthProtocol", "Unsupported security level. Security level is : " + (this.getUser().getSecurityLevel() & 2));
                }
                throw new SnmpStatusException(12);
            }
            if (this.isDebugOn()) {
                this.debug("checkUsmUserAuthProtocol", "auth protocol is no protocol.");
            }
            return;
        }
        if (this.getUsmUserStatus().intValue() == 1) {
            if (this.isDebugOn()) {
                this.debug("checkUsmUserAuthProtocol", "auth protocol already active. Failed");
            }
            throw new SnmpStatusException(12);
        }
        if (this.lcd.getAlgorithmManager().getAlgorithm(string) == null) {
            if (this.isDebugOn()) {
                this.debug("checkUsmUserAuthProtocol", "Unknown algo : " + string);
            }
            throw new SnmpStatusException(10);
        }
    }

    public EnumUsmUserStorageType getUsmUserStorageType() throws SnmpStatusException {
        EnumUsmUserStorageType enumUsmUserStorageType = new EnumUsmUserStorageType(this.user.getStorageType());
        return enumUsmUserStorageType;
    }

    public void setUsmUserStorageType(EnumUsmUserStorageType enumUsmUserStorageType) throws SnmpStatusException {
        super.setUsmUserStorageType(enumUsmUserStorageType);
        if (this.isDebugOn()) {
            this.debug("setUsmUserStorageType", "Enum : " + enumUsmUserStorageType.toString());
        }
        this.user.setStorageType(enumUsmUserStorageType.intValue());
    }

    public void checkUsmUserStorageType(EnumUsmUserStorageType enumUsmUserStorageType) throws SnmpStatusException {
        if (enumUsmUserStorageType.intValue() != 3 && enumUsmUserStorageType.intValue() != 2) {
            if (this.isDebugOn()) {
                this.debug("checkUsmUserStorageType", "Wrong storage type :" + enumUsmUserStorageType.intValue());
            }
            throw new SnmpStatusException(10);
        }
        if (this.lcd.getStorageType() < enumUsmUserStorageType.intValue()) {
            if (this.isDebugOn()) {
                this.debug("checkUsmUserStorageType", "Unsupported storage type :" + enumUsmUserStorageType.intValue());
            }
            throw new SnmpStatusException(12);
        }
    }

    public Byte[] getUsmUserEngineID() throws SnmpStatusException {
        byte[] byArray = this.user.getEngineId().getBytes();
        Byte[] byteArray = new Byte[byArray.length];
        int n = 0;
        while (n < byteArray.length) {
            byteArray[n] = new Byte(byArray[n]);
            ++n;
        }
        return byteArray;
    }

    public String getUsmUserName() throws SnmpStatusException {
        return this.user.getName();
    }

    public String getUsmUserCloneFrom() throws SnmpStatusException {
        return "0.0";
    }

    public void checkUsmUserCloneFrom(String string) throws SnmpStatusException {
        if (this.original != null) {
            return;
        }
        try {
            this.original = this.table.getCloneFromUser(string);
        }
        catch (SnmpStatusException snmpStatusException) {
            throw new SnmpStatusException(18);
        }
        if (this.original == null) {
            throw new SnmpStatusException(18);
        }
        this.UsmUserCloneFrom = string;
        EnumUsmUserStatus enumUsmUserStatus = this.original.getUsmUserStatus();
        if (enumUsmUserStatus.intValue() != 1) {
            throw new SnmpStatusException(18);
        }
    }

    public void setUsmUserCloneFrom(String string) throws SnmpStatusException {
        if (this.original == null) {
            if (this.isDebugOn()) {
                this.debug("setUsmUserCloneFrom", "original == null");
            }
            throw new SnmpStatusException(18);
        }
        SnmpUsmSecureUser snmpUsmSecureUser = this.original.getUser();
        if (this.isDebugOn()) {
            this.debug("setUsmUserCloneFrom", "Auth pair algo : " + snmpUsmSecureUser.getAuthPair().algo);
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserCloneFrom", "Auth pair key : " + snmpUsmSecureUser.getAuthPair().key);
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserCloneFrom", "Priv pair algo : " + snmpUsmSecureUser.getPrivPair().algo);
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserCloneFrom", "Priv pair key: " + snmpUsmSecureUser.getPrivPair().key);
        }
        this.user.cloneAuthPair(snmpUsmSecureUser.getAuthPair());
        this.user.clonePrivPair(snmpUsmSecureUser.getPrivPair());
        super.setUsmUserCloneFrom(string);
    }

    public void setUsmUserStatus(EnumUsmUserStatus enumUsmUserStatus) throws SnmpStatusException {
        if (this.getUsmUserStatus().intValue() == 1) {
            if (this.isDebugOn()) {
                this.debug("setUsmUserStatus", "Already active. Return");
            }
            return;
        }
        if (this.user.isTemplate()) {
            super.setUsmUserStatus(enumUsmUserStatus);
            return;
        }
        if (this.isDebugOn()) {
            this.debug("setUsmUserStatus", "Setting status to : " + enumUsmUserStatus.intValue());
        }
        if (enumUsmUserStatus.intValue() == 1) {
            try {
                this.lcd.addUser(this.user, false);
            }
            catch (SnmpUsmException snmpUsmException) {
                if (this.isDebugOn()) {
                    this.debug("setUsmUserStatus", " error when adding a user : " + (Object)((Object)snmpUsmException));
                }
                throw new SnmpStatusException(15);
            }
        }
        super.setUsmUserStatus(enumUsmUserStatus);
    }

    public void checkUsmUserStatus(EnumUsmUserStatus enumUsmUserStatus) throws SnmpStatusException {
        if (this.getUsmUserStatus().intValue() == 1) {
            if (this.isDebugOn()) {
                this.debug("checkUsmUserStatus", "Already active. Return");
            }
            return;
        }
        if (enumUsmUserStatus.intValue() == 1) {
            if (this.original == null) {
                if (this.isDebugOn()) {
                    this.debug("checkUsmUserStatus", "cloneFrom not done. Can't switch to active state.");
                }
                throw new SnmpStatusException(12);
            }
            if (this.user.getAuthPair().algo != null && this.user.getAuthPair().key != null && this.UsmUserAuthKeyChange == null) {
                if (this.isDebugOn()) {
                    this.debug("checkUsmUserStatus", "Auth key change not done. Can't switch to active state.");
                }
                throw new SnmpStatusException(12);
            }
            if (this.user.getPrivPair().algo != null && this.user.getPrivPair().key != null && this.UsmUserPrivKeyChange == null) {
                if (this.isDebugOn()) {
                    this.debug("checkUsmUserStatus", "Priv key change not done. Can't switch to active state.");
                }
                throw new SnmpStatusException(12);
            }
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

