/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm.usmmib;

import com.sun.jdmk.snmp.agent.SnmpIndex;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.agent.SnmpMibSubRequest;
import com.sun.jdmk.snmp.agent.SnmpMibTable;
import com.sun.jdmk.snmp.usm.SnmpUsmAlgorithm;
import com.sun.jdmk.snmp.usm.SnmpUsmLcd;
import com.sun.jdmk.snmp.usm.SnmpUsmMibTable;
import com.sun.jdmk.snmp.usm.SnmpUsmSecureUser;
import com.sun.jdmk.snmp.usm.usmmib.EnumUsmUserStatus;
import com.sun.jdmk.snmp.usm.usmmib.TableUsmUserTable;
import com.sun.jdmk.snmp.usm.usmmib.UsmUserEntryImpl;
import com.sun.jdmk.trace.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;

public class TableUsmUserTableImpl
extends TableUsmUserTable
implements SnmpUsmMibTable {
    SnmpUsmLcd lcd = null;
    SnmpEngine engine = null;
    Hashtable templates = new Hashtable();
    String dbgTag = "TableUsmUserTableImpl";

    public Object createUsmUserEntryMBean(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n, ObjectName objectName, SnmpMibTable snmpMibTable, Byte[] byteArray, String string) throws SnmpStatusException {
        byte[] byArray = new byte[byteArray.length];
        int n2 = 0;
        while (n2 < byteArray.length) {
            byArray[n2] = byteArray[n2];
            ++n2;
        }
        if (this.isDebugOn()) {
            this.debug("createUsmUserEntryMBean", "Creating new user : " + string);
        }
        SnmpUsmSecureUser snmpUsmSecureUser = null;
        snmpUsmSecureUser = this.lcd.createNewUser(byArray, string);
        snmpUsmSecureUser.setStorageType(3);
        snmpUsmSecureUser.setAuthAlgorithm("1.3.6.1.6.3.10.1.1.1.0");
        snmpUsmSecureUser.setPrivAlgorithm("1.3.6.1.6.3.10.1.2.1.0");
        UsmUserEntryImpl usmUserEntryImpl = this.createUsmUserEntry(this.engine, this.theMib, this.lcd, snmpUsmSecureUser, snmpMibTable);
        return usmUserEntryImpl;
    }

    UsmUserEntryImpl getCloneFromUser(String string) throws SnmpStatusException {
        UsmUserEntryImpl usmUserEntryImpl = null;
        if (this.isDebugOn()) {
            this.debug("getCloneFromUser", "cloneFromUser : " + string);
        }
        if ((usmUserEntryImpl = (UsmUserEntryImpl)this.templates.get(string)) == null) {
            SnmpOid snmpOid = new SnmpOid(string);
            usmUserEntryImpl = (UsmUserEntryImpl)this.meta.getEntry(snmpOid);
        }
        if (this.isDebugOn()) {
            this.debug("getCloneFromUser", "cloneFromUser : " + usmUserEntryImpl);
        }
        return usmUserEntryImpl;
    }

    protected UsmUserEntryImpl createUsmUserEntry(SnmpEngine snmpEngine, SnmpMib snmpMib, SnmpUsmLcd snmpUsmLcd, SnmpUsmSecureUser snmpUsmSecureUser, SnmpMibTable snmpMibTable) {
        return new UsmUserEntryImpl(snmpEngine, this.theMib, snmpUsmLcd, snmpUsmSecureUser, this);
    }

    public void userAdded(SnmpUsmSecureUser snmpUsmSecureUser) {
        block4: {
            if (this.isDebugOn()) {
                this.debug("userAdded", "engineId : " + snmpUsmSecureUser.getEngineId().toString() + "\nname : " + snmpUsmSecureUser.getName() + "\nsecurityName : " + snmpUsmSecureUser.getSecurityName() + "\nauthAlgo : " + this.convertAuthAlgorithm((SnmpUsmAlgorithm)snmpUsmSecureUser.getAuthPair().algo) + "\nprivAlgo : " + this.convertPrivAlgorithm((SnmpUsmAlgorithm)snmpUsmSecureUser.getPrivPair().algo) + "\nstorageType : " + snmpUsmSecureUser.getStorageType());
            }
            UsmUserEntryImpl usmUserEntryImpl = new UsmUserEntryImpl(this.engine, this.theMib, this.lcd, snmpUsmSecureUser, this);
            if (this.server != null) {
                usmUserEntryImpl.addInMBeanServer(this.server);
            }
            try {
                this.addEntry(usmUserEntryImpl);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!this.isDebugOn()) break block4;
                this.debug("userAdded", snmpStatusException);
            }
        }
    }

    public void userUpdated(SnmpUsmSecureUser snmpUsmSecureUser) {
        block7: {
            SnmpOid snmpOid;
            block6: {
                if (this.isDebugOn()) {
                    this.debug("userUpdated", "engineId : " + snmpUsmSecureUser.getEngineId().toString() + "\nname : " + snmpUsmSecureUser.getName() + "\nsecurityName : " + snmpUsmSecureUser.getSecurityName() + "\nauthAlgo : " + this.convertAuthAlgorithm((SnmpUsmAlgorithm)snmpUsmSecureUser.getAuthPair().algo) + "\nprivAlgo : " + this.convertPrivAlgorithm((SnmpUsmAlgorithm)snmpUsmSecureUser.getPrivPair().algo) + "\nsorageType : " + snmpUsmSecureUser.getStorageType());
                }
                snmpOid = null;
                byte[] byArray = snmpUsmSecureUser.getEngineId().getBytes();
                Byte[] byteArray = new Byte[byArray.length];
                int n = 0;
                while (n < byteArray.length) {
                    byteArray[n] = new Byte(byArray[n]);
                    ++n;
                }
                try {
                    snmpOid = this.buildOidFromIndexVal(byteArray, snmpUsmSecureUser.getName());
                }
                catch (SnmpStatusException snmpStatusException) {
                    if (!this.isDebugOn()) break block6;
                    this.debug("userUpdated", snmpStatusException);
                }
            }
            try {
                UsmUserEntryImpl usmUserEntryImpl = (UsmUserEntryImpl)this.meta.getEntry(snmpOid);
                usmUserEntryImpl.setUser(snmpUsmSecureUser);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!this.isDebugOn()) break block7;
                this.debug("userUpdated", snmpStatusException);
            }
        }
    }

    public void userRemoved(SnmpUsmSecureUser snmpUsmSecureUser) {
        UsmUserEntryImpl usmUserEntryImpl;
        block4: {
            if (this.isDebugOn()) {
                this.debug("userUpdated", "engineId : " + snmpUsmSecureUser.getEngineId().toString() + "\nname : " + snmpUsmSecureUser.getName() + "\nsecurityName : " + snmpUsmSecureUser.getSecurityName() + "\nauthAlgo : " + this.convertAuthAlgorithm((SnmpUsmAlgorithm)snmpUsmSecureUser.getAuthPair().algo) + "\nprivAlgo : " + this.convertPrivAlgorithm((SnmpUsmAlgorithm)snmpUsmSecureUser.getPrivPair().algo) + "\nsorageType : " + snmpUsmSecureUser.getStorageType());
            }
            usmUserEntryImpl = new UsmUserEntryImpl(this.engine, this.theMib, this.lcd, snmpUsmSecureUser, this);
            try {
                this.removeEntry(usmUserEntryImpl);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!this.isDebugOn()) break block4;
                this.debug("userRemoved", snmpStatusException);
            }
        }
        if (this.server != null) {
            usmUserEntryImpl.removeFromMBeanServer(this.server);
        }
    }

    public TableUsmUserTableImpl(SnmpEngine snmpEngine, SnmpMib snmpMib, SnmpUsmLcd snmpUsmLcd) {
        super(snmpMib);
        this.init(snmpUsmLcd, snmpEngine);
    }

    public TableUsmUserTableImpl(SnmpEngine snmpEngine, SnmpMib snmpMib, MBeanServer mBeanServer, SnmpUsmLcd snmpUsmLcd) {
        super(snmpMib, mBeanServer);
        this.init(snmpUsmLcd, snmpEngine);
    }

    public void addEntryCb(int n, SnmpOid snmpOid, ObjectName objectName, Object object, SnmpMibTable snmpMibTable) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("addEntryCb", "");
        }
    }

    public void removeEntryCb(int n, SnmpOid snmpOid, ObjectName objectName, Object object, SnmpMibTable snmpMibTable) throws SnmpStatusException {
        super.removeEntryCb(n, snmpOid, objectName, object, snmpMibTable);
        if (this.isDebugOn()) {
            this.debug("removeEntryCb", "");
        }
        this.lcd.removeUser(((UsmUserEntryImpl)object).getUser().getEngineId(), ((UsmUserEntryImpl)object).getUser().getName(), false);
    }

    private void init(SnmpUsmLcd snmpUsmLcd, SnmpEngine snmpEngine) {
        this.lcd = snmpUsmLcd;
        this.engine = snmpEngine;
        snmpUsmLcd.setMibTable((SnmpUsmMibTable)this);
        Enumeration enumeration = snmpUsmLcd.getAllUsers();
        while (enumeration.hasMoreElements()) {
            String string;
            UsmUserEntryImpl usmUserEntryImpl;
            block14: {
                SnmpUsmSecureUser snmpUsmSecureUser;
                block12: {
                    snmpUsmSecureUser = (SnmpUsmSecureUser)enumeration.nextElement();
                    usmUserEntryImpl = this.createUsmUserEntry(snmpEngine, this.theMib, snmpUsmLcd, snmpUsmSecureUser, this.meta);
                    try {
                        usmUserEntryImpl.setUsmUserStatus(new EnumUsmUserStatus("active"));
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block12;
                        this.debug("init", exception);
                    }
                }
                if (this.isDebugOn()) {
                    this.debug("init", "Adding :" + snmpUsmSecureUser.getEngineId().toString() + "/" + snmpUsmSecureUser.getName());
                }
                if (!snmpUsmSecureUser.isTemplate()) {
                    block13: {
                        try {
                            this.addEntry(usmUserEntryImpl);
                            if (this.isDebugOn()) {
                                this.debug("init", "Added :" + snmpUsmSecureUser.getEngineId().toString() + "/" + snmpUsmSecureUser.getName());
                            }
                        }
                        catch (SnmpStatusException snmpStatusException) {
                            if (!this.isDebugOn()) break block13;
                            this.debug("init", snmpStatusException);
                        }
                    }
                    if (this.server == null) continue;
                    usmUserEntryImpl.addInMBeanServer(this.server);
                    continue;
                }
                if (this.isDebugOn()) {
                    this.debug("init", "Template user detected :" + snmpUsmSecureUser.getEngineId().toString() + "/" + snmpUsmSecureUser.getName());
                }
                string = null;
                try {
                    SnmpIndex snmpIndex = this.buildSnmpIndex(usmUserEntryImpl);
                    string = "1.3.6.1.6.3.15.1.2.2.1.3." + this.buildOidFromIndex(snmpIndex).toString();
                    if (this.isDebugOn()) {
                        this.debug("init", "template user oid :" + string);
                    }
                    usmUserEntryImpl.setUsmUserStatus(new EnumUsmUserStatus("active"));
                }
                catch (SnmpStatusException snmpStatusException) {
                    if (!this.isDebugOn()) break block14;
                    this.debug("init", snmpStatusException);
                }
            }
            this.templates.put(string, usmUserEntryImpl);
        }
    }

    private String convertAuthAlgorithm(SnmpUsmAlgorithm snmpUsmAlgorithm) {
        if (snmpUsmAlgorithm == null) {
            return "usmNoAuthProtocol";
        }
        return snmpUsmAlgorithm.getAlgorithm();
    }

    private String convertPrivAlgorithm(SnmpUsmAlgorithm snmpUsmAlgorithm) {
        if (snmpUsmAlgorithm == null) {
            return "usmNoPrivProtocol";
        }
        return snmpUsmAlgorithm.getAlgorithm();
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)64, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)64, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)64, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

