/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.internal.snmp.SnmpTools;
import com.sun.jdmk.snmp.agent.SnmpTrapReceiver;
import com.sun.jdmk.trace.Trace;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpPduTrap;
import javax.management.snmp.SnmpScopedPduRequest;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.manager.SnmpTrapListener;

class TrapListener
implements SnmpTrapListener {
    private static final String dbgTag = "TrapListener";
    private SnmpTrapReceiver forwarder = null;

    TrapListener(SnmpTrapReceiver snmpTrapReceiver) {
        this.forwarder = snmpTrapReceiver;
    }

    public void processSnmpTrapV1(SnmpPduTrap snmpPduTrap) {
        this.printV1Trap(snmpPduTrap);
        this.forwarder.receivedV1(snmpPduTrap);
    }

    public void processSnmpTrapV2(SnmpPduRequest snmpPduRequest) {
        this.printV2Trap(snmpPduRequest);
        this.forwarder.receivedV2(snmpPduRequest);
    }

    public void processSnmpTrapV3(SnmpScopedPduRequest snmpScopedPduRequest) {
        this.printV3Trap(snmpScopedPduRequest);
        this.forwarder.receivedV3(snmpScopedPduRequest);
    }

    private void printV1Trap(SnmpPduTrap snmpPduTrap) {
        if (this.isTraceOn()) {
            this.trace("printV1Trap", "received V1 trap :");
            this.trace("printV1Trap", "\tCommunity " + new String(snmpPduTrap.community));
            this.trace("printV1Trap", "\tEnterprise " + snmpPduTrap.enterprise);
            this.trace("printV1Trap", "\tGeneric " + snmpPduTrap.genericTrap);
            this.trace("printV1Trap", "\tSpecific " + snmpPduTrap.specificTrap);
            this.trace("printV1Trap", "\tTimeStamp " + snmpPduTrap.timeStamp);
            this.trace("printV1Trap", "\tAgent adress " + snmpPduTrap.agentAddr.stringValue());
            int n = 0;
            while (n < snmpPduTrap.varBindList.length) {
                this.trace("printV1Trap", "oid : " + snmpPduTrap.varBindList[n].oid + " val : " + snmpPduTrap.varBindList[n].value + "\n");
                ++n;
            }
            this.trace("printV1Trap", "************************************************\n");
        }
    }

    private void printV2Trap(SnmpPduRequest snmpPduRequest) {
        if (this.isTraceOn()) {
            this.trace("printV2Trap", "received V2 trap :");
            this.trace("printV2Trap", "\tCommunity " + new String(snmpPduRequest.community));
            SnmpVarBind[] snmpVarBindArray = snmpPduRequest.varBindList;
            int n = 0;
            while (n < snmpVarBindArray.length) {
                this.trace("printV2Trap", "OID " + snmpVarBindArray[n].oid);
                this.trace("printV2Trap", "Value " + snmpVarBindArray[n].value);
                ++n;
            }
            this.trace("printV2Trap", "************************************************\n");
        }
    }

    private void printV3Trap(SnmpScopedPduRequest snmpScopedPduRequest) {
        if (this.isTraceOn()) {
            this.trace("printV3Trap", "received V3 trap :");
            this.trace("printV3Trap", "\tContextEngineId : " + new String(SnmpTools.binary2ascii((byte[])snmpScopedPduRequest.contextEngineId)) + "\n");
            this.trace("printV3Trap", "\tContextName : " + new String(snmpScopedPduRequest.contextName) + "\n");
            this.trace("printV3Trap", "\tMsgFlags : " + snmpScopedPduRequest.msgFlags + "\n");
            this.trace("printV3Trap", "\tMsgMaxSize : " + snmpScopedPduRequest.msgMaxSize + "\n");
            this.trace("printV3Trap", "\tMsgSecurityModel : " + snmpScopedPduRequest.msgSecurityModel + "\n");
            this.trace("printV3Trap", "\tAgent list :\n");
            int n = 0;
            while (n < snmpScopedPduRequest.varBindList.length) {
                this.trace("printV3Trap", "oid : " + snmpScopedPduRequest.varBindList[n].oid + " val : " + snmpScopedPduRequest.varBindList[n].value + "\n");
                ++n;
            }
            this.trace("printV3Trap", "************************************************\n");
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void debug(String string, String string2) {
        this.debug(dbgTag, string, string2);
    }
}

