/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpMibRequest;
import com.sun.jdmk.snmp.agent.SnmpProxy;
import com.sun.jdmk.trace.Trace;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpScopedPduPacket;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.manager.SnmpParams;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpV3Parameters;

public abstract class SnmpV3Proxy
extends SnmpProxy {
    String dbgTag = "SnmpV3Proxy";

    public SnmpV3Proxy(SnmpEngine snmpEngine, SnmpPeer snmpPeer, String string, String string2) throws SnmpStatusException {
        super(snmpEngine, snmpPeer, string, string2);
    }

    public abstract SnmpEngineId getEngineId();

    protected abstract SnmpParams createParameters(SnmpPdu var1) throws SnmpStatusException;

    protected SnmpParams translateParameters(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpPdu snmpPdu;
        if (this.isDebugOn()) {
            this.debug("translateParameters", " Mib request :" + snmpMibRequest);
        }
        if ((snmpPdu = snmpMibRequest.getPdu()) == null) {
            return this.createParameters(null);
        }
        SnmpV3Parameters snmpV3Parameters = (SnmpV3Parameters)this.createParameters(snmpPdu);
        byte[] byArray = null;
        int n = 0;
        byte[] byArray2 = this.getEngineId().getBytes();
        snmpV3Parameters.setContextEngineId(byArray2);
        if (this.isDebugOn()) {
            this.debug("translateParameters", " Snmp version :" + snmpPdu.version);
        }
        switch (snmpPdu.version) {
            case 0: 
            case 1: {
                int n2;
                SnmpPduPacket snmpPduPacket = (SnmpPduPacket)snmpPdu;
                String string = new String(snmpPduPacket.community);
                if (this.isDebugOn()) {
                    this.debug("translateParameters", " Community :" + string);
                }
                if ((n2 = string.indexOf(64)) != -1) {
                    byArray = string.substring(n2 + 1).getBytes();
                }
                n = 0;
                break;
            }
            case 3: {
                SnmpScopedPduPacket snmpScopedPduPacket = (SnmpScopedPduPacket)snmpPdu;
                byArray = snmpScopedPduPacket.contextName;
                n = snmpScopedPduPacket.msgFlags;
                snmpV3Parameters.setMsgMaxSize(snmpScopedPduPacket.msgMaxSize);
                if (!this.isDebugOn()) break;
                this.debug("translateParameters", " msgMaxSize :" + snmpScopedPduPacket.msgMaxSize);
            }
        }
        if (this.isDebugOn()) {
            this.debug("translateParameters", " contextName :" + byArray);
            this.debug("translateParameters", " msgFlags :" + n);
        }
        snmpV3Parameters.setSecurityLevel(n);
        snmpV3Parameters.setContextName(byArray);
        if (this.isDebugOn()) {
            this.debug("translateParameters", "Returned parameters : " + snmpV3Parameters);
        }
        return snmpV3Parameters;
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

