/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpV3Proxy;
import com.sun.jdmk.trace.Trace;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpScopedPduPacket;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpUnknownModelException;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParams;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.usm.SnmpUsmParameters;
import javax.management.snmp.manager.usm.SnmpUsmPeer;

public class SnmpUsmProxy
extends SnmpV3Proxy {
    String user = null;
    boolean timelinessRetry = true;
    String dbgTag = "SnmpUsmProxy";

    public SnmpUsmProxy(SnmpEngine snmpEngine, SnmpUsmPeer snmpUsmPeer, String string) throws SnmpStatusException {
        super(snmpEngine, (SnmpPeer)snmpUsmPeer, string, "SnmpUsmProxy");
    }

    public SnmpUsmProxy(SnmpEngine snmpEngine, SnmpUsmPeer snmpUsmPeer, String string, String string2) throws SnmpStatusException {
        super(snmpEngine, (SnmpPeer)snmpUsmPeer, string, string2);
    }

    public SnmpEngineId getEngineId() {
        return ((SnmpUsmPeer)this.getPeer()).getEngineId();
    }

    public void resyncOnTimelinessReport(boolean bl) {
        this.timelinessRetry = bl;
    }

    protected boolean handleReport(SnmpRequest snmpRequest) {
        if (this.isDebugOn()) {
            this.debug("handleReport", "Received a report");
        }
        if (!this.timelinessRetry) {
            if (this.isDebugOn()) {
                this.debug("handleReport", "No retrying, return false");
            }
            return false;
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getReportVarBindList();
        SnmpOid snmpOid = null;
        try {
            snmpOid = new SnmpOid("1.3.6.1.6.3.15.1.1.2.0");
        }
        catch (Exception exception) {
            return false;
        }
        if (snmpVarBindList.indexOfOid(snmpOid) != -1) {
            if (this.isDebugOn()) {
                this.debug("handleReport", "Received a Not in Time Window report");
            }
            SnmpUsmPeer snmpUsmPeer = (SnmpUsmPeer)snmpRequest.getPeer();
            try {
                snmpUsmPeer.processUsmTimelinessDiscovery();
                if (this.isDebugOn()) {
                    this.debug("handleReport", " synchro done. EngineId : " + snmpUsmPeer.getEngineId() + " time : " + snmpUsmPeer.getEngineTime() + " boot : " + snmpUsmPeer.getEngineBoots());
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                if (this.isDebugOn()) {
                    this.debug("handleReport", "Time Window synchro failed.");
                }
                return false;
            }
            return true;
        }
        if (this.isDebugOn()) {
            this.debug("handleReport", "Received a report that is not usmStatsNotInTimeWindows");
        }
        return false;
    }

    protected final SnmpParams createParameters(SnmpPdu snmpPdu) throws SnmpStatusException {
        SnmpUsmPeer snmpUsmPeer = (SnmpUsmPeer)this.getPeer();
        if (snmpPdu == null || !(snmpPdu instanceof SnmpScopedPduPacket)) {
            if (this.isDebugOn()) {
                this.debug("createParameters", "pdu :" + snmpPdu);
            }
            return snmpUsmPeer.getParams();
        }
        SnmpScopedPduPacket snmpScopedPduPacket = (SnmpScopedPduPacket)snmpPdu;
        if (this.isDebugOn()) {
            this.debug("createParameters", "pdu security parameters :" + snmpScopedPduPacket.securityParameters);
        }
        String string = snmpScopedPduPacket.securityParameters.getPrincipal();
        if (this.isDebugOn()) {
            this.debug("createParameters", "pdu principal :" + string);
        }
        SnmpUsmParameters snmpUsmParameters = null;
        try {
            snmpUsmParameters = new SnmpUsmParameters(this.getEngine(), string);
        }
        catch (SnmpUnknownModelException snmpUnknownModelException) {
            if (this.isTraceOn()) {
                this.trace("createParameters", "Failed " + (Object)((Object)snmpUnknownModelException));
            }
            throw new SnmpStatusException(snmpUnknownModelException.toString());
        }
        snmpUsmParameters.setContextEngineId(snmpUsmPeer.getEngineId().getBytes());
        return snmpUsmParameters;
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

