/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.JdmkEngineFactory;
import com.sun.jdmk.snmp.SnmpEventReportDispatcher;
import com.sun.jdmk.snmp.agent.SnmpTrap;
import com.sun.jdmk.snmp.agent.TrapListener;
import com.sun.jdmk.tasks.DaemonTaskServer;
import com.sun.jdmk.tasks.TaskServer;
import com.sun.jdmk.trace.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineFactory;
import javax.management.snmp.SnmpEngineParameters;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpPduTrap;
import javax.management.snmp.SnmpScopedPduRequest;
import javax.management.snmp.manager.SnmpTrapListener;

public class SnmpTrapReceiver {
    private static final String dbgTag = "SnmpTrapReceiver";
    private static int count = 0;
    private TrapListener listener = null;
    private SnmpEventReportDispatcher dispatcher = null;
    private SnmpEngine eng = null;
    private boolean started = false;
    private int port = 0;
    private Thread dispatchThread = null;
    private boolean receiveAsGeneric = false;
    private InetAddress address = null;
    private final TaskServer packetTaskServer;
    private final TaskServer callbackTaskServer;

    public SnmpTrapReceiver(SnmpEngine snmpEngine, int n, InetAddress inetAddress) throws IllegalArgumentException {
        this.eng = snmpEngine;
        this.listener = new TrapListener(this);
        this.port = n;
        this.address = inetAddress;
        this.packetTaskServer = this.createPacketTaskServer();
        this.callbackTaskServer = this.createCallbackTaskServer();
    }

    public SnmpTrapReceiver(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory, int n, InetAddress inetAddress) throws IllegalArgumentException {
        if (snmpEngineParameters == null) {
            snmpEngineParameters = new SnmpEngineParameters();
        }
        if (snmpEngineFactory == null) {
            snmpEngineFactory = new JdmkEngineFactory();
        }
        this.eng = snmpEngineFactory.createEngine(snmpEngineParameters);
        this.listener = new TrapListener(this);
        this.port = n;
        this.address = inetAddress;
        this.packetTaskServer = this.createPacketTaskServer();
        this.callbackTaskServer = this.createCallbackTaskServer();
    }

    public void receiveAsGeneric(boolean bl) {
        this.receiveAsGeneric = bl;
    }

    public synchronized void start() throws SocketException {
        if (this.started) {
            return;
        }
        this.dispatcher = new SnmpEventReportDispatcher(this.eng, this.port, this.address, this.packetTaskServer, this.callbackTaskServer);
        this.dispatcher.addTrapListener((SnmpTrapListener)this.listener);
        this.started = true;
        this.dispatchThread = new Thread((Runnable)this.dispatcher);
        this.dispatchThread.start();
    }

    public synchronized void stop() throws SocketException {
        if (!this.started) {
            return;
        }
        try {
            this.dispatcher.close();
        }
        catch (IOException iOException) {
            this.debug("stop", "Exception caught while closing dispatcher: " + iOException);
        }
        this.dispatchThread.interrupt();
    }

    synchronized void receivedV1(SnmpPduTrap snmpPduTrap) {
        if (this.receiveAsGeneric) {
            SnmpTrap snmpTrap = new SnmpTrap(snmpPduTrap);
            this.receivedTrap(snmpTrap);
        } else {
            this.receivedV1Trap(snmpPduTrap);
        }
    }

    synchronized void receivedV2(SnmpPduRequest snmpPduRequest) {
        if (this.receiveAsGeneric) {
            SnmpTrap snmpTrap = new SnmpTrap(snmpPduRequest);
            this.receivedTrap(snmpTrap);
        } else {
            this.receivedV2Trap(snmpPduRequest);
        }
    }

    synchronized void receivedV3(SnmpScopedPduRequest snmpScopedPduRequest) {
        if (this.receiveAsGeneric) {
            SnmpTrap snmpTrap = new SnmpTrap(snmpScopedPduRequest);
            this.receivedTrap(snmpTrap);
        } else {
            this.receivedV3Trap(snmpScopedPduRequest);
        }
    }

    protected TaskServer createPacketTaskServer() {
        DaemonTaskServer daemonTaskServer = new DaemonTaskServer();
        daemonTaskServer.start();
        return daemonTaskServer;
    }

    protected TaskServer createCallbackTaskServer() {
        return null;
    }

    protected Thread createDispatcherThread(Runnable runnable) {
        return new Thread(runnable, "SnmpTrapReceiver[" + count++ + "]");
    }

    protected void receivedTrap(SnmpTrap snmpTrap) {
    }

    protected void receivedV1Trap(SnmpPduTrap snmpPduTrap) {
    }

    protected void receivedV2Trap(SnmpPduRequest snmpPduRequest) {
    }

    protected void receivedV3Trap(SnmpScopedPduRequest snmpScopedPduRequest) {
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void debug(String string, String string2) {
        this.debug(dbgTag, string, string2);
    }
}

