/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.comm.SnmpV3AdaptorServer;
import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.snmp.usm.SnmpUsm;
import com.sun.jdmk.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.jdmk.trace.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.snmp.SnmpCounter64;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpIpAddress;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpPduTrap;
import javax.management.snmp.SnmpScopedPduRequest;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpTimeticks;
import javax.management.snmp.SnmpUnknownModelException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpParams;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.usm.SnmpUsmParameters;
import javax.management.snmp.manager.usm.SnmpUsmPeer;

public class SnmpTrap
implements Serializable {
    public static final SnmpOid coldStartOid = new SnmpOid("1.3.6.1.6.3.1.1.5.1");
    public static final SnmpOid warmStartOid = new SnmpOid("1.3.6.1.6.3.1.1.5.2");
    public static final SnmpOid linkDownOid = new SnmpOid("1.3.6.1.6.3.1.1.5.3");
    public static final SnmpOid linkUpOid = new SnmpOid("1.3.6.1.6.3.1.1.5.4");
    public static final SnmpOid authenticationFailureOid = new SnmpOid("1.3.6.1.6.3.1.1.5.5");
    public static final SnmpOid egpNeighborLossOid = new SnmpOid("1.3.6.1.6.3.1.1.5.6");
    private static final SnmpOid snmpTrapRadicalOid = new SnmpOid("1.3.6.1.6.3.1.1.5");
    public static final SnmpOid snmpTrapSysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    public static final SnmpOid snmpTrapOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");
    public static final SnmpOid snmpTrapAddressOid = new SnmpOid("1.3.6.1.6.3.18.1.3.0");
    public static final SnmpOid snmpTrapEnterpriseOid = new SnmpOid("1.3.6.1.6.3.1.1.4.3.0");
    public static final SnmpOid snmpTrapsOid = new SnmpOid("1.3.6.1.6.3.1.1.5");
    public static final SnmpOid snmpTrapCommunityOid = new SnmpOid("1.3.6.1.6.3.18.1.4.0");
    String dbgTag = "SnmpTrap";
    InetAddress address = null;
    String communityString = null;
    SnmpOid trapOid = null;
    Integer gen = null;
    Integer specific = null;
    SnmpAdaptorServer server = null;
    SnmpOid enterpriseOid = null;
    SnmpPduTrap pduTrap = null;
    SnmpPduRequest pduRequest = null;
    SnmpVarBindList pduTrapList = null;
    int bufferSize = 1024;
    int port = -1;
    SnmpScopedPduRequest scopedTrap = null;
    private boolean originator = true;
    private InetAddress pduAddr = null;

    public SnmpTrap(int n, int n2, SnmpVarBindList snmpVarBindList) {
        this.gen = new Integer(n);
        this.specific = new Integer(n2);
        this.initialize(null, null, snmpVarBindList);
    }

    public SnmpTrap(InetAddress inetAddress, String string, int n, int n2, SnmpVarBindList snmpVarBindList) {
        this.gen = new Integer(n);
        this.specific = new Integer(n2);
        this.initialize(inetAddress, string, snmpVarBindList);
    }

    public SnmpTrap(SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) {
        this.trapOid = snmpOid;
        this.initialize(null, null, snmpVarBindList);
    }

    public SnmpTrap(InetAddress inetAddress, String string, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) {
        this.trapOid = snmpOid;
        this.initialize(inetAddress, string, snmpVarBindList);
    }

    public SnmpTrap(SnmpPduTrap snmpPduTrap) {
        this.pduTrap = snmpPduTrap;
        this.convertPduList(snmpPduTrap.varBindList);
    }

    public SnmpTrap(SnmpScopedPduRequest snmpScopedPduRequest) {
        this.scopedTrap = snmpScopedPduRequest;
        this.convertPduList(snmpScopedPduRequest.varBindList);
    }

    public SnmpTrap(SnmpPduRequest snmpPduRequest) {
        this.pduRequest = snmpPduRequest;
        this.convertPduList(snmpPduRequest.varBindList);
    }

    public InetAddress getSourceAddress() {
        if (this.scopedTrap != null) {
            return this.scopedTrap.address;
        }
        if (this.pduRequest != null) {
            return this.pduRequest.address;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.address;
        }
        return null;
    }

    public SnmpPdu getPdu() {
        if (this.scopedTrap != null) {
            return this.scopedTrap;
        }
        if (this.pduRequest != null) {
            return this.pduRequest;
        }
        if (this.pduTrap != null) {
            return this.pduTrap;
        }
        return null;
    }

    public void setEnterpriseOid(String string) {
        this.enterpriseOid = new SnmpOid(string);
    }

    public void setDestinationAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void setDestinationPort(int n) {
        this.port = n;
    }

    public void setCommunityString(String string) {
        this.communityString = string;
    }

    public void sendV3(SnmpV3AdaptorServer snmpV3AdaptorServer) throws IOException, SnmpStatusException {
        if (this.scopedTrap == null) {
            throw new SnmpStatusException("No scoped trap. Should use sendV3Usm method");
        }
        if (this.port != -1) {
            SnmpUsmPeer snmpUsmPeer = null;
            if (this.getAddress() != null) {
                try {
                    snmpUsmPeer = new SnmpUsmPeer(snmpV3AdaptorServer.getEngine(), this.getAddress().getHostName(), this.port, null);
                }
                catch (SnmpUnknownModelException snmpUnknownModelException) {
                    throw new SnmpStatusException(snmpUnknownModelException.getMessage());
                }
                snmpV3AdaptorServer.snmpV3Trap(snmpUsmPeer, this.scopedTrap);
                return;
            }
        }
        snmpV3AdaptorServer.snmpV3Trap(this.getAddress(), this.scopedTrap);
    }

    public void sendV3Usm(SnmpV3AdaptorServer snmpV3AdaptorServer, String string, int n, String string2) throws IOException, SnmpStatusException {
        Object object;
        if (this.isDebugOn()) {
            this.debug("sendV3Trap", "trapOid= " + this.getTrapOid());
        }
        int n2 = this.port == -1 ? snmpV3AdaptorServer.getTrapPort() : this.port;
        SnmpEngineImpl snmpEngineImpl = (SnmpEngineImpl)snmpV3AdaptorServer.getEngine();
        SnmpUsmPeer snmpUsmPeer = null;
        SnmpUsmParameters snmpUsmParameters = null;
        if (this.getAddress() != null) {
            if (this.isDebugOn()) {
                this.debug("sendV3Trap", "Create Peer " + this.getAddress() + "/" + n2);
            }
            try {
                snmpUsmPeer = new SnmpUsmPeer((SnmpEngine)snmpEngineImpl, this.getAddress().getHostName(), n2, null);
                snmpUsmParameters = new SnmpUsmParameters((SnmpEngine)snmpEngineImpl);
            }
            catch (SnmpUnknownModelException snmpUnknownModelException) {
                throw new SnmpStatusException(snmpUnknownModelException.getMessage());
            }
            snmpUsmParameters.setPrincipal(string);
            snmpUsmParameters.setSecurityLevel(n);
            object = this.getContext(string2);
            if (object != null) {
                snmpUsmParameters.setContextName((byte[])object);
            }
            snmpUsmPeer.setParams((SnmpParams)snmpUsmParameters);
        }
        if ((object = this.getTimeStamp()) == null) {
            if (this.isDebugOn()) {
                this.debug("sendV3Trap", "time is null");
            }
            if (snmpUsmPeer != null) {
                snmpV3AdaptorServer.snmpV3UsmTrap(snmpUsmPeer, this.getTrapOid(), this.getVarBindList(3), (SnmpTimeticks)object);
            } else {
                byte[] byArray = this.getContext(string2);
                snmpV3AdaptorServer.snmpV3UsmTrap(this.getAddress(), string, n, byArray == null ? null : new String(byArray), this.getTrapOid(), this.getVarBindList(3), (SnmpTimeticks)object);
            }
        } else {
            if (this.isDebugOn()) {
                this.debug("sendV3Trap", "time is not null");
            }
            SnmpVarBind[] snmpVarBindArray = this.toVarBindArray(this.getFullV2VarBindList());
            if (this.isDebugOn()) {
                this.debug("sendV3Trap", "Create pdu : " + snmpEngineImpl + " " + string + " " + n + " " + string2 + " " + snmpVarBindArray + " " + snmpV3AdaptorServer);
            }
            SnmpScopedPduRequest snmpScopedPduRequest = this.createScopedUsmPdu(snmpEngineImpl, string, n, string2 == null ? null : string2.getBytes(), snmpEngineImpl.getEngineId(), snmpEngineImpl.getEngineBoots(), snmpEngineImpl.getEngineTime(), snmpVarBindArray, snmpV3AdaptorServer.getTrapPort());
            if (snmpUsmPeer == null) {
                snmpV3AdaptorServer.snmpV3Trap(this.getAddress(), snmpScopedPduRequest);
            } else {
                snmpV3AdaptorServer.snmpV3Trap(snmpUsmPeer, snmpScopedPduRequest);
            }
        }
    }

    private SnmpScopedPduRequest createScopedUsmPdu(SnmpEngineImpl snmpEngineImpl, String string, int n, byte[] byArray, SnmpEngineId snmpEngineId, int n2, int n3, SnmpVarBind[] snmpVarBindArray, int n4) {
        SnmpUsm snmpUsm;
        block2: {
            snmpUsm = null;
            try {
                snmpUsm = (SnmpUsm)snmpEngineImpl.getSecuritySubSystem().getModel(3);
            }
            catch (SnmpUnknownModelException snmpUnknownModelException) {
                if (!this.isDebugOn()) break block2;
                this.debug("createScopedUsmPdu", snmpUnknownModelException);
            }
        }
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = snmpUsm.createUsmSecurityParameters();
        snmpUsmSecurityParameters.setAuthoritativeEngineId(snmpEngineId);
        snmpUsmSecurityParameters.setAuthoritativeEngineBoots(n2);
        snmpUsmSecurityParameters.setAuthoritativeEngineTime(n3);
        snmpUsmSecurityParameters.setUserName(string);
        SnmpScopedPduRequest snmpScopedPduRequest = new SnmpScopedPduRequest();
        snmpScopedPduRequest.version = 3;
        snmpScopedPduRequest.type = 167;
        snmpScopedPduRequest.port = n4;
        snmpScopedPduRequest.msgFlags = (byte)n;
        snmpScopedPduRequest.msgSecurityModel = 3;
        snmpScopedPduRequest.msgMaxSize = this.bufferSize;
        snmpScopedPduRequest.contextEngineId = snmpEngineId.getBytes();
        snmpScopedPduRequest.contextName = byArray;
        snmpScopedPduRequest.securityParameters = snmpUsmSecurityParameters;
        snmpScopedPduRequest.varBindList = snmpVarBindArray;
        return snmpScopedPduRequest;
    }

    public void sendV2(SnmpAdaptorServer snmpAdaptorServer) throws IOException, SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("sendV2Trap", "trapOid= " + this.getTrapOid());
        }
        int n = this.port == -1 ? snmpAdaptorServer.getTrapPort() : this.port;
        SnmpPeer snmpPeer = null;
        SnmpParameters snmpParameters = null;
        if (this.getAddress() != null) {
            if (this.isDebugOn()) {
                this.debug("sendV2Trap", "Create Peer " + this.getAddress() + "/" + n);
            }
            snmpPeer = new SnmpPeer(this.getAddress().getHostName(), n);
            snmpParameters = new SnmpParameters();
            snmpParameters.setRdCommunity(this.getCommunity());
            snmpPeer.setParams((SnmpParams)snmpParameters);
        }
        if (this.pduRequest != null) {
            String string;
            if (this.isDebugOn()) {
                this.debug("sendV2Trap", "pduRequest is provided");
            }
            if ((string = this.getCommunity()) != null) {
                this.pduRequest.community = string.getBytes();
            }
            if (snmpPeer == null) {
                snmpAdaptorServer.snmpPduTrap(this.getAddress(), (SnmpPduPacket)this.pduRequest);
            } else {
                this.pduRequest.port = snmpAdaptorServer.getTrapPort();
                snmpAdaptorServer.snmpPduTrap(snmpPeer, (SnmpPduPacket)this.pduRequest);
            }
        } else {
            SnmpTimeticks snmpTimeticks;
            if (this.isDebugOn()) {
                this.debug("sendV2Trap", "pduRequest is not provided");
            }
            if ((snmpTimeticks = this.getTimeStamp()) == null) {
                if (this.isDebugOn()) {
                    this.debug("sendV2Trap", "time is null");
                }
                if (snmpPeer == null) {
                    snmpAdaptorServer.snmpV2Trap(this.getAddress(), this.getCommunity(), this.getTrapOid(), this.getVarBindList(1), snmpTimeticks);
                } else {
                    snmpAdaptorServer.snmpV2Trap(snmpPeer, this.getTrapOid(), this.getVarBindList(1), snmpTimeticks);
                }
            } else {
                if (this.isDebugOn()) {
                    this.debug("sendV2Trap", "time is not null");
                }
                SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
                snmpPduRequest.type = 167;
                snmpPduRequest.version = 1;
                snmpPduRequest.varBindList = this.toVarBindArray(this.getFullV2VarBindList());
                String string = this.getCommunity();
                if (string != null) {
                    snmpPduRequest.community = string.getBytes();
                }
                if (snmpPeer == null) {
                    snmpPduRequest.port = snmpAdaptorServer.getTrapPort();
                    snmpAdaptorServer.snmpPduTrap(this.getAddress(), (SnmpPduPacket)snmpPduRequest);
                } else {
                    snmpAdaptorServer.snmpPduTrap(snmpPeer, (SnmpPduPacket)snmpPduRequest);
                }
            }
        }
    }

    public void sendV1(SnmpAdaptorServer snmpAdaptorServer) throws IOException, SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("snmpV1Trap", "generic = " + this.getGeneric());
        }
        int n = this.port == -1 ? snmpAdaptorServer.getTrapPort() : this.port;
        SnmpPeer snmpPeer = null;
        SnmpParameters snmpParameters = null;
        if (this.getAddress() != null) {
            if (this.isDebugOn()) {
                this.debug("sendV1Trap", "Create Peer " + this.getAddress() + "/" + n);
            }
            snmpPeer = new SnmpPeer(this.getAddress().getHostName(), n);
            snmpParameters = new SnmpParameters();
            snmpParameters.setRdCommunity(this.getCommunity());
            snmpPeer.setParams((SnmpParams)snmpParameters);
        }
        if (this.pduTrap != null) {
            if (this.isDebugOn()) {
                this.debug("sendV1Trap", "pduTrap is provided");
            }
            this.pduTrap.agentAddr = this.getAgentAddr();
            String string = this.getCommunity();
            if (string != null) {
                this.pduTrap.community = string.getBytes();
            }
            if (snmpPeer == null) {
                snmpAdaptorServer.snmpPduTrap(this.getAddress(), (SnmpPduPacket)this.pduTrap);
            } else {
                this.pduTrap.port = snmpAdaptorServer.getTrapPort();
                snmpAdaptorServer.snmpPduTrap(snmpPeer, (SnmpPduPacket)this.pduTrap);
            }
        } else {
            SnmpTimeticks snmpTimeticks;
            if (this.isDebugOn()) {
                this.debug("sendV1Trap", "pduRequest is not provided");
            }
            if ((snmpTimeticks = this.getTimeStamp()) == null) {
                if (this.isDebugOn()) {
                    this.debug("sendV1Trap", "time is null");
                }
                if (snmpPeer == null) {
                    snmpAdaptorServer.snmpV1Trap(this.getAddress(), this.getAgentAddr(), this.getCommunity(), this.getEnterpriseOid(), this.getGeneric(), this.getSpecific(), this.getVarBindList(0), snmpTimeticks);
                } else {
                    snmpAdaptorServer.snmpV1Trap(snmpPeer, this.getAgentAddr(), this.getEnterpriseOid(), this.getGeneric(), this.getSpecific(), this.getVarBindList(0), snmpTimeticks);
                }
            } else {
                if (this.isDebugOn()) {
                    this.debug("sendV1Trap", "time is not null");
                }
                if (this.isDebugOn()) {
                    this.debug("sendV1Trap", "Sendint trap : to " + this.getAddress() + " community : " + this.getCommunity());
                }
                SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
                snmpPduTrap.agentAddr = this.getAgentAddr();
                snmpPduTrap.enterprise = this.getEnterpriseOid();
                snmpPduTrap.genericTrap = this.getGeneric();
                snmpPduTrap.specificTrap = this.getSpecific();
                snmpPduTrap.varBindList = this.toVarBindArray(this.getVarBindList(0));
                snmpPduTrap.timeStamp = snmpTimeticks.longValue();
                String string = this.getCommunity();
                if (string != null) {
                    snmpPduTrap.community = string.getBytes();
                }
                if (snmpPeer == null) {
                    snmpPduTrap.port = snmpAdaptorServer.getTrapPort();
                    snmpAdaptorServer.snmpPduTrap(this.getAddress(), (SnmpPduPacket)snmpPduTrap);
                } else {
                    snmpAdaptorServer.snmpPduTrap(snmpPeer, (SnmpPduPacket)snmpPduTrap);
                }
            }
        }
    }

    private SnmpOid getTrapOid() {
        if (this.trapOid != null) {
            return this.trapOid;
        }
        if (this.pduRequest != null || this.scopedTrap != null) {
            SnmpVarBindList snmpVarBindList = this.pduTrapList;
            int n = snmpVarBindList.indexOfOid(snmpTrapOid);
            SnmpVarBind snmpVarBind = snmpVarBindList.getVarBindAt(n);
            return (SnmpOid)snmpVarBind.value;
        }
        return this.calculateTrapOid();
    }

    private int getGeneric() {
        if (this.gen != null) {
            return this.gen;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.genericTrap;
        }
        return this.calculateGeneric();
    }

    private int getSpecific() {
        if (this.specific != null) {
            return this.specific;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.specificTrap;
        }
        return this.calculateSpecific();
    }

    private InetAddress getAddress() {
        return this.address;
    }

    private String getCommunity() {
        if (this.communityString != null) {
            return this.communityString;
        }
        if (this.pduTrap != null && this.pduTrap.community != null) {
            return new String(this.pduTrap.community);
        }
        if (this.pduRequest != null && this.pduRequest.community != null) {
            return new String(this.pduRequest.community);
        }
        if (this.scopedTrap != null && this.scopedTrap.contextName != null) {
            return new String(this.scopedTrap.contextName);
        }
        return null;
    }

    private byte[] getContext(String string) {
        if (string != null) {
            return string.getBytes();
        }
        if (this.pduTrap != null) {
            return this.pduTrap.community;
        }
        if (this.pduRequest != null) {
            return this.pduRequest.community;
        }
        if (this.scopedTrap != null) {
            return this.scopedTrap.contextName;
        }
        return null;
    }

    private SnmpOid getEnterpriseOid() {
        if (this.enterpriseOid != null) {
            return this.enterpriseOid;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.enterprise;
        }
        return this.calculateEnterpriseOid();
    }

    private SnmpVarBindList getVarBindList(int n) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("getVarBindList", "Calculate varbindlist for version : " + n);
        }
        switch (n) {
            case 1: 
            case 3: {
                return this.calculateV2VarBindList();
            }
            case 0: {
                return this.calculateV1VarBindList();
            }
        }
        throw new SnmpStatusException("getVarBindList. Unable to define varBindList.");
    }

    private SnmpVarBindList getFullV2VarBindList() {
        SnmpVarBindList snmpVarBindList = this.calculateV2VarBindList();
        int n = snmpVarBindList.indexOfOid(snmpTrapOid);
        if (n == -1) {
            if (this.isDebugOn()) {
                this.debug("getFullV2VarBindList", "Must add trapOid : " + this.getTrapOid());
            }
            snmpVarBindList.insertElementAt((Object)new SnmpVarBind(snmpTrapOid, (SnmpValue)this.getTrapOid()), 0);
        }
        if ((n = snmpVarBindList.indexOfOid(snmpTrapSysUpTimeOid)) == -1) {
            if (this.isDebugOn()) {
                this.debug("getFullV2VarBindList", "Must add timeStamp : " + this.getTimeStamp());
            }
            snmpVarBindList.insertElementAt((Object)new SnmpVarBind(snmpTrapSysUpTimeOid, (SnmpValue)this.getTimeStamp()), 0);
        }
        if (this.isDebugOn()) {
            this.debug("getFullV2VarBindList", "List updated");
        }
        return snmpVarBindList;
    }

    private SnmpTimeticks getTimeStamp() {
        if (this.pduTrap != null) {
            return new SnmpTimeticks(this.pduTrap.timeStamp);
        }
        if (this.pduRequest != null || this.scopedTrap != null) {
            int n = this.pduTrapList.indexOfOid(snmpTrapSysUpTimeOid);
            SnmpVarBind snmpVarBind = this.pduTrapList.getVarBindAt(n);
            return (SnmpTimeticks)snmpVarBind.value;
        }
        return null;
    }

    public void sendAsNotificationOriginator() {
        this.originator = true;
    }

    public void sendAsProxy() {
        this.originator = false;
    }

    public boolean isOriginatorWay() {
        return this.originator;
    }

    public boolean isProxyWay() {
        return !this.isOriginatorWay();
    }

    public void setPduSourceAddress(InetAddress inetAddress) {
        this.pduAddr = inetAddress;
    }

    private SnmpIpAddress handleMultipleIpVersion(byte[] byArray) {
        if (byArray.length == 4) {
            return new SnmpIpAddress(byArray);
        }
        if (this.isDebugOn()) {
            this.debug("handleMultipleIPVersion", "Not an IPv4 address, return null");
        }
        return null;
    }

    private SnmpIpAddress getAgentAddr() {
        if (this.isOriginatorWay()) {
            if (this.pduAddr == null) {
                try {
                    return this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    return null;
                }
            }
            return this.handleMultipleIpVersion(this.pduAddr.getAddress());
        }
        if (this.pduTrap != null) {
            return this.pduTrap.agentAddr;
        }
        if (this.pduRequest != null || this.scopedTrap != null) {
            int n = this.pduTrapList.indexOfOid(snmpTrapAddressOid);
            if (n != -1) {
                SnmpVarBind snmpVarBind = this.pduTrapList.getVarBindAt(n);
                return (SnmpIpAddress)snmpVarBind.value;
            }
            return new SnmpIpAddress("0.0.0.0");
        }
        return null;
    }

    private int calculateGeneric() {
        SnmpOid snmpOid = null;
        if (this.trapOid != null) {
            snmpOid = this.trapOid;
        } else {
            SnmpVarBindList snmpVarBindList = this.pduTrapList;
            int n = snmpVarBindList.indexOfOid(snmpTrapOid);
            SnmpVarBind snmpVarBind = snmpVarBindList.getVarBindAt(n);
            snmpOid = (SnmpOid)snmpVarBind.value;
        }
        if (snmpOid.equals((Object)coldStartOid)) {
            return 0;
        }
        if (snmpOid.equals((Object)warmStartOid)) {
            return 1;
        }
        if (snmpOid.equals((Object)linkDownOid)) {
            return 2;
        }
        if (snmpOid.equals((Object)linkUpOid)) {
            return 3;
        }
        if (snmpOid.equals((Object)authenticationFailureOid)) {
            return 4;
        }
        if (snmpOid.equals((Object)egpNeighborLossOid)) {
            return 5;
        }
        return 6;
    }

    private int calculateSpecific() {
        SnmpOid snmpOid = null;
        if (this.trapOid != null) {
            snmpOid = this.trapOid;
        } else {
            SnmpVarBindList snmpVarBindList = this.pduTrapList;
            int n = snmpVarBindList.indexOfOid(snmpTrapOid);
            SnmpVarBind snmpVarBind = snmpVarBindList.getVarBindAt(n);
            snmpOid = (SnmpOid)snmpVarBind.value;
        }
        if (this.getGeneric() == 6) {
            int n = 0;
            try {
                n = (int)snmpOid.getOidArc(snmpOid.getLength() - 1);
            }
            catch (SnmpStatusException snmpStatusException) {
                // empty catch block
            }
            return n;
        }
        return 0;
    }

    private SnmpOid calculateTrapOid() {
        SnmpOid snmpOid = null;
        int n = 0;
        int n2 = 0;
        if (this.pduTrap != null) {
            n = this.pduTrap.genericTrap;
            n2 = this.pduTrap.specificTrap;
        } else {
            n = this.gen;
            n2 = this.specific;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                snmpOid = new SnmpOid(snmpTrapRadicalOid.longValue());
                snmpOid.append((long)(n + 1));
                break;
            }
            default: {
                snmpOid = this.enterpriseOid != null ? new SnmpOid(snmpTrapEnterpriseOid.longValue()) : new SnmpOid(this.pduTrap.enterprise.longValue());
                snmpOid.append(0L);
                snmpOid.append((long)n2);
            }
        }
        return snmpOid;
    }

    private SnmpOid calculateEnterpriseOid() {
        int n = this.pduTrapList.indexOfOid(snmpTrapOid);
        if (n == -1) {
            return null;
        }
        SnmpVarBind snmpVarBind = this.pduTrapList.getVarBindAt(n);
        SnmpOid snmpOid = (SnmpOid)snmpVarBind.value;
        if (SnmpTrap.isStandardTrap(snmpOid)) {
            int n2 = this.pduTrapList.indexOfOid(snmpTrapEnterpriseOid);
            if (n2 != -1) {
                SnmpVarBind snmpVarBind2 = this.pduTrapList.getVarBindAt(n2);
                return (SnmpOid)snmpVarBind2.value;
            }
            return snmpTrapsOid;
        }
        long[] lArray = snmpOid.longValue();
        long l = lArray[lArray.length - 2];
        int n3 = 0;
        n3 = l == 0L ? 2 : 1;
        long[] lArray2 = new long[lArray.length - n3];
        int n4 = 0;
        while (n4 < lArray2.length) {
            lArray2[n4] = lArray[n4];
            ++n4;
        }
        return new SnmpOid(lArray2);
    }

    private static boolean isStandardTrap(SnmpOid snmpOid) {
        return snmpOid.equals((Object)coldStartOid) || snmpOid.equals((Object)warmStartOid) || snmpOid.equals((Object)linkUpOid) || snmpOid.equals((Object)linkDownOid) || snmpOid.equals((Object)authenticationFailureOid) || snmpOid.equals((Object)egpNeighborLossOid);
    }

    private SnmpVarBindList calculateV1VarBindList() throws SnmpStatusException {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        int n = 0;
        while (n < this.pduTrapList.size()) {
            SnmpVarBind snmpVarBind = this.pduTrapList.getVarBindAt(n);
            if (snmpVarBind.value instanceof SnmpCounter64) {
                throw new SnmpStatusException(2, n);
            }
            snmpVarBindList.addVarBind(snmpVarBind);
            ++n;
        }
        return snmpVarBindList;
    }

    private SnmpVarBindList calculateV2VarBindList() {
        if (this.pduTrap == null) {
            return this.pduTrapList;
        }
        if (this.isOriginatorWay()) {
            return this.pduTrapList;
        }
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList(this.pduTrapList);
        boolean bl = false;
        int n = this.pduTrapList.indexOfOid(snmpTrapAddressOid);
        if (n == -1) {
            bl = true;
        }
        if ((n = this.pduTrapList.indexOfOid(snmpTrapCommunityOid)) == -1) {
            bl = true;
        }
        if ((n = this.pduTrapList.indexOfOid(snmpTrapEnterpriseOid)) == -1) {
            bl = true;
        }
        if (bl) {
            if (this.isDebugOn()) {
                this.debug("calculateV2VarBindList", "Must add varbind");
            }
            snmpVarBindList.addVarBind(new SnmpVarBind(snmpTrapAddressOid, (SnmpValue)this.pduTrap.agentAddr));
            SnmpString snmpString = new SnmpString(this.pduTrap.community);
            snmpVarBindList.addVarBind(new SnmpVarBind(snmpTrapCommunityOid, (SnmpValue)snmpString));
            snmpVarBindList.addVarBind(new SnmpVarBind(snmpTrapEnterpriseOid, (SnmpValue)this.pduTrap.enterprise));
        }
        return snmpVarBindList;
    }

    private void convertPduList(SnmpVarBind[] snmpVarBindArray) {
        this.pduTrapList = new SnmpVarBindList();
        int n = 0;
        while (n < snmpVarBindArray.length) {
            this.pduTrapList.addVarBind(snmpVarBindArray[n]);
            ++n;
        }
    }

    private SnmpVarBind[] toVarBindArray(SnmpVarBindList snmpVarBindList) {
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[snmpVarBindList.size()];
        int n = 0;
        while (n < snmpVarBindList.size()) {
            snmpVarBindArray[n] = snmpVarBindList.getVarBindAt(n);
            ++n;
        }
        return snmpVarBindArray;
    }

    private void initialize(InetAddress inetAddress, String string, SnmpVarBindList snmpVarBindList) {
        this.address = inetAddress;
        this.communityString = string;
        this.pduTrapList = snmpVarBindList;
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)64, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)64, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)64, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

