/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.trace.Trace;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpSession;

class SnmpSessionProvider {
    private SnmpSession fixSession;
    private SnmpSession session;
    private int peerVersion;
    private String dbgTag;

    public SnmpSessionProvider(SnmpPeer snmpPeer, SnmpSession snmpSession) {
        block2: {
            this.fixSession = null;
            this.session = null;
            this.peerVersion = 0;
            this.dbgTag = "SnmpSessionProvider";
            try {
                this.peerVersion = snmpPeer.getParams().getProtocolVersion();
                this.session = snmpSession;
                SnmpEngine snmpEngine = snmpSession.getEngine();
                snmpSession.setDefaultPeer(snmpPeer);
                snmpSession.snmpOptions.setPduFixedOnError(false);
                this.fixSession = new SnmpSession(snmpEngine, "Fixed error Snmp session", null);
                this.fixSession.setDefaultPeer(snmpPeer);
                this.fixSession.snmpOptions.setPduFixedOnError(true);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!this.isDebugOn()) break block2;
                this.debug("SnmpSessionProvider", snmpStatusException);
            }
        }
    }

    SnmpSession getSession(int n) {
        if (this.isDebugOn()) {
            this.debug("getSession", "Manager protocol : " + n + "\nPeer protocol :" + this.peerVersion);
        }
        if (this.peerVersion == n) {
            return this.session;
        }
        if (this.peerVersion == 0) {
            if (this.isDebugOn()) {
                this.debug("getSession", "Return fixed session");
            }
            return this.fixSession;
        }
        return this.session;
    }

    SnmpSession getDefaultSession() {
        return this.session;
    }

    public synchronized void hideInvalidResponseError(boolean bl) {
        this.session.hideInvalidResponseError(bl);
        this.fixSession.hideInvalidResponseError(bl);
    }

    public synchronized boolean isInvalidResponseErrorHidden() {
        return this.session.isInvalidResponseErrorHidden();
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)64, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)64, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)64, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

