/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import com.sun.jdmk.snmp.agent.SnmpMibRequest;
import com.sun.jdmk.snmp.agent.SnmpSessionProvider;
import com.sun.jdmk.trace.Trace;
import java.io.Serializable;
import java.util.Enumeration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.snmp.SnmpCounter64;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpParams;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

public class SnmpProxy
extends SnmpMibAgent
implements Serializable {
    public static final long defaultTimeout = 10000L;
    private transient SnmpEngine engine = null;
    private SnmpPeer peer = null;
    private String dbgTag = "SnmpProxy";
    private String mibName = null;
    private String oid = null;
    private long timeout = 10000L;
    private SnmpSessionProvider provider = null;
    private transient long[] rootOid = null;
    private boolean initialized = false;
    private boolean skipError = false;
    private boolean forwardOnCheck = false;
    private boolean hide = true;

    public SnmpProxy(SnmpEngine snmpEngine, SnmpPeer snmpPeer, String string) throws SnmpStatusException, IllegalArgumentException {
        this.initializeProxy(snmpEngine, snmpPeer, string, "SnmpProxy");
    }

    public SnmpProxy(SnmpEngine snmpEngine, SnmpPeer snmpPeer, String string, String string2) throws SnmpStatusException, IllegalArgumentException {
        this.initializeProxy(snmpEngine, snmpPeer, string, string2);
    }

    public void skipError(boolean bl) {
        this.skipError = bl;
    }

    public boolean skipError() {
        return this.skipError;
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public long getTimeout() {
        return this.syncGetTimeout();
    }

    public void setTimeout(long l) {
        this.syncSetTimeout(l);
    }

    public void init() throws IllegalAccessException {
        if (this.initialized) {
            return;
        }
        if (this.isDebugOn()) {
            this.trace("init", "init");
        }
        try {
            SnmpSession snmpSession = new SnmpSession(this.engine, "Snmp session", null);
            this.provider = new SnmpSessionProvider(this.peer, snmpSession);
        }
        catch (SnmpStatusException snmpStatusException) {
            if (this.isTraceOn()) {
                this.trace("init", snmpStatusException.toString());
            }
            throw new IllegalAccessException(snmpStatusException.toString());
        }
        this.initialized = true;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        this.init();
        return objectName;
    }

    private void initializeProxy(SnmpEngine snmpEngine, SnmpPeer snmpPeer, String string, String string2) throws SnmpStatusException, IllegalArgumentException {
        if (snmpEngine == null) {
            new IllegalArgumentException("Engine can't be null");
        }
        if (this.isTraceOn()) {
            this.trace("initializeProxy", "initializing snmp proxy with : \nengine : " + snmpEngine + "\n" + "peer : " + snmpPeer.toString() + "\n" + "root OID : " + string + "\n" + "mib name : " + string2 + "\n");
        }
        this.engine = snmpEngine;
        this.oid = string;
        this.mibName = string2;
        this.peer = snmpPeer;
    }

    public String getMibName() {
        return this.mibName;
    }

    public synchronized void get(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isTraceOn()) {
            this.trace("get", "Sending get request to SNMP sub-agent");
        }
        this.provider.hideInvalidResponseError(this.hide);
        SnmpSession snmpSession = this.defineSession(snmpMibRequest);
        this.get(snmpSession.getDefaultPeer(), snmpSession, snmpMibRequest);
    }

    public synchronized void set(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (!this.isSetRequestForwardedOnCheck()) {
            if (this.isTraceOn()) {
                this.trace("set", "Sending set request to SNMP sub-agent.");
            }
            this.provider.hideInvalidResponseError(this.hide);
            SnmpSession snmpSession = this.provider.getDefaultSession();
            SnmpParams snmpParams = this.translateParameters(snmpMibRequest);
            snmpParams.setProtocolVersion(snmpSession.getDefaultPeer().getParams().getProtocolVersion());
            snmpSession.getDefaultPeer().setParams(snmpParams);
            this.set(snmpSession.getDefaultPeer(), snmpSession, snmpMibRequest);
        } else if (this.isTraceOn()) {
            this.trace("set", "Doing nothing, set already done on check.");
        }
    }

    public synchronized void forwardSetRequestOnCheck(boolean bl) {
        this.forwardOnCheck = bl;
    }

    public synchronized boolean isSetRequestForwardedOnCheck() {
        return this.forwardOnCheck;
    }

    public synchronized void hideInvalidResponseError(boolean bl) {
        this.hide = bl;
    }

    public synchronized boolean isInvalidResponseErrorHidden() {
        return this.hide;
    }

    public synchronized void check(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.provider.hideInvalidResponseError(this.hide);
        if (this.isSetRequestForwardedOnCheck()) {
            if (this.isTraceOn()) {
                this.trace("check", "Sending set request to SNMP sub-agent.");
            }
            SnmpSession snmpSession = this.provider.getDefaultSession();
            SnmpParams snmpParams = this.translateParameters(snmpMibRequest);
            snmpParams.setProtocolVersion(snmpSession.getDefaultPeer().getParams().getProtocolVersion());
            snmpSession.getDefaultPeer().setParams(snmpParams);
            this.set(snmpSession.getDefaultPeer(), snmpSession, snmpMibRequest);
        } else if (this.isTraceOn()) {
            this.trace("check", "Nothing to do, set forwarded on set");
        }
    }

    public synchronized void getNext(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isTraceOn()) {
            this.trace("getNext", "Sending getNext request to SNMP sub-agent.");
        }
        this.provider.hideInvalidResponseError(this.hide);
        SnmpSession snmpSession = this.defineSession(snmpMibRequest);
        this.getNext(snmpSession.getDefaultPeer(), snmpSession, snmpMibRequest);
    }

    public synchronized void getBulk(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        int n3 = snmpMibRequest.getVersion();
        if (n3 == 0) {
            if (this.isTraceOn()) {
                this.trace("getBulk", "Receive a getBulk in SnmpV1 protocol for sub-agent.");
            }
            throw new SnmpStatusException(5, 0);
        }
        this.provider.hideInvalidResponseError(this.hide);
        if (this.isTraceOn()) {
            this.trace("getBulk", "Sending getBulk (using getNext) request to SNMP sub-agent.");
        }
        this.getBulkWithGetNext(snmpMibRequest, n, n2);
    }

    public long[] getRootOid() {
        if (this.isTraceOn()) {
            this.trace("getRootOid", "Root oid to return : " + this.oid);
        }
        this.rootOid = this.resolveOidString(this.oid);
        return this.rootOid;
    }

    public final SnmpPeer getPeer() {
        return this.peer;
    }

    protected boolean handleReport(SnmpRequest snmpRequest) {
        return false;
    }

    protected SnmpParams translateParameters(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpPdu snmpPdu = snmpMibRequest.getPdu();
        if (snmpPdu == null) {
            return new SnmpParameters("public", "private");
        }
        SnmpParameters snmpParameters = new SnmpParameters("public", "private");
        if (this.isDebugOn()) {
            this.debug("translateParameters", "From version : " + snmpPdu.version);
        }
        switch (snmpPdu.version) {
            case 0: 
            case 1: {
                SnmpPduPacket snmpPduPacket = (SnmpPduPacket)snmpPdu;
                if (snmpPduPacket.community == null) break;
                snmpParameters.setRdCommunity(new String(snmpPduPacket.community));
                snmpParameters.setWrCommunity(new String(snmpPduPacket.community));
                break;
            }
            case 3: {
                break;
            }
            default: {
                if (!this.isTraceOn()) break;
                this.trace("translateParameters", "Unsupported snmp protocol version :" + snmpPdu.version);
            }
        }
        return snmpParameters;
    }

    protected synchronized void get(SnmpPeer snmpPeer, SnmpSession snmpSession, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        int n;
        boolean bl = true;
        SnmpRequest snmpRequest = null;
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SnmpProxy varbind list", snmpMibRequest.getSubList());
        while (bl) {
            if (this.isDebugOn()) {
                this.debug("get", "get(SnmpPeer " + snmpPeer + ",\n" + "SnmpSession " + snmpSession + ",\n" + "SnmpMibRequest " + snmpMibRequest + ")");
            }
            snmpRequest = snmpSession.snmpGetRequest(snmpPeer, null, snmpVarBindList);
            if (this.isDebugOn()) {
                this.debug("get(session, request)", "\nRequest:\n" + snmpRequest.toString());
            }
            if ((n = (int)(snmpRequest.waitForCompletion(this.getTimeout()) ? 1 : 0)) == 0) {
                if (this.isDebugOn()) {
                    this.debug("get(session, request)", "Request timed out.");
                }
                throw new SnmpStatusException(5, 0);
            }
            if (snmpRequest.isReport()) {
                bl = this.handleReport(snmpRequest);
                if (!bl) {
                    throw new SnmpStatusException(5);
                }
                if (!this.isDebugOn()) continue;
                this.debug("get", "Retrying");
                continue;
            }
            bl = false;
        }
        n = snmpRequest.getErrorStatus();
        int n2 = snmpRequest.getErrorIndex() + 1;
        if (n != 0) {
            if (this.isDebugOn()) {
                this.debug("get(session, request)", "Error.\nError status :" + SnmpRequest.snmpErrorToString((int)n) + "\nError index :" + n2);
            }
            throw new SnmpStatusException(n, n2);
        }
        if (snmpSession.snmpOptions.isPduFixedOnError()) {
            this.moveFixResult(snmpRequest, snmpMibRequest);
        } else {
            this.moveResult(snmpRequest, snmpMibRequest);
        }
    }

    protected synchronized void getNext(SnmpPeer snmpPeer, SnmpSession snmpSession, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        int n;
        boolean bl = true;
        SnmpRequest snmpRequest = null;
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SnmpProxy varbind list", snmpMibRequest.getSubList());
        while (bl) {
            if (this.isDebugOn()) {
                this.debug("get", "getnext(SnmpPeer " + snmpPeer + ",\n" + "SnmpSession " + snmpSession + ",\n" + "SnmpMibRequest " + snmpMibRequest + ")");
            }
            if ((n = (int)((snmpRequest = snmpSession.snmpGetNextRequest(snmpPeer, null, snmpVarBindList)).waitForCompletion(this.getTimeout()) ? 1 : 0)) == 0) {
                if (!this.skipError) {
                    if (this.isDebugOn()) {
                        this.debug("get(session, request)", "Request timed out.");
                    }
                    throw new SnmpStatusException(5, 0);
                }
                if (this.isDebugOn()) {
                    this.debug("getNext(session, request)", "Skipping error : timeout.");
                }
                return;
            }
            if (snmpRequest.isReport()) {
                bl = this.handleReport(snmpRequest);
                if (!bl) {
                    throw new SnmpStatusException(5);
                }
                if (!this.isDebugOn()) continue;
                this.debug("get", "Retrying");
                continue;
            }
            bl = false;
        }
        n = snmpRequest.getErrorStatus();
        int n2 = snmpRequest.getErrorIndex() + 1;
        if (n != 0) {
            if (this.skipError) {
                if (this.isDebugOn()) {
                    this.debug("getNext(session, request)", "Skipping error : " + n);
                }
                Enumeration enumeration = snmpMibRequest.getElements();
                while (enumeration.hasMoreElements()) {
                    SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
                    snmpVarBind.setSnmpValue((SnmpValue)SnmpVarBind.endOfMibView);
                }
                return;
            }
            if (this.isDebugOn()) {
                this.debug("getNext(session, request)", "Error.\nError status :" + SnmpRequest.snmpErrorToString((int)n) + "\nError index :" + n2);
            }
            throw new SnmpStatusException(n, n2);
        }
        if (snmpSession.snmpOptions.isPduFixedOnError()) {
            this.moveFixGetNextResult(snmpRequest, snmpMibRequest);
        } else {
            this.moveGetNextResult(snmpRequest, snmpMibRequest);
        }
    }

    protected synchronized void set(SnmpPeer snmpPeer, SnmpSession snmpSession, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        int n;
        boolean bl = true;
        SnmpRequest snmpRequest = null;
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SnmpProxy varbind list", snmpMibRequest.getSubList());
        while (bl) {
            if (this.isDebugOn()) {
                this.debug("get", "getnext(SnmpPeer " + snmpPeer + ",\n" + "SnmpSession " + snmpSession + ",\n" + "SnmpMibRequest " + snmpMibRequest + ")");
            }
            if ((n = (int)((snmpRequest = snmpSession.snmpSetRequest(snmpPeer, null, snmpVarBindList)).waitForCompletion(this.getTimeout()) ? 1 : 0)) == 0) {
                if (this.isDebugOn()) {
                    this.debug("set(session, request)", "Request timed out.");
                }
                throw new SnmpStatusException(5, 0);
            }
            if (snmpRequest.isReport()) {
                bl = this.handleReport(snmpRequest);
                if (!this.isDebugOn()) continue;
                this.debug("get", "Retrying");
                continue;
            }
            bl = false;
        }
        n = snmpRequest.getErrorStatus();
        int n2 = snmpRequest.getErrorIndex() + 1;
        if (n != 0) {
            if (this.isDebugOn()) {
                this.debug("set(session, request)", "Error.\nError status :" + SnmpRequest.snmpErrorToString((int)n) + "\nError index :" + n2);
            }
            throw new SnmpStatusException(n, n2);
        }
        this.moveResult(snmpRequest, snmpMibRequest);
    }

    private synchronized void syncSetTimeout(long l) {
        this.timeout = l;
    }

    private synchronized long syncGetTimeout() {
        return this.timeout;
    }

    private SnmpSession defineSession(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("defineSession", snmpMibRequest.toString());
        }
        int n = snmpMibRequest.getVersion();
        SnmpSession snmpSession = this.provider.getSession(n);
        SnmpParams snmpParams = null;
        snmpParams = this.translateParameters(snmpMibRequest);
        if (snmpParams == null) {
            throw new SnmpStatusException("Unable to define parameters to send to distant peer.");
        }
        snmpParams.setProtocolVersion(snmpSession.getDefaultPeer().getParams().getProtocolVersion());
        snmpSession.getDefaultPeer().setParams(snmpParams);
        return snmpSession;
    }

    private void handleException(SnmpVarBind snmpVarBind, int n) throws SnmpStatusException {
        int n2 = snmpVarBind.status;
        if (n2 != 2) {
            if (n2 == 2 || n2 == 3 || n2 == 5) {
                throw new SnmpStatusException(n2, n + 1);
            }
            throw new SnmpStatusException(2, n + 1);
        }
    }

    private void handleCounter64(SnmpVarBind snmpVarBind, int n) throws SnmpStatusException {
        if (snmpVarBind.value instanceof SnmpCounter64) {
            throw new SnmpStatusException(2, n);
        }
    }

    private void moveResult(SnmpRequest snmpRequest, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("moveResult", "Result to move with no error");
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
        Enumeration enumeration = snmpMibRequest.getElements();
        int n = 0;
        Enumeration enumeration2 = snmpVarBindList.elements();
        while (enumeration2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration2.nextElement();
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            if (snmpMibRequest.getVersion() == 0) {
                this.handleException(snmpVarBind, n);
                this.handleCounter64(snmpVarBind, n);
            }
            snmpVarBind2.value = snmpVarBind.value;
            ++n;
            if (!this.isDebugOn()) continue;
            this.debug("moveResult", "\nVarResult : " + snmpVarBind.toString() + "\nVarResult status: " + snmpVarBind.status + "\nVarBind : " + snmpVarBind2.toString() + "\nVarBind status: " + snmpVarBind2.status);
        }
    }

    private void moveFixResult(SnmpRequest snmpRequest, SnmpMibRequest snmpMibRequest) {
        if (this.isDebugOn()) {
            this.debug("moveFixResult", "Result to move with errors");
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
        Enumeration enumeration = snmpMibRequest.getElements();
        Enumeration enumeration2 = snmpVarBindList.elements();
        while (enumeration2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration2.nextElement();
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind2.value = snmpVarBind.status == 4 || snmpVarBind.status == 3 ? SnmpVarBind.noSuchInstance : snmpVarBind.value;
            if (!this.isDebugOn()) continue;
            this.debug("moveResult", "\nVarResult : " + snmpVarBind.toString() + "\nVarResult status: " + snmpVarBind.status + "\nVarBind : " + snmpVarBind2.toString() + "\nVarBind status: " + snmpVarBind2.status);
        }
    }

    private void moveGetNextResult(SnmpRequest snmpRequest, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("moveGetNextResult", "Result to move with no error");
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
        Enumeration enumeration = snmpMibRequest.getElements();
        int n = 0;
        Enumeration enumeration2 = snmpVarBindList.elements();
        while (enumeration2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration2.nextElement();
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            if (snmpMibRequest.getVersion() == 0) {
                this.handleException(snmpVarBind, n);
                this.handleCounter64(snmpVarBind, n);
            }
            snmpVarBind2.value = snmpVarBind.value;
            snmpVarBind2.oid = snmpVarBind.oid;
            ++n;
            if (!this.isDebugOn()) continue;
            this.debug("moveGetNextResult", "\nVarResult : " + snmpVarBind.toString() + "\nVarResult status: " + snmpVarBind.status + "\nVarBind : " + snmpVarBind2.toString() + "\nVarBind status: " + snmpVarBind2.status);
        }
    }

    private void moveFixGetNextResult(SnmpRequest snmpRequest, SnmpMibRequest snmpMibRequest) {
        if (this.isDebugOn()) {
            this.debug("moveFixGetNextResult", "Result to move with errors");
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
        Enumeration enumeration = snmpMibRequest.getElements();
        Enumeration enumeration2 = snmpVarBindList.elements();
        while (enumeration2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration2.nextElement();
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind2.oid = snmpVarBind.oid;
            snmpVarBind2.value = snmpVarBind.status == 5 ? SnmpVarBind.endOfMibView : snmpVarBind.value;
            if (!this.isDebugOn()) continue;
            this.debug("moveResult", "\nVarResult : " + snmpVarBind.toString() + "\nVarResult status: " + snmpVarBind.status + "\nVarBind : " + snmpVarBind2.toString() + "\nVarBind status: " + snmpVarBind2.status);
        }
    }

    private long[] resolveOidString(String string) {
        SnmpOid snmpOid = new SnmpOid(string);
        return snmpOid.longValue();
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

