/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.AcmChecker;
import com.sun.jdmk.snmp.agent.SnmpEntryOid;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.agent.SnmpMibNode;
import com.sun.jdmk.snmp.agent.SnmpMibSubRequest;
import com.sun.jdmk.snmp.agent.SnmpRequestTree;
import com.sun.jdmk.snmp.agent.SnmpTableEntryFactory;
import com.sun.jdmk.snmp.agent.SnmpTableEntryNotification;
import com.sun.jdmk.trace.Trace;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public abstract class SnmpMibTable
extends SnmpMibNode
implements NotificationBroadcaster,
Serializable {
    protected int nodeId = 1;
    protected SnmpMib theMib;
    protected boolean creationEnabled = false;
    protected SnmpTableEntryFactory factory = null;
    private int size = 0;
    private static final int Delta = 16;
    private int tablecount = 0;
    private int tablesize = 16;
    private SnmpOid[] tableoids = new SnmpOid[this.tablesize];
    private final Vector entries = new Vector();
    private final Vector entrynames = new Vector();
    private Hashtable handbackTable = new Hashtable();
    private Hashtable filterTable = new Hashtable();
    transient long sequenceNumber = 0L;

    public SnmpMibTable(SnmpMib snmpMib) {
        this.theMib = snmpMib;
        this.setCreationEnabled(false);
    }

    public abstract void createNewEntry(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    public abstract boolean isRegistrationRequired();

    public boolean isCreationEnabled() {
        return this.creationEnabled;
    }

    public void setCreationEnabled(boolean bl) {
        this.creationEnabled = bl;
    }

    public boolean hasRowStatus() {
        return false;
    }

    public void get(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        SnmpOid snmpOid;
        boolean bl = snmpMibSubRequest.isNewEntry();
        SnmpMibSubRequest snmpMibSubRequest2 = snmpMibSubRequest;
        if (bl) {
            snmpOid = null;
            Enumeration enumeration = snmpMibSubRequest2.getElements();
            while (enumeration.hasMoreElements()) {
                snmpOid = (SnmpVarBind)enumeration.nextElement();
                snmpMibSubRequest2.registerGetException((SnmpVarBind)snmpOid, SnmpMibNode.noSuchInstanceException);
            }
        }
        snmpOid = snmpMibSubRequest2.getEntryOid();
        this.get(snmpMibSubRequest, snmpOid, n + 1);
    }

    public void check(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        SnmpOid snmpOid = snmpMibSubRequest.getEntryOid();
        int n2 = this.getRowAction(snmpMibSubRequest, snmpOid, n + 1);
        boolean bl = SnmpMibTable.isDebugOn();
        if (bl) {
            this.debug("check", "Calling beginRowAction");
        }
        this.beginRowAction(snmpMibSubRequest, snmpOid, n + 1, n2);
        if (bl) {
            this.debug("check", "Calling check for " + snmpMibSubRequest.getSize() + " varbinds.");
        }
        this.check(snmpMibSubRequest, snmpOid, n + 1);
        if (bl) {
            this.debug("check", "check finished");
        }
    }

    public void set(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        boolean bl = SnmpMibTable.isDebugOn();
        if (bl) {
            this.debug("set", "Entering set.");
        }
        SnmpOid snmpOid = snmpMibSubRequest.getEntryOid();
        int n2 = this.getRowAction(snmpMibSubRequest, snmpOid, n + 1);
        if (bl) {
            this.debug("set", "Calling set for " + snmpMibSubRequest.getSize() + "varbinds.");
        }
        this.set(snmpMibSubRequest, snmpOid, n + 1);
        if (bl) {
            this.debug("set", "Calling endRowAction");
        }
        this.endRowAction(snmpMibSubRequest, snmpOid, n + 1, n2);
        if (bl) {
            this.debug("set", "RowAction finished");
        }
    }

    public void addEntry(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        this.addEntry(snmpOid, null, object);
    }

    public synchronized void addEntry(SnmpOid snmpOid, ObjectName objectName, Object object) throws SnmpStatusException {
        if (this.isRegistrationRequired() && objectName == null) {
            throw new SnmpStatusException(3);
        }
        if (this.size == 0) {
            this.insertOid(0, snmpOid);
            if (this.entries != null) {
                this.entries.addElement(object);
            }
            if (this.entrynames != null) {
                this.entrynames.addElement(objectName);
            }
            ++this.size;
            if (this.factory != null) {
                try {
                    this.factory.addEntryCb(0, snmpOid, objectName, object, this);
                }
                catch (SnmpStatusException snmpStatusException) {
                    this.removeOid(0);
                    if (this.entries != null) {
                        this.entries.removeElementAt(0);
                    }
                    if (this.entrynames != null) {
                        this.entrynames.removeElementAt(0);
                    }
                    throw snmpStatusException;
                }
            }
            this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_ADDED, new Date().getTime(), object, objectName);
            return;
        }
        int n = 0;
        n = this.getInsertionPoint(snmpOid, true);
        if (n == this.size) {
            this.insertOid(this.tablecount, snmpOid);
            if (this.entries != null) {
                this.entries.addElement(object);
            }
            if (this.entrynames != null) {
                this.entrynames.addElement(objectName);
            }
            ++this.size;
        } else {
            try {
                this.insertOid(n, snmpOid);
                if (this.entries != null) {
                    this.entries.insertElementAt(object, n);
                }
                if (this.entrynames != null) {
                    this.entrynames.insertElementAt(objectName, n);
                }
                ++this.size;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (this.factory != null) {
            try {
                this.factory.addEntryCb(n, snmpOid, objectName, object, this);
            }
            catch (SnmpStatusException snmpStatusException) {
                this.removeOid(n);
                if (this.entries != null) {
                    this.entries.removeElementAt(n);
                }
                if (this.entrynames != null) {
                    this.entrynames.removeElementAt(n);
                }
                throw snmpStatusException;
            }
        }
        this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_ADDED, new Date().getTime(), object, objectName);
    }

    public synchronized void removeEntry(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        int n = this.findObject(snmpOid);
        if (n == -1) {
            return;
        }
        this.removeEntry(n, object);
    }

    public void removeEntry(SnmpOid snmpOid) throws SnmpStatusException {
        int n = this.findObject(snmpOid);
        if (n == -1) {
            return;
        }
        this.removeEntry(n, null);
    }

    public synchronized void removeEntry(int n, Object object) throws SnmpStatusException {
        if (n == -1) {
            return;
        }
        if (n >= this.size) {
            return;
        }
        Object object2 = object;
        if (this.entries != null && this.entries.size() > n) {
            object2 = this.entries.elementAt(n);
            this.entries.removeElementAt(n);
        }
        ObjectName objectName = null;
        if (this.entrynames != null && this.entrynames.size() > n) {
            objectName = (ObjectName)this.entrynames.elementAt(n);
            this.entrynames.removeElementAt(n);
        }
        SnmpOid snmpOid = this.tableoids[n];
        this.removeOid(n);
        --this.size;
        if (object2 == null) {
            object2 = object;
        }
        if (this.factory != null) {
            this.factory.removeEntryCb(n, snmpOid, objectName, object2, this);
        }
        this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_REMOVED, new Date().getTime(), object2, objectName);
    }

    public synchronized Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        int n = this.findObject(snmpOid);
        if (n == -1) {
            throw new SnmpStatusException(224);
        }
        return this.entries.elementAt(n);
    }

    public synchronized ObjectName getEntryName(SnmpOid snmpOid) throws SnmpStatusException {
        int n = this.findObject(snmpOid);
        if (this.entrynames == null) {
            return null;
        }
        if (n == -1 || n >= this.entrynames.size()) {
            throw new SnmpStatusException(224);
        }
        return (ObjectName)this.entrynames.elementAt(n);
    }

    public Object[] getBasicEntries() {
        Object[] objectArray = new Object[this.size];
        this.entries.copyInto(objectArray);
        return objectArray;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Vector<Object> vector = (Vector<Object>)this.handbackTable.get(notificationListener);
        Vector<NotificationFilter> vector2 = (Vector<NotificationFilter>)this.filterTable.get(notificationListener);
        if (vector == null) {
            vector = new Vector<Object>();
            vector2 = new Vector<NotificationFilter>();
            this.handbackTable.put(notificationListener, vector);
            this.filterTable.put(notificationListener, vector2);
        }
        vector.addElement(object);
        vector2.addElement(notificationFilter);
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Vector vector = (Vector)this.handbackTable.get(notificationListener);
        Vector vector2 = (Vector)this.filterTable.get(notificationListener);
        if (vector == null) {
            throw new ListenerNotFoundException("listener");
        }
        this.handbackTable.remove(notificationListener);
        this.filterTable.remove(notificationListener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{SnmpTableEntryNotification.SNMP_ENTRY_ADDED, SnmpTableEntryNotification.SNMP_ENTRY_REMOVED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "com.sun.jdmk.snmp.agent.SnmpTableEntryNotification", "Notifications sent by the SnmpMibTable")};
        return mBeanNotificationInfoArray;
    }

    public void registerEntryFactory(SnmpTableEntryFactory snmpTableEntryFactory) {
        this.factory = snmpTableEntryFactory;
    }

    protected boolean isRowStatus(SnmpOid snmpOid, long l, Object object) {
        return false;
    }

    protected int getRowAction(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n) throws SnmpStatusException {
        boolean bl = snmpMibSubRequest.isNewEntry();
        SnmpVarBind snmpVarBind = snmpMibSubRequest.getRowStatusVarBind();
        if (snmpVarBind == null) {
            if (bl && !this.hasRowStatus()) {
                return 4;
            }
            return 0;
        }
        try {
            return this.mapRowStatus(snmpOid, snmpVarBind, snmpMibSubRequest.getUserData());
        }
        catch (SnmpStatusException snmpStatusException) {
            SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, snmpStatusException.getStatus());
            return 0;
        }
    }

    protected int mapRowStatus(SnmpOid snmpOid, SnmpVarBind snmpVarBind, Object object) throws SnmpStatusException {
        SnmpValue snmpValue = snmpVarBind.value;
        if (snmpValue instanceof SnmpInt) {
            return ((SnmpInt)snmpValue).intValue();
        }
        throw new SnmpStatusException(12);
    }

    protected SnmpValue setRowStatus(SnmpOid snmpOid, int n, Object object) throws SnmpStatusException {
        return null;
    }

    protected boolean isRowReady(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        return true;
    }

    protected void checkRowStatusChange(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n, int n2) throws SnmpStatusException {
    }

    protected void checkRemoveTableRow(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n) throws SnmpStatusException {
    }

    protected void removeTableRow(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n) throws SnmpStatusException {
        this.removeEntry(snmpOid);
    }

    protected synchronized void beginRowAction(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n, int n2) throws SnmpStatusException {
        boolean bl = snmpMibSubRequest.isNewEntry();
        SnmpOid snmpOid2 = snmpOid;
        int n3 = n2;
        switch (n3) {
            case 0: {
                if (!bl) break;
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("beginRowAction", "Failed to create row[" + snmpOid + "] : RowStatus = unspecified");
                }
                SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 6);
                break;
            }
            case 4: 
            case 5: {
                if (bl) {
                    if (this.isCreationEnabled()) {
                        if (SnmpMibTable.isDebugOn()) {
                            this.debug("beginRowAction", "Creating row[" + snmpOid + "] : RowStatus = createAndGo | createAndWait");
                        }
                        this.createNewEntry(snmpMibSubRequest, snmpOid2, n);
                        break;
                    }
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("beginRowAction", "Can't create row[" + snmpOid + "] : RowStatus = createAndGo | createAndWait" + " but creation is disabled");
                    }
                    SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 6);
                    break;
                }
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("beginRowAction", "Can't create row[" + snmpOid + "] : RowStatus = createAndGo | createAndWait" + " but row already exists");
                }
                SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 12);
                break;
            }
            case 6: {
                if (bl) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("beginRowAction", "Warning: can't destroy row[" + snmpOid + "] : RowStatus = destroy" + " but row does not exist");
                    }
                } else if (!this.isCreationEnabled()) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("beginRowAction", "Can't destroy row[" + snmpOid + "] : RowStatus = destroy " + " but creation is disabled");
                    }
                    SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 6);
                }
                this.checkRemoveTableRow(snmpMibSubRequest, snmpOid, n);
                break;
            }
            case 1: 
            case 2: {
                if (bl) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("beginRowAction", "Can't switch state of row[" + snmpOid + "] : specified RowStatus = active | notInService" + " but row does not exist");
                    }
                    SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 12);
                }
                this.checkRowStatusChange(snmpMibSubRequest, snmpOid, n, n3);
                break;
            }
            default: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("beginRowAction", "Invalid RowStatus value for row[" + snmpOid + "] : specified RowStatus = " + n3);
                }
                SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 12);
            }
        }
    }

    protected void endRowAction(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n, int n2) throws SnmpStatusException {
        SnmpVarBind snmpVarBind;
        boolean bl = snmpMibSubRequest.isNewEntry();
        SnmpOid snmpOid2 = snmpOid;
        int n3 = n2;
        Object object = snmpMibSubRequest.getUserData();
        SnmpValue snmpValue = null;
        switch (n3) {
            case 0: {
                break;
            }
            case 4: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Setting RowStatus to `active' for row[" + snmpOid + "] : requested RowStatus = " + "createAndGo");
                }
                snmpValue = this.setRowStatus(snmpOid2, 1, object);
                break;
            }
            case 5: {
                if (this.isRowReady(snmpOid2, object)) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("endRowAction", "Setting RowStatus to `notInService' for row[" + snmpOid + "] : requested RowStatus = " + "createAndWait");
                    }
                    snmpValue = this.setRowStatus(snmpOid2, 2, object);
                    break;
                }
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Setting RowStatus to `notReady' for row[" + snmpOid + "] : requested RowStatus = " + "createAndWait");
                }
                snmpValue = this.setRowStatus(snmpOid2, 3, object);
                break;
            }
            case 6: {
                if (bl) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("endRowAction", "Warning:  requested RowStatus = destroy,but row[" + snmpOid + "] does not exist.");
                    }
                } else if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "destroying row[" + snmpOid + "] : requested RowStatus = destroy");
                }
                this.removeTableRow(snmpMibSubRequest, snmpOid2, n);
                break;
            }
            case 1: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Setting RowStatus to `active' for row[" + snmpOid + "] : requested RowStatus = " + "active");
                }
                snmpValue = this.setRowStatus(snmpOid2, 1, object);
                break;
            }
            case 2: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Setting RowStatus to `notInService' for row[" + snmpOid + "] : requested RowStatus = " + "notInService");
                }
                snmpValue = this.setRowStatus(snmpOid2, 2, object);
                break;
            }
            default: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Invalid RowStatus value for row[" + snmpOid + "] : specified RowStatus = " + n3);
                }
                SnmpMibTable.setRowStatusFail(snmpMibSubRequest, 12);
            }
        }
        if (snmpValue != null && (snmpVarBind = snmpMibSubRequest.getRowStatusVarBind()) != null) {
            snmpVarBind.value = snmpValue;
        }
    }

    protected abstract long getNextVarEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract void validateVarEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract boolean isReadableEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract void get(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    protected abstract void check(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    protected abstract void set(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        if (this.size == 0) {
            throw SnmpMibNode.noSuchInstanceException;
        }
        SnmpOid snmpOid2 = this.tableoids[this.tablecount - 1];
        SnmpOid snmpOid3 = snmpOid;
        if (snmpOid2.equals((Object)snmpOid3)) {
            throw SnmpMibNode.noSuchInstanceException;
        }
        int n = this.getInsertionPoint(snmpOid3, false);
        if (n > -1 && n < this.size) {
            try {
                snmpOid2 = this.tableoids[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw SnmpMibNode.noSuchInstanceException;
            }
        } else {
            throw SnmpMibNode.noSuchInstanceException;
        }
        return snmpOid2;
    }

    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        if (this.size == 0) {
            throw SnmpMibNode.noSuchInstanceException;
        }
        return this.tableoids[0];
    }

    SnmpOid getNextOid(long[] lArray, int n, Object object) throws SnmpStatusException {
        if (this.size == 0) {
            throw SnmpMibNode.noSuchInstanceException;
        }
        SnmpEntryOid snmpEntryOid = new SnmpEntryOid(lArray, n);
        return this.getNextOid(snmpEntryOid, object);
    }

    static final void checkRowStatusFail(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = snmpMibSubRequest.getRowStatusVarBind();
        SnmpStatusException snmpStatusException = new SnmpStatusException(n);
        snmpMibSubRequest.registerCheckException(snmpVarBind, snmpStatusException);
    }

    static final void setRowStatusFail(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = snmpMibSubRequest.getRowStatusVarBind();
        SnmpStatusException snmpStatusException = new SnmpStatusException(n);
        snmpMibSubRequest.registerSetException(snmpVarBind, snmpStatusException);
    }

    final synchronized void findHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, SnmpRequestTree snmpRequestTree) throws SnmpStatusException {
        int n2 = lArray.length;
        if (snmpRequestTree == null) {
            throw new SnmpStatusException(5);
        }
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        if (lArray[n] != (long)this.nodeId) {
            throw new SnmpStatusException(6);
        }
        if (n + 2 >= n2) {
            throw new SnmpStatusException(6);
        }
        SnmpEntryOid snmpEntryOid = new SnmpEntryOid(lArray, n + 2);
        Object object = snmpRequestTree.getUserData();
        boolean bl = this.contains(snmpEntryOid, object);
        if (!bl) {
            if (!snmpRequestTree.isCreationAllowed()) {
                throw SnmpMibNode.noSuchInstanceException;
            }
            if (!this.isCreationEnabled()) {
                throw new SnmpStatusException(6);
            }
        }
        long l = lArray[n + 1];
        if (bl) {
            this.validateVarEntryId(snmpEntryOid, l, object);
        }
        if (snmpRequestTree.isSetRequest() && this.isRowStatus(snmpEntryOid, l, object)) {
            snmpRequestTree.add(this, n, snmpEntryOid, snmpVarBind, !bl, snmpVarBind);
        } else {
            snmpRequestTree.add(this, n, snmpEntryOid, snmpVarBind, !bl);
        }
    }

    final synchronized long[] findNextHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, int n2, SnmpRequestTree snmpRequestTree, AcmChecker acmChecker) throws SnmpStatusException {
        int n3 = lArray.length;
        if (snmpRequestTree == null) {
            throw SnmpMibNode.noSuchObjectException;
        }
        Object object = snmpRequestTree.getUserData();
        long l = -1L;
        if (n >= n3) {
            lArray = new long[]{this.nodeId};
            n = 0;
            n3 = 1;
        } else {
            if (lArray[n] > (long)this.nodeId) {
                throw SnmpMibNode.noSuchObjectException;
            }
            if (lArray[n] < (long)this.nodeId) {
                lArray = new long[]{this.nodeId};
                n = 0;
                n3 = 0;
            } else if (n + 1 < n3) {
                l = lArray[n + 1];
            }
        }
        SnmpOid snmpOid = null;
        Object var12_11 = null;
        if (n == n3 - 1) {
            return this.findNextAccessibleOid(null, snmpVarBind, lArray, n2, snmpRequestTree, acmChecker, object, l);
        }
        if (n == n3 - 2) {
            return this.findNextAccessibleOid(null, snmpVarBind, lArray, n2, snmpRequestTree, acmChecker, object, l);
        }
        try {
            snmpOid = this.getNextOid(lArray, n + 2, object);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpOid = null;
            l = this.getNextVarEntryId(snmpOid, l, object);
        }
        return this.findNextAccessibleOid(snmpOid, snmpVarBind, lArray, n2, snmpRequestTree, acmChecker, object, l);
    }

    /*
     * Unable to fully structure code
     */
    private long[] findNextAccessibleOid(SnmpOid var1_1, SnmpVarBind var2_2, long[] var3_3, int var4_4, SnmpRequestTree var5_5, AcmChecker var6_6, Object var7_7, long var8_8) throws SnmpStatusException {
        var10_9 = false;
        var11_10 = null;
        while (!var10_9) {
            if (var8_8 != -1L) {
                if (var1_1 == null) {
                    var1_1 = this.getNextOid(var7_7);
                }
                var12_11 = var1_1.getLength();
                var13_14 = var1_1.longValue(false);
                var11_10 = new long[var4_4 + 2 + var12_11];
                var11_10[0] = -1L;
                System.arraycopy(var13_14, 0, var11_10, var4_4 + 2, var12_11);
                var6_6.add(var4_4, -1L);
                var6_6.add(var4_4 + 1, -1L);
                var14_16 = 0;
                var15_18 = var4_4 + 2;
                while (var14_16 < var12_11) {
                    var6_6.add(var15_18, var13_14[var14_16]);
                    ++var14_16;
                    ++var15_18;
                }
                try {
                    if (!this.isReadableEntryId(var1_1, var8_8, var7_7)) {
                        throw SnmpMibNode.noSuchObjectException;
                    }
                    var11_10[var4_4] = this.nodeId;
                    var11_10[var4_4 + 1] = var8_8;
                    var6_6.remove(var4_4 + 1);
                    var6_6.remove(var4_4);
                    var6_6.add(var4_4, var11_10[var4_4]);
                    var6_6.add(var4_4 + 1, var11_10[var4_4 + 1]);
                    try {
                        var6_6.checkCurrentOid();
                        var5_5.add(this, var4_4, var1_1, var2_2, false);
                        var16_20 = var12_11;
                        while (var16_20 >= 0) {
                            var6_6.remove(var4_4 + 2 + var16_20);
                            --var16_20;
                        }
                        var6_6.remove(var4_4 + 1);
                        var6_6.remove(var4_4);
                        return var11_10;
                    }
                    catch (SnmpStatusException var16_21) {
                        var17_25 = var12_11;
                        ** while (var17_25 >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var6_6.remove(var4_4 + 2 + var17_25);
                        --var17_25;
                        continue;
                    }
lbl47:
                    // 1 sources

                    var6_6.remove(var4_4 + 1);
                    var6_6.remove(var4_4);
                    var1_1 = this.getNextOid(var1_1, var7_7);
                }
                catch (SnmpStatusException var16_22) {
                    var1_1 = this.getNextOid(var7_7);
                    var8_8 = this.getNextVarEntryId(var1_1, var8_8, var7_7);
                }
            }
            try {
                var12_12 = false;
                var13_15 = 0;
                var14_17 = null;
                var15_19 = null;
                while (!var12_12) {
                    if (var1_1 == null && var15_19 == null) {
                        var1_1 = this.getNextOid(var7_7);
                        var8_8 = this.getNextVarEntryId(var1_1, var8_8, var7_7);
                    }
                    if (var15_19 != null) {
                        var1_1 = this.getNextOid(var1_1, var7_7);
                    }
                    var15_19 = var1_1;
                    var13_15 = var1_1.getLength();
                    var14_17 = var1_1.longValue(false);
                    var11_10 = new long[var4_4 + 2 + var13_15];
                    var11_10[0] = -1L;
                    System.arraycopy(var14_17, 0, var11_10, var4_4 + 2, var13_15);
                    var6_6.add(var4_4, -1L);
                    var6_6.add(var4_4 + 1, -1L);
                    var16_23 = 0;
                    var17_25 = var4_4 + 2;
                    while (var16_23 < var13_15) {
                        var6_6.add(var17_25, var14_17[var16_23]);
                        ++var16_23;
                        ++var17_25;
                    }
                    var11_10[var4_4] = this.nodeId;
                    var11_10[var4_4 + 1] = var8_8;
                    var6_6.remove(var4_4 + 1);
                    var6_6.remove(var4_4);
                    var6_6.add(var4_4, var11_10[var4_4]);
                    var6_6.add(var4_4 + 1, var11_10[var4_4 + 1]);
                    try {
                        var6_6.checkCurrentOid();
                        var12_12 = true;
                        continue;
                    }
                    catch (SnmpStatusException var18_26) {
                        var19_27 = var13_15;
                        ** while (var19_27 >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var6_6.remove(var4_4 + 2 + var19_27);
                        --var19_27;
                        continue;
                    }
lbl96:
                    // 1 sources

                    var6_6.remove(var4_4 + 1);
                    var6_6.remove(var4_4);
                }
                var16_24 = var13_15;
                while (var16_24 >= 0) {
                    var6_6.remove(var4_4 + 2 + var16_24);
                    --var16_24;
                }
                var6_6.remove(var4_4 + 1);
                var6_6.remove(var4_4);
                var12_12 = true;
            }
            catch (SnmpStatusException var12_13) {
                var8_8 = this.getNextVarEntryId(var1_1, var8_8, var7_7);
                continue;
            }
            var10_9 = true;
        }
        var5_5.add(this, var4_4, var1_1, var2_2, false);
        return var11_10;
    }

    final void validateOid(long[] lArray, int n) throws SnmpStatusException {
        int n2 = lArray.length;
        if (n + 2 >= n2) {
            throw SnmpMibNode.noSuchInstanceException;
        }
        if (lArray[n] != (long)this.nodeId) {
            throw SnmpMibNode.noSuchObjectException;
        }
    }

    private synchronized void sendNotification(Notification notification) {
        Enumeration enumeration = this.handbackTable.keys();
        while (enumeration.hasMoreElements()) {
            NotificationListener notificationListener = (NotificationListener)enumeration.nextElement();
            Vector vector = (Vector)this.handbackTable.get(notificationListener);
            Vector vector2 = (Vector)this.filterTable.get(notificationListener);
            Enumeration enumeration2 = vector2.elements();
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                Object e = enumeration3.nextElement();
                NotificationFilter notificationFilter = (NotificationFilter)enumeration2.nextElement();
                if (notificationFilter != null && (notificationFilter == null || !notificationFilter.isNotificationEnabled(notification))) continue;
                notificationListener.handleNotification(notification, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(String string, long l, Object object, ObjectName objectName) {
        SnmpMibTable snmpMibTable = this;
        synchronized (snmpMibTable) {
            ++this.sequenceNumber;
        }
        SnmpTableEntryNotification snmpTableEntryNotification = new SnmpTableEntryNotification(string, this, this.sequenceNumber, l, object, objectName);
        this.sendNotification(snmpTableEntryNotification);
    }

    protected boolean contains(SnmpOid snmpOid, Object object) {
        return this.findObject(snmpOid) > -1;
    }

    private final int findObject(SnmpOid snmpOid) {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = n + (n2 - n) / 2;
        while (n <= n2) {
            SnmpOid snmpOid2 = this.tableoids[n3];
            int n4 = snmpOid.compareTo(snmpOid2);
            if (n4 == 0) {
                return n3;
            }
            if (snmpOid.equals((Object)snmpOid2)) {
                return n3;
            }
            if (n4 > 0) {
                n = n3 + 1;
            } else {
                n2 = n3 - 1;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1;
    }

    private final int getInsertionPoint(SnmpOid snmpOid) throws SnmpStatusException {
        return this.getInsertionPoint(snmpOid, true);
    }

    private final int getInsertionPoint(SnmpOid snmpOid, boolean bl) throws SnmpStatusException {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = n + (n2 - n) / 2;
        while (n <= n2) {
            SnmpOid snmpOid2 = this.tableoids[n3];
            int n4 = snmpOid.compareTo(snmpOid2);
            if (n4 == 0) {
                if (bl) {
                    throw new SnmpStatusException(17, n3);
                }
                return n3 + 1;
            }
            if (n4 > 0) {
                n = n3 + 1;
            } else {
                n2 = n3 - 1;
            }
            n3 = n + (n2 - n) / 2;
        }
        return n3;
    }

    private final void removeOid(int n) {
        if (n >= this.tablecount) {
            return;
        }
        if (n < 0) {
            return;
        }
        int n2 = --this.tablecount - n;
        this.tableoids[n] = null;
        if (n2 > 0) {
            System.arraycopy(this.tableoids, n + 1, this.tableoids, n, n2);
        }
        this.tableoids[this.tablecount] = null;
    }

    private final void insertOid(int n, SnmpOid snmpOid) {
        if (n >= this.tablesize || this.tablecount == this.tablesize) {
            SnmpOid[] snmpOidArray = this.tableoids;
            this.tablesize += 16;
            this.tableoids = new SnmpOid[this.tablesize];
            if (n > this.tablecount) {
                n = this.tablecount;
            }
            if (n < 0) {
                n = 0;
            }
            int n2 = n;
            int n3 = this.tablecount - n;
            if (n2 > 0) {
                System.arraycopy(snmpOidArray, 0, this.tableoids, 0, n2);
            }
            if (n3 > 0) {
                System.arraycopy(snmpOidArray, n2, this.tableoids, n2 + 1, n3);
            }
        } else if (n < this.tablecount) {
            System.arraycopy(this.tableoids, n, this.tableoids, n + 1, this.tablecount - n);
        }
        this.tableoids[n] = snmpOid;
        ++this.tablecount;
    }

    private static final boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    private final void debug(String string, String string2) {
        Trace.send((int)2, (int)1024, (String)this.getClass().getName(), (String)string, (String)string2);
    }
}

