/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpMibRequest;
import com.sun.jdmk.snmp.agent.SnmpRequestTree;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpVarBind;

final class SnmpMibRequestImpl
implements SnmpMibRequest {
    private Vector varbinds;
    private int version;
    private Object data;
    private SnmpPdu reqPdu = null;
    private SnmpRequestTree tree = null;
    private SnmpEngine engine = null;
    private String principal = null;
    private int securityLevel = -1;
    private int securityModel = -1;
    private byte[] contextName = null;
    private byte[] accessContextName = null;

    public SnmpMibRequestImpl(Vector vector, int n, Object object) {
        this.varbinds = vector;
        this.version = n;
        this.data = object;
    }

    public SnmpMibRequestImpl(SnmpPdu snmpPdu, Vector vector, int n, Object object) {
        this.varbinds = vector;
        this.version = n;
        this.data = object;
        this.reqPdu = snmpPdu;
    }

    public SnmpMibRequestImpl(SnmpEngine snmpEngine, SnmpPdu snmpPdu, Vector vector, int n, Object object, String string, int n2, int n3, byte[] byArray, byte[] byArray2) {
        this.varbinds = vector;
        this.version = n;
        this.data = object;
        this.reqPdu = snmpPdu;
        this.engine = snmpEngine;
        this.principal = string;
        this.securityLevel = n2;
        this.securityModel = n3;
        this.contextName = byArray;
        this.accessContextName = byArray2;
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public int getSecurityModel() {
        return this.securityModel;
    }

    public byte[] getContextName() {
        return this.contextName;
    }

    public byte[] getAccessContextName() {
        return this.accessContextName;
    }

    public final SnmpPdu getPdu() {
        return this.reqPdu;
    }

    public final Enumeration getElements() {
        return this.varbinds.elements();
    }

    public final Vector getSubList() {
        return this.varbinds;
    }

    public final int getSize() {
        if (this.varbinds == null) {
            return 0;
        }
        return this.varbinds.size();
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getRequestPduVersion() {
        return this.reqPdu.version;
    }

    public final Object getUserData() {
        return this.data;
    }

    public final int getVarIndex(SnmpVarBind snmpVarBind) {
        return this.varbinds.indexOf(snmpVarBind);
    }

    public void addVarBind(SnmpVarBind snmpVarBind) {
        this.varbinds.addElement(snmpVarBind);
    }

    final void setRequestTree(SnmpRequestTree snmpRequestTree) {
        this.tree = snmpRequestTree;
    }

    final SnmpRequestTree getRequestTree() {
        return this.tree;
    }

    final Vector getVarbinds() {
        return this.varbinds;
    }
}

