/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpMibAgentMBean;
import com.sun.jdmk.snmp.agent.SnmpMibHandler;
import com.sun.jdmk.snmp.agent.SnmpMibRequest;
import com.sun.jdmk.snmp.agent.SnmpMibRequestImpl;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;

public abstract class SnmpMibAgent
implements SnmpMibAgentMBean,
MBeanRegistration,
Serializable {
    protected String mibName;
    protected MBeanServer server;
    private ObjectName adaptorName;
    private transient SnmpMibHandler adaptor;

    public abstract void init() throws IllegalAccessException;

    public abstract ObjectName preRegister(MBeanServer var1, ObjectName var2) throws Exception;

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void get(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.get(snmpMibRequest.getSubList(), snmpMibRequest.getVersion());
    }

    private void get(Vector vector, int n) throws SnmpStatusException {
    }

    public void getNext(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.getNext(snmpMibRequest.getSubList(), snmpMibRequest.getVersion());
    }

    private void getNext(Vector vector, int n) throws SnmpStatusException {
    }

    public void getBulk(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        this.getBulk(snmpMibRequest.getSubList(), n, n2, snmpMibRequest.getVersion());
    }

    private void getBulk(Vector vector, int n, int n2, int n3) throws SnmpStatusException {
    }

    public void set(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.set(snmpMibRequest.getSubList(), snmpMibRequest.getVersion());
    }

    private void set(Vector vector, int n) throws SnmpStatusException {
    }

    public void check(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.check(snmpMibRequest.getSubList());
    }

    private void check(Vector vector) throws SnmpStatusException {
    }

    public abstract long[] getRootOid();

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public SnmpMibHandler getSnmpAdaptor() {
        return this.adaptor;
    }

    public void setSnmpAdaptor(SnmpMibHandler snmpMibHandler) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        this.adaptor = snmpMibHandler;
        if (this.adaptor != null) {
            this.adaptor.addMib(this);
        }
    }

    public void setSnmpAdaptor(SnmpMibHandler snmpMibHandler, SnmpOid[] snmpOidArray) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, snmpOidArray);
        }
        this.adaptor = snmpMibHandler;
        if (this.adaptor != null) {
            this.adaptor.addMib(this, snmpOidArray);
        }
    }

    public void setSnmpAdaptor(SnmpMibHandler snmpMibHandler, String string) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, string);
        }
        this.adaptor = snmpMibHandler;
        if (this.adaptor != null) {
            this.adaptor.addMib(this, string);
        }
    }

    public ObjectName getSnmpAdaptorName() {
        return this.adaptorName;
    }

    public void setSnmpAdaptorName(ObjectName objectName) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        Object[] objectArray = new Object[]{this};
        String[] stringArray = new String[]{"com.sun.jdmk.snmp.agent.SnmpMibAgent"};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(objectName, "addMib", objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        catch (ReflectionException reflectionException) {
            throw new ServiceNotFoundException(objectName.toString());
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
        this.adaptorName = objectName;
    }

    public void setSnmpAdaptorName(ObjectName objectName, SnmpOid[] snmpOidArray) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, snmpOidArray);
        }
        Object[] objectArray = new Object[]{this, snmpOidArray};
        String[] stringArray = new String[]{"com.sun.jdmk.snmp.agent.SnmpMibAgent", snmpOidArray.getClass().getName()};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(objectName, "addMib", objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        catch (ReflectionException reflectionException) {
            throw new ServiceNotFoundException(objectName.toString());
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
        this.adaptorName = objectName;
    }

    public void setSnmpAdaptorName(ObjectName objectName, String string) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, string);
        }
        Object[] objectArray = new Object[]{this, string};
        String[] stringArray = new String[]{"com.sun.jdmk.snmp.agent.SnmpMibAgent", "java.lang.String"};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(objectName, "addMib", objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        catch (ReflectionException reflectionException) {
            throw new ServiceNotFoundException(objectName.toString());
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
        this.adaptorName = objectName;
    }

    public boolean getBindingState() {
        return this.adaptor != null;
    }

    public String getMibName() {
        return this.mibName;
    }

    public static SnmpMibRequest newMibRequest(Vector vector, int n, Object object) {
        return new SnmpMibRequestImpl(vector, n, object);
    }

    public static SnmpMibRequest newMibRequest(SnmpPdu snmpPdu, Vector vector, int n, Object object) {
        return new SnmpMibRequestImpl(snmpPdu, vector, n, object);
    }

    public static SnmpMibRequest newMibRequest(SnmpEngine snmpEngine, SnmpPdu snmpPdu, Vector vector, int n, Object object, String string, int n2, int n3, byte[] byArray, byte[] byArray2) {
        return new SnmpMibRequestImpl(snmpEngine, snmpPdu, vector, n, object, string, n2, n3, byArray, byArray2);
    }

    void getBulkWithGetNext(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        Vector vector = snmpMibRequest.getSubList();
        int n3 = vector.size();
        int n4 = Math.max(Math.min(n, n3), 0);
        int n5 = Math.max(n2, 0);
        int n6 = n3 - n4;
        if (n3 != 0) {
            this.getNext(snmpMibRequest);
            Vector vector2 = this.splitFrom(vector, n4);
            SnmpMibRequestImpl snmpMibRequestImpl = new SnmpMibRequestImpl(snmpMibRequest.getEngine(), snmpMibRequest.getPdu(), vector2, 1, snmpMibRequest.getUserData(), snmpMibRequest.getPrincipal(), snmpMibRequest.getSecurityLevel(), snmpMibRequest.getSecurityModel(), snmpMibRequest.getContextName(), snmpMibRequest.getAccessContextName());
            int n7 = 2;
            while (n7 <= n5) {
                this.getNext(snmpMibRequestImpl);
                this.concatVector(snmpMibRequest, vector2);
                ++n7;
            }
        }
    }

    private void getBulkWithGetNext(Vector vector, int n, int n2, int n3) throws SnmpStatusException {
        SnmpMibRequestImpl snmpMibRequestImpl = new SnmpMibRequestImpl(vector, n3, null);
        this.getBulkWithGetNext(snmpMibRequestImpl, n, n2);
    }

    private Vector splitFrom(Vector vector, int n) {
        int n2 = vector.size();
        Vector<SnmpVarBind> vector2 = new Vector<SnmpVarBind>(n2 - n);
        int n3 = n;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            if (n3 <= 0) {
                vector2.addElement(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
            }
            --n3;
        }
        return vector2;
    }

    private void concatVector(SnmpMibRequest snmpMibRequest, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpMibRequest.addVarBind(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
        }
    }

    private void concatVector(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            vector.addElement(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
        }
    }

    private static Vector vector(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }
}

