/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import com.sun.jdmk.snmp.agent.SnmpMibRequest;
import com.sun.jdmk.trace.Trace;
import java.io.Serializable;
import java.util.Enumeration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;

public class SnmpErrorHandlerAgent
extends SnmpMibAgent
implements Serializable {
    private String dbgTag = "SnmpErrorHandlerAgent";

    public void init() throws IllegalAccessException {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return objectName;
    }

    public long[] getRootOid() {
        return null;
    }

    public void get(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("get", "Get in Exception");
        }
        if (snmpMibRequest.getVersion() == 0) {
            throw new SnmpStatusException(2);
        }
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind.value = SnmpVarBind.noSuchObject;
        }
    }

    public void check(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("check", "Check in Exception");
        }
        throw new SnmpStatusException(17);
    }

    public void set(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("set", "Set in Exception, CAN't be called");
        }
        throw new SnmpStatusException(17);
    }

    public void getNext(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("getNext", "GetNext in Exception");
        }
        if (snmpMibRequest.getVersion() == 0) {
            throw new SnmpStatusException(2);
        }
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind.value = SnmpVarBind.endOfMibView;
        }
    }

    public void getBulk(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("getBulk", "GetBulk in Exception");
        }
        if (snmpMibRequest.getVersion() == 0) {
            throw new SnmpStatusException(5, 0);
        }
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind.value = SnmpVarBind.endOfMibView;
        }
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

