/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import com.sun.jdmk.internal.ThreadService;
import com.sun.jdmk.tasks.Task;
import com.sun.jdmk.tasks.TaskServer;
import java.util.ArrayList;

public class TimedExecutor
implements TaskServer {
    private ThreadService tService;
    private ArrayList jobInfoList = new ArrayList();
    private ExecutorThread exeThread;
    private boolean terminated;
    private long doneJob = 0L;
    private long addedJob = 0L;

    public TimedExecutor() {
        this(2);
    }

    public TimedExecutor(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Thread number should be bigger than zero.");
        }
        this.tService = new ThreadService(n);
        this.exeThread = new ExecutorThread();
        this.exeThread.start();
    }

    public void submitTask(Task task) throws IllegalArgumentException {
        this.submitTask((Runnable)task, 0L);
    }

    public void submitTask(Task task, long l) throws IllegalArgumentException {
        this.submitTask((Runnable)task, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(Runnable runnable, long l) throws IllegalArgumentException {
        if (runnable == null) {
            throw new IllegalArgumentException("No task specified.");
        }
        long l2 = l + System.currentTimeMillis();
        JobInfo jobInfo = new JobInfo(runnable, l2);
        boolean bl = false;
        ArrayList arrayList = this.jobInfoList;
        synchronized (arrayList) {
            int n = this.jobInfoList.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                JobInfo jobInfo2 = (JobInfo)this.jobInfoList.get(n2);
                if (jobInfo.startTime >= jobInfo2.startTime) {
                    this.jobInfoList.add(n2 + 1, jobInfo);
                    bl = true;
                    break;
                }
                --n2;
            }
            if (!bl) {
                this.jobInfoList.add(0, jobInfo);
            }
            this.jobInfoList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable removeTask(Runnable runnable) {
        Runnable runnable2 = null;
        ArrayList arrayList = this.jobInfoList;
        synchronized (arrayList) {
            int n = this.jobInfoList.size();
            int n2 = 0;
            while (n2 < n) {
                JobInfo jobInfo = (JobInfo)this.jobInfoList.get(n2);
                if (runnable == jobInfo.job) {
                    runnable2 = ((JobInfo)this.jobInfoList.remove((int)n2)).job;
                    if (n2 != 0) break;
                    this.jobInfoList.notify();
                    break;
                }
                ++n2;
            }
        }
        if (runnable2 != null && runnable2 instanceof Task) {
            ((Task)runnable2).cancel();
        }
        return runnable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        JobInfo[] jobInfoArray;
        ArrayList arrayList = this.jobInfoList;
        synchronized (arrayList) {
            jobInfoArray = new JobInfo[this.jobInfoList.size()];
            this.jobInfoList.toArray(jobInfoArray);
            this.jobInfoList.clear();
            this.jobInfoList.notifyAll();
        }
        int n = jobInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable runnable = jobInfoArray[n2].job;
            if (runnable != null && runnable instanceof Task) {
                ((Task)runnable).cancel();
            }
            ++n2;
        }
    }

    public void terminate() {
        this.terminated = true;
        this.removeAll();
        try {
            Thread.sleep(100L);
            this.exeThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class JobInfo {
        public Runnable job;
        public long startTime;

        public JobInfo(Runnable runnable, long l) {
            this.job = runnable;
            this.startTime = l;
        }
    }

    private class ExecutorThread
    extends Thread {
        public ExecutorThread() {
            super("ExecutorThread");
            this.setDaemon(true);
        }

        public void run() {
            while (!TimedExecutor.this.terminated) {
                JobInfo jobInfo = this.getJobInfo();
                if (TimedExecutor.this.terminated) break;
                try {
                    TimedExecutor.this.tService.submitTask(jobInfo.job);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private JobInfo getJobInfo() {
            JobInfo jobInfo = null;
            ArrayList arrayList = TimedExecutor.this.jobInfoList;
            synchronized (arrayList) {
                while (!TimedExecutor.this.terminated) {
                    if (TimedExecutor.this.jobInfoList.size() == 0) {
                        try {
                            TimedExecutor.this.jobInfoList.wait();
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    jobInfo = (JobInfo)TimedExecutor.this.jobInfoList.get(0);
                    long l = jobInfo.startTime - System.currentTimeMillis();
                    if (l <= 0L) {
                        TimedExecutor.this.jobInfoList.remove(0);
                        break;
                    }
                    try {
                        TimedExecutor.this.jobInfoList.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return jobInfo;
            }
        }
    }
}

