/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import com.sun.jdmk.tasks.Task;
import com.sun.jdmk.tasks.TaskServer;
import java.util.ArrayList;

public class ThreadService
implements TaskServer {
    private ArrayList jobList = new ArrayList(0);
    private ExecutorThread[] threadList;
    private int minThreads = 1;
    private int currThreds = 0;
    private int idle = 0;
    private boolean terminated = false;
    private int priority;
    private ThreadGroup threadGroup = new ThreadGroup("ThreadService");
    private ClassLoader cloader;
    private static long counter = 0L;
    private int addedJobs = 1;
    private int doneJobs = 1;

    public ThreadService(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The thread number should bigger than zero.");
        }
        this.minThreads = n;
        this.threadList = new ExecutorThread[n];
        this.priority = Thread.currentThread().getPriority();
        this.cloader = Thread.currentThread().getContextClassLoader();
    }

    public void submitTask(Task task) throws IllegalArgumentException {
        this.submitTask((Runnable)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(Runnable runnable) throws IllegalArgumentException {
        this.stateCheck();
        if (runnable == null) {
            throw new IllegalArgumentException("No task specified.");
        }
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            this.jobList.add(this.jobList.size(), runnable);
            this.jobList.notify();
        }
        this.createThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable removeTask(Runnable runnable) {
        this.stateCheck();
        Runnable runnable2 = null;
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            int n = this.jobList.indexOf(runnable);
            if (n >= 0) {
                runnable2 = (Runnable)this.jobList.remove(n);
            }
        }
        if (runnable2 != null && runnable2 instanceof Task) {
            ((Task)runnable2).cancel();
        }
        return runnable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object[] objectArray;
        this.stateCheck();
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            objectArray = this.jobList.toArray();
            this.jobList.clear();
        }
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null && object instanceof Task) {
                ((Task)object).cancel();
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            this.jobList.notifyAll();
        }
        this.removeAll();
        int n = 0;
        while (n < this.currThreds) {
            try {
                this.threadList[n].interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        this.threadList = null;
    }

    private void stateCheck() throws IllegalStateException {
        if (this.terminated) {
            throw new IllegalStateException("The thread service has been terminated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createThread() {
        if (this.idle < 1) {
            ExecutorThread[] executorThreadArray = this.threadList;
            synchronized (executorThreadArray) {
                if (this.jobList.size() > 0 && this.currThreds < this.minThreads) {
                    ExecutorThread executorThread = new ExecutorThread();
                    executorThread.start();
                    this.threadList[this.currThreds++] = executorThread;
                }
            }
        }
    }

    private class ExecutorThread
    extends Thread {
        public ExecutorThread() {
            super(ThreadService.this.threadGroup, "ThreadService-" + counter++);
            this.setDaemon(true);
            this.setPriority(ThreadService.this.priority);
            this.setContextClassLoader(ThreadService.this.cloader);
            ThreadService.this.idle++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (!ThreadService.this.terminated) {
                Runnable runnable = null;
                ArrayList arrayList = ThreadService.this.jobList;
                // MONITORENTER : arrayList
                if (ThreadService.this.jobList.size() > 0) {
                    runnable = (Runnable)ThreadService.this.jobList.remove(0);
                    if (ThreadService.this.jobList.size() > 0) {
                        ThreadService.this.jobList.notify();
                    }
                } else {
                    Object v0;
                    try {
                        try {
                            ThreadService.this.jobList.wait();
                            v0 = null;
                        }
                        catch (InterruptedException interruptedException) {
                            v0 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v0 = null;
                    }
                    Object var5_7 = v0;
                    // MONITOREXIT : arrayList
                    continue;
                }
                // MONITOREXIT : arrayList
                if (runnable != null) {
                    Object var8_8;
                    try {
                        try {
                            ThreadService.this.idle--;
                            runnable.run();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            var8_8 = null;
                            ThreadService.this.idle++;
                        }
                        var8_8 = null;
                        ThreadService.this.idle++;
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        ThreadService.this.idle++;
                        throw throwable;
                    }
                }
                this.setPriority(ThreadService.this.priority);
                ExecutorThread.interrupted();
                this.setContextClassLoader(ThreadService.this.cloader);
            }
        }
    }
}

