/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.Trace;
import com.sun.jdmk.discovery.ActualResponder;
import com.sun.jdmk.discovery.DiscoveryResponderMBean;
import com.sun.jdmk.internal.Useful;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.Date;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DiscoveryResponder
implements Serializable,
DiscoveryResponderMBean,
MBeanRegistration {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    private int infoType = 4096;
    private String localClassName;
    private String dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryResponder";
    private static final String sccs_id = "@(#)DiscoveryResponder.java 4.31 02/05/31 SMI";
    private int multicastPort;
    private String multicastGroup;
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int ttl = 1;
    private MBeanServer cmf = null;
    private ObjectName responderObjectName = null;
    private transient ActualResponder responder = null;
    private transient Thread responderThread = null;
    private static final String HOST = "host";
    private static final String GROUP = "group";
    private static final String PORT = "port";
    private static final String TTL = "ttl";
    private static final String SPY = "spy";
    private String spy = "";
    private String noEvent = null;
    private volatile transient int state = 1;
    private byte[] userData;
    private InetAddress usrInet = null;
    private String local = null;

    public DiscoveryResponder() {
        this(defaultMulticastGroup, defaultMulticastPort, null, null);
    }

    public DiscoveryResponder(String string, int n) {
        this(string, n, null, null);
    }

    public DiscoveryResponder(String string, int n, InetAddress inetAddress) {
        this(string, n, inetAddress, null);
    }

    public DiscoveryResponder(String string, int n, InetAddress inetAddress, String string2) {
        this.multicastGroup = string;
        this.multicastPort = n;
        if (inetAddress != null && !Useful.isLocalHost(inetAddress)) {
            throw new IllegalArgumentException("The user specified multi cast group is not a local interface: " + inetAddress);
        }
        this.usrInet = inetAddress;
        if (string2 != null && !Useful.isLocalHost(string2)) {
            throw new IllegalArgumentException("The user specified local host is not a local: " + string2);
        }
        this.local = string2;
        if (this.isTraceOn()) {
            this.trace("constructor ", "Set group to '" + string + "'");
            this.trace("constructor ", "Set port  to '" + n + "'");
            if (inetAddress != null) {
                this.trace("constructor ", "Set interface  to '" + inetAddress + "'");
            }
            if (string2 != null) {
                this.trace("constructor ", "Set the local host to '" + string2 + "'");
            }
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (this.isTraceOn()) {
            this.trace("preRegister ", "object name   = " + objectName);
        }
        this.responderObjectName = objectName;
        this.spy = objectName.getKeyProperty(SPY);
        this.noEvent = objectName.getKeyProperty("PRIVATE_NO_EVENT");
        this.cmf = mBeanServer;
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        if (this.state == 0) {
            this.stop();
        }
    }

    public void postDeregister() {
    }

    public void start() throws IOException {
        if (this.state == 1) {
            this.changeState(3);
            if (this.cmf == null) {
                if (this.isTraceOn()) {
                    this.trace("start ", "Can't start discoveryResponder: JDMK MBeanServer is not set");
                }
                return;
            }
            try {
                if (this.isTraceOn()) {
                    this.trace("start ", "Create a new responder");
                }
                this.responder = new ActualResponder(this.multicastGroup, this.multicastPort, this.getTimeToLive(), this.cmf, this.spy, this);
                if (this.local != null) {
                    this.responder.setLocalHost(this.local);
                }
                if (this.usrInet != null) {
                    this.responder.setInterface(this.usrInet);
                    if (this.isTraceOn()) {
                        this.trace("start ", "set interface to " + this.usrInet);
                    }
                }
                if (this.noEvent != null) {
                    this.responder.noEvent();
                }
                if (this.isTraceOn()) {
                    this.trace("start ", "call responder connect");
                }
                this.responder.connectToGroup();
                this.responderThread = new Thread(this.responder);
                this.responderThread.setName("Multicast responder");
                this.responderThread.start();
            }
            catch (SocketException socketException) {
                if (this.isDebugOn()) {
                    this.debug("start", socketException);
                }
                throw new IOException(socketException.getMessage());
            }
            catch (IOException iOException) {
                if (this.isDebugOn()) {
                    this.debug("start ", iOException);
                }
                throw iOException;
            }
            catch (NullPointerException nullPointerException) {
                if (this.isDebugOn()) {
                    this.debug("start ", nullPointerException);
                }
                throw new IOException(nullPointerException.getMessage());
            }
        } else if (this.isTraceOn()) {
            this.trace("start ", "Responder is not OFFLINE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.state == 0) {
            block11: {
                this.changeState(2);
                this.responder.stopRequested = true;
                Boolean bl = this.responder.interrupted;
                synchronized (bl) {
                    if (!this.responder.interrupted.booleanValue()) {
                        this.responderThread.interrupt();
                    }
                }
                try {
                    MulticastSocket multicastSocket = new MulticastSocket(this.multicastPort);
                    if (this.usrInet != null) {
                        multicastSocket.setInterface(this.usrInet);
                        if (this.isTraceOn()) {
                            this.trace("stop ", "use the interface " + this.usrInet);
                        }
                    }
                    InetAddress inetAddress = InetAddress.getByName(this.multicastGroup);
                    multicastSocket.joinGroup(inetAddress);
                    multicastSocket.send(new DatagramPacket(new byte[1], 1, inetAddress, this.multicastPort));
                    multicastSocket.leaveGroup(inetAddress);
                }
                catch (Exception exception) {
                    if (!this.isTraceOn()) break block11;
                    this.trace("stop ", "Unexpected exception occured trying to send empty message " + exception.getMessage());
                }
            }
            this.responder = null;
            System.runFinalization();
        } else if (this.isTraceOn()) {
            this.trace("stop ", "Responder is not ONLINE");
        }
    }

    public boolean isActive() {
        return this.state == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitState(int n, long l) {
        if (this.isTraceOn()) {
            this.trace("waitState", n + "(0on,1off,2st) TO=" + l + " ; current state = " + this.getStateString());
        }
        if (l < 0L) {
            return this.state == n;
        }
        boolean bl = this.state == n;
        long l2 = -1L;
        Date date = new Date(new Date().getTime() + l);
        while (!bl) {
            if (l != 0L && (l2 = date.getTime() - new Date().getTime()) <= 0L) {
                bl = true;
                break;
            }
            try {
                DiscoveryResponder discoveryResponder = this;
                synchronized (discoveryResponder) {
                    if (l == 0L) {
                        if (this.isTraceOn()) {
                            this.trace("waitState", "Start waiting infinite, current state = " + this.state);
                        }
                        bl = this.state == n;
                        while (!bl) {
                            bl = this.state == n;
                            try {
                                this.wait(1000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    } else {
                        if (this.isTraceOn()) {
                            this.trace("waitState", "Start waiting " + l2 + " current state = " + this.state);
                        }
                        this.wait(l2);
                    }
                }
                bl = this.state == n;
            }
            catch (InterruptedException interruptedException) {
                boolean bl2 = bl = this.state == n;
            }
        }
        if (this.isTraceOn()) {
            this.trace("waitState", "End, TO=" + l2);
        }
        return this.state == n;
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public void setMulticastGroup(String string) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastGroup = string;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastPort(int n) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastPort = n;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public void setTimeToLive(int n) throws IllegalStateException {
        if (this.state == 1) {
            if (n <= 0 || n > 255) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalStateException();
        }
        this.ttl = n;
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
            case 2: {
                string = "STOPPING";
                break;
            }
            case 3: {
                string = "STARTING";
            }
        }
        return string;
    }

    public void setUserData(byte[] byArray) {
        this.userData = byArray;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    synchronized void changeState(int n) {
        if (this.state == n) {
            return;
        }
        int n2 = this.state;
        this.state = n;
        this.notifyAll();
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }

    private void trace(String string, String string2, Exception exception) {
        Trace.send(1, this.infoType, string, string2, exception);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    private void debug(String string, String string2, Exception exception) {
        Trace.send(2, this.infoType, string, string2, exception);
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void trace(String string, Exception exception) {
        this.trace(this.localClassName, string, exception);
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }

    private void debug(String string, Exception exception) {
        this.debug(this.localClassName, string, exception);
    }
}

