/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryMonitor;
import com.sun.jdmk.discovery.DiscoveryResponderNotification;
import com.sun.jdmk.discovery.DiscoveryResponse;
import com.sun.jdmk.discovery.ResponsePDU;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.Vector;

class ActualMonitor
extends DiscoveryCommon
implements Serializable {
    private static long sequenceNumber = 0L;
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private Thread listeningThread = null;
    private volatile boolean stopRequested = false;
    public Boolean interrupted = new Boolean(false);
    private transient int state = 1;
    private transient DiscoveryMonitor monitor = null;
    private Vector listeners = new Vector();

    public ActualMonitor(String string, int n, DiscoveryMonitor discoveryMonitor) throws IOException {
        super(string, n);
        this.localClassName = "com.sun.jdmk.discovery.ActualMonitor";
        if (this.isTraceOn()) {
            this.trace("constructor ", "initialize multicast socket");
        }
        this.multicastGroup = string;
        this.multicastPort = n;
        this.monitor = discoveryMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block22: {
            if (this.isTraceOn()) {
                this.trace("run ", "start");
            }
            try {
                this.connectToGroup();
            }
            catch (IOException var1_1) {
                this.stopRequested = true;
            }
            try {
                while (true) {
                    if (this.stopRequested) {
                        var6_7 = null;
                        var7_9 = this.interrupted;
                        break;
                    }
                    this.monitor.changeState(0);
                    try {
                        if (this.isTraceOn()) {
                            this.trace("run ", "Start Waiting ");
                        }
                        var1_2 = (ResponsePDU)this.receiveMsg(this);
                        this.processMsg(var1_2);
                    }
                    catch (InterruptedIOException var1_3) {
                        if (this.isTraceOn()) {
                            this.trace("run ", "Stop execution ");
                        }
                        this.stopRequested = true;
                    }
                    catch (IOException var2_4) {
                        if (!this.isTraceOn()) continue;
                        this.trace("run ", "Not a event msg - continue - ");
                    }
                    catch (ClassCastException var3_5) {
                        if (!this.isTraceOn()) continue;
                        this.trace("run ", "Not a event msg - continue - ");
                    }
                    catch (ClassNotFoundException var4_6) {
                        if (!this.isTraceOn()) continue;
                        this.trace("run ", "Not a event msg - continue - ");
                    }
                }
            }
            catch (Throwable var5_13) {
                block21: {
                    var6_8 = null;
                    var7_10 = this.interrupted;
                    synchronized (var7_10) {
                        this.interrupted = new Boolean(true);
                        Thread.currentThread();
                        Thread.interrupted();
                    }
                    try {
                        this.disconnectFromGroup();
                        this.monitor.changeState(1);
                    }
                    catch (IOException var8_12) {
                        if (!this.isDebugOn()) break block21;
                        this.debug("run ", var8_12);
                    }
                }
                this.close();
                throw var5_13;
            }
            synchronized (var7_9) {
                this.interrupted = new Boolean(true);
                Thread.currentThread();
                Thread.interrupted();
            }
            ** try [egrp 4[TRYBLOCK] [9 : 216->231)] { 
lbl67:
            // 1 sources

            this.disconnectFromGroup();
            this.monitor.changeState(1);
            break block22;
lbl70:
            // 1 sources

            catch (IOException var8_11) {
                if (!this.isDebugOn()) break block22;
                this.debug("run ", var8_11);
            }
        }
        this.close();
    }

    public void stopMonitor() {
        this.stopRequested = true;
    }

    private void processMsg(ResponsePDU responsePDU) throws IOException {
        if (responsePDU == null) {
            if (this.isTraceOn()) {
                this.trace("processMsg ", "received a nul pdu '");
            }
            return;
        }
        if (this.isTraceOn()) {
            this.trace("processMsg ", "received pdu '" + responsePDU.printState() + "'");
        }
        if (!responsePDU.getEvent()) {
            if (this.isTraceOn()) {
                this.trace("processMsg ", "not an event message");
            }
            return;
        }
        DiscoveryResponse discoveryResponse = new DiscoveryResponse();
        discoveryResponse.host = responsePDU.getHost();
        discoveryResponse.mbeanServerId = responsePDU.getMbeanServerId();
        discoveryResponse.specificationName = responsePDU.getSpecificationName();
        discoveryResponse.specificationVendor = responsePDU.getSpecificationVendor();
        discoveryResponse.specificationVersion = responsePDU.getSpecificationVersion();
        discoveryResponse.implementationName = responsePDU.getImplementationName();
        discoveryResponse.implementationVendor = responsePDU.getImplementationVendor();
        discoveryResponse.implementationVersion = responsePDU.getImplementationVersion();
        discoveryResponse.objectList = responsePDU.getObjectList();
        discoveryResponse.userData = responsePDU.getUserData();
        DiscoveryResponderNotification discoveryResponderNotification = new DiscoveryResponderNotification(this.monitor, responsePDU.getAgentState(), discoveryResponse, sequenceNumber++);
        this.monitor.sendNotification(discoveryResponderNotification);
    }
}

