/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryMsg;
import com.sun.jdmk.discovery.DiscoveryPDU;
import com.sun.jdmk.discovery.DiscoveryResponse;
import com.sun.jdmk.discovery.ResponsePDU;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;

class ActualDiscovery
extends DiscoveryCommon {
    private boolean PointToPointResponse = true;
    private int RETURN_PORT_MIN_VAL = 1024;
    private int RETURN_PORT_MAX_VAL = this.RETURN_PORT_MIN_VAL * 10;
    private int ttl = 1;
    private int defaultTtl = 1;
    private int timeOut = 1000;
    private String timeStamp = null;
    public Vector returnValue = new Vector();

    public ActualDiscovery(String string, int n) throws IOException {
        super(string, n);
        this.localClassName = "com.sun.jdmk.discovery.ActualDiscovery";
        if (this.isTraceOn()) {
            this.trace("constructor", "group = " + string + ", " + "port  = " + n);
        }
    }

    public void setTimeOut(int n) throws IOException {
        if (this.isTraceOn()) {
            this.trace("setTimeOut", "set to " + n);
        }
        this.setSoTimeout(n);
        this.timeOut = n;
    }

    public int getTimeOut() {
        if (this.isTraceOn()) {
            this.trace("getTimeOut", "Value = " + this.timeOut);
        }
        return this.timeOut;
    }

    public void setTimeToLive(int n) throws IOException {
        try {
            super.setTimeToLive(n);
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("setTimeToLive", "Unable to set Time-to-live to " + n);
            }
            throw iOException;
        }
        if (this.isTraceOn()) {
            this.trace("Time-to-live", "Set Time-to-live to " + n);
        }
        this.ttl = n;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public boolean getPointToPointResponse() {
        return this.PointToPointResponse;
    }

    public void setPointToPointResponse(boolean bl) {
        if (this.isTraceOn()) {
            this.trace("setPointToPointResponse", "setPointToPointResponse to " + bl);
        }
        this.PointToPointResponse = bl;
    }

    public Vector findCommunicators(boolean bl, String string) throws IOException {
        return this.getObject(bl, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getObject(boolean bl, String string) throws IOException {
        Thread thread;
        ReceivedMsgObj receivedMsgObj;
        block26: {
            InetAddress inetAddress;
            this.returnValue = new Vector();
            DatagramSocket datagramSocket = null;
            int n = this.RETURN_PORT_MIN_VAL;
            if (System.getProperty("oldInet") == null) {
                if (!this.getInterface().getHostAddress().equals("0.0.0.0")) {
                    if (this.isTraceOn()) {
                        this.trace("getObject", " getInterface");
                    }
                    inetAddress = this.getInterface();
                } else {
                    inetAddress = this.getLocalHostAddr();
                }
            } else {
                inetAddress = this.getLocalHostAddr();
            }
            if (this.isTraceOn()) {
                this.trace("getObject", " returnAddr is set to " + inetAddress);
            }
            if (this.getPointToPointResponse()) {
                if (this.isTraceOn()) {
                    this.trace("getObject", " Create datagram socket for response");
                }
                while (n < this.RETURN_PORT_MAX_VAL) {
                    try {
                        datagramSocket = new DatagramSocket(n, inetAddress);
                        datagramSocket.setSoTimeout(this.getTimeOut());
                        break;
                    }
                    catch (BindException bindException) {
                        if (this.isDebugOn()) {
                            this.debug("getObject", " try port " + n);
                        }
                        ++n;
                    }
                }
                if (n == this.RETURN_PORT_MAX_VAL) {
                    throw new IOException("Address already in use");
                }
            } else {
                if (this.isTraceOn()) {
                    this.trace("getObject", "Use multicast socket for response");
                }
                datagramSocket = this;
            }
            if (this.isTraceOn()) {
                this.trace("getObject", "Format msg");
            }
            DiscoveryPDU discoveryPDU = new DiscoveryPDU();
            this.formatPdu(discoveryPDU, bl, string, n);
            if (this.isTraceOn()) {
                this.trace("getObject", "Create a thread to get responses");
            }
            receivedMsgObj = new ReceivedMsgObj(datagramSocket, this);
            thread = new Thread(receivedMsgObj);
            if (this.isTraceOn()) {
                this.trace("getObject", "Send the multicast query");
            }
            this.sendMsg(discoveryPDU, this.multicastGroup, this.multicastPort);
            thread.start();
            if (this.isTraceOn()) {
                this.trace("getObject", "Sleep before receiving");
            }
            try {
                Thread.sleep(this.getTimeOut());
            }
            catch (InterruptedException interruptedException) {
                if (!this.isDebugOn()) break block26;
                this.debug("getObject", interruptedException);
            }
        }
        if (this.isTraceOn()) {
            this.trace("getObject", "Stop receiving");
        }
        receivedMsgObj.stopRequested = true;
        Boolean bl2 = receivedMsgObj.interrupted;
        synchronized (bl2) {
            if (!receivedMsgObj.interrupted.booleanValue()) {
                thread.interrupt();
            }
        }
        return this.returnValue;
    }

    private void formatPdu(DiscoveryPDU discoveryPDU, boolean bl, String string, int n) {
        String string2;
        Object object;
        String string3;
        block24: {
            string3 = new Long(new Date().getTime()).toString();
            if (System.getProperty("oldInet") == null) {
                try {
                    object = this.getInterface().getHostAddress();
                    if (!((String)object).equals("0.0.0.0")) {
                        if (this.isTraceOn()) {
                            this.trace("formatPdu", " getInterface for localHostName");
                        }
                        string2 = object;
                        break block24;
                    }
                    if (System.getProperty("jdmk.hostname") != null) {
                        string2 = System.getProperty("jdmk.hostname");
                        break block24;
                    }
                    try {
                        string2 = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        string2 = "localHost";
                    }
                }
                catch (SocketException socketException) {
                    if (this.isTraceOn()) {
                        this.trace("formatPdu", "cannot get Interface");
                    }
                    string2 = "localHost";
                }
            } else if (System.getProperty("jdmk.hostname") != null) {
                string2 = System.getProperty("jdmk.hostname");
            } else {
                try {
                    string2 = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    string2 = "localHost";
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("formatPdu", "localHostName =" + string2);
        }
        this.timeStamp = string2 + ":" + string3;
        discoveryPDU.setTimeStamp(string2 + ":" + string3);
        discoveryPDU.setEmittedGroup(this.multicastGroup);
        if (this.getPointToPointResponse()) {
            if (System.getProperty("oldInet") == null) {
                try {
                    if (this.isTraceOn()) {
                        this.trace("formatPdu", " getInterface");
                    }
                    if (((InetAddress)(object = this.getInterface())).getHostAddress().equals("0.0.0.0")) {
                        object = this.localHost;
                    }
                }
                catch (SocketException socketException) {
                    if (this.isTraceOn()) {
                        this.trace("formatPdu", "cannot get Interface");
                    }
                    object = this.localHost;
                }
            } else {
                object = this.localHost;
            }
            if (this.isTraceOn()) {
                this.trace("formatPdu", "set return addr to " + object + ":" + n);
            }
            discoveryPDU.setReturnaddr((InetAddress)object, n);
        }
        discoveryPDU.setHost(string);
        discoveryPDU.setTimeOut(this.getTimeOut());
        discoveryPDU.setTimeToLive(this.getTimeToLive());
        discoveryPDU.setObjectRequired(bl);
    }

    class ReceivedMsgObj
    implements Runnable {
        public Vector result = new Vector();
        public volatile boolean stopRequested = false;
        public Boolean interrupted = new Boolean(false);
        private ActualDiscovery discovery;
        private DatagramSocket socket;

        ReceivedMsgObj(DatagramSocket datagramSocket, ActualDiscovery actualDiscovery2) {
            this.socket = datagramSocket;
            this.discovery = actualDiscovery2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            int n = 0;
            try {
                while (true) {
                    if (this.stopRequested) break;
                    try {
                        DiscoveryMsg discoveryMsg = ActualDiscovery.this.receiveMsg(this.socket);
                        if (discoveryMsg == null) {
                            if (!ActualDiscovery.this.isTraceOn()) continue;
                            ActualDiscovery.this.trace("receivedMsg", "Null msg - continue - ");
                            continue;
                        }
                        ResponsePDU responsePDU = (ResponsePDU)discoveryMsg;
                        if (this.discovery.timeStamp.compareTo(responsePDU.getTimeStamp()) != 0) {
                            if (!ActualDiscovery.this.isTraceOn()) continue;
                            ActualDiscovery.this.trace("receivedMsg", "Msg is not for us : local timeStamp = " + this.discovery.timeStamp + " ; receiced timeStamp =  " + responsePDU.getTimeStamp());
                            continue;
                        }
                        DiscoveryResponse discoveryResponse = this.TranslatePDU(responsePDU);
                        this.discovery.returnValue.addElement(discoveryResponse);
                        ++n;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.stopRequested = true;
                        if (!ActualDiscovery.this.isTraceOn()) continue;
                        ActualDiscovery.this.trace("receivedMsg", "timeOut expiration");
                        ActualDiscovery.this.trace("receivedMsg", "Got " + n + " responses");
                    }
                    catch (InvalidClassException invalidClassException) {
                        if (!ActualDiscovery.this.isDebugOn()) continue;
                        ActualDiscovery.this.debug("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.debug("receivedMsg", invalidClassException);
                    }
                    catch (ClassCastException classCastException) {
                        if (!ActualDiscovery.this.isDebugOn()) continue;
                        ActualDiscovery.this.debug("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.debug("receivedMsg", classCastException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!ActualDiscovery.this.isDebugOn()) continue;
                        ActualDiscovery.this.debug("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.debug("receivedMsg", classNotFoundException);
                    }
                    catch (IOException iOException) {
                        if (!ActualDiscovery.this.isDebugOn()) continue;
                        ActualDiscovery.this.debug("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.debug("receivedMsg", iOException);
                    }
                }
                Object var10_10 = null;
                Boolean bl = this.interrupted;
                // MONITORENTER : bl
                this.interrupted = new Boolean(true);
                Thread.currentThread();
                Thread.interrupted();
                // MONITOREXIT : bl
                if (ActualDiscovery.this.isTraceOn()) {
                    ActualDiscovery.this.trace("receivedMsg", "timeOut expiration");
                    ActualDiscovery.this.trace("receivedMsg", "Got " + n + " responses");
                }
                if (!this.discovery.getPointToPointResponse()) return;
                if (ActualDiscovery.this.isTraceOn()) {
                    ActualDiscovery.this.trace("receivedMsg", "Close datagram socket");
                }
                this.socket.close();
                return;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                Boolean bl = this.interrupted;
                // MONITORENTER : bl
                this.interrupted = new Boolean(true);
                Thread.currentThread();
                Thread.interrupted();
                // MONITOREXIT : bl
                if (ActualDiscovery.this.isTraceOn()) {
                    ActualDiscovery.this.trace("receivedMsg", "timeOut expiration");
                    ActualDiscovery.this.trace("receivedMsg", "Got " + n + " responses");
                }
                if (!this.discovery.getPointToPointResponse()) throw throwable;
                if (ActualDiscovery.this.isTraceOn()) {
                    ActualDiscovery.this.trace("receivedMsg", "Close datagram socket");
                }
                this.socket.close();
                throw throwable;
            }
        }

        private DiscoveryResponse TranslatePDU(ResponsePDU responsePDU) {
            DiscoveryResponse discoveryResponse = new DiscoveryResponse();
            discoveryResponse.host = responsePDU.getHost();
            discoveryResponse.mbeanServerId = responsePDU.getMbeanServerId();
            discoveryResponse.specificationName = responsePDU.getSpecificationName();
            discoveryResponse.specificationVendor = responsePDU.getSpecificationVendor();
            discoveryResponse.specificationVersion = responsePDU.getSpecificationVersion();
            discoveryResponse.implementationName = responsePDU.getImplementationName();
            discoveryResponse.implementationVendor = responsePDU.getImplementationVendor();
            discoveryResponse.implementationVersion = responsePDU.getImplementationVersion();
            discoveryResponse.userData = responsePDU.getUserData();
            discoveryResponse.objectList = responsePDU.getObjectList();
            return discoveryResponse;
        }
    }
}

