/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.SnmpQManager;
import com.sun.jdmk.comm.SnmpResponseHandler;
import com.sun.jdmk.comm.SnmpV3AdaptorServer;
import com.sun.jdmk.comm.SnmpV3InformRequest;
import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.internal.snmp.SnmpIncomingResponse;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.internal.snmp.SnmpSecurityCache;
import com.sun.jdmk.trace.Trace;
import java.net.DatagramPacket;
import javax.management.snmp.SnmpMsg;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduRequestType;
import javax.management.snmp.SnmpSecurityException;

class SnmpV3ResponseHandler
extends SnmpResponseHandler {
    SnmpV3AdaptorServer v3adaptor = null;
    SnmpSecurityCache cache = null;
    String dbgTag = "SnmpV3ResponseHandler";

    public SnmpV3ResponseHandler(SnmpV3AdaptorServer snmpV3AdaptorServer, SnmpQManager snmpQManager) {
        super(snmpV3AdaptorServer, snmpQManager);
        this.v3adaptor = snmpV3AdaptorServer;
    }

    public void setSecurityCache(SnmpSecurityCache snmpSecurityCache) {
        this.cache = snmpSecurityCache;
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        block12: {
            byte[] byArray = datagramPacket.getData();
            int n = datagramPacket.getLength();
            if (this.isTraceOn()) {
                this.trace("processDatagram", "Received from peer " + datagramPacket.getAddress().toString() + " Length = " + n + "\nDump : \n" + SnmpMsg.dumpHexBuffer((byte[])byArray, (int)0, (int)n));
            }
            try {
                SnmpEngineImpl snmpEngineImpl = (SnmpEngineImpl)this.v3adaptor.getEngine();
                int n2 = SnmpMsg.getProtocolVersion((byte[])datagramPacket.getData());
                SnmpPduFactory snmpPduFactory = this.v3adaptor.getPduFactory();
                if (snmpPduFactory == null) {
                    if (this.isDebugOn()) {
                        this.debug("processDatagram", "Dropping packet. Unable to find the pdu factory of the SNMP adaptor server");
                    }
                    break block12;
                }
                SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = snmpEngineImpl.getMsgProcessingSubSystem();
                SnmpIncomingResponse snmpIncomingResponse = snmpMsgProcessingSubSystem.getIncomingResponse(n2, snmpPduFactory);
                int n3 = snmpIncomingResponse.getRequestId(byArray);
                SnmpV3InformRequest snmpV3InformRequest = (SnmpV3InformRequest)this.snmpq.removeRequest(n3);
                snmpIncomingResponse.setSecurityCache(this.cache);
                try {
                    snmpIncomingResponse.decodeMessage(byArray, n, datagramPacket.getAddress(), datagramPacket.getPort());
                }
                catch (SnmpSecurityException snmpSecurityException) {
                    if (this.isDebugOn()) {
                        this.debug("processDatagram", " Security Exception when unmarshalling, status : " + snmpSecurityException.status);
                    }
                    snmpV3InformRequest.setErrorStatusAndIndex(snmpSecurityException.status, 0);
                    snmpV3InformRequest.invokeOnResponse(null);
                    return;
                }
                SnmpPdu snmpPdu = snmpIncomingResponse.decodeSnmpPdu();
                if (snmpPdu == null) {
                    if (this.isDebugOn()) {
                        this.debug("processDatagram", "Dropping packet. Pdu factory returned a null value");
                    }
                    return;
                }
                if (!(snmpPdu instanceof SnmpPduRequestType)) {
                    if (this.isDebugOn()) {
                        this.debug("processDatagram", "Dropping packet. The packet does not contain a response");
                    }
                    snmpPdu = null;
                    return;
                }
                SnmpPdu snmpPdu2 = snmpPdu;
                snmpV3InformRequest.invokeOnResponse(snmpPdu2);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block12;
                this.debug("processDatagram", "Exception while processsing");
                this.debug("processDatagram", exception);
            }
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)64, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)64, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)64, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

