/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.comm.SnmpMibContextName;
import com.sun.jdmk.comm.SnmpMibTree;
import com.sun.jdmk.comm.SnmpSubBulkRequestHandler;
import com.sun.jdmk.comm.SnmpSubNextRequestHandler;
import com.sun.jdmk.comm.SnmpSubRequestHandler;
import com.sun.jdmk.comm.SnmpV3AdaptorServer;
import com.sun.jdmk.internal.snmp.SnmpAccessControlSubSystem;
import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.internal.snmp.SnmpIncomingRequest;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.snmp.SnmpBadSecurityLevelException;
import com.sun.jdmk.snmp.SnmpUnknownAccContrModelException;
import com.sun.jdmk.snmp.SnmpUnknownMsgProcModelException;
import com.sun.jdmk.snmp.SnmpUnknownSecModelException;
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import com.sun.jdmk.snmp.agent.SnmpRequestForwarder;
import com.sun.jdmk.snmp.agent.SnmpUserDataFactory;
import com.sun.jdmk.trace.Trace;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.snmp.InetAddressAcl;
import javax.management.snmp.SnmpAckPdu;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpMsg;
import javax.management.snmp.SnmpNull;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduBulkType;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduRequestType;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;

class SnmpV3RequestHandler
extends ClientHandler
implements SnmpDefinitions {
    private transient DatagramSocket socket = null;
    private transient DatagramPacket packet = null;
    private transient Vector mibs = null;
    private transient Hashtable contexts = null;
    private transient Hashtable forwarders = null;
    private transient Hashtable subs = null;
    private transient SnmpMibTree root;
    private transient Vector currentMibs = null;
    private transient SnmpMibTree currentRoot = null;
    private transient Object ipacl = null;
    private transient SnmpPduFactory pduFactory = null;
    private transient SnmpUserDataFactory userDataFactory = null;
    private transient SnmpEngineImpl engine = null;
    private transient SnmpMsgProcessingSubSystem msgProcSubSys = null;
    private transient SnmpAccessControlSubSystem accessSubSys = null;
    private transient SnmpV3AdaptorServer adaptor = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpStatusException noSuchNameException = new SnmpStatusException(2);

    public SnmpV3RequestHandler(SnmpV3AdaptorServer snmpV3AdaptorServer, SnmpEngine snmpEngine, int n, DatagramSocket datagramSocket, DatagramPacket datagramPacket, Hashtable hashtable, Hashtable hashtable2, SnmpMibTree snmpMibTree, Vector vector, Object object, SnmpPduFactory snmpPduFactory, SnmpUserDataFactory snmpUserDataFactory, MBeanServer mBeanServer, ObjectName objectName) {
        super(snmpV3AdaptorServer, n, mBeanServer, objectName);
        this.adaptor = snmpV3AdaptorServer;
        this.engine = (SnmpEngineImpl)snmpEngine;
        this.msgProcSubSys = this.engine.getMsgProcessingSubSystem();
        this.accessSubSys = this.engine.getAccessControlSubSystem();
        this.contexts = hashtable;
        this.forwarders = hashtable2;
        this.socket = datagramSocket;
        this.packet = datagramPacket;
        this.root = snmpMibTree;
        this.mibs = (Vector)vector.clone();
        this.ipacl = object;
        this.pduFactory = snmpPduFactory;
        this.userDataFactory = snmpUserDataFactory;
        if (this.isDebugOn()) {
            this.debug("SnmpV3RequestHandler", "userDataFactory : " + this.userDataFactory);
        }
    }

    public void doRun() {
        block11: {
            if (this.isTraceOn()) {
                this.trace("doRun", "Packet received:\n" + SnmpMsg.dumpHexBuffer((byte[])this.packet.getData(), (int)0, (int)this.packet.getLength()));
            }
            DatagramPacket datagramPacket = this.makeResponsePacket(this.packet);
            if (this.isTraceOn() && datagramPacket != null) {
                this.trace("doRun", "Packet to be sent:\n" + SnmpMsg.dumpHexBuffer((byte[])datagramPacket.getData(), (int)0, (int)datagramPacket.getLength()));
            }
            if (datagramPacket != null) {
                try {
                    this.socket.send(datagramPacket);
                }
                catch (SocketException socketException) {
                    if (this.isDebugOn()) {
                        if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                            this.debug("doRun", "interrupted");
                        } else {
                            this.debug("doRun", "i/o exception");
                            this.debug("doRun", socketException);
                        }
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.isDebugOn()) {
                        this.debug("doRun", "interrupted");
                    }
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block11;
                    this.debug("doRun", "failure when sending response");
                    this.debug("doRun", exception);
                }
            }
        }
    }

    private SnmpRequestForwarder handleContextEngineId(SnmpIncomingRequest snmpIncomingRequest) {
        SnmpEngineId snmpEngineId = SnmpEngineId.createEngineId((byte[])snmpIncomingRequest.getContextEngineId());
        SnmpRequestForwarder snmpRequestForwarder = null;
        if (!this.engine.getEngineId().equals((Object)snmpEngineId)) {
            if (this.isTraceOn()) {
                this.trace("handleContextEngineId", " The received contextEngineId is UNKNOWN:[" + snmpEngineId + "]. Forward to registered proxy.");
            }
            if (snmpEngineId != null) {
                snmpRequestForwarder = (SnmpRequestForwarder)this.forwarders.get(snmpEngineId.toString());
            }
            if (snmpRequestForwarder == null) {
                if (this.isTraceOn()) {
                    this.trace("handleContextEngineId", " The received contextEngineId is not handled:[" + snmpEngineId + "]");
                }
                snmpIncomingRequest.noResponse();
            }
        }
        return snmpRequestForwarder;
    }

    private void handleContextName(SnmpIncomingRequest snmpIncomingRequest) {
        if (snmpIncomingRequest.getContextName() != null) {
            String string = new String(snmpIncomingRequest.getContextName());
            if (snmpIncomingRequest.getContextName().length != 0 && !string.equals("default")) {
                SnmpMibContextName snmpMibContextName;
                if (this.isTraceOn()) {
                    this.trace("handleContextName", " The received contextName is :[" + string + "]");
                }
                if ((snmpMibContextName = (SnmpMibContextName)this.contexts.get(string)) != null) {
                    this.currentRoot = snmpMibContextName.root;
                    this.currentMibs = snmpMibContextName.mibs;
                } else {
                    if (this.isTraceOn()) {
                        this.trace("handleContextName", " The received contextName is UNKNOWN:[" + string + "]");
                    }
                    this.adaptor.incSnmpUnknownContexts(1);
                    snmpIncomingRequest.noResponse();
                }
            } else {
                this.currentRoot = this.root;
                this.currentMibs = this.mibs;
            }
        } else {
            this.currentRoot = this.root;
            this.currentMibs = this.mibs;
        }
    }

    private DatagramPacket makeResponsePacket(DatagramPacket datagramPacket) {
        DatagramPacket datagramPacket2 = null;
        SnmpIncomingRequest snmpIncomingRequest = null;
        int n = 0;
        try {
            n = SnmpMsg.getProtocolVersion((byte[])datagramPacket.getData());
            snmpIncomingRequest = this.msgProcSubSys.getIncomingRequest(n, this.pduFactory);
            snmpIncomingRequest.decodeMessage(datagramPacket.getData(), datagramPacket.getLength(), datagramPacket.getAddress(), datagramPacket.getPort());
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (this.isDebugOn()) {
                this.debug("makeResponsePacket", "Unknown Msg Processing Model:" + n);
                this.debug("makeResponsePacket", snmpUnknownMsgProcModelException);
            }
            this.adaptor.incSnmpInBadVersions(1);
            this.adaptor.incSnmpInvalidMsgs(1);
            return null;
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (this.isDebugOn()) {
                this.debug("makeResponsePacket", "Unknown Security Model:" + n);
                this.debug("makeResponsePacket", snmpUnknownSecModelException);
            }
            this.adaptor.incSnmpUnknownSecurityModels(1);
            return null;
        }
        catch (SnmpBadSecurityLevelException snmpBadSecurityLevelException) {
            if (this.isDebugOn()) {
                this.debug("makeResponsePacket", "Bad Security Level:" + n);
                this.debug("makeResponsePacket", snmpBadSecurityLevelException);
            }
            this.adaptor.incSnmpInvalidMsgs(1);
            return null;
        }
        catch (SnmpStatusException snmpStatusException) {
            if (this.isDebugOn()) {
                this.debug("makeResponsePacket", "packet decoding failed");
            }
            this.adaptor.incSnmpInASNParseErrs(1);
            return null;
        }
        if (snmpIncomingRequest.isReport()) {
            try {
                datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                datagramPacket2 = datagramPacket;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponsePacket", "response message is too big");
                }
                try {
                    this.newTooBigMessage(snmpIncomingRequest);
                    datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (this.isDebugOn()) {
                        this.debug("makeResponsePacket", "'too big' is 'too big' !!!");
                    }
                    this.adaptor.incSnmpSilentDrops(1);
                }
            }
            return datagramPacket2;
        }
        if (snmpIncomingRequest.isResponse()) {
            SnmpRequestForwarder snmpRequestForwarder = this.handleContextEngineId(snmpIncomingRequest);
            if (snmpRequestForwarder != null) {
                this.makeResponseMessage(snmpIncomingRequest, snmpRequestForwarder);
            } else if (snmpIncomingRequest.isResponse()) {
                this.handleContextName(snmpIncomingRequest);
                if (snmpIncomingRequest.isResponse()) {
                    this.subs = new Hashtable(this.currentMibs.size());
                    this.makeResponseMessage(snmpIncomingRequest, null);
                }
            }
        }
        if (snmpIncomingRequest.isResponse()) {
            try {
                datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                datagramPacket2 = datagramPacket;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponsePacket", "response message is too big");
                }
                try {
                    this.newTooBigMessage(snmpIncomingRequest);
                    datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpTooBigException snmpTooBigException3) {
                    if (this.isDebugOn()) {
                        this.debug("makeResponsePacket", "'too big' is 'too big' !!!");
                    }
                    this.adaptor.incSnmpSilentDrops(1);
                }
            }
        }
        return datagramPacket2;
    }

    private void makeResponseMessage(SnmpIncomingRequest snmpIncomingRequest, SnmpRequestForwarder snmpRequestForwarder) {
        Object object;
        SnmpPdu snmpPdu;
        block29: {
            snmpPdu = null;
            object = null;
            try {
                snmpPdu = snmpIncomingRequest.decodeSnmpPdu();
                if (snmpPdu != null && this.userDataFactory != null) {
                    object = this.userDataFactory.allocateUserData(snmpPdu);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpPdu = null;
                this.adaptor.incSnmpInASNParseErrs(1);
                if (snmpStatusException.getStatus() == 243) {
                    this.adaptor.incSnmpInBadVersions(1);
                }
                if (!this.isDebugOn()) break block29;
                this.debug("makeResponseMessage", "message decoding failed");
            }
        }
        SnmpPdu snmpPdu2 = null;
        if (snmpPdu != null) {
            snmpPdu2 = this.makeResponsePdu(snmpIncomingRequest, snmpPdu, object, snmpRequestForwarder);
            try {
                if (this.userDataFactory != null) {
                    this.userDataFactory.releaseUserData(object, snmpPdu2);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpPdu2 = null;
            }
        }
        if (snmpPdu2 != null) {
            try {
                snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, this.packet.getData().length);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpIncomingRequest.noResponse();
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "failure when encoding the response message");
                    this.debug("makeResponseMessage", snmpStatusException);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "response message is too big");
                }
                try {
                    if (this.packet.getData().length <= 32) {
                        throw snmpTooBigException;
                    }
                    int n = snmpTooBigException.getVarBindCount();
                    if (this.isDebugOn()) {
                        this.debug("makeResponseMessage", "fail on element" + n);
                    }
                    int n2 = 0;
                    while (true) {
                        try {
                            snmpPdu2 = this.reduceResponsePdu(snmpPdu, snmpPdu2, n);
                            snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, this.packet.getData().length - 32);
                        }
                        catch (SnmpTooBigException snmpTooBigException2) {
                            if (this.isDebugOn()) {
                                this.debug("makeResponseMessage", "response message is still too big");
                            }
                            n2 = n;
                            n = snmpTooBigException2.getVarBindCount();
                            if (!this.isDebugOn()) continue;
                            this.debug("makeResponseMessage", "fail on element" + n);
                            if (n != n2) continue;
                            throw snmpTooBigException2;
                        }
                        break;
                    }
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpIncomingRequest.noResponse();
                    if (this.isDebugOn()) {
                        this.debug("makeResponseMessage", "failure when encoding the response message");
                        this.debug("makeResponseMessage", snmpStatusException);
                    }
                }
                catch (SnmpTooBigException snmpTooBigException3) {
                    try {
                        snmpPdu2 = this.newTooBigPdu(snmpPdu);
                        snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, this.packet.getData().length);
                    }
                    catch (SnmpTooBigException snmpTooBigException4) {
                        snmpIncomingRequest.noResponse();
                        if (this.isDebugOn()) {
                            this.debug("makeResponseMessage", "'too big' is 'too big' !!!");
                        }
                        this.adaptor.incSnmpSilentDrops(1);
                    }
                    catch (Exception exception) {
                        snmpIncomingRequest.noResponse();
                    }
                }
                catch (Exception exception) {
                    snmpIncomingRequest.noResponse();
                }
            }
        }
    }

    private SnmpPdu makeResponsePdu(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu, Object object, SnmpRequestForwarder snmpRequestForwarder) {
        SnmpPdu snmpPdu2;
        block33: {
            snmpPdu2 = null;
            if (snmpRequestForwarder != null) {
                return this.makeForwardResponsePdu(snmpIncomingRequest, snmpPdu, snmpRequestForwarder);
            }
            this.adaptor.updateRequestCounters(snmpPdu.type);
            if (snmpPdu.varBindList != null) {
                this.adaptor.updateVarCounters(snmpPdu.type, snmpPdu.varBindList.length);
            }
            if (this.checkPduType(snmpPdu)) {
                if (this.currentMibs.size() < 1) {
                    if (this.isTraceOn()) {
                        this.trace("makeResponsePdu", "Request " + snmpPdu.requestId + " received but no MIB registered.");
                    }
                    return this.makeNoMibErrorPdu(snmpPdu, object);
                }
                if (this.isDebugOn()) {
                    this.trace("makeResponsePdu", "Testing access for : Principal : " + snmpIncomingRequest.getPrincipal() + " \n" + "Snmp version : " + snmpPdu.version + " \n" + "Security level : " + snmpIncomingRequest.getSecurityLevel() + " \n" + "Pdu type : " + snmpPdu.type + " \n" + "Security model : " + snmpIncomingRequest.getSecurityModel() + " \n" + " Access context : " + snmpIncomingRequest.getAccessContext() + " \n");
                }
                try {
                    this.accessSubSys.checkPduAccess(snmpPdu.version, snmpIncomingRequest.getPrincipal(), snmpIncomingRequest.getSecurityLevel(), snmpPdu.type, snmpIncomingRequest.getSecurityModel(), snmpIncomingRequest.getAccessContext(), snmpPdu);
                }
                catch (SnmpStatusException snmpStatusException) {
                    int n = -1;
                    if (this.isDebugOn()) {
                        this.debug("makeResponsePdu", "authorization failed : " + snmpStatusException.getStatus());
                    }
                    switch (snmpStatusException.getStatus()) {
                        case 2: {
                            if (this.isDebugOn()) {
                                this.debug("makeResponsePdu", " update noSuchName counter");
                            }
                            this.adaptor.updateErrorCounters(2);
                        }
                        case 4: {
                            if (this.isDebugOn()) {
                                this.debug("makeResponsePdu", " update bad community uses");
                            }
                            this.adaptor.incSnmpInBadCommunityUses(1);
                            InetAddressAcl inetAddressAcl = this.adaptor.getInetAddressAcl();
                            if (!inetAddressAcl.checkCommunity(new String(snmpIncomingRequest.getAccessContext()))) {
                                if (this.isDebugOn()) {
                                    this.debug("makeResponsePdu", "update bad community names");
                                }
                                this.adaptor.incSnmpInBadCommunityNames(1);
                            }
                            n = SnmpSubRequestHandler.mapErrorStatus(16, snmpPdu.version, snmpPdu.type);
                            break;
                        }
                        case 20: {
                            if (this.isDebugOn()) {
                                this.debug("makeResponsePdu", "No such context context. Dropping the request");
                            }
                            snmpIncomingRequest.noResponse();
                            return null;
                        }
                        default: {
                            if (this.isDebugOn()) {
                                this.debug("makeResponsePdu", "AuthorizationError.");
                            }
                            n = SnmpSubRequestHandler.mapErrorStatus(16, snmpPdu.version, snmpPdu.type);
                        }
                    }
                    if (this.isTraceOn()) {
                        this.trace("makeResponsePdu", "Mapped status : " + n);
                    }
                    snmpPdu2 = this.newErrorResponsePdu(snmpPdu, n, 0);
                    return snmpPdu2;
                }
                catch (SnmpUnknownAccContrModelException snmpUnknownAccContrModelException) {
                    if (this.isTraceOn()) {
                        this.trace("makeResponsePdu", "SnmpUnknownAccContrModelException");
                    }
                    snmpPdu2 = this.newErrorResponsePdu(snmpPdu, 5, 0);
                    return snmpPdu2;
                }
                if (this.isTraceOn()) {
                    this.trace("makeResponsePdu", "Access Granted to " + snmpIncomingRequest.getPrincipal());
                }
                switch (snmpPdu.type) {
                    case 160: 
                    case 161: 
                    case 163: {
                        snmpPdu2 = this.makeGetSetResponsePdu(snmpIncomingRequest, snmpPdu, object);
                        break;
                    }
                    case 165: {
                        snmpPdu2 = this.makeGetBulkResponsePdu(snmpIncomingRequest, (SnmpPduBulkType)snmpPdu, object);
                    }
                }
            } else {
                if (!this.adaptor.getAuthRespEnabled()) {
                    snmpPdu2 = null;
                }
                if (this.adaptor.getAuthTrapEnabled()) {
                    try {
                        this.adaptor.snmpV1Trap(4, 0, new SnmpVarBindList());
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block33;
                        this.debug("makeResponsePdu", "failure when sending authentication trap");
                        this.debug("makeResponsePdu", exception);
                    }
                }
            }
        }
        return snmpPdu2;
    }

    private SnmpPdu makeForwardResponsePdu(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu, SnmpRequestForwarder snmpRequestForwarder) {
        try {
            return snmpRequestForwarder.forward(snmpPdu);
        }
        catch (SnmpStatusException snmpStatusException) {
            if (this.isDebugOn()) {
                this.debug("makeForwardResponsePdu", "Failure when forwarding, return null.");
            }
            return null;
        }
    }

    SnmpPdu makeErrorVarbindPdu(SnmpPdu snmpPdu, int n) {
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        int n2 = snmpVarBindArray.length;
        switch (n) {
            case 130: {
                int n3 = 0;
                while (n3 < n2) {
                    snmpVarBindArray[n3].value = SnmpVarBind.endOfMibView;
                    ++n3;
                }
                break;
            }
            case 128: {
                int n4 = 0;
                while (n4 < n2) {
                    snmpVarBindArray[n4].value = SnmpVarBind.noSuchObject;
                    ++n4;
                }
                break;
            }
            case 129: {
                int n5 = 0;
                while (n5 < n2) {
                    snmpVarBindArray[n5].value = SnmpVarBind.noSuchInstance;
                    ++n5;
                }
                break;
            }
            default: {
                return this.newErrorResponsePdu(snmpPdu, 5, 1);
            }
        }
        return this.newValidResponsePdu(snmpPdu, snmpVarBindArray);
    }

    SnmpPdu makeNoMibErrorPdu(SnmpPdu snmpPdu, Object object) {
        if (snmpPdu.version == 0) {
            return this.newErrorResponsePdu(snmpPdu, 2, 1);
        }
        if (snmpPdu.version == 1 || snmpPdu.version == 3) {
            switch (snmpPdu.type) {
                case 163: 
                case 253: {
                    return this.newErrorResponsePdu(snmpPdu, 6, 1);
                }
                case 160: {
                    return this.makeErrorVarbindPdu(snmpPdu, 128);
                }
                case 161: 
                case 165: {
                    return this.makeErrorVarbindPdu(snmpPdu, 130);
                }
            }
        }
        return this.newErrorResponsePdu(snmpPdu, 5, 1);
    }

    private SnmpPdu makeGetSetResponsePdu(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu, Object object) {
        if (snmpPdu.varBindList == null) {
            return this.newValidResponsePdu(snmpPdu, null);
        }
        SnmpPdu snmpPdu2 = null;
        snmpPdu2 = this.splitRequest(snmpIncomingRequest, snmpPdu);
        if (snmpPdu2 != null) {
            return snmpPdu2;
        }
        int n = this.subs.size();
        if (n == 1) {
            return this.turboProcessingGetSet(snmpPdu, object);
        }
        snmpPdu2 = this.executeSubRequest(snmpPdu, object);
        if (snmpPdu2 != null) {
            return snmpPdu2;
        }
        if (this.isTraceOn()) {
            this.trace("makeGetSetResponsePdu", "Build the unified response for request " + snmpPdu.requestId);
        }
        return this.mergeResponses(snmpPdu);
    }

    private SnmpPdu executeSubRequest(SnmpPdu snmpPdu, Object object) {
        SnmpSubRequestHandler snmpSubRequestHandler;
        Enumeration enumeration;
        int n;
        int n2 = 0;
        int n3 = this.subs.size();
        if (snmpPdu.type == 163) {
            n = 0;
            enumeration = this.subs.elements();
            while (enumeration.hasMoreElements()) {
                snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
                snmpSubRequestHandler.setUserData(object);
                snmpSubRequestHandler.type = 253;
                snmpSubRequestHandler.run();
                snmpSubRequestHandler.type = 163;
                if (snmpSubRequestHandler.getErrorStatus() != 0) {
                    return this.newErrorResponsePdu(snmpPdu, n2, snmpSubRequestHandler.getErrorIndex() + 1);
                }
                ++n;
            }
        }
        n = 0;
        enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.setUserData(object);
            snmpSubRequestHandler.run();
            if (snmpSubRequestHandler.getErrorStatus() != 0) {
                if (this.isDebugOn()) {
                    this.debug("executeSubRequest", "an error occurs");
                }
                int n4 = snmpSubRequestHandler.getErrorIndex() + 1;
                return this.newErrorResponsePdu(snmpPdu, n2, n4);
            }
            ++n;
        }
        return null;
    }

    private SnmpPdu turboProcessingGetSet(SnmpPdu snmpPdu, Object object) {
        int n = 0;
        SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)this.subs.elements().nextElement();
        snmpSubRequestHandler.setUserData(object);
        if (snmpPdu.type == 163) {
            snmpSubRequestHandler.type = 253;
            snmpSubRequestHandler.run();
            snmpSubRequestHandler.type = 163;
            n = snmpSubRequestHandler.getErrorStatus();
            if (n != 0) {
                return this.newErrorResponsePdu(snmpPdu, n, snmpSubRequestHandler.getErrorIndex() + 1);
            }
        }
        snmpSubRequestHandler.run();
        n = snmpSubRequestHandler.getErrorStatus();
        if (n != 0) {
            if (this.isDebugOn()) {
                this.debug("turboProcessingGetSet", "an error occurs");
            }
            int n2 = snmpSubRequestHandler.getErrorIndex() + 1;
            return this.newErrorResponsePdu(snmpPdu, n, n2);
        }
        if (this.isTraceOn()) {
            this.trace("turboProcessingGetSet", "build the unified response for request " + snmpPdu.requestId);
        }
        return this.mergeResponses(snmpPdu);
    }

    private SnmpPdu makeGetBulkResponsePdu(SnmpIncomingRequest snmpIncomingRequest, SnmpPduBulkType snmpPduBulkType, Object object) {
        int n;
        int n2;
        SnmpVarBind[] snmpVarBindArray = null;
        SnmpVarBind[] snmpVarBindArray2 = ((SnmpPdu)snmpPduBulkType).varBindList;
        if (snmpVarBindArray2 == null) {
            return this.newValidResponsePdu((SnmpPdu)snmpPduBulkType, null);
        }
        int n3 = snmpVarBindArray2.length;
        int n4 = Math.max(Math.min(snmpPduBulkType.getNonRepeaters(), n3), 0);
        SnmpPdu snmpPdu = this.splitBulkRequest(snmpIncomingRequest, snmpPduBulkType, n4, n2 = Math.max(snmpPduBulkType.getMaxRepetitions(), 0), n = n3 - n4);
        if (snmpPdu != null) {
            return snmpPdu;
        }
        snmpPdu = this.executeSubRequest((SnmpPdu)snmpPduBulkType, object);
        if (snmpPdu != null) {
            return snmpPdu;
        }
        snmpVarBindArray = this.mergeBulkResponses(n4 + n2 * n);
        int n5 = snmpVarBindArray.length;
        while (n5 > n4 && snmpVarBindArray[n5 - 1].value.equals(SnmpVarBind.endOfMibView)) {
            --n5;
        }
        int n6 = n5 == n4 ? n4 + n : n4 + ((n5 - 1 - n4) / n + 2) * n;
        if (n6 < snmpVarBindArray.length) {
            SnmpVarBind[] snmpVarBindArray3 = new SnmpVarBind[n6];
            int n7 = 0;
            while (n7 < n6) {
                snmpVarBindArray3[n7] = snmpVarBindArray[n7];
                ++n7;
            }
            snmpVarBindArray = snmpVarBindArray3;
        }
        return this.newValidResponsePdu((SnmpPdu)snmpPduBulkType, snmpVarBindArray);
    }

    private boolean checkPduType(SnmpPdu snmpPdu) {
        boolean bl = true;
        if (snmpPdu.type == 165 && snmpPdu.version == 0 && this.isDebugOn()) {
            this.debug("checkPduType", "Received a getbulk in V1, rejecting the request");
            return false;
        }
        switch (snmpPdu.type) {
            case 160: 
            case 161: 
            case 163: 
            case 165: {
                bl = true;
                break;
            }
            default: {
                if (this.isDebugOn()) {
                    this.debug("checkPduType", "cannot respond to this kind of PDU");
                }
                bl = false;
            }
        }
        return bl;
    }

    private SnmpPdu newValidResponsePdu(SnmpPdu snmpPdu, SnmpVarBind[] snmpVarBindArray) {
        SnmpPdu snmpPdu2 = null;
        SnmpAckPdu snmpAckPdu = (SnmpAckPdu)snmpPdu;
        snmpPdu2 = snmpAckPdu.getResponsePdu();
        snmpPdu2.varBindList = snmpVarBindArray;
        this.adaptor.updateErrorCounters(((SnmpPduRequestType)snmpPdu2).getErrorStatus());
        return snmpPdu2;
    }

    private SnmpPdu newErrorResponsePdu(SnmpPdu snmpPdu, int n, int n2) {
        SnmpPduRequestType snmpPduRequestType = (SnmpPduRequestType)this.newValidResponsePdu(snmpPdu, null);
        snmpPduRequestType.setErrorStatus(n);
        snmpPduRequestType.setErrorIndex(n2);
        ((SnmpPdu)snmpPduRequestType).varBindList = snmpPdu.varBindList;
        this.adaptor.updateErrorCounters(snmpPduRequestType.getErrorStatus());
        return (SnmpPdu)snmpPduRequestType;
    }

    private void newTooBigMessage(SnmpIncomingRequest snmpIncomingRequest) throws SnmpTooBigException {
        Object var2_2 = null;
        SnmpPdu snmpPdu = null;
        try {
            snmpPdu = snmpIncomingRequest.decodeSnmpPdu();
            if (snmpPdu != null) {
                SnmpPdu snmpPdu2 = this.newTooBigPdu(snmpPdu);
                snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, this.packet.getData().length);
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            throw new InternalError();
        }
    }

    private SnmpPdu newTooBigPdu(SnmpPdu snmpPdu) {
        SnmpPdu snmpPdu2 = this.newErrorResponsePdu(snmpPdu, 1, 0);
        snmpPdu2.varBindList = null;
        return snmpPdu2;
    }

    private SnmpPdu reduceResponsePdu(SnmpPdu snmpPdu, SnmpPdu snmpPdu2, int n) throws SnmpTooBigException {
        if (snmpPdu.type != 165) {
            if (this.isDebugOn()) {
                this.debug("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(n);
        }
        int n2 = snmpPdu2.varBindList.length;
        n2 = n >= 3 ? Math.min(n - 1, snmpPdu2.varBindList.length) : (n == 1 ? 1 : snmpPdu2.varBindList.length / 2);
        if (n2 < 1) {
            if (this.isDebugOn()) {
                this.debug("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(n);
        }
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        int n3 = 0;
        while (n3 < n2) {
            snmpVarBindArray[n3] = snmpPdu2.varBindList[n3];
            ++n3;
        }
        if (this.isDebugOn()) {
            this.debug("reduceResponsePdu", snmpPdu2.varBindList.length - snmpVarBindArray.length + " items have been removed");
        }
        snmpPdu2.varBindList = snmpVarBindArray;
        return snmpPdu2;
    }

    private SnmpPdu handleAccessException(int n, int n2, SnmpPdu snmpPdu, SnmpVarBind snmpVarBind, SnmpAdaptorServer snmpAdaptorServer) {
        SnmpPdu snmpPdu2 = null;
        int n3 = 0;
        if (snmpPdu.version != 3) {
            block12: {
                if (!snmpAdaptorServer.getAuthRespEnabled()) {
                    // empty if block
                }
                if (snmpAdaptorServer.getAuthTrapEnabled()) {
                    try {
                        snmpAdaptorServer.snmpV1Trap(4, 0, new SnmpVarBindList());
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block12;
                        this.debug("handleAccessException", "failure when sending authentication trap");
                        this.debug("handleAccessException", exception);
                    }
                }
            }
            if (snmpPdu.version == 0) {
                n3 = SnmpSubRequestHandler.mapErrorStatus(n, snmpPdu.version, snmpPdu.type);
                snmpPdu2 = this.newErrorResponsePdu(snmpPdu, n3, n2);
            } else {
                n3 = SnmpSubRequestHandler.mapErrorStatus(n, snmpPdu.version, snmpPdu.type);
                if (snmpPdu.type == 163) {
                    snmpPdu2 = this.newErrorResponsePdu(snmpPdu, n3, n2);
                } else {
                    snmpVarBind.value = new SnmpNull(n3);
                }
            }
        } else {
            n3 = SnmpSubRequestHandler.mapErrorStatus(n, snmpPdu.version, snmpPdu.type);
            if (snmpPdu.type == 163) {
                snmpPdu2 = this.newErrorResponsePdu(snmpPdu, n3, n2);
            } else {
                snmpVarBind.value = new SnmpNull(n3);
            }
        }
        return snmpPdu2;
    }

    private Object checkOidAccess(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu, SnmpVarBind snmpVarBind, int n) {
        SnmpPdu snmpPdu2 = null;
        try {
            this.accessSubSys.checkAccess(snmpPdu.version, snmpIncomingRequest.getPrincipal(), snmpIncomingRequest.getSecurityLevel(), snmpPdu.type, snmpIncomingRequest.getSecurityModel(), snmpIncomingRequest.getAccessContext(), snmpVarBind.oid);
        }
        catch (SnmpStatusException snmpStatusException) {
            switch (snmpStatusException.getStatus()) {
                default: 
            }
            if (this.isTraceOn()) {
                this.trace("checkOidAccess", "SnmpStatusException : " + snmpStatusException.getStatus());
            }
            if (snmpPdu.version == 0) {
                snmpPdu2 = this.newErrorResponsePdu(snmpPdu, 2, n + 1);
                return snmpPdu2;
            }
            return SnmpVarBind.noSuchInstance;
        }
        catch (SnmpUnknownAccContrModelException snmpUnknownAccContrModelException) {
            snmpPdu2 = this.newErrorResponsePdu(snmpPdu, 5, n + 1);
        }
        return snmpPdu2;
    }

    private SnmpPdu splitRequest(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu) {
        Object var3_3 = null;
        int n = this.currentMibs.size();
        if (this.isTraceOn()) {
            this.trace("splitRequest", "Nb agents : " + n);
        }
        SnmpSubRequestHandler snmpSubRequestHandler = null;
        int n2 = snmpPdu.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpMibAgent snmpMibAgent = null;
        if (n == 1) {
            snmpMibAgent = (SnmpMibAgent)this.currentMibs.firstElement();
            if (snmpPdu.type == 163 || snmpPdu.type == 160) {
                snmpSubRequestHandler = new SnmpSubRequestHandler((SnmpEngine)this.engine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
                this.subs.put(snmpMibAgent, snmpSubRequestHandler);
                if (this.isDebugOn()) {
                    this.debug("splitRequest", "Checking access for each oid.");
                }
                boolean bl = false;
                Object object = null;
                int n3 = 0;
                while (n3 < n2) {
                    object = this.checkOidAccess(snmpIncomingRequest, snmpPdu, snmpVarBindArray[n3], n3);
                    if (object != null) {
                        if (this.isDebugOn()) {
                            this.debug("splitRequest", "Access NOT granted for OID:" + snmpVarBindArray[n3].getOid());
                        }
                        if (object instanceof SnmpPdu) {
                            return (SnmpPdu)object;
                        }
                        snmpVarBindArray[n3].setSnmpValue((SnmpValue)object);
                    } else {
                        if (this.isDebugOn()) {
                            this.debug("splitRequest", "Access granted for OID:" + snmpVarBindArray[n3].getOid());
                        }
                        snmpSubRequestHandler.updateRequest(snmpVarBindArray[n3], n3);
                    }
                    ++n3;
                }
            } else {
                if (this.isTraceOn()) {
                    this.trace("splitRequest", "Doing getNext on 1 agent [" + snmpMibAgent + "]");
                }
                snmpSubRequestHandler = new SnmpSubRequestHandler((SnmpEngine)this.engine, snmpIncomingRequest, snmpMibAgent, snmpPdu, true);
                this.subs.put(snmpMibAgent, snmpSubRequestHandler);
            }
            return null;
        }
        if (snmpPdu.type == 161) {
            if (this.isTraceOn()) {
                this.trace("splitRequest", "Doing getNext on muliple agents");
            }
            Enumeration enumeration = this.currentMibs.elements();
            while (enumeration.hasMoreElements()) {
                SnmpSubNextRequestHandler snmpSubNextRequestHandler = null;
                SnmpMibAgent snmpMibAgent2 = (SnmpMibAgent)enumeration.nextElement();
                snmpSubNextRequestHandler = new SnmpSubNextRequestHandler((SnmpEngine)this.engine, this.adaptor, snmpIncomingRequest, snmpMibAgent2, snmpPdu);
                this.subs.put(snmpMibAgent2, snmpSubNextRequestHandler);
                if (!this.isTraceOn()) continue;
                this.trace("splitRequest", "Doing getNext on agent [" + snmpMibAgent2 + "]");
            }
            return null;
        }
        if (this.isTraceOn()) {
            this.trace("splitRequest", "Access Granted to " + snmpIncomingRequest.getPrincipal() + n2);
        }
        Object object = null;
        int n4 = 0;
        while (n4 < n2) {
            object = this.checkOidAccess(snmpIncomingRequest, snmpPdu, snmpVarBindArray[n4], n4);
            if (object != null) {
                if (this.isDebugOn()) {
                    this.debug("splitRequest", "Access NOT granted for OID:" + snmpVarBindArray[n4].getOid());
                }
                if (object instanceof SnmpPdu) {
                    return (SnmpPdu)object;
                }
                snmpVarBindArray[n4].setSnmpValue((SnmpValue)object);
            } else {
                if (this.isDebugOn()) {
                    this.debug("splitRequest", "Access granted for OID : " + snmpVarBindArray[n4].getOid());
                }
                if ((snmpSubRequestHandler = (SnmpSubRequestHandler)this.subs.get(snmpMibAgent = this.currentRoot.getAgentMib(snmpVarBindArray[n4].oid))) == null) {
                    snmpSubRequestHandler = new SnmpSubRequestHandler((SnmpEngine)this.engine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
                    this.subs.put(snmpMibAgent, snmpSubRequestHandler);
                }
                snmpSubRequestHandler.updateRequest(snmpVarBindArray[n4], n4);
            }
            ++n4;
        }
        return null;
    }

    private SnmpPdu splitBulkRequest(SnmpIncomingRequest snmpIncomingRequest, SnmpPduBulkType snmpPduBulkType, int n, int n2, int n3) {
        int n4 = this.currentMibs.size();
        if (n4 == 1) {
            SnmpMibAgent snmpMibAgent = (SnmpMibAgent)this.currentMibs.firstElement();
            this.subs.put(snmpMibAgent, new SnmpSubBulkRequestHandler((SnmpEngine)this.engine, this.adaptor, snmpIncomingRequest, snmpMibAgent, (SnmpPdu)snmpPduBulkType, n, n2, n3));
            return null;
        }
        Enumeration enumeration = this.currentMibs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubBulkRequestHandler snmpSubBulkRequestHandler = null;
            SnmpMibAgent snmpMibAgent = (SnmpMibAgent)enumeration.nextElement();
            snmpSubBulkRequestHandler = new SnmpSubBulkRequestHandler((SnmpEngine)this.engine, this.adaptor, snmpIncomingRequest, snmpMibAgent, (SnmpPdu)snmpPduBulkType, n, n2, n3);
            this.subs.put(snmpMibAgent, snmpSubBulkRequestHandler);
        }
        return null;
    }

    private SnmpPdu mergeResponses(SnmpPdu snmpPdu) {
        if (snmpPdu.type == 161) {
            return this.mergeNextResponses(snmpPdu);
        }
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        return this.newValidResponsePdu(snmpPdu, snmpVarBindArray);
    }

    private SnmpPdu mergeNextResponses(SnmpPdu snmpPdu) {
        int n = snmpPdu.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        if (snmpPdu.version == 1 || snmpPdu.version == 3) {
            return this.newValidResponsePdu(snmpPdu, snmpVarBindArray);
        }
        int n2 = 0;
        while (n2 < n) {
            SnmpValue snmpValue = snmpVarBindArray[n2].value;
            if (snmpValue == SnmpVarBind.endOfMibView) {
                return this.newErrorResponsePdu(snmpPdu, 2, n2 + 1);
            }
            ++n2;
        }
        return this.newValidResponsePdu(snmpPdu, snmpVarBindArray);
    }

    private SnmpVarBind[] mergeBulkResponses(int n) {
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            snmpVarBindArray[n2] = new SnmpVarBind();
            snmpVarBindArray[n2].value = SnmpVarBind.endOfMibView;
            --n2;
        }
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        return snmpVarBindArray;
    }

    protected boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    protected void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    protected boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    protected void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (Throwable)throwable);
    }

    protected void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    protected void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    protected String makeDebugTag() {
        return "SnmpV3RequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "]";
    }

    Thread createThread(Runnable runnable) {
        return null;
    }
}

