/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.SnmpInformHandler;
import com.sun.jdmk.comm.SnmpInformRequest;
import com.sun.jdmk.comm.SnmpV3AdaptorServer;
import com.sun.jdmk.comm.SnmpV3ResponseHandler;
import com.sun.jdmk.comm.SnmpV3Session;
import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.internal.snmp.SnmpOutgoingRequest;
import com.sun.jdmk.snmp.SnmpBadSecurityLevelException;
import com.sun.jdmk.snmp.SnmpUnknownMsgProcModelException;
import com.sun.jdmk.snmp.SnmpUnknownSecModelException;
import com.sun.jdmk.trace.Trace;
import java.io.IOException;
import java.net.InetAddress;
import javax.management.snmp.SnmpMsg;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduRequestType;
import javax.management.snmp.SnmpScopedPduRequest;
import javax.management.snmp.SnmpSecurityException;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpV3Message;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;

public class SnmpV3InformRequest
extends SnmpInformRequest {
    private SnmpV3ResponseHandler respHandler = null;
    private SnmpScopedPduRequest v3pdu = null;
    private SnmpV3AdaptorServer v3adaptor = null;
    private SnmpVarBindList reportVarBindList = null;
    private String dbgTag = "SnmpV3InformRequest";

    SnmpV3InformRequest(SnmpV3Session snmpV3Session, SnmpV3ResponseHandler snmpV3ResponseHandler, SnmpV3AdaptorServer snmpV3AdaptorServer, InetAddress inetAddress, SnmpScopedPduRequest snmpScopedPduRequest, SnmpInformHandler snmpInformHandler) throws SnmpStatusException {
        super(snmpV3Session, snmpV3AdaptorServer, inetAddress, null, snmpScopedPduRequest.port, snmpInformHandler);
        this.respHandler = snmpV3ResponseHandler;
        this.v3adaptor = snmpV3AdaptorServer;
        this.v3pdu = snmpScopedPduRequest;
        snmpScopedPduRequest.type = 166;
        snmpScopedPduRequest.version = 3;
        snmpScopedPduRequest.address = inetAddress;
    }

    public SnmpVarBindList getReportVarBindList() {
        return this.reportVarBindList;
    }

    synchronized void parsePduPacket(SnmpPduRequestType snmpPduRequestType) {
        if (snmpPduRequestType == null) {
            return;
        }
        if (this.isTraceOn()) {
            this.trace("parsePduPacket", "received inform response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
        this.errorStatus = snmpPduRequestType.getErrorStatus();
        this.errorIndex = snmpPduRequestType.getErrorIndex();
        if (this.errorStatus == 0) {
            if (((SnmpPdu)snmpPduRequestType).type == 168) {
                if (this.isTraceOn()) {
                    this.trace("parsePduPacket", "received inform report.");
                }
                this.updateReportVarBindList(((SnmpPdu)snmpPduRequestType).varBindList);
            } else {
                if (this.isTraceOn()) {
                    this.trace("parsePduPacket", "received inform reponse.");
                }
                this.updateInternalVarBindWithResult(((SnmpPdu)snmpPduRequestType).varBindList);
            }
            return;
        }
        if (this.errorStatus != 0) {
            --this.errorIndex;
        }
        if (this.isTraceOn()) {
            this.trace("parsePduPacket", "received inform response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
    }

    private void updateReportVarBindList(SnmpVarBind[] snmpVarBindArray) {
        this.reportVarBindList = new SnmpVarBindList();
        int n = 0;
        while (n < snmpVarBindArray.length) {
            SnmpVarBind snmpVarBind = snmpVarBindArray[n];
            SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value);
            this.reportVarBindList.addVarBind(snmpVarBind2);
            ++n;
        }
    }

    synchronized SnmpPdu constructPduPacket() {
        this.v3pdu.varBindList = this.internalVarBind;
        this.v3pdu.requestId = this.getRequestId();
        this.v3pdu.msgFlags = (byte)(this.v3pdu.msgFlags | 4);
        return this.v3pdu;
    }

    public boolean isReport() {
        if (this.responsePdu == null) {
            if (this.isDebugOn()) {
                this.debug("isReport", "responsePdu is null");
            }
            return false;
        }
        if (this.isDebugOn()) {
            this.debug("isReport", "responsePdu not null");
        }
        return ((SnmpPdu)this.responsePdu).type == 168;
    }

    public boolean isResponse() {
        if (this.responsePdu == null) {
            if (this.isDebugOn()) {
                this.debug("isResponse", "responsePdu is null");
            }
            return false;
        }
        if (this.isDebugOn()) {
            this.debug("isResponse", "responsePdu not null");
        }
        return ((SnmpPdu)this.responsePdu).type == 162;
    }

    boolean sendPdu() {
        try {
            this.responsePdu = null;
            this.reportVarBindList = null;
            SnmpPduFactory snmpPduFactory = this.v3adaptor.getPduFactory();
            SnmpEngineImpl snmpEngineImpl = (SnmpEngineImpl)this.v3adaptor.getEngine();
            SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = snmpEngineImpl.getMsgProcessingSubSystem();
            SnmpOutgoingRequest snmpOutgoingRequest = snmpMsgProcessingSubSystem.getOutgoingRequest(3, snmpPduFactory);
            SnmpMsg snmpMsg = snmpOutgoingRequest.encodeSnmpPdu(this.requestPdu, this.v3adaptor.getBufferSize().intValue());
            if (snmpMsg == null) {
                if (this.isDebugOn()) {
                    this.debug("sendPdu", "pdu factory returned a null value");
                }
                throw new SnmpStatusException(242);
            }
            ((SnmpV3Message)snmpMsg).msgId = this.getRequestId();
            int n = this.v3adaptor.getBufferSize();
            byte[] byArray = new byte[n];
            int n2 = snmpOutgoingRequest.encodeMessage(byArray);
            if (this.isTraceOn()) {
                this.trace("sendPdu", "Dump : \n" + snmpMsg.printMessage());
            }
            this.respHandler.setSecurityCache(snmpOutgoingRequest.getSecurityCache());
            this.sendPduPacket(byArray, n2);
            return true;
        }
        catch (SnmpTooBigException snmpTooBigException) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", snmpTooBigException);
            }
            this.setErrorStatusAndIndex(228, snmpTooBigException.getVarBindCount());
            this.requestPdu = null;
            this.reason = snmpTooBigException.getMessage();
            if (this.isDebugOn()) {
                this.debug("sendPdu", "Packet Overflow while building inform request");
            }
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", iOException.toString());
            }
            this.setErrorStatusAndIndex(241, 0);
            this.reason = iOException.getMessage();
        }
        catch (SnmpSecurityException snmpSecurityException) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", snmpSecurityException.toString());
            }
            this.setErrorStatusAndIndex(snmpSecurityException.status, 0);
            this.reason = snmpSecurityException.getMessage();
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", snmpUnknownMsgProcModelException.toString());
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = snmpUnknownMsgProcModelException.getMessage();
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (this.isTraceOn()) {
                this.trace("sendPdu", snmpUnknownSecModelException.toString());
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = snmpUnknownSecModelException.getMessage();
        }
        catch (SnmpBadSecurityLevelException snmpBadSecurityLevelException) {
            if (this.isTraceOn()) {
                this.trace("sendPdu", snmpBadSecurityLevelException.toString());
            }
            this.setErrorStatusAndIndex(249, 0);
            this.reason = snmpBadSecurityLevelException.getMessage();
        }
        catch (SnmpStatusException snmpStatusException) {
            if (this.isTraceOn()) {
                this.trace("sendPdu", snmpStatusException.toString());
            }
            this.setErrorStatusAndIndex(snmpStatusException.getStatus(), 0);
            this.reason = snmpStatusException.getMessage();
        }
        return false;
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

