/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.ThreadContext;
import com.sun.jdmk.internal.snmp.SnmpIncomingRequest;
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import com.sun.jdmk.snmp.agent.SnmpMibRequest;
import com.sun.jdmk.trace.Trace;
import java.util.Vector;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;

class SnmpSubRequestHandler
implements SnmpDefinitions,
Runnable {
    protected SnmpIncomingRequest incRequest = null;
    protected SnmpEngine engine = null;
    protected String dbgTag = this.makeDebugTag();
    protected int version = 0;
    protected int type = 0;
    protected SnmpMibAgent agent;
    protected int errorStatus = 0;
    protected int errorIndex = -1;
    protected Vector varBind;
    protected int[] translation;
    protected Object data;
    private SnmpMibRequest mibRequest = null;
    private SnmpPdu reqPdu = null;

    protected SnmpSubRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        this(snmpMibAgent, snmpPdu);
        this.init(snmpEngine, snmpIncomingRequest);
    }

    protected SnmpSubRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, boolean bl) {
        this(snmpMibAgent, snmpPdu, bl);
        this.init(snmpEngine, snmpIncomingRequest);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        if (this.isTraceOn()) {
            this.trace("constructor", "creating instance for request " + String.valueOf(snmpPdu.requestId));
        }
        this.version = snmpPdu.version;
        this.type = snmpPdu.type;
        this.agent = snmpMibAgent;
        this.reqPdu = snmpPdu;
        int n = snmpPdu.varBindList.length;
        this.translation = new int[n];
        this.varBind = new NonSyncVector(n);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, boolean bl) {
        this(snmpMibAgent, snmpPdu);
        int n = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        int n2 = 0;
        while (n2 < n) {
            this.translation[n2] = n2;
            ((NonSyncVector)this.varBind).addNonSyncElement(snmpVarBindArray[n2]);
            ++n2;
        }
    }

    SnmpMibRequest createMibRequest(Vector vector, int n, Object object) {
        if (this.type == 163 && this.mibRequest != null) {
            return this.mibRequest;
        }
        SnmpMibRequest snmpMibRequest = null;
        snmpMibRequest = this.incRequest != null ? SnmpMibAgent.newMibRequest(this.engine, this.reqPdu, vector, n, object, this.incRequest.getPrincipal(), this.incRequest.getSecurityLevel(), this.incRequest.getSecurityModel(), this.incRequest.getContextName(), this.incRequest.getAccessContext()) : SnmpMibAgent.newMibRequest(this.reqPdu, vector, n, object);
        if (this.type == 253) {
            this.mibRequest = snmpMibRequest;
        }
        return snmpMibRequest;
    }

    void setUserData(Object object) {
        this.data = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    switch (this.type) {
                        case 160: {
                            if (this.isTraceOn()) {
                                this.trace("run", "[" + Thread.currentThread() + "]:get operation on " + this.agent.getMibName());
                            }
                            this.agent.get(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        case 161: {
                            if (this.isTraceOn()) {
                                this.trace("run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                            }
                            this.agent.getNext(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        case 163: {
                            if (this.isTraceOn()) {
                                this.trace("run", "[" + Thread.currentThread() + "]:set operation on " + this.agent.getMibName());
                            }
                            this.agent.set(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        case 253: {
                            if (this.isTraceOn()) {
                                this.trace("run", "[" + Thread.currentThread() + "]:check operation on " + this.agent.getMibName());
                            }
                            this.agent.check(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        default: {
                            if (this.isDebugOn()) {
                                this.debug("run", "[" + Thread.currentThread() + "]:unknown operation (" + this.type + ") on " + this.agent.getMibName());
                            }
                            this.errorStatus = 5;
                            this.errorIndex = 1;
                        }
                    }
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    ThreadContext.restore(threadContext);
                    throw throwable;
                }
                ThreadContext.restore(threadContext);
                {
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (this.isDebugOn()) {
                    this.debug("run", "[" + Thread.currentThread() + "]:a Snmp error occured during the operation");
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (!this.isDebugOn()) break block18;
                this.debug("run", "[" + Thread.currentThread() + "]a generic error occured during the operation");
            }
        }
        if (this.isTraceOn()) {
            this.trace("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    static final int mapErrorStatusToV1(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n == 5) {
            return 5;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 224 || n == 225 || n == 6 || n == 18 || n == 16) {
            return 2;
        }
        if (n == 16 || n == 17) {
            if (n2 == 253) {
                return 4;
            }
            return 2;
        }
        if (n == 11) {
            return 2;
        }
        if (n == 7 || n == 8 || n == 9 || n == 10 || n == 8 || n == 12) {
            if (n2 == 163 || n2 == 253) {
                return 3;
            }
            return 2;
        }
        if (n == 13 || n == 14 || n == 15) {
            return 5;
        }
        if (n == 1) {
            return 1;
        }
        if (n == 3 || n == 4) {
            if (n2 == 163 || n2 == 253) {
                return n;
            }
            return 2;
        }
        return 5;
    }

    static final int mapErrorStatusToV2(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n == 5) {
            return 5;
        }
        if (n == 1) {
            return 1;
        }
        if (n2 != 163 && n2 != 253) {
            if (n == 16) {
                return n;
            }
            return 5;
        }
        if (n == 2) {
            return 6;
        }
        if (n == 4) {
            return 17;
        }
        if (n == 3) {
            return 10;
        }
        if (n == 6 || n == 18 || n == 16 || n == 17 || n == 11 || n == 7 || n == 8 || n == 9 || n == 10 || n == 8 || n == 12 || n == 13 || n == 14 || n == 15) {
            return n;
        }
        return 5;
    }

    static final int mapErrorStatus(int n, int n2, int n3) {
        if (n == 0) {
            return 0;
        }
        if (n2 == 0) {
            return SnmpSubRequestHandler.mapErrorStatusToV1(n, n3);
        }
        if (n2 == 1 || n2 == 3) {
            return SnmpSubRequestHandler.mapErrorStatusToV2(n, n3);
        }
        return 5;
    }

    protected int getErrorStatus() {
        if (this.errorStatus == 0) {
            return 0;
        }
        return SnmpSubRequestHandler.mapErrorStatus(this.errorStatus, this.version, this.type);
    }

    protected int getErrorIndex() {
        if (this.errorStatus == 0) {
            return -1;
        }
        if (this.errorIndex == 0 || this.errorIndex == -1) {
            this.errorIndex = 1;
        }
        return this.translation[this.errorIndex - 1];
    }

    protected void updateRequest(SnmpVarBind snmpVarBind, int n) {
        int n2 = this.varBind.size();
        this.translation[n2] = n;
        this.varBind.addElement(snmpVarBind);
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        if (snmpVarBindArray == null) {
            return;
        }
        int n = this.varBind.size();
        int n2 = snmpVarBindArray.length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.translation[n3];
            if (n4 < n2) {
                snmpVarBindArray[n4] = (SnmpVarBind)((NonSyncVector)this.varBind).elementAtNonSync(n3);
            } else {
                this.debug("updateResult", "Position `" + n4 + "' is out of bound...");
            }
            ++n3;
        }
    }

    private void init(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest) {
        this.incRequest = snmpIncomingRequest;
        this.engine = snmpEngine;
    }

    protected boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    protected void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    protected boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    protected void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    protected String makeDebugTag() {
        return "SnmpSubRequestHandler";
    }

    class NonSyncVector
    extends Vector {
        public NonSyncVector(int n) {
            super(n);
        }

        final void addNonSyncElement(Object object) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = object;
        }

        final Object elementAtNonSync(int n) {
            return this.elementData[n];
        }
    }
}

