/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.ThreadContext;
import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.comm.SnmpSubRequestHandler;
import com.sun.jdmk.internal.snmp.SnmpIncomingRequest;
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

class SnmpSubNextRequestHandler
extends SnmpSubRequestHandler {
    private SnmpAdaptorServer server = null;

    protected SnmpSubNextRequestHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        super(snmpMibAgent, snmpPdu);
        this.init(snmpPdu, snmpAdaptorServer);
    }

    protected SnmpSubNextRequestHandler(SnmpEngine snmpEngine, SnmpAdaptorServer snmpAdaptorServer, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        super(snmpEngine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
        this.init(snmpPdu, snmpAdaptorServer);
        if (this.isDebugOn()) {
            this.debug("SnmpSubNextRequestHandler", "Constructor :" + this);
        }
    }

    private void init(SnmpPdu snmpPdu, SnmpAdaptorServer snmpAdaptorServer) {
        this.server = snmpAdaptorServer;
        int n = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVector = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        int n2 = 0;
        while (n2 < n) {
            this.translation[n2] = n2;
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpVarBindArray[n2].oid, snmpVarBindArray[n2].value);
            nonSyncVector.addNonSyncElement(snmpVarBind);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
            try {
                if (this.isTraceOn()) {
                    this.trace("run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                }
                this.agent.getNext(this.createMibRequest(this.varBind, 1, this.data));
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ThreadContext.restore(threadContext);
                throw throwable;
            }
            ThreadContext.restore(threadContext);
            {
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            this.errorStatus = snmpStatusException.getStatus();
            this.errorIndex = snmpStatusException.getErrorIndex();
            if (this.isDebugOn()) {
                this.debug("run", "[" + Thread.currentThread() + "]:a Snmp error occured during the operation");
            }
        }
        catch (Exception exception) {
            this.errorStatus = 5;
            if (this.isDebugOn()) {
                this.debug("run", "[" + Thread.currentThread() + "]:a generic error occured during the operation");
            }
            exception.printStackTrace();
        }
        if (this.isTraceOn()) {
            this.trace("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    protected void updateRequest(SnmpVarBind snmpVarBind, int n) {
        if (this.isDebugOn()) {
            this.debug("updateRequest", "Copy :" + snmpVarBind);
        }
        int n2 = this.varBind.size();
        this.translation[n2] = n;
        SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value);
        if (this.isDebugOn()) {
            this.debug("updateRequest", "Copied :" + snmpVarBind2);
        }
        this.varBind.addElement(snmpVarBind2);
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        int n = this.varBind.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.translation[n2];
            SnmpVarBind snmpVarBind = (SnmpVarBind)((SnmpSubRequestHandler.NonSyncVector)this.varBind).elementAtNonSync(n2);
            SnmpVarBind snmpVarBind2 = snmpVarBindArray[n3];
            if (snmpVarBind2 == null) {
                snmpVarBindArray[n3] = snmpVarBind;
            } else {
                SnmpValue snmpValue = snmpVarBind2.value;
                if (snmpValue == null || snmpValue == SnmpVarBind.endOfMibView) {
                    if (snmpVarBind != null && snmpVarBind.value != SnmpVarBind.endOfMibView) {
                        snmpVarBindArray[n3] = snmpVarBind;
                    }
                } else if (snmpVarBind != null && snmpVarBind.value != SnmpVarBind.endOfMibView) {
                    int n4 = snmpVarBind.oid.compareTo(snmpVarBind2.oid);
                    if (n4 < 0) {
                        snmpVarBindArray[n3] = snmpVarBind;
                    } else if (n4 == 0) {
                        if (this.isDebugOn()) {
                            this.trace("updateResult", " oid overlapping. Oid : " + snmpVarBind.oid + "value :" + snmpVarBind.value);
                            this.trace("updateResult", "Already present varBind : " + snmpVarBind2);
                        }
                        SnmpOid snmpOid = snmpVarBind2.oid;
                        SnmpMibAgent snmpMibAgent = this.server.getAgentMib(snmpOid);
                        if (this.isDebugOn()) {
                            this.trace("updateResult", "Deeper agent : " + snmpMibAgent);
                        }
                        if (snmpMibAgent == this.agent) {
                            if (this.isDebugOn()) {
                                this.trace("updateResult", "The current agent is the deeper one. Update the value with the current one");
                            }
                            snmpVarBindArray[n3].value = snmpVarBind.value;
                        }
                    }
                }
            }
            ++n2;
        }
    }

    protected String makeDebugTag() {
        return "SnmpSubNextRequestHandler";
    }
}

