/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.ThreadContext;
import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.comm.SnmpSubRequestHandler;
import com.sun.jdmk.internal.snmp.SnmpIncomingRequest;
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import java.util.Enumeration;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

class SnmpSubBulkRequestHandler
extends SnmpSubRequestHandler {
    private SnmpAdaptorServer server = null;
    protected int nonRepeat = 0;
    protected int maxRepeat = 0;
    protected int globalR = 0;
    protected int size = 0;

    protected SnmpSubBulkRequestHandler(SnmpEngine snmpEngine, SnmpAdaptorServer snmpAdaptorServer, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, int n, int n2, int n3) {
        super(snmpEngine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
        this.init(snmpAdaptorServer, snmpPdu, n, n2, n3);
    }

    protected SnmpSubBulkRequestHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, int n, int n2, int n3) {
        super(snmpMibAgent, snmpPdu);
        this.init(snmpAdaptorServer, snmpPdu, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: {
            this.size = this.varBind.size();
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (this.isTraceOn()) {
                        this.trace("run", "[" + Thread.currentThread() + "]:getBulk operation on " + this.agent.getMibName());
                    }
                    this.agent.getBulk(this.createMibRequest(this.varBind, this.version, this.data), this.nonRepeat, this.maxRepeat);
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    ThreadContext.restore(threadContext);
                    throw throwable;
                }
                ThreadContext.restore(threadContext);
                {
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (this.isDebugOn()) {
                    this.debug("run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation");
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (!this.isDebugOn()) break block8;
                this.debug("run", "[" + Thread.currentThread() + "]:a generic error occured during the operation");
            }
        }
        if (this.isTraceOn()) {
            this.trace("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    private void init(SnmpAdaptorServer snmpAdaptorServer, SnmpPdu snmpPdu, int n, int n2, int n3) {
        this.server = snmpAdaptorServer;
        this.nonRepeat = n;
        this.maxRepeat = n2;
        this.globalR = n3;
        int n4 = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVector = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        int n5 = 0;
        while (n5 < n4) {
            this.translation[n5] = n5;
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpVarBindArray[n5].oid, snmpVarBindArray[n5].value);
            nonSyncVector.addNonSyncElement(snmpVarBind);
            ++n5;
        }
    }

    private SnmpVarBind findVarBind(SnmpVarBind snmpVarBind, SnmpVarBind snmpVarBind2) {
        if (snmpVarBind == null) {
            return null;
        }
        if (snmpVarBind2.oid == null) {
            return snmpVarBind;
        }
        if (snmpVarBind.value == SnmpVarBind.endOfMibView) {
            return snmpVarBind2;
        }
        if (snmpVarBind2.value == SnmpVarBind.endOfMibView) {
            return snmpVarBind;
        }
        SnmpValue snmpValue = snmpVarBind2.value;
        int n = snmpVarBind.oid.compareTo(snmpVarBind2.oid);
        if (this.isDebugOn()) {
            this.trace("findVarBind", "Comparing OID element : " + snmpVarBind.oid + " with result : " + snmpVarBind2.oid);
            this.trace("findVarBind", "Values element : " + snmpVarBind.value + " result : " + snmpVarBind2.value);
        }
        if (n < 0) {
            return snmpVarBind;
        }
        if (n == 0) {
            if (this.isDebugOn()) {
                this.trace("findVarBind", " oid overlapping. Oid : " + snmpVarBind.oid + "value :" + snmpVarBind.value);
                this.trace("findVarBind", "Already present varBind : " + snmpVarBind2);
            }
            SnmpOid snmpOid = snmpVarBind2.oid;
            SnmpMibAgent snmpMibAgent = this.server.getAgentMib(snmpOid);
            if (this.isDebugOn()) {
                this.trace("findVarBind", "Deeper agent : " + snmpMibAgent);
            }
            if (snmpMibAgent == this.agent) {
                if (this.isDebugOn()) {
                    this.trace("updateResult", "The current agent is the deeper one. Update the value with the current one");
                }
                return snmpVarBind;
            }
            if (this.isDebugOn()) {
                this.trace("updateResult", "Current is not the deeper, return the previous one.");
            }
            return snmpVarBind2;
        }
        if (this.isDebugOn()) {
            this.trace("findVarBind", "The right varBind is the already present one");
        }
        return snmpVarBind2;
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        int n;
        Enumeration enumeration = this.varBind.elements();
        int n2 = snmpVarBindArray.length;
        int n3 = 0;
        while (n3 < this.size) {
            if (!enumeration.hasMoreElements()) {
                return;
            }
            n = this.translation[n3];
            if (n >= n2) {
                this.debug("updateResult", "Position `" + n + "' is out of bound...");
            } else {
                SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
                if (snmpVarBind != null) {
                    SnmpVarBind snmpVarBind2;
                    if (this.isDebugOn()) {
                        this.trace("updateResult", "Non repeaters Current element : " + snmpVarBind + " from agent : " + this.agent);
                    }
                    if ((snmpVarBind2 = this.findVarBind(snmpVarBind, snmpVarBindArray[n])) != null) {
                        snmpVarBindArray[n] = snmpVarBind2;
                    }
                }
            }
            ++n3;
        }
        n = this.size - this.nonRepeat;
        int n4 = 2;
        while (n4 <= this.maxRepeat) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = (n4 - 1) * this.globalR + this.translation[this.nonRepeat + n5];
                if (n6 >= n2) {
                    return;
                }
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
                if (snmpVarBind != null) {
                    SnmpVarBind snmpVarBind3;
                    if (this.isDebugOn()) {
                        this.trace("updateResult", "Repeaters Current element : " + snmpVarBind + " from agent : " + this.agent);
                    }
                    if ((snmpVarBind3 = this.findVarBind(snmpVarBind, snmpVarBindArray[n6])) != null) {
                        snmpVarBindArray[n6] = snmpVarBind3;
                    }
                }
                ++n5;
            }
            ++n4;
        }
    }

    protected String makeDebugTag() {
        return "SnmpSubBulkRequestHandler";
    }
}

