/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.comm.SnmpInformHandler;
import com.sun.jdmk.comm.SnmpInformRequest;
import com.sun.jdmk.comm.SnmpQManager;
import com.sun.jdmk.comm.SnmpResponseHandler;
import com.sun.jdmk.comm.SnmpSocket;
import com.sun.jdmk.trace.Trace;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBindList;

class SnmpSession
implements SnmpDefinitions,
Runnable {
    protected transient SnmpAdaptorServer adaptor;
    protected transient SnmpSocket informSocket = null;
    private transient Hashtable informRequestList = new Hashtable();
    private transient Stack informRespq = new Stack();
    private transient Thread myThread = null;
    private transient SnmpInformRequest syncInformReq;
    SnmpQManager snmpQman = null;
    String dbgTag = "SnmpSession";

    public SnmpSession(SnmpAdaptorServer snmpAdaptorServer) throws SocketException {
        this.adaptor = snmpAdaptorServer;
        this.snmpQman = new SnmpQManager();
        SnmpResponseHandler snmpResponseHandler = new SnmpResponseHandler(snmpAdaptorServer, this.snmpQman);
        this.initialize(snmpAdaptorServer, snmpResponseHandler);
    }

    public SnmpSession() throws SocketException {
    }

    protected synchronized void initialize(SnmpAdaptorServer snmpAdaptorServer, SnmpResponseHandler snmpResponseHandler) throws SocketException {
        this.informSocket = new SnmpSocket(snmpResponseHandler, snmpAdaptorServer.getAddress(), snmpAdaptorServer.getBufferSize());
        this.myThread = new Thread((Runnable)this, "SnmpSession");
        this.myThread.start();
    }

    synchronized boolean isSessionActive() {
        return this.adaptor.isActive() && this.myThread != null && this.myThread.isAlive();
    }

    SnmpSocket getSocket() {
        return this.informSocket;
    }

    SnmpQManager getSnmpQManager() {
        return this.snmpQman;
    }

    private synchronized boolean syncInProgress() {
        return this.syncInformReq != null;
    }

    private synchronized void setSyncMode(SnmpInformRequest snmpInformRequest) {
        this.syncInformReq = snmpInformRequest;
    }

    private synchronized void resetSyncMode() {
        if (this.syncInformReq == null) {
            return;
        }
        this.syncInformReq = null;
        if (this.thisSessionContext()) {
            return;
        }
        this.notifyAll();
    }

    boolean thisSessionContext() {
        return Thread.currentThread() == this.myThread;
    }

    SnmpInformRequest makeAsyncRequest(InetAddress inetAddress, String string, SnmpInformHandler snmpInformHandler, SnmpVarBindList snmpVarBindList, int n) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException("SNMP adaptor server not ONLINE");
        }
        SnmpInformRequest snmpInformRequest = new SnmpInformRequest(this, this.adaptor, inetAddress, string, n, snmpInformHandler);
        snmpInformRequest.start(snmpVarBindList);
        return snmpInformRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForResponse(SnmpInformRequest snmpInformRequest, long l) {
        if (!snmpInformRequest.inProgress()) {
            return;
        }
        this.setSyncMode(snmpInformRequest);
        if (this.isTraceOn()) {
            this.trace("waitForResponse", "Session switching to sync mode for inform request " + snmpInformRequest.getRequestId());
        }
        long l2 = l <= 0L ? System.currentTimeMillis() + 6000000L : System.currentTimeMillis() + l;
        while (snmpInformRequest.inProgress() || this.syncInProgress()) {
            l = l2 - System.currentTimeMillis();
            if (l <= 0L) break;
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                if (!this.informRespq.removeElement(snmpInformRequest)) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                this.processResponse(snmpInformRequest);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("waitForResponse", exception);
            }
        }
        this.resetSyncMode();
    }

    public void run() {
        this.myThread = Thread.currentThread();
        this.myThread.setPriority(5);
        SnmpInformRequest snmpInformRequest = null;
        while (this.myThread != null) {
            try {
                snmpInformRequest = this.nextResponse();
                if (snmpInformRequest == null) continue;
                this.processResponse(snmpInformRequest);
            }
            catch (ThreadDeath threadDeath) {
                this.myThread = null;
                if (this.isDebugOn()) {
                    this.debug("run", "Session thread unexpectedly shutting down");
                }
                throw threadDeath;
            }
        }
        if (this.isTraceOn()) {
            this.trace("run", "Session thread shutting down");
        }
        this.myThread = null;
    }

    private void processResponse(SnmpInformRequest snmpInformRequest) {
        while (snmpInformRequest != null && this.myThread != null) {
            try {
                if (snmpInformRequest == null) continue;
                if (this.isTraceOn()) {
                    this.trace("processResponse", "Processing response to req = " + snmpInformRequest.getRequestId());
                }
                snmpInformRequest.processResponse();
                snmpInformRequest = null;
            }
            catch (Exception exception) {
                if (this.isDebugOn()) {
                    this.debug("processResponse", exception);
                }
                snmpInformRequest = null;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (this.isDebugOn()) {
                    this.debug("processResponse", "Out of memory error in session thread");
                    this.debug("processResponse", outOfMemoryError);
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
    }

    synchronized void addInformRequest(SnmpInformRequest snmpInformRequest) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException("SNMP adaptor is not ONLINE or session is dead...");
        }
        this.informRequestList.put(snmpInformRequest, snmpInformRequest);
    }

    synchronized void removeInformRequest(SnmpInformRequest snmpInformRequest) {
        this.informRequestList.remove(snmpInformRequest);
        if (this.syncInformReq != null && this.syncInformReq == snmpInformRequest) {
            this.resetSyncMode();
        }
    }

    private void cancelAllRequests() {
        if (this.informRequestList.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.informRequestList.elements();
        while (enumeration.hasMoreElements()) {
            ((SnmpInformRequest)enumeration.nextElement()).cancelRequest();
        }
        this.informRequestList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResponse(SnmpInformRequest snmpInformRequest) {
        SnmpInformRequest snmpInformRequest2 = snmpInformRequest;
        if (this.isSessionActive()) {
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                this.informRespq.push(snmpInformRequest);
                this.notifyAll();
            }
        } else if (this.isDebugOn()) {
            this.debug("addResponse", "Adaptor not ONLINE or session thread dead. So inform response is dropped..." + snmpInformRequest.getRequestId());
        }
    }

    private synchronized SnmpInformRequest nextResponse() {
        if (this.informRespq.isEmpty()) {
            try {
                if (this.isTraceOn()) {
                    this.trace("nextResponse", "Blocking for response");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.informRespq.isEmpty()) {
            return null;
        }
        SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.informRespq.firstElement();
        this.informRespq.removeElementAt(0);
        return snmpInformRequest;
    }

    private synchronized void cancelAllResponses() {
        if (this.informRespq != null) {
            this.syncInformReq = null;
            this.informRespq.removeAllElements();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void destroySession() {
        this.cancelAllRequests();
        this.cancelAllResponses();
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            this.informSocket.close();
            this.informSocket = null;
        }
        this.snmpQman.stopQThreads();
        this.snmpQman = null;
        this.killSessionThread();
    }

    private synchronized void killSessionThread() {
        if (this.myThread != null && this.myThread.isAlive()) {
            if (this.isTraceOn()) {
                this.trace("killSessionThread", "Destroying session");
            }
            if (!this.thisSessionContext()) {
                this.myThread = null;
                this.notifyAll();
            } else {
                this.myThread = null;
            }
        }
    }

    public void finalize() {
        if (this.informRespq != null) {
            this.informRespq.removeAllElements();
        }
        this.informRespq = null;
        if (this.informSocket != null) {
            this.informSocket.close();
        }
        this.informSocket = null;
        if (this.isTraceOn()) {
            this.trace("finalize", "Shutting all servers");
        }
        this.snmpQman = null;
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

