/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.SnmpInformRequest;
import com.sun.jdmk.comm.SnmpQManager;
import com.sun.jdmk.trace.Trace;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpSendServer
extends Thread {
    private int intervalRange = 5000;
    private Vector readyPool;
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpSendServer";
    boolean isBeingDestroyed = false;

    public SnmpSendServer(ThreadGroup threadGroup, SnmpQManager snmpQManager) {
        super(threadGroup, "SnmpSendServer");
        this.snmpq = snmpQManager;
        this.start();
    }

    public synchronized void stopSendServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (this.isTraceOn()) {
            this.trace("run", "Thread Started");
        }
        while (true) {
            try {
                do {
                    this.prepareAndSendRequest();
                } while (!this.isBeingDestroyed);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("run", "Exception in send server");
                this.debug("run", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (this.isDebugOn()) {
                    this.debug("run", "Exiting... Fatal error");
                }
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!this.isDebugOn()) continue;
                this.debug("run", "Out of memory");
                continue;
            }
            catch (Error error) {
                if (this.isDebugOn()) {
                    this.debug("run", error);
                }
                throw error;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (this.isTraceOn()) {
                this.trace("prepareAndSendRequest", "Blocking for inform requests");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
            if (this.isBeingDestroyed) {
                return;
            }
        } else if (this.isDebugOn()) {
            this.debug("prepareAndSendRequest", "Inform requests from a previous block left unprocessed. Will try again");
        }
        if (this.isTraceOn()) {
            this.trace("prepareAndSendRequest", "List of inform requests to send : " + this.reqListToString(this.readyPool));
        }
        var1_1 = this;
        synchronized (var1_1) {
            if (this.readyPool.size() >= 2) ** GOTO lbl22
            this.fireRequestList(this.readyPool);
            return;
lbl-1000:
            // 1 sources

            {
                var2_2 = (SnmpInformRequest)this.readyPool.lastElement();
                if (var2_2 != null && var2_2.inProgress()) {
                    this.fireRequest(var2_2);
                }
                this.readyPool.removeElementAt(this.readyPool.size() - 1);
lbl22:
                // 2 sources

                ** while (!this.readyPool.isEmpty())
            }
lbl23:
            // 1 sources

            this.readyPool.removeAllElements();
        }
    }

    void fireRequest(SnmpInformRequest snmpInformRequest) {
        if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
            if (this.isTraceOn()) {
                this.trace("fireRequest", "Firing inform request directly. -> " + snmpInformRequest.getRequestId());
            }
            snmpInformRequest.action();
        }
    }

    void fireRequestList(Vector vector) {
        while (!vector.isEmpty()) {
            SnmpInformRequest snmpInformRequest = (SnmpInformRequest)vector.lastElement();
            if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
                this.fireRequest(snmpInformRequest);
            }
            vector.removeElementAt(vector.size() - 1);
        }
    }

    final String reqListToString(Vector vector) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(vector.size() * 100);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (SnmpInformRequest)enumeration.nextElement();
            stringBuffer.append("InformRequestId -> ");
            stringBuffer.append(((SnmpInformRequest)object).getRequestId());
            stringBuffer.append(" / Destination -> ");
            stringBuffer.append(((SnmpInformRequest)object).getAddress());
            stringBuffer.append(". ");
        }
        object = stringBuffer.toString();
        stringBuffer = null;
        return object;
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

