/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.comm.SnmpMibTree;
import com.sun.jdmk.comm.SnmpSubBulkRequestHandler;
import com.sun.jdmk.comm.SnmpSubNextRequestHandler;
import com.sun.jdmk.comm.SnmpSubRequestHandler;
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import com.sun.jdmk.snmp.agent.SnmpUserDataFactory;
import com.sun.jdmk.trace.Trace;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.snmp.InetAddressAcl;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpMsg;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduBulk;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;

class SnmpRequestHandler
extends ClientHandler
implements SnmpDefinitions {
    private transient DatagramSocket socket = null;
    private transient DatagramPacket packet = null;
    private transient Vector mibs = null;
    private transient Hashtable subs = null;
    private transient SnmpMibTree root;
    private transient Object ipacl = null;
    private transient SnmpPduFactory pduFactory = null;
    private transient SnmpUserDataFactory userDataFactory = null;
    private transient SnmpAdaptorServer adaptor = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpStatusException noSuchNameException = new SnmpStatusException(2);

    public SnmpRequestHandler(SnmpAdaptorServer snmpAdaptorServer, int n, DatagramSocket datagramSocket, DatagramPacket datagramPacket, SnmpMibTree snmpMibTree, Vector vector, Object object, SnmpPduFactory snmpPduFactory, SnmpUserDataFactory snmpUserDataFactory, MBeanServer mBeanServer, ObjectName objectName) {
        super(snmpAdaptorServer, n, mBeanServer, objectName);
        this.adaptor = snmpAdaptorServer;
        this.socket = datagramSocket;
        this.packet = datagramPacket;
        this.root = snmpMibTree;
        this.mibs = (Vector)vector.clone();
        this.subs = new Hashtable(this.mibs.size());
        this.ipacl = object;
        this.pduFactory = snmpPduFactory;
        this.userDataFactory = snmpUserDataFactory;
    }

    public void doRun() {
        block11: {
            if (this.isTraceOn()) {
                this.trace("doRun", "Packet received:\n" + SnmpMessage.dumpHexBuffer((byte[])this.packet.getData(), (int)0, (int)this.packet.getLength()));
            }
            DatagramPacket datagramPacket = this.makeResponsePacket(this.packet);
            if (this.isTraceOn() && datagramPacket != null) {
                this.trace("doRun", "Packet to be sent:\n" + SnmpMessage.dumpHexBuffer((byte[])datagramPacket.getData(), (int)0, (int)datagramPacket.getLength()));
            }
            if (datagramPacket != null) {
                try {
                    this.socket.send(datagramPacket);
                }
                catch (SocketException socketException) {
                    if (this.isDebugOn()) {
                        if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                            this.debug("doRun", "interrupted");
                        } else {
                            this.debug("doRun", "i/o exception");
                            this.debug("doRun", socketException);
                        }
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.isDebugOn()) {
                        this.debug("doRun", "interrupted");
                    }
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block11;
                    this.debug("doRun", "failure when sending response");
                    this.debug("doRun", exception);
                }
            }
        }
    }

    private DatagramPacket makeResponsePacket(DatagramPacket datagramPacket) {
        DatagramPacket datagramPacket2 = null;
        SnmpMessage snmpMessage = new SnmpMessage();
        try {
            snmpMessage.decodeMessage(datagramPacket.getData(), datagramPacket.getLength());
            snmpMessage.address = datagramPacket.getAddress();
            snmpMessage.port = datagramPacket.getPort();
        }
        catch (SnmpStatusException snmpStatusException) {
            if (this.isDebugOn()) {
                this.debug("makeResponsePacket", "packet decoding failed");
                this.debug("makeResponsePacket", snmpStatusException);
            }
            snmpMessage = null;
            ((SnmpAdaptorServer)this.adaptorServer).incSnmpInASNParseErrs(1);
        }
        SnmpMessage snmpMessage2 = null;
        if (snmpMessage != null) {
            snmpMessage2 = this.makeResponseMessage(snmpMessage);
        }
        if (snmpMessage2 != null) {
            try {
                datagramPacket.setLength(snmpMessage2.encodeMessage(datagramPacket.getData()));
                datagramPacket2 = datagramPacket;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponsePacket", "response message is too big");
                }
                try {
                    snmpMessage2 = this.newTooBigMessage(snmpMessage);
                    datagramPacket.setLength(snmpMessage2.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (this.isDebugOn()) {
                        this.debug("makeResponsePacket", "'too big' is 'too big' !!!");
                    }
                    this.adaptor.incSnmpSilentDrops(1);
                }
            }
        }
        return datagramPacket2;
    }

    private SnmpMessage makeResponseMessage(SnmpMessage snmpMessage) {
        Object object;
        SnmpPduPacket snmpPduPacket;
        SnmpMessage snmpMessage2;
        block29: {
            snmpMessage2 = null;
            snmpPduPacket = null;
            object = null;
            try {
                snmpPduPacket = (SnmpPduPacket)this.pduFactory.decodeSnmpPdu((SnmpMsg)snmpMessage);
                if (snmpPduPacket != null && this.userDataFactory != null) {
                    object = this.userDataFactory.allocateUserData(snmpPduPacket);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpPduPacket = null;
                SnmpAdaptorServer snmpAdaptorServer = (SnmpAdaptorServer)this.adaptorServer;
                snmpAdaptorServer.incSnmpInASNParseErrs(1);
                if (snmpStatusException.getStatus() == 243) {
                    snmpAdaptorServer.incSnmpInBadVersions(1);
                }
                if (!this.isDebugOn()) break block29;
                this.debug("makeResponseMessage", "message decoding failed");
            }
        }
        SnmpPduPacket snmpPduPacket2 = null;
        if (snmpPduPacket != null) {
            snmpPduPacket2 = this.makeResponsePdu(snmpPduPacket, object);
            try {
                if (this.userDataFactory != null) {
                    this.userDataFactory.releaseUserData(object, snmpPduPacket2);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpPduPacket2 = null;
            }
        }
        if (snmpPduPacket2 != null) {
            try {
                snmpMessage2 = (SnmpMessage)this.pduFactory.encodeSnmpPdu((SnmpPdu)snmpPduPacket2, this.packet.getData().length);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMessage2 = null;
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "failure when encoding the response message");
                    this.debug("makeResponseMessage", snmpStatusException);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "response message is too big");
                }
                try {
                    if (this.packet.getData().length <= 32) {
                        throw snmpTooBigException;
                    }
                    int n = snmpTooBigException.getVarBindCount();
                    if (this.isDebugOn()) {
                        this.debug("makeResponseMessage", "fail on element" + n);
                    }
                    int n2 = 0;
                    while (true) {
                        try {
                            snmpPduPacket2 = this.reduceResponsePdu(snmpPduPacket, snmpPduPacket2, n);
                            snmpMessage2 = (SnmpMessage)this.pduFactory.encodeSnmpPdu((SnmpPdu)snmpPduPacket2, this.packet.getData().length - 32);
                        }
                        catch (SnmpTooBigException snmpTooBigException2) {
                            if (this.isDebugOn()) {
                                this.debug("makeResponseMessage", "response message is still too big");
                            }
                            n2 = n;
                            n = snmpTooBigException2.getVarBindCount();
                            if (!this.isDebugOn()) continue;
                            this.debug("makeResponseMessage", "fail on element" + n);
                            if (n != n2) continue;
                            throw snmpTooBigException2;
                        }
                        break;
                    }
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpMessage2 = null;
                    if (this.isDebugOn()) {
                        this.debug("makeResponseMessage", "failure when encoding the response message");
                        this.debug("makeResponseMessage", snmpStatusException);
                    }
                }
                catch (SnmpTooBigException snmpTooBigException3) {
                    try {
                        snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                        snmpMessage2 = (SnmpMessage)this.pduFactory.encodeSnmpPdu((SnmpPdu)snmpPduPacket2, this.packet.getData().length);
                    }
                    catch (SnmpTooBigException snmpTooBigException4) {
                        snmpMessage2 = null;
                        if (this.isDebugOn()) {
                            this.debug("makeResponseMessage", "'too big' is 'too big' !!!");
                        }
                        this.adaptor.incSnmpSilentDrops(1);
                    }
                    catch (Exception exception) {
                        snmpMessage2 = null;
                    }
                }
                catch (Exception exception) {
                    snmpMessage2 = null;
                }
            }
        }
        return snmpMessage2;
    }

    private SnmpPduPacket makeResponsePdu(SnmpPduPacket snmpPduPacket, Object object) {
        SnmpPduPacket snmpPduPacket2;
        block14: {
            SnmpAdaptorServer snmpAdaptorServer = (SnmpAdaptorServer)this.adaptorServer;
            snmpPduPacket2 = null;
            snmpAdaptorServer.updateRequestCounters(snmpPduPacket.type);
            if (snmpPduPacket.varBindList != null) {
                snmpAdaptorServer.updateVarCounters(snmpPduPacket.type, snmpPduPacket.varBindList.length);
            }
            if (this.checkPduType(snmpPduPacket)) {
                snmpPduPacket2 = this.checkAcl(snmpPduPacket);
                if (snmpPduPacket2 == null) {
                    if (this.mibs.size() < 1) {
                        if (this.isTraceOn()) {
                            this.trace("makeResponsePdu", "Request " + snmpPduPacket.requestId + " received but no MIB registered.");
                        }
                        return this.makeNoMibErrorPdu((SnmpPduRequest)snmpPduPacket, object);
                    }
                    switch (snmpPduPacket.type) {
                        case 160: 
                        case 161: 
                        case 163: {
                            snmpPduPacket2 = this.makeGetSetResponsePdu((SnmpPduRequest)snmpPduPacket, object);
                            break;
                        }
                        case 165: {
                            snmpPduPacket2 = this.makeGetBulkResponsePdu((SnmpPduBulk)snmpPduPacket, object);
                        }
                    }
                } else {
                    if (!snmpAdaptorServer.getAuthRespEnabled()) {
                        snmpPduPacket2 = null;
                    }
                    if (snmpAdaptorServer.getAuthTrapEnabled()) {
                        try {
                            snmpAdaptorServer.snmpV1Trap(4, 0, new SnmpVarBindList());
                        }
                        catch (Exception exception) {
                            if (!this.isDebugOn()) break block14;
                            this.debug("makeResponsePdu", "failure when sending authentication trap");
                            this.debug("makeResponsePdu", exception);
                        }
                    }
                }
            }
        }
        return snmpPduPacket2;
    }

    SnmpPduPacket makeErrorVarbindPdu(SnmpPduPacket snmpPduPacket, int n) {
        SnmpVarBind[] snmpVarBindArray = snmpPduPacket.varBindList;
        int n2 = snmpVarBindArray.length;
        switch (n) {
            case 130: {
                int n3 = 0;
                while (n3 < n2) {
                    snmpVarBindArray[n3].value = SnmpVarBind.endOfMibView;
                    ++n3;
                }
                break;
            }
            case 128: {
                int n4 = 0;
                while (n4 < n2) {
                    snmpVarBindArray[n4].value = SnmpVarBind.noSuchObject;
                    ++n4;
                }
                break;
            }
            case 129: {
                int n5 = 0;
                while (n5 < n2) {
                    snmpVarBindArray[n5].value = SnmpVarBind.noSuchInstance;
                    ++n5;
                }
                break;
            }
            default: {
                return this.newErrorResponsePdu(snmpPduPacket, 5, 1);
            }
        }
        return this.newValidResponsePdu(snmpPduPacket, snmpVarBindArray);
    }

    SnmpPduPacket makeNoMibErrorPdu(SnmpPduRequest snmpPduRequest, Object object) {
        if (snmpPduRequest.version == 0) {
            return this.newErrorResponsePdu((SnmpPduPacket)snmpPduRequest, 2, 1);
        }
        if (snmpPduRequest.version == 1) {
            switch (snmpPduRequest.type) {
                case 163: 
                case 253: {
                    return this.newErrorResponsePdu((SnmpPduPacket)snmpPduRequest, 6, 1);
                }
                case 160: {
                    return this.makeErrorVarbindPdu((SnmpPduPacket)snmpPduRequest, 128);
                }
                case 161: 
                case 165: {
                    return this.makeErrorVarbindPdu((SnmpPduPacket)snmpPduRequest, 130);
                }
            }
        }
        return this.newErrorResponsePdu((SnmpPduPacket)snmpPduRequest, 5, 1);
    }

    private SnmpPduPacket makeGetSetResponsePdu(SnmpPduRequest snmpPduRequest, Object object) {
        if (snmpPduRequest.varBindList == null) {
            return this.newValidResponsePdu((SnmpPduPacket)snmpPduRequest, null);
        }
        this.splitRequest(snmpPduRequest);
        int n = this.subs.size();
        if (n == 1) {
            return this.turboProcessingGetSet(snmpPduRequest, object);
        }
        SnmpPduPacket snmpPduPacket = this.executeSubRequest((SnmpPduPacket)snmpPduRequest, object);
        if (snmpPduPacket != null) {
            return snmpPduPacket;
        }
        if (this.isTraceOn()) {
            this.trace("makeGetSetResponsePdu", "Build the unified response for request " + snmpPduRequest.requestId);
        }
        return this.mergeResponses(snmpPduRequest);
    }

    private SnmpPduPacket executeSubRequest(SnmpPduPacket snmpPduPacket, Object object) {
        SnmpSubRequestHandler snmpSubRequestHandler;
        Enumeration enumeration;
        int n = 0;
        int n2 = this.subs.size();
        int n3 = 0;
        if (snmpPduPacket.type == 163) {
            n3 = 0;
            enumeration = this.subs.elements();
            while (enumeration.hasMoreElements()) {
                snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
                snmpSubRequestHandler.setUserData(object);
                snmpSubRequestHandler.type = 253;
                snmpSubRequestHandler.run();
                snmpSubRequestHandler.type = 163;
                if (snmpSubRequestHandler.getErrorStatus() != 0) {
                    if (this.isDebugOn()) {
                        this.debug("executeSubRequest", "an error occurs");
                    }
                    return this.newErrorResponsePdu(snmpPduPacket, n, snmpSubRequestHandler.getErrorIndex() + 1);
                }
                ++n3;
            }
        }
        n3 = 0;
        enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.setUserData(object);
            snmpSubRequestHandler.run();
            if (snmpSubRequestHandler.getErrorStatus() != 0) {
                if (this.isDebugOn()) {
                    this.debug("executeSubRequest", "an error occurs");
                }
                return this.newErrorResponsePdu(snmpPduPacket, n, snmpSubRequestHandler.getErrorIndex() + 1);
            }
            ++n3;
        }
        return null;
    }

    private SnmpPduPacket turboProcessingGetSet(SnmpPduRequest snmpPduRequest, Object object) {
        int n = 0;
        SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)this.subs.elements().nextElement();
        snmpSubRequestHandler.setUserData(object);
        if (snmpPduRequest.type == 163) {
            snmpSubRequestHandler.type = 253;
            snmpSubRequestHandler.run();
            snmpSubRequestHandler.type = 163;
            n = snmpSubRequestHandler.getErrorStatus();
            if (n != 0) {
                return this.newErrorResponsePdu((SnmpPduPacket)snmpPduRequest, n, snmpSubRequestHandler.getErrorIndex() + 1);
            }
        }
        snmpSubRequestHandler.run();
        n = snmpSubRequestHandler.getErrorStatus();
        if (n != 0) {
            if (this.isDebugOn()) {
                this.debug("turboProcessingGetSet", "an error occurs");
            }
            int n2 = snmpSubRequestHandler.getErrorIndex() + 1;
            return this.newErrorResponsePdu((SnmpPduPacket)snmpPduRequest, n, n2);
        }
        if (this.isTraceOn()) {
            this.trace("turboProcessingGetSet", "build the unified response for request " + snmpPduRequest.requestId);
        }
        return this.mergeResponses(snmpPduRequest);
    }

    private SnmpPduPacket makeGetBulkResponsePdu(SnmpPduBulk snmpPduBulk, Object object) {
        SnmpVarBind[] snmpVarBindArray = null;
        int n = snmpPduBulk.varBindList.length;
        int n2 = Math.max(Math.min(snmpPduBulk.nonRepeaters, n), 0);
        int n3 = Math.max(snmpPduBulk.maxRepetitions, 0);
        int n4 = n - n2;
        if (snmpPduBulk.varBindList == null) {
            return this.newValidResponsePdu((SnmpPduPacket)snmpPduBulk, null);
        }
        this.splitBulkRequest(snmpPduBulk, n2, n3, n4);
        SnmpPduPacket snmpPduPacket = this.executeSubRequest((SnmpPduPacket)snmpPduBulk, object);
        if (snmpPduPacket != null) {
            return snmpPduPacket;
        }
        snmpVarBindArray = this.mergeBulkResponses(n2 + n3 * n4);
        int n5 = snmpVarBindArray.length;
        while (n5 > n2 && snmpVarBindArray[n5 - 1].value.equals(SnmpVarBind.endOfMibView)) {
            --n5;
        }
        int n6 = n5 == n2 ? n2 + n4 : n2 + ((n5 - 1 - n2) / n4 + 2) * n4;
        if (n6 < snmpVarBindArray.length) {
            SnmpVarBind[] snmpVarBindArray2 = new SnmpVarBind[n6];
            int n7 = 0;
            while (n7 < n6) {
                snmpVarBindArray2[n7] = snmpVarBindArray[n7];
                ++n7;
            }
            snmpVarBindArray = snmpVarBindArray2;
        }
        return this.newValidResponsePdu((SnmpPduPacket)snmpPduBulk, snmpVarBindArray);
    }

    private boolean checkPduType(SnmpPduPacket snmpPduPacket) {
        boolean bl = true;
        switch (snmpPduPacket.type) {
            case 160: 
            case 161: 
            case 163: 
            case 165: {
                bl = true;
                break;
            }
            default: {
                if (this.isDebugOn()) {
                    this.debug("checkPduType", "cannot respond to this kind of PDU");
                }
                bl = false;
            }
        }
        return bl;
    }

    private SnmpPduPacket checkAcl(SnmpPduPacket snmpPduPacket) {
        SnmpPduRequest snmpPduRequest = null;
        String string = new String(snmpPduPacket.community);
        if (this.ipacl != null) {
            int n;
            if (snmpPduPacket.type == 163) {
                if (!((InetAddressAcl)this.ipacl).checkWritePermission(snmpPduPacket.address, string)) {
                    if (this.isTraceOn()) {
                        this.trace("checkAcl", "sender is " + snmpPduPacket.address + " with " + string);
                        this.trace("checkAcl", "sender has no write permission");
                    }
                    n = SnmpSubRequestHandler.mapErrorStatus(16, snmpPduPacket.version, snmpPduPacket.type);
                    snmpPduRequest = this.newErrorResponsePdu(snmpPduPacket, n, 0);
                } else if (this.isTraceOn()) {
                    this.trace("checkAcl", "sender is " + snmpPduPacket.address + " with " + string);
                    this.trace("checkAcl", "sender has write permission");
                }
            } else if (!((InetAddressAcl)this.ipacl).checkReadPermission(snmpPduPacket.address, string)) {
                if (this.isTraceOn()) {
                    this.trace("checkAcl", "sender is " + snmpPduPacket.address + " with " + string);
                    this.trace("checkAcl", "sender has no read permission");
                }
                n = SnmpSubRequestHandler.mapErrorStatus(16, snmpPduPacket.version, snmpPduPacket.type);
                snmpPduRequest = this.newErrorResponsePdu(snmpPduPacket, n, 0);
                SnmpAdaptorServer snmpAdaptorServer = (SnmpAdaptorServer)this.adaptorServer;
                snmpAdaptorServer.updateErrorCounters(2);
            } else if (this.isTraceOn()) {
                this.trace("checkAcl", "sender is " + snmpPduPacket.address + " with " + string);
                this.trace("checkAcl", "sender has read permission");
            }
        }
        if (snmpPduRequest != null) {
            SnmpAdaptorServer snmpAdaptorServer = (SnmpAdaptorServer)this.adaptorServer;
            snmpAdaptorServer.incSnmpInBadCommunityUses(1);
            if (!((InetAddressAcl)this.ipacl).checkCommunity(string)) {
                snmpAdaptorServer.incSnmpInBadCommunityNames(1);
            }
        }
        return snmpPduRequest;
    }

    private SnmpPduRequest newValidResponsePdu(SnmpPduPacket snmpPduPacket, SnmpVarBind[] snmpVarBindArray) {
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = snmpPduPacket.address;
        snmpPduRequest.port = snmpPduPacket.port;
        snmpPduRequest.version = snmpPduPacket.version;
        snmpPduRequest.community = snmpPduPacket.community;
        snmpPduRequest.type = 162;
        snmpPduRequest.requestId = snmpPduPacket.requestId;
        snmpPduRequest.errorStatus = 0;
        snmpPduRequest.errorIndex = 0;
        snmpPduRequest.varBindList = snmpVarBindArray;
        ((SnmpAdaptorServer)this.adaptorServer).updateErrorCounters(snmpPduRequest.errorStatus);
        return snmpPduRequest;
    }

    private SnmpPduRequest newErrorResponsePdu(SnmpPduPacket snmpPduPacket, int n, int n2) {
        SnmpPduRequest snmpPduRequest = this.newValidResponsePdu(snmpPduPacket, null);
        snmpPduRequest.errorStatus = n;
        snmpPduRequest.errorIndex = n2;
        snmpPduRequest.varBindList = snmpPduPacket.varBindList;
        ((SnmpAdaptorServer)this.adaptorServer).updateErrorCounters(snmpPduRequest.errorStatus);
        return snmpPduRequest;
    }

    private SnmpMessage newTooBigMessage(SnmpMessage snmpMessage) throws SnmpTooBigException {
        SnmpMessage snmpMessage2 = null;
        SnmpPduPacket snmpPduPacket = null;
        try {
            snmpPduPacket = (SnmpPduPacket)this.pduFactory.decodeSnmpPdu((SnmpMsg)snmpMessage);
            if (snmpPduPacket != null) {
                SnmpPduPacket snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                snmpMessage2 = (SnmpMessage)this.pduFactory.encodeSnmpPdu((SnmpPdu)snmpPduPacket2, this.packet.getData().length);
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            throw new InternalError();
        }
        return snmpMessage2;
    }

    private SnmpPduPacket newTooBigPdu(SnmpPduPacket snmpPduPacket) {
        SnmpPduRequest snmpPduRequest = this.newErrorResponsePdu(snmpPduPacket, 1, 0);
        snmpPduRequest.varBindList = null;
        return snmpPduRequest;
    }

    private SnmpPduPacket reduceResponsePdu(SnmpPduPacket snmpPduPacket, SnmpPduPacket snmpPduPacket2, int n) throws SnmpTooBigException {
        if (snmpPduPacket.type != 165) {
            if (this.isDebugOn()) {
                this.debug("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(n);
        }
        int n2 = snmpPduPacket2.varBindList.length;
        n2 = n >= 3 ? Math.min(n - 1, snmpPduPacket2.varBindList.length) : (n == 1 ? 1 : snmpPduPacket2.varBindList.length / 2);
        if (n2 < 1) {
            if (this.isDebugOn()) {
                this.debug("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(n);
        }
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        int n3 = 0;
        while (n3 < n2) {
            snmpVarBindArray[n3] = snmpPduPacket2.varBindList[n3];
            ++n3;
        }
        if (this.isDebugOn()) {
            this.debug("reduceResponsePdu", snmpPduPacket2.varBindList.length - snmpVarBindArray.length + " items have been removed");
        }
        snmpPduPacket2.varBindList = snmpVarBindArray;
        return snmpPduPacket2;
    }

    private void splitRequest(SnmpPduRequest snmpPduRequest) {
        int n = this.mibs.size();
        SnmpMibAgent snmpMibAgent = (SnmpMibAgent)this.mibs.firstElement();
        if (n == 1) {
            this.subs.put(snmpMibAgent, new SnmpSubRequestHandler(snmpMibAgent, (SnmpPdu)snmpPduRequest, true));
            return;
        }
        if (snmpPduRequest.type == 161) {
            Enumeration enumeration = this.mibs.elements();
            while (enumeration.hasMoreElements()) {
                SnmpMibAgent snmpMibAgent2 = (SnmpMibAgent)enumeration.nextElement();
                this.subs.put(snmpMibAgent2, new SnmpSubNextRequestHandler(this.adaptor, snmpMibAgent2, (SnmpPdu)snmpPduRequest));
            }
            return;
        }
        int n2 = snmpPduRequest.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = snmpPduRequest.varBindList;
        int n3 = 0;
        while (n3 < n2) {
            snmpMibAgent = this.root.getAgentMib(snmpVarBindArray[n3].oid);
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)this.subs.get(snmpMibAgent);
            if (snmpSubRequestHandler == null) {
                snmpSubRequestHandler = new SnmpSubRequestHandler(snmpMibAgent, (SnmpPdu)snmpPduRequest);
                this.subs.put(snmpMibAgent, snmpSubRequestHandler);
            }
            snmpSubRequestHandler.updateRequest(snmpVarBindArray[n3], n3);
            ++n3;
        }
    }

    private void splitBulkRequest(SnmpPduBulk snmpPduBulk, int n, int n2, int n3) {
        Enumeration enumeration = this.mibs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpMibAgent snmpMibAgent = (SnmpMibAgent)enumeration.nextElement();
            if (this.isDebugOn()) {
                this.trace("splitBulkRequest", "Create a sub with : " + snmpMibAgent + " " + n + " " + n2 + " " + n3);
            }
            this.subs.put(snmpMibAgent, new SnmpSubBulkRequestHandler(this.adaptor, snmpMibAgent, (SnmpPdu)snmpPduBulk, n, n2, n3));
        }
    }

    private SnmpPduPacket mergeResponses(SnmpPduRequest snmpPduRequest) {
        if (snmpPduRequest.type == 161) {
            return this.mergeNextResponses(snmpPduRequest);
        }
        SnmpVarBind[] snmpVarBindArray = snmpPduRequest.varBindList;
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        return this.newValidResponsePdu((SnmpPduPacket)snmpPduRequest, snmpVarBindArray);
    }

    private SnmpPduPacket mergeNextResponses(SnmpPduRequest snmpPduRequest) {
        int n = snmpPduRequest.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        if (snmpPduRequest.version == 1) {
            return this.newValidResponsePdu((SnmpPduPacket)snmpPduRequest, snmpVarBindArray);
        }
        int n2 = 0;
        while (n2 < n) {
            SnmpValue snmpValue = snmpVarBindArray[n2].value;
            if (snmpValue == SnmpVarBind.endOfMibView) {
                return this.newErrorResponsePdu((SnmpPduPacket)snmpPduRequest, 2, n2 + 1);
            }
            ++n2;
        }
        return this.newValidResponsePdu((SnmpPduPacket)snmpPduRequest, snmpVarBindArray);
    }

    private SnmpVarBind[] mergeBulkResponses(int n) {
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            snmpVarBindArray[n2] = new SnmpVarBind();
            snmpVarBindArray[n2].value = SnmpVarBind.endOfMibView;
            --n2;
        }
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        return snmpVarBindArray;
    }

    protected boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1024);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1024, (String)string, (String)string2, (String)string3);
    }

    protected void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    protected boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1024);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (String)string3);
    }

    protected void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)1024, (String)string, (String)string2, (Throwable)throwable);
    }

    protected void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    protected void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    protected String makeDebugTag() {
        return "SnmpRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "]";
    }

    Thread createThread(Runnable runnable) {
        return null;
    }
}

