/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpOid;

final class SnmpMibTree {
    private SnmpMibAgent defaultAgent = null;
    private TreeNode root = new TreeNode(-1L, null, null);

    public void setDefaultAgent(SnmpMibAgent snmpMibAgent) {
        this.defaultAgent = snmpMibAgent;
        this.root.agent = snmpMibAgent;
    }

    public SnmpMibAgent getDefaultAgent() {
        return this.defaultAgent;
    }

    public void register(SnmpMibAgent snmpMibAgent) {
        this.root.registerNode(snmpMibAgent);
    }

    public void register(SnmpMibAgent snmpMibAgent, long[] lArray) {
        this.root.registerNode(lArray, 0, snmpMibAgent);
    }

    public SnmpMibAgent getAgentMib(SnmpOid snmpOid) {
        TreeNode treeNode = this.root.retrieveMatchingBranch(snmpOid.longValue(), 0);
        if (treeNode == null) {
            return this.defaultAgent;
        }
        if (treeNode.getAgentMib() == null) {
            return this.defaultAgent;
        }
        return treeNode.getAgentMib();
    }

    public void unregister(SnmpMibAgent snmpMibAgent, SnmpOid[] snmpOidArray) {
        int n = 0;
        while (n < snmpOidArray.length) {
            long[] lArray = snmpOidArray[n].longValue();
            TreeNode treeNode = this.root.retrieveMatchingBranch(lArray, 0);
            if (treeNode != null) {
                treeNode.removeAgent(snmpMibAgent);
            }
            ++n;
        }
    }

    public void unregister(SnmpMibAgent snmpMibAgent) {
        long[] lArray = snmpMibAgent.getRootOid();
        TreeNode treeNode = this.root.retrieveMatchingBranch(lArray, 0);
        if (treeNode == null) {
            return;
        }
        treeNode.removeAgent(snmpMibAgent);
    }

    public void printTree() {
        this.root.printTree(">");
    }

    final class TreeNode {
        private Vector children = new Vector();
        private Vector agents = new Vector();
        private long nodeValue;
        protected SnmpMibAgent agent;
        private TreeNode parent;

        void registerNode(SnmpMibAgent snmpMibAgent) {
            long[] lArray = snmpMibAgent.getRootOid();
            this.registerNode(lArray, 0, snmpMibAgent);
        }

        TreeNode retrieveMatchingBranch(long[] lArray, int n) {
            TreeNode treeNode = this.retrieveChild(lArray, n);
            if (treeNode == null) {
                return this;
            }
            if (this.children.size() == 0) {
                return treeNode;
            }
            if (n + 1 == lArray.length) {
                return treeNode;
            }
            TreeNode treeNode2 = treeNode.retrieveMatchingBranch(lArray, n + 1);
            return treeNode2.agent == null ? this : treeNode2;
        }

        SnmpMibAgent getAgentMib() {
            return this.agent;
        }

        public void printTree(String string) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.agents == null) {
                return;
            }
            Enumeration enumeration = this.agents.elements();
            while (enumeration.hasMoreElements()) {
                object = (SnmpMibAgent)enumeration.nextElement();
                if (object == null) {
                    stringBuffer.append("empty ");
                    continue;
                }
                stringBuffer.append(((SnmpMibAgent)object).getMibName() + " ");
            }
            string = string + " ";
            if (this.children == null) {
                return;
            }
            object = this.children.elements();
            while (object.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)object.nextElement();
                treeNode.printTree(string);
            }
        }

        private TreeNode(long l, SnmpMibAgent snmpMibAgent, TreeNode treeNode) {
            this.nodeValue = l;
            this.agent = snmpMibAgent;
            this.parent = treeNode;
            this.agents.addElement(snmpMibAgent);
        }

        private void removeAgent(SnmpMibAgent snmpMibAgent) {
            if (!this.agents.contains(snmpMibAgent)) {
                return;
            }
            this.agents.removeElement(snmpMibAgent);
            if (this.agents.isEmpty()) {
                if (this.parent == null) {
                    return;
                }
                this.parent.children.removeElement(this);
                this.parent.removeAgent(snmpMibAgent);
                return;
            }
            this.agent = (SnmpMibAgent)this.agents.firstElement();
            if (this.parent != null) {
                this.parent.removeAgent(snmpMibAgent);
            }
        }

        private void setAgent(SnmpMibAgent snmpMibAgent) {
            this.agent = snmpMibAgent;
        }

        private void registerNode(long[] lArray, int n, SnmpMibAgent snmpMibAgent) {
            if (n >= lArray.length) {
                return;
            }
            TreeNode treeNode = this.retrieveChild(lArray, n);
            if (treeNode == null) {
                long l = lArray[n];
                treeNode = new TreeNode(l, null, this);
                this.children.addElement(treeNode);
            } else if (!this.agents.contains(snmpMibAgent)) {
                this.agents.addElement(snmpMibAgent);
            }
            if (n == lArray.length - 1) {
                treeNode.setAgent(snmpMibAgent);
            } else {
                treeNode.registerNode(lArray, n + 1, snmpMibAgent);
            }
        }

        private TreeNode retrieveChild(long[] lArray, int n) {
            long l = lArray[n];
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                if (!treeNode.match(l)) continue;
                return treeNode;
            }
            return null;
        }

        private final boolean match(long l) {
            return this.nodeValue == l;
        }
    }
}

