/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorAddressV2;
import com.sun.jdmk.comm.RmiConnectorClient;
import com.sun.jdmk.trace.Trace;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

class RmiNotificationReceiverImplV2
extends UnicastRemoteObject
implements NotificationBackConnector {
    private int infoType = 256;
    private String localClassName = "com.sun.jdmk.comm.RmiConnectorClient";
    private transient RmiConnectorClient myClient = null;
    private RmiConnectorAddressV2 localAddress = null;
    private String serviceName = null;
    private ClientNotificationDispatcher dispatcher = null;
    private String localHost = "localhost";
    private ThreadGroup group;
    private boolean offline = false;

    public RmiNotificationReceiverImplV2(RmiConnectorClient rmiConnectorClient, RmiConnectorAddress rmiConnectorAddress, ClientNotificationDispatcher clientNotificationDispatcher) throws RemoteException, CommunicationException {
        this.myClient = rmiConnectorClient;
        this.dispatcher = clientNotificationDispatcher;
        this.localAddress = new RmiConnectorAddressV2();
        this.localAddress.setRemoteObj(this);
    }

    public void stopListening() {
        this.offline = true;
    }

    public void startListening() {
        this.offline = false;
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (this.offline) {
            return null;
        }
        if (this.isDebugOn()) {
            this.debug("RmiNotificationReceiverImpl::handleEvent", "Start event dispatching");
        }
        return this.dispatcher.remoteRequest(n, objectArray);
    }

    public RmiConnectorAddress getAddress() {
        return this.localAddress;
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)this.infoType);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)this.infoType, (String)string, (String)string2, (String)string3);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)this.infoType);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)this.infoType, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }
}

