/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorClient;
import com.sun.jdmk.comm.RmiNotificationReceiver;
import com.sun.jdmk.trace.Trace;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;

class RmiNotificationReceiverImpl
extends UnicastRemoteObject
implements RmiNotificationReceiver {
    private int infoType = 256;
    private String localClassName = "com.sun.jdmk.comm.RmiConnectorClient";
    private transient RmiConnectorClient myClient = null;
    private RmiConnectorAddress rmiAddress = null;
    private RmiConnectorAddress localAddress = null;
    private String serviceName = null;
    private ClientNotificationDispatcher dispatcher = null;
    private String localHost = "localhost";
    private ThreadGroup group;
    private boolean offline = false;

    public RmiNotificationReceiverImpl(RmiConnectorClient rmiConnectorClient, RmiConnectorAddress rmiConnectorAddress, ClientNotificationDispatcher clientNotificationDispatcher) throws RemoteException, CommunicationException {
        this.myClient = rmiConnectorClient;
        this.rmiAddress = rmiConnectorAddress;
        this.dispatcher = clientNotificationDispatcher;
        this.group = new ThreadGroup("rmi dispatcher");
        Object var4_4 = null;
        this.localHost = this.myClient.getHost();
    }

    public void stopListening() {
        block2: {
            this.offline = true;
            try {
                Naming.unbind(this.serviceName);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block2;
                this.debug("RmiNotificationReceiverImpl::stopListening", "Fails to unregister " + this.serviceName);
            }
        }
    }

    public void startListening() {
        try {
            String string = new Long(new Date().getTime()).toString();
            String string2 = "RmiNotificationReceiver." + string;
            this.serviceName = "rmi://" + this.localHost + ":" + this.rmiAddress.getPort() + "/" + string2;
            this.localAddress = new RmiConnectorAddress(this.localHost, this.rmiAddress.getPort(), string2);
            Naming.bind(this.serviceName, this);
            if (this.isDebugOn()) {
                this.debug("RmiNotificationReceiverImpl::new", " register " + this.serviceName);
            }
        }
        catch (AlreadyBoundException alreadyBoundException) {
            if (this.isDebugOn()) {
                this.debug("RmiNotificationReceiverImpl::new", "Attempt was made to bind an object in the registry to a name that already had an associated binding.");
            }
            throw new CommunicationException(alreadyBoundException, "Fails to register " + this.serviceName);
        }
        catch (MalformedURLException malformedURLException) {
            if (this.isDebugOn()) {
                this.debug("RmiNotificationReceiverImpl::new:", this.serviceName + " is not an appropriately formatted URL.");
            }
            throw new CommunicationException(malformedURLException, "Fails to register " + this.serviceName);
        }
        catch (AccessException accessException) {
            if (this.isDebugOn()) {
                this.debug("RmiNotificationReceiverImpl::new", "Permission to perform a binding in the registry has been denied.");
            }
            throw new CommunicationException(accessException, "Fails to register " + this.serviceName);
        }
        catch (RemoteException remoteException) {
            if (this.isDebugOn()) {
                this.debug("RmiNotificationReceiverImpl::new", "Try to start a local registry on port " + this.rmiAddress.getPort());
            }
            try {
                Registry registry = LocateRegistry.createRegistry(this.rmiAddress.getPort());
                Naming.bind(this.serviceName, this);
                if (this.isDebugOn()) {
                    this.debug("RmiNotificationReceiverImpl::new", " register " + this.serviceName);
                }
            }
            catch (Exception exception) {
                throw new CommunicationException(exception, "Fails to register " + this.serviceName);
            }
        }
        this.offline = false;
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (this.offline) {
            return null;
        }
        if (this.isDebugOn()) {
            this.debug("RmiNotificationReceiverImpl::handleEvent", "Start event dispatching");
        }
        return this.dispatcher.remoteRequest(n, objectArray);
    }

    public RmiConnectorAddress getAddress() {
        return this.localAddress;
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)this.infoType);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)this.infoType, (String)string, (String)string2, (String)string3);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)this.infoType);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)this.infoType, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }
}

