/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorServer;
import com.sun.jdmk.comm.RmiNotificationReceiver;
import com.sun.jdmk.trace.Trace;
import java.rmi.Naming;
import java.rmi.RemoteException;

class RmiNotificationForwarder
implements NotificationBackConnector {
    private int infoType = 256;
    private String localClassName = "com.sun.jdmk.comm.RmiNotificationForwarder";
    private boolean connected = false;
    private RmiConnectorAddress receiverAddress = null;
    private RmiConnectorServer rmiConnectorServer = null;
    private RmiNotificationReceiver rmiNotificationReceiver = null;

    public RmiNotificationForwarder(RmiConnectorAddress rmiConnectorAddress, RmiConnectorServer rmiConnectorServer) throws RemoteException, IllegalAccessException {
        this.receiverAddress = rmiConnectorAddress;
        this.rmiConnectorServer = rmiConnectorServer;
        String string = new String("rmi://" + rmiConnectorAddress.getHost() + ":" + rmiConnectorAddress.getPort() + "/" + rmiConnectorAddress.getName());
        if (this.isDebugOn()) {
            this.debug("Constructor", "looking for " + string);
        }
        try {
            this.rmiNotificationReceiver = (RmiNotificationReceiver)Naming.lookup(string);
            this.connected = true;
            if (this.rmiNotificationReceiver == null) {
                if (this.isDebugOn()) {
                    this.debug("handleEvent", "receiver is null");
                }
                throw new RemoteException("Can't contact RMI Notification receive server at " + string);
            }
        }
        catch (Exception exception) {
            throw new RemoteException("Can't contact RMI Notification receive server at " + string);
        }
    }

    public void disconnect() {
        this.connected = false;
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (this.connected) {
            return this.rmiNotificationReceiver.remoteRequest(n, objectArray);
        }
        throw new CommunicationException("NotificationForwarder not connected");
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)this.infoType);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)this.infoType, (String)string, (String)string2, (String)string3);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)this.infoType);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)this.infoType, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }
}

