/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HeartBeatServerHandler;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorServerMBean;
import com.sun.jdmk.comm.RmiConnectorServerObjectImpl;
import com.sun.jdmk.comm.RmiConnectorServerObjectImplV2;
import com.sun.jdmk.comm.RmiNotificationForwarder;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import com.sun.jdmk.comm.ServerNotificationHandlerInternal;
import java.rmi.RemoteException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class RmiConnectorServer
extends CommunicatorServer
implements MBeanRegistration,
RmiConnectorServerMBean {
    private static int defaultPort = 1099;
    private static final String defaultServiceName = "name=RmiConnectorServer";
    private String serviceName = null;
    private transient RmiConnectorServerObjectImpl rmiConnectorV1;
    private transient RmiConnectorServerObjectImplV2 rmiConnectorV2;
    private ServerNotificationDispatcher serverNotificationDispatcher = null;
    private RmiNotificationForwarder rmiNotificationForwarder = null;
    private HeartBeatServerHandler heartbeatServerHandler = null;

    public RmiConnectorServer() {
        this(defaultPort, defaultServiceName);
    }

    public RmiConnectorServer(int n) {
        this(n, defaultServiceName);
    }

    public RmiConnectorServer(String string) {
        this(defaultPort, string);
    }

    public RmiConnectorServer(int n, String string) {
        super(1);
        this.port = n;
        this.serviceName = string;
    }

    static String serviceNameForVersion(String string, int n) {
        switch (n) {
            case 1: {
                return string;
            }
            case 2: {
                return string + "V2";
            }
        }
        throw new IllegalArgumentException("serviceNameForVersion" + n);
    }

    NotificationBackConnector startPush(ConnectorAddress connectorAddress) {
        if (!(connectorAddress instanceof RmiConnectorAddress)) {
            throw new IllegalArgumentException("Expected RmiConnectorAddress class, got " + connectorAddress.getClass().getName());
        }
        try {
            RmiNotificationForwarder rmiNotificationForwarder = new RmiNotificationForwarder((RmiConnectorAddress)connectorAddress, this);
            return rmiNotificationForwarder;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommunicationException(illegalAccessException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    void stopPush(NotificationBackConnector notificationBackConnector) {
        if (notificationBackConnector instanceof RmiNotificationForwarder) {
            ((RmiNotificationForwarder)notificationBackConnector).disconnect();
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        Object var3_3 = null;
        if (objectName == null) {
            objectName = new ObjectName(mBeanServer.getDefaultDomain() + ":" + defaultServiceName);
        }
        super.preRegister(mBeanServer, objectName);
        return objectName;
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
        NotificationHandlerInternal notificationHandlerInternal = new NotificationHandlerInternal(this);
        this.serverNotificationDispatcher = new ServerNotificationDispatcher(notificationHandlerInternal, this.topMBS);
        this.heartbeatServerHandler = new HeartBeatServerHandler(this.topMBS, this.serverNotificationDispatcher);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public void postDeregister() {
        super.postDeregister();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.serviceName = string;
        this.dbgTag = this.makeDebugTag();
    }

    public String getProtocol() {
        return "rmi";
    }

    public void stop() {
        if (this.state == 0 || this.state == 3) {
            super.stop();
            this.heartbeatServerHandler.cleanupClientResources();
        }
    }

    public synchronized void setMBeanServer(MBeanServer mBeanServer) throws IllegalArgumentException, IllegalStateException {
        super.setMBeanServer(mBeanServer);
        this.serverNotificationDispatcher.setMBeanServer(mBeanServer);
    }

    protected void doError(Exception exception) throws CommunicationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doBind() throws CommunicationException, InterruptedException {
        try {
            if (this.rmiConnectorV1 == null) {
                if (this.isTraceOn()) {
                    this.trace("doBind", "Create the RMI object server");
                }
                if (this.isDebugOn()) {
                    this.debug("doBind", "serviceName=" + this.serviceName + " ; port=" + this.port);
                }
                String string = RmiConnectorServer.serviceNameForVersion(this.serviceName, 1);
                String string2 = RmiConnectorServer.serviceNameForVersion(this.serviceName, 2);
                this.rmiConnectorV2 = new RmiConnectorServerObjectImplV2(this, string2, this.port, this.serverNotificationDispatcher, this.heartbeatServerHandler);
                this.rmiConnectorV1 = new RmiConnectorServerObjectImpl(this.rmiConnectorV2, string, this.port, this.serverNotificationDispatcher, this.heartbeatServerHandler);
            }
            try {
                this.rmiConnectorV2.bind();
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.rmiConnectorV1.bind();
                throw throwable;
            }
            this.rmiConnectorV1.bind();
            if (this.isTraceOn()) {
                this.trace("doBind", "Bind RMI object server");
            }
        }
        catch (RemoteException remoteException) {
            if (this.isDebugOn()) {
                this.debug("doBind", "Got Exception: " + remoteException.getMessage());
            }
            throw new CommunicationException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doReceive() throws CommunicationException, InterruptedException {
        while (true) {
            try {
                while (true) {
                    Object object;
                    Object object2 = object = new Object();
                    synchronized (object2) {
                        object.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (this.isTraceOn()) {
            this.trace("doUnbind", "Unbind RMI object server");
        }
        try {
            this.rmiConnectorV1.unbind();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.rmiConnectorV2.unbind();
            throw throwable;
        }
        this.rmiConnectorV2.unbind();
    }

    protected String makeDebugTag() {
        return "RmiConnectorServer[" + this.getProtocol() + ":" + this.getPort() + ":" + this.getServiceName() + "]";
    }

    private class NotificationHandlerInternal
    implements ServerNotificationHandlerInternal {
        private RmiConnectorServer connector;

        public NotificationHandlerInternal(RmiConnectorServer rmiConnectorServer2) {
            this.connector = rmiConnectorServer2;
        }

        public NotificationBackConnector startPush(ConnectorAddress connectorAddress) {
            return this.connector.startPush(connectorAddress);
        }

        public void stopPush(NotificationBackConnector notificationBackConnector) {
            this.connector.stopPush(notificationBackConnector);
        }
    }
}

