/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.OperationContext;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.DefaultMapper;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatClientHandlerImpl;
import com.sun.jdmk.comm.HeartBeatInternalClientHandler;
import com.sun.jdmk.comm.Mapper;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RemoteRuntimeException;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorServer;
import com.sun.jdmk.comm.RmiConnectorServerObject;
import com.sun.jdmk.comm.RmiConnectorServerObjectV2;
import com.sun.jdmk.comm.RmiNotificationReceiverImpl;
import com.sun.jdmk.comm.RmiNotificationReceiverImplV2;
import com.sun.jdmk.comm.TimedRmiSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerRuntimeException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class RmiConnectorClient
implements RemoteMBeanServer,
HeartBeatClientHandler {
    private int infoType = 256;
    private String localClassName;
    private String dbgTag = this.localClassName = "com.sun.jdmk.comm.RmiConnectorClient";
    private OperationContext operationContext = null;
    private transient boolean isConnected = false;
    private transient RmiConnectorAddress connectorAddress = null;
    private transient RmiConnectorServerObject connectorServerV1 = null;
    private transient RmiConnectorServerObjectV2 connectorServerV2 = null;
    private transient String MBeanServerId = null;
    private transient ClassLoader classLoader = null;
    private transient Mapper mapper = null;
    private transient Mapper defaultMapper = null;
    private ClientNotificationDispatcher notificationClientHandler = null;
    private RmiNotificationReceiverImpl rmiNotificationReceiver = null;
    private RmiNotificationReceiverImplV2 rmiNotificationReceiverV2 = null;
    private HeartBeatClientHandlerImpl heartbeatClientHandler = null;
    private transient Hashtable proxyHandles = new Hashtable();
    private transient Hashtable genericHandles = new Hashtable();
    private String localHost = null;
    private RMIClientSocketFactory csf = null;
    static /* synthetic */ Class class$com$sun$jdmk$comm$RmiConnectorAddress;

    public RmiConnectorClient(RMIClientSocketFactory rMIClientSocketFactory) {
        this.csf = rMIClientSocketFactory;
        if (System.getProperty("jdmk.hostname") != null) {
            this.localHost = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.localHost = "localhost";
            }
        }
        if (this.isDebugOn()) {
            this.debug("RmiConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public RmiConnectorClient() {
        if (System.getProperty("jdmk.hostname") != null) {
            this.localHost = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.localHost = "localhost";
            }
        }
        if (this.isDebugOn()) {
            this.debug("RmiConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public RmiConnectorClient(InetAddress inetAddress) {
        try {
            this.localHost = inetAddress == null ? (System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress()) : inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            this.localHost = "localhost";
        }
        if (this.isDebugOn()) {
            this.debug("RmiConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public RmiConnectorClient(InetAddress inetAddress, int n) {
        try {
            this.localHost = inetAddress == null ? (System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress()) : inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            this.localHost = "localhost";
        }
        try {
            RMISocketFactory.setSocketFactory(new TimedRmiSocketFactory(n));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.Initialize();
    }

    public void setTimeout(int n) {
        try {
            RMISocketFactory.setSocketFactory(new TimedRmiSocketFactory(n));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public RmiConnectorClient(String string) {
        if (string != null) {
            this.localHost = string;
        } else {
            try {
                this.localHost = System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.localHost = "localhost";
            }
        }
        if (this.isDebugOn()) {
            this.debug("RmiConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    private void Initialize() {
        this.mapper = this.defaultMapper = new DefaultMapper();
        this.notificationClientHandler = new ClientNotificationDispatcher(new NotificationHandlerInternal(this));
        this.heartbeatClientHandler = new HeartBeatClientHandlerImpl(new HeartBeatInternalClientHandlerImpl(this), this.notificationClientHandler);
    }

    Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        this.stopIfNotConnected("createMBean(className,name)");
        if (this.isTraceOn()) {
            this.debug("remoteRequest(opType,params)", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.remoteRequest(n, objectArray, this.operationContext);
            }
            return this.connectorServerV1.remoteRequest(n, objectArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            serverRuntimeException.detail.fillInStackTrace();
            if (serverRuntimeException.detail instanceof RuntimeOperationsException) {
                throw (RuntimeOperationsException)serverRuntimeException.detail;
            }
            if (serverRuntimeException.detail instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)serverRuntimeException.detail;
            }
            if (serverRuntimeException.detail instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)serverRuntimeException.detail;
            }
            throw serverRuntimeException;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    ConnectorAddress startPush() {
        this.stopIfNotConnected("startPush()");
        if (this.rmiNotificationReceiver == null && this.rmiNotificationReceiverV2 == null) {
            try {
                if (this.isDebugOn()) {
                    this.debug("startPush", "Create new RmiNotificationReceiverImpl");
                }
                try {
                    Object[] objectArray = this.remoteRequest(13, null);
                    this.rmiNotificationReceiverV2 = new RmiNotificationReceiverImplV2(this, this.connectorAddress, this.notificationClientHandler);
                    this.rmiNotificationReceiverV2.startListening();
                }
                catch (JMRuntimeException jMRuntimeException) {
                    this.rmiNotificationReceiverV2 = null;
                    this.rmiNotificationReceiver = new RmiNotificationReceiverImpl(this, this.connectorAddress, this.notificationClientHandler);
                    this.rmiNotificationReceiver.startListening();
                }
            }
            catch (ServerRuntimeException serverRuntimeException) {
                throw (JMRuntimeException)serverRuntimeException.detail;
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(remoteException);
            }
            catch (Exception exception) {
                throw new CommunicationException(exception);
            }
        }
        if (this.rmiNotificationReceiverV2 != null) {
            return this.rmiNotificationReceiverV2.getAddress();
        }
        return this.rmiNotificationReceiver.getAddress();
    }

    void stopPush() {
        this.stopIfNotConnected("stopPush()");
        if (this.rmiNotificationReceiver != null) {
            this.rmiNotificationReceiver.stopListening();
            this.rmiNotificationReceiver = null;
        } else if (this.rmiNotificationReceiverV2 != null) {
            this.rmiNotificationReceiverV2.stopListening();
            this.rmiNotificationReceiverV2 = null;
        }
    }

    public void setMode(int n) throws IllegalArgumentException {
        this.stopIfNotConnected("setMode()");
        this.notificationClientHandler.setMode(n);
    }

    public int getMode() {
        this.stopIfNotConnected("getMode()");
        return this.notificationClientHandler.getMode();
    }

    public void getNotifications() {
        this.stopIfNotConnected("getNotifications()");
        this.notificationClientHandler.getNotifications();
    }

    public void clearCache() {
        this.stopIfNotConnected("clearCache()");
        this.notificationClientHandler.clearCache();
    }

    public void setPeriod(int n) {
        this.stopIfNotConnected("setPeriod()");
        this.notificationClientHandler.setPeriod(n);
    }

    public int getPeriod() {
        this.stopIfNotConnected("getPeriod()");
        return this.notificationClientHandler.getPeriod();
    }

    public int setCacheSize(int n, boolean bl) {
        this.stopIfNotConnected("setCacheSize()");
        return this.notificationClientHandler.setCacheSize(n, bl);
    }

    public int getCacheSize() {
        this.stopIfNotConnected("getCacheSize()");
        return this.notificationClientHandler.getCacheSize();
    }

    public void setOverflowCount(int n) {
        this.stopIfNotConnected("setOverflowCount()");
        this.notificationClientHandler.setOverflowCount(n);
    }

    public int getOverflowCount() {
        this.stopIfNotConnected("getOverflowCount()");
        return this.notificationClientHandler.getOverflowCount();
    }

    public void setOverflowMode(int n) throws IllegalArgumentException {
        this.stopIfNotConnected("setOverflowMode()");
        this.notificationClientHandler.setOverflowMode(n);
    }

    public int getOverflowMode() {
        this.stopIfNotConnected("getOverflowMode()");
        return this.notificationClientHandler.getOverflowMode();
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.stopIfNotConnected("addNotificationListener()");
        this.notificationClientHandler.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.stopIfNotConnected("removeNotificationListener()");
        this.notificationClientHandler.removeNotificationListener(objectName, notificationListener);
    }

    String pingHeartBeatServer(String string, int n, int n2, Long l) {
        if (this.isTraceOn()) {
            this.debug("pingHeartBeatServer", "pingHeartBeatServer");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.pingHeartBeatServer(string, n, n2, l, this.operationContext);
            }
            return this.connectorServerV1.pingHeartBeatServer(string, n, n2, l);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public int getHeartBeatPeriod() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatPeriod", "getHeartBeatPeriod");
        }
        return this.heartbeatClientHandler.getHeartBeatPeriod();
    }

    public void setHeartBeatPeriod(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatPeriod", "setHeartBeatPeriod");
        }
        this.heartbeatClientHandler.setHeartBeatPeriod(n);
    }

    public int getHeartBeatRetries() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatRetries", "getHeartBeatRetries");
        }
        return this.heartbeatClientHandler.getHeartBeatRetries();
    }

    public void setHeartBeatRetries(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatRetries", "setHeartBeatRetries");
        }
        this.heartbeatClientHandler.setHeartBeatRetries(n);
    }

    public void addHeartBeatNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (this.isTraceOn()) {
            this.trace("addHeartBeatNotificationListener", "addHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.addHeartBeatNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeHeartBeatNotificationListener(NotificationListener notificationListener) {
        if (this.isTraceOn()) {
            this.trace("removeHeartBeatNotificationListener", "removeHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.removeHeartBeatNotificationListener(notificationListener);
    }

    public void setOperationContext(OperationContext operationContext) {
        try {
            if (operationContext != null) {
                operationContext = (OperationContext)operationContext.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CommunicationException(cloneNotSupportedException);
        }
        this.operationContext = operationContext;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public String connect(ConnectorAddress connectorAddress) {
        String string;
        Object object;
        Registry registry;
        if (!(connectorAddress instanceof RmiConnectorAddress)) {
            String string2 = "Invalid ConnectorAddress class: Expected '" + (class$com$sun$jdmk$comm$RmiConnectorAddress == null ? (class$com$sun$jdmk$comm$RmiConnectorAddress = RmiConnectorClient.class$("com.sun.jdmk.comm.RmiConnectorAddress")) : class$com$sun$jdmk$comm$RmiConnectorAddress) + "', got'" + connectorAddress.getClass().getName() + "'";
            if (this.isTraceOn()) {
                this.trace("connect", string2);
            }
            throw new IllegalArgumentException(string2);
        }
        if (this.isConnected) {
            if (this.isTraceOn()) {
                this.trace("connect", "ConnectorClient already connected to RemoteMBeanServer");
            }
            throw new CommunicationException("ConnectorClient already connected to RemoteMBeanServer");
        }
        this.connectorAddress = (RmiConnectorAddress)connectorAddress;
        String string3 = this.connectorAddress.getHost();
        int n = this.connectorAddress.getPort();
        String string4 = this.connectorAddress.getName();
        Object var6_6 = null;
        try {
            registry = LocateRegistry.getRegistry(string3, n, this.csf);
        }
        catch (Exception exception) {
            String string5 = "Can't contact RMI registry at " + string3 + ":" + n;
            if (this.isTraceOn()) {
                this.trace("connect", string5);
            }
            throw new CommunicationException(exception, string5);
        }
        try {
            try {
                object = RmiConnectorServer.serviceNameForVersion(string4, 2);
                this.connectorServerV2 = (RmiConnectorServerObjectV2)registry.lookup((String)object);
            }
            catch (NotBoundException notBoundException) {
                string = RmiConnectorServer.serviceNameForVersion(string4, 1);
                this.connectorServerV1 = (RmiConnectorServerObject)registry.lookup(string);
            }
        }
        catch (Exception exception) {
            String string6 = "Can't contact RMI Connector Server with name " + string4;
            if (this.isTraceOn()) {
                this.trace("connect", string6);
            }
            throw new CommunicationException(exception, string6);
        }
        string = null;
        try {
            object = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            string = this.connectorServerV2 != null ? (String)this.connectorServerV2.getAttribute((ObjectName)object, "MBeanServerId", this.operationContext) : (String)this.connectorServerV1.getAttribute((ObjectName)object, "MBeanServerId");
        }
        catch (CommunicationException communicationException) {
            if (this.isTraceOn()) {
                this.trace("connect", "Can't contact RMI Connector Server to get MBeanServerId");
            }
            throw communicationException;
        }
        catch (Exception exception) {
            if (this.isTraceOn()) {
                this.trace("connect", "Can't contact RMI Connector Server to get MBeanServerId");
            }
            throw new CommunicationException(exception, "Can't contact RMI Connector Server to get MBeanServerId");
        }
        if (this.MBeanServerId != null && !this.MBeanServerId.equals(string)) {
            if (this.isTraceOn()) {
                this.trace("connect", "Invalid MBeanServerId");
            }
            throw new IllegalArgumentException("Invalid MBeanServerId");
        }
        this.MBeanServerId = string;
        this.isConnected = true;
        this.dbgTag = this.makeDebugTag();
        this.heartbeatClientHandler.notifyConnectionEstablished();
        this.heartbeatClientHandler.startPinging();
        if (this.isTraceOn()) {
            this.trace("connect", "Connection Ok");
        }
        return this.MBeanServerId;
    }

    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean bl) {
        if (this.isConnected) {
            this.stopPush();
            this.notificationClientHandler.stopListening(bl);
            this.heartbeatClientHandler.stopPinging(-1, bl);
            this.heartbeatClientHandler.notifyConnectionTerminated();
            this.connectorServerV1 = null;
            this.connectorServerV2 = null;
            this.connectorAddress = null;
            this.dbgTag = this.localClassName;
            if (this.isTraceOn()) {
                this.trace("connect", "Disconnection Ok");
            }
            this.isConnected = false;
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public ConnectorAddress getMBeanServerAddress() {
        return this.connectorAddress;
    }

    public String getMBeanServerId() {
        return this.MBeanServerId;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectInstance objectInstance;
        this.stopIfNotConnected("createMBean(className,name)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        try {
            objectInstance = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(string, objectName, this.operationContext) : this.connectorServerV1.createMBean(string, objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance objectInstance;
        this.stopIfNotConnected("createMBean(className,name,loaderName)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name,loaderName)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        try {
            objectInstance = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(string, objectName, objectName2, this.operationContext) : this.connectorServerV1.createMBean(string, objectName, objectName2);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectInstance objectInstance;
        this.stopIfNotConnected("createMBean(className,name,params,signature)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name,params,signature)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        try {
            objectInstance = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(string, objectName, objectArray, stringArray, this.operationContext) : this.connectorServerV1.createMBean(string, objectName, objectArray, stringArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance objectInstance;
        this.stopIfNotConnected("createMBean(className,name,loaderName,params,signature)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name,loaderName,params,signature)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        try {
            objectInstance = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(string, objectName, objectName2, objectArray, stringArray, this.operationContext) : this.connectorServerV1.createMBean(string, objectName, objectName2, objectArray, stringArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        return objectInstance;
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.stopIfNotConnected("unregisterMBean(name)");
        if (this.isTraceOn()) {
            this.trace("unregisterMBean", "Remove ProxyMBean and GenericProxy, if required, for name " + objectName);
        }
        if (this.isTraceOn()) {
            this.trace("unregisterMBean(name)", "Remove MBean with name " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                this.connectorServerV2.unregisterMBean(objectName, this.operationContext);
            } else {
                this.connectorServerV1.unregisterMBean(objectName);
            }
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        this.proxyHandles.remove(objectName);
        this.genericHandles.remove(objectName);
    }

    public boolean isRegistered(ObjectName objectName) {
        this.stopIfNotConnected("isRegistered(name)");
        if (this.isTraceOn()) {
            this.trace("isRegistered(name)", "Call remote MBean server");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.isRegistered(objectName, this.operationContext);
            }
            return this.connectorServerV1.isRegistered(objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        this.stopIfNotConnected("queryNames(name,query)");
        if (this.isTraceOn()) {
            this.trace("queryNames(name,query)", "Call remote MBean server");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.queryNames(objectName, queryExp, this.operationContext);
            }
            return this.connectorServerV1.queryNames(objectName, queryExp);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        this.stopIfNotConnected("queryMBeans(name,query)");
        if (this.isTraceOn()) {
            this.trace("queryMBeans(name,query)", "MBean name = " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.queryMBeans(objectName, queryExp, this.operationContext);
            }
            return this.connectorServerV1.queryMBeans(objectName, queryExp);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public Integer getMBeanCount() {
        this.stopIfNotConnected("getMBeanCount()");
        if (this.isTraceOn()) {
            this.trace("getMBeanCount()", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getMBeanCount(this.operationContext);
            }
            return this.connectorServerV1.getMBeanCount();
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public String getDefaultDomain() {
        this.stopIfNotConnected("getDefaultDomain()");
        if (this.isTraceOn()) {
            this.trace("getDefaultDomain()", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getDefaultDomain(this.operationContext);
            }
            return this.connectorServerV1.getDefaultDomain();
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        this.stopIfNotConnected("isInstanceOf(name)");
        if (this.isTraceOn()) {
            this.trace("isInstanceOf(name)", "MBean object name = " + objectName + " class name = " + string);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.isInstanceOf(objectName, string, this.operationContext);
            }
            throw new IllegalArgumentException("isInstanceOf unsupported with this server");
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        this.stopIfNotConnected("getObjectInstance(name)");
        if (this.isTraceOn()) {
            this.trace("getObjectInstance(name)", "MBean object name = " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getObjectInstance(objectName, this.operationContext);
            }
            return this.connectorServerV1.getObjectInstance(objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.stopIfNotConnected("getAttribute(name,attribute)");
        if (this.isTraceOn()) {
            this.trace("getAttribute(name,attribute)", "MBean object name = " + objectName + " ; attribute name = " + string);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getAttribute(objectName, string, this.operationContext);
            }
            return this.connectorServerV1.getAttribute(objectName, string);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        this.stopIfNotConnected("getAttributes(name,attributes)");
        if (this.isTraceOn()) {
            this.trace("getAttribute(name,attributes)", "MBean object name = " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getAttributes(objectName, stringArray, this.operationContext);
            }
            return this.connectorServerV1.getAttributes(objectName, stringArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.stopIfNotConnected("setAttribute(name,attribute)");
        if (this.isTraceOn() && attribute != null) {
            this.trace("setAttribute(name,attribute)", "MBean object name = " + objectName + " ; attribute name = " + attribute.getName());
        }
        try {
            if (this.connectorServerV2 != null) {
                this.connectorServerV2.setAttribute(objectName, attribute, this.operationContext);
            } else {
                this.connectorServerV1.setAttribute(objectName, attribute);
            }
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        this.stopIfNotConnected("setAttributes(name,attributes)");
        if (this.isTraceOn()) {
            this.trace("setAttribute(name,attributes)", "MBean object name = " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.setAttributes(objectName, attributeList, this.operationContext);
            }
            return this.connectorServerV1.setAttributes(objectName, attributeList);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.stopIfNotConnected("invoke(name,methodName,arguments,signature)");
        if (this.isTraceOn()) {
            this.trace("invoke(name,methodName,arguments,signature)", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.invoke(objectName, string, objectArray, stringArray, this.operationContext);
            }
            return this.connectorServerV1.invoke(objectName, string, objectArray, stringArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.stopIfNotConnected("getMBeanInfo(name)");
        if (this.isTraceOn()) {
            this.trace("getMBeanInfo(name)", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getMBeanInfo(objectName, this.operationContext);
            }
            return this.connectorServerV1.getMBeanInfo(objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public String getClassForProxyMBean(ObjectInstance objectInstance) throws ProxyMBeanInstantiationException {
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        return this.mapper.getClassForProxyMBean(objectInstance);
    }

    String getHost() {
        return this.localHost;
    }

    private void stopIfNotConnected(String string) throws CommunicationException {
        if (!this.isConnected) {
            if (this.isTraceOn()) {
                this.trace("methodName", " Not connected");
            }
            throw new CommunicationException("ConnectorClient not connected to RMI Connector Server");
        }
    }

    private String makeDebugTag() {
        if (this.connectorAddress != null) {
            return this.localClassName + "[" + this.connectorAddress.getPort() + ":" + this.connectorAddress.getName() + "]";
        }
        return this.localClassName;
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HeartBeatInternalClientHandlerImpl
    implements HeartBeatInternalClientHandler {
        private RmiConnectorClient connector;

        public HeartBeatInternalClientHandlerImpl(RmiConnectorClient rmiConnectorClient2) {
            this.connector = rmiConnectorClient2;
        }

        public RemoteMBeanServer getRemoteMBeanServer() {
            return this.connector;
        }

        public String pingHeartBeatServer(String string, int n, int n2, Long l) {
            return this.connector.pingHeartBeatServer(string, n, n2, l);
        }
    }

    private class NotificationHandlerInternal
    implements ClientNotificationHandlerInternal {
        private RmiConnectorClient connector;

        public NotificationHandlerInternal(RmiConnectorClient rmiConnectorClient2) {
            this.connector = rmiConnectorClient2;
        }

        public Object[] remoteRequest(int n, Object[] objectArray) throws CommunicationException, Exception {
            return this.connector.remoteRequest(n, objectArray);
        }

        public ConnectorAddress startPush() throws CommunicationException, RemoteRuntimeException {
            return this.connector.startPush();
        }

        public void stopPush(ConnectorAddress connectorAddress) {
            this.connector.stopPush();
        }
    }
}

