/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.GenericHttpNotificationForwarder;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpsConnectorServerMBean;
import com.sun.jdmk.comm.HttpsNotificationForwarder;
import com.sun.jdmk.comm.HttpsSocket;
import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class HttpsConnectorServer
extends GenericHttpConnectorServer
implements HttpsConnectorServerMBean {
    private int timeout = 60000;

    public HttpsConnectorServer() {
        super(5, 8084);
    }

    public HttpsConnectorServer(int n) {
        super(5, n);
    }

    public HttpsConnectorServer(int n, AuthInfo[] authInfoArray) {
        super(5, n, authInfoArray);
    }

    public HttpsConnectorServer(int n, InetAddress inetAddress) {
        super(5, n, inetAddress);
    }

    public HttpsConnectorServer(int n, AuthInfo[] authInfoArray, InetAddress inetAddress) {
        super(5, n, authInfoArray, inetAddress);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            objectName = new ObjectName("DefaultDomain:name=HttpsConnectorServer");
        }
        return super.preRegister(mBeanServer, objectName);
    }

    GenericHttpSocket createSocket() {
        HttpsSocket httpsSocket = new HttpsSocket();
        httpsSocket.setTimeout(this.getTimeout());
        return httpsSocket;
    }

    GenericHttpNotificationForwarder getNotificationForwarder(GenericHttpConnectorAddress genericHttpConnectorAddress) {
        return new HttpsNotificationForwarder(genericHttpConnectorAddress);
    }

    public String getProtocol() {
        return "https";
    }

    public int getTimeout() {
        if (this.sockListen != null) {
            return this.sockListen.getTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(int n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.timeout = n;
        if (this.sockListen != null) {
            this.sockListen.setTimeout(n);
        }
    }

    String makeDebugTag() {
        return "HttpsConnectorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }
}

