/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.GenericHttpNotificationReceiverHandler;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpConnectorAddress;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;

abstract class GenericHttpNotificationReceiver
extends CommunicatorServer {
    protected transient GenericHttpSocket sockListen = null;
    protected InetAddress addrLastClient = null;
    private GenericHttpConnectorClient connector = null;
    private GenericHttpConnectorAddress connAddr = null;
    ClientNotificationDispatcher dispatcher = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    abstract GenericHttpSocket createSocket();

    public GenericHttpNotificationReceiver(int n, int n2, GenericHttpConnectorClient genericHttpConnectorClient, ClientNotificationDispatcher clientNotificationDispatcher) {
        super(n);
        this.port = n2;
        this.connector = genericHttpConnectorClient;
        this.dispatcher = clientNotificationDispatcher;
        this.maxActiveClientCount = 10;
    }

    public void startListening() {
        this.start();
        if (!this.waitState(0, 60000L)) {
            throw new CommunicationException("Notification Server could not be started");
        }
        this.connAddr = new HttpConnectorAddress(this.connector.getHost(), this.sockListen.getLocalPort());
    }

    public void stopListening() {
        this.stop();
    }

    public GenericHttpConnectorAddress getConnectorAddress() {
        return this.connAddr;
    }

    protected void doError(Exception exception) throws CommunicationException {
        if (exception instanceof CommunicationException) {
            throw (CommunicationException)exception;
        }
        throw new CommunicationException(exception);
    }

    protected void doBind() throws InterruptedException, CommunicationException {
        try {
            this.sockListen = this.createSocket().createServerSocket(this.port);
            this.sockListen.doBind();
            this.port = this.sockListen.getLocalPort();
            this.dbgTag = this.makeDebugTag();
            if (this.isTraceOn()) {
                this.trace("doBind", this.sockListen.toString() + " bound to " + this.sockListen.getLocalAddress() + " port " + this.sockListen.getLocalPort());
            }
        }
        catch (SocketException socketException) {
            if (this.isTraceOn()) {
                this.trace("doBind", "EXCEPTION MSG = '" + socketException.getMessage() + "'");
            }
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException);
        }
    }

    protected void doReceive() throws InterruptedException, CommunicationException {
        try {
            this.sockListen.doReceive();
            this.addrLastClient = this.sockListen.getRemoteAddress();
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(iOException.toString());
            }
            throw new CommunicationException(iOException);
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            if (this.isTraceOn()) {
                this.trace("doReceive", "EXCEPTION MSG = '" + exception.getMessage() + "'");
            }
            throw new InterruptedException();
        }
    }

    protected void doProcess() throws InterruptedException, CommunicationException {
        if (this.isTraceOn()) {
            this.trace("doProcess", "Address of last connected client [" + this.addrLastClient + "]");
        }
        GenericHttpNotificationReceiverHandler genericHttpNotificationReceiverHandler = new GenericHttpNotificationReceiverHandler(this, this.getServedClientCount(), (GenericHttpSocket)this.sockListen.clone());
    }

    protected void doUnbind() throws InterruptedException, CommunicationException {
        try {
            if (this.sockListen != null) {
                if (this.isTraceOn()) {
                    this.trace("doUnbind", "Port [" + this.port + "] has been definitively closed");
                }
                this.sockListen.doUnbind();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException);
        }
    }

    protected String makeDebugTag() {
        return "GenericHttpNotificationReceiver[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    public void stop() {
        if (this.isActive()) {
            super.stop();
            try {
                GenericHttpSocket genericHttpSocket = this.sockListen.createClientSocket();
                if (System.getProperty("jdmk.hostname") != null) {
                    genericHttpSocket.doConnect(System.getProperty("jdmk.hostname"), this.port);
                } else {
                    genericHttpSocket.doConnect(InetAddress.getLocalHost().getHostAddress(), this.port);
                }
                genericHttpSocket.doSend("", null);
                genericHttpSocket.doDisconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getLastConnectedClient() {
        if (this.addrLastClient == null) {
            return "unknown";
        }
        return this.addrLastClient.toString();
    }
}

