/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;

abstract class GenericHttpNotificationForwarder
extends GenericHttpConnectorClient
implements NotificationBackConnector {
    private static final int BUFFER_SIZE = 256;
    private transient boolean connected = false;

    public GenericHttpNotificationForwarder(GenericHttpConnectorAddress genericHttpConnectorAddress) {
        this.httpConnAddr = genericHttpConnectorAddress;
        this.factory = this.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private byte[] sendHttp(Object[] objectArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            objectOutputStream.writeObject(objectArray[n3]);
            ++n3;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Socket socket = null;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        try {
            int n;
            socket = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
            OutputStream outputStream = socket.getOutputStream();
            if (byArray.length != 0) {
                outputStream.write(byArray);
            }
            outputStream.flush();
            InputStream inputStream = socket.getInputStream();
            byte[] byArray2 = new byte[256];
            byteArrayOutputStream2 = new ByteArrayOutputStream(256);
            while ((n = inputStream.read(byArray2, 0, 256)) != -1) {
                byteArrayOutputStream2.write(byArray2, 0, n);
            }
            Object var14_14 = null;
            if (socket == null) return byteArrayOutputStream2.toByteArray();
            try {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    return byteArrayOutputStream2.toByteArray();
                }
                return byteArrayOutputStream2.toByteArray();
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                socket = null;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (socket == null) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var17_21 = null;
                socket = null;
                throw throwable2;
            }
            try {}
            catch (IOException iOException) {
                Object var17_20 = null;
                socket = null;
                throw throwable;
            }
            socket.close();
            Object var17_19 = null;
            socket = null;
            throw throwable;
        }
    }

    public String connect() {
        if (GenericHttpNotificationForwarder.isTraceOn()) {
            GenericHttpNotificationForwarder.trace("connect", "connect");
        }
        this.connected = true;
        return null;
    }

    public void disconnect() {
        if (GenericHttpNotificationForwarder.isTraceOn()) {
            GenericHttpNotificationForwarder.trace("disconnect", "disconnect");
        }
        if (this.connected) {
            this.httpConnAddr = null;
            this.connected = false;
        }
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (GenericHttpNotificationForwarder.isTraceOn()) {
            GenericHttpNotificationForwarder.trace("remoteRequest", "remoteRequest");
        }
        if (!this.connected) {
            throw new CommunicationException("NotificationForwarder not connected");
        }
        Object[] objectArray2 = new Object[]{"remoteRequest", new Integer(n), objectArray};
        try {
            byte[] byArray = this.sendHttp(objectArray2);
            if (byArray.length == 0) {
                throw new IllegalAccessException("Entity Body in HTTP Response is empty");
            }
            Object object = this.readObjectValue(byArray);
            if (object instanceof Exception) {
                throw (Exception)object;
            }
            return (Object[])object;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (GenericHttpNotificationForwarder.isDebugOn()) {
                GenericHttpNotificationForwarder.debug("remoteRequest", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (GenericHttpNotificationForwarder.isDebugOn()) {
                GenericHttpNotificationForwarder.debug("remoteRequest", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    private Object readObjectValue(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        String string = (String)objectInputStream.readObject();
        if (GenericHttpNotificationForwarder.isDebugOn()) {
            GenericHttpNotificationForwarder.debug("readObjectValue", "Received object of type " + string);
        }
        return objectInputStream.readObject();
    }

    private static boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)3856);
    }

    private static void trace(String string, String string2) {
        Trace.send((int)1, (int)3856, (String)"GenericHttpNotificationForwarder", (String)string, (String)string2);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)3856, (String)string, (String)string2, (String)string3);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)3856);
    }

    private static void debug(String string, String string2) {
        Trace.send((int)2, (int)3856, (String)"GenericHttpNotificationForwarder", (String)string, (String)string2);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)3856, (String)string, (String)string2, (String)string3);
    }
}

