/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.OperationContext;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.AuthSchemeInfo;
import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.BASE64Encoder;
import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.DefaultMapper;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocketFactory;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatClientHandlerImpl;
import com.sun.jdmk.comm.HeartBeatInternalClientHandler;
import com.sun.jdmk.comm.Mapper;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.UnauthorizedSecurityException;
import com.sun.jdmk.trace.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public abstract class GenericHttpConnectorClient
implements RemoteMBeanServer,
HeartBeatClientHandler,
Serializable {
    private OperationContext operationContext = null;
    transient Hashtable authSchemeInfoList = null;
    transient GenericHttpConnectorAddress httpConnAddr = null;
    transient GenericHttpSocketFactory factory = null;
    private transient boolean connected = false;
    private transient boolean supportsOperationContext = false;
    private String mbeanServerId = null;
    private transient Mapper mapper = null;
    private transient Mapper defaultMapper = null;
    private transient ClassLoader classloader = null;
    private transient Hashtable proxyHandles = new Hashtable();
    private transient Hashtable genericHandles = new Hashtable();
    private GenericHttpNotificationReceiver notificationReceiver = null;
    private ClientNotificationDispatcher notificationClientHandler = null;
    private HeartBeatClientHandlerImpl heartbeatClientHandler = null;
    private String localHost = null;

    abstract GenericHttpSocketFactory getSocketFactory();

    abstract GenericHttpNotificationReceiver getNotificationReceiver(GenericHttpConnectorClient var1, ClientNotificationDispatcher var2);

    public void setOperationContext(OperationContext operationContext) {
        try {
            if (operationContext != null) {
                operationContext = (OperationContext)operationContext.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CommunicationException(cloneNotSupportedException);
        }
        this.operationContext = operationContext;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public GenericHttpConnectorClient() {
        if (System.getProperty("jdmk.hostname") != null) {
            this.localHost = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.localHost = "localhost";
            }
        }
        if (this.isDebugOn()) {
            this.debug("GenericHttpConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public GenericHttpConnectorClient(InetAddress inetAddress) {
        try {
            this.localHost = inetAddress == null ? (System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress()) : inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            this.localHost = "localhost";
        }
        if (this.isDebugOn()) {
            this.debug("GenericHttpConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public GenericHttpConnectorClient(String string) {
        if (string != null) {
            this.localHost = string;
        } else {
            try {
                this.localHost = System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                this.localHost = "localhost";
            }
        }
        if (this.isDebugOn()) {
            this.debug("GenericHttpConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    private void Initialize() {
        this.factory = this.getSocketFactory();
        this.mapper = this.defaultMapper = new DefaultMapper();
        this.notificationClientHandler = new ClientNotificationDispatcher(new NotificationHandlerInternal(this));
        this.heartbeatClientHandler = new HeartBeatClientHandlerImpl(new HeartBeatInternalClientHandlerImpl(this), this.notificationClientHandler);
    }

    /*
     * Unable to fully structure code
     */
    private String HMAC_MD5(byte[] var1_1, byte[] var2_2) {
        var4_3 = null;
        try {
            var4_3 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException var5_4) {
            // empty catch block
        }
        if (var2_2.length > 64) {
            var2_2 = var4_3.digest(var2_2);
        }
        var5_5 = new byte[64];
        var6_6 = new byte[64];
        var8_7 = 0;
        ** GOTO lbl21
        {
            var5_5[var8_7] = var2_2[var8_7];
            var6_6[var8_7] = var2_2[var8_7];
            ++var8_7;
            do {
                if (var8_7 < var2_2.length) continue block2;
                var5_5[var8_7] = 0;
                var6_6[var8_7] = 0;
                ++var8_7;
lbl21:
                // 2 sources

            } while (var8_7 < 64);
        }
        var8_7 = 0;
        while (var8_7 < 64) {
            v0 = var8_7;
            var5_5[v0] = (byte)(var5_5[v0] ^ 54);
            v1 = var8_7++;
            var6_6[v1] = (byte)(var6_6[v1] ^ 92);
        }
        var4_3.update(var5_5);
        var4_3.update(var1_1);
        var7_8 = var4_3.digest();
        var4_3.update(var6_6);
        var4_3.update(var7_8);
        var7_8 = var4_3.digest();
        var9_9 = new StringBuffer();
        var8_7 = 0;
        while (var8_7 < var7_8.length) {
            if ((var7_8[var8_7] & 255) < 16) {
                var9_9.append("0" + Integer.toHexString(var7_8[var8_7] & 255));
            } else {
                var9_9.append(Integer.toHexString(var7_8[var8_7] & 255));
            }
            ++var8_7;
        }
        return var9_9.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream sendHttp(Object[] objectArray, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (this.authSchemeInfoList != null) {
            if (this.authSchemeInfoList.get(Thread.currentThread()) == null) {
                this.authSchemeInfoList.put(Thread.currentThread(), new AuthSchemeInfo("CRAM-MD5"));
            }
            if ((object6 = (AuthSchemeInfo)this.authSchemeInfoList.get(Thread.currentThread())) != null && (object5 = ((AuthSchemeInfo)object6).getChallenge()) != null) {
                object4 = "";
                try {
                    object5 = ((String)object5).substring((((AuthSchemeInfo)object6).getAuthScheme() + " ").length());
                    byte[] byArray = new BASE64Decoder().decodeBuffer((String)object5);
                    object3 = this.httpConnAddr.getAuthInfo().getLogin();
                    object2 = this.httpConnAddr.getAuthInfo().getPassword().getBytes();
                    String string = this.HMAC_MD5(byArray, (byte[])object2);
                    object = (String)object3 + " " + string;
                    String string2 = null;
                    int n = ((String)object).length() / 57;
                    int n2 = ((String)object).length() % 57;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n) {
                            if (n2 > 0) {
                                string2 = ((String)object).substring(n * 57);
                                object4 = (String)object4 + new BASE64Encoder().encode(string2.getBytes());
                            }
                            break;
                        }
                        string2 = ((String)object).substring(n3 * 57, (n3 + 1) * 57);
                        object4 = (String)object4 + new BASE64Encoder().encode(string2.getBytes());
                        ++n3;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ((AuthSchemeInfo)object6).setResponse(((AuthSchemeInfo)object6).getAuthScheme() + " " + (String)object4);
                ((AuthSchemeInfo)object6).setChallenge(null);
            }
        }
        object6 = null;
        try {
            try {
                object5 = new ByteArrayOutputStream();
                object4 = new ObjectOutputStream((OutputStream)object5);
                if (this.operationContext != null && this.supportsOperationContext) {
                    ((ObjectOutputStream)object4).writeObject(this.operationContext);
                }
                int n = 0;
                while (true) {
                    if (n >= objectArray.length) {
                        try {
                            object6 = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
                        }
                        catch (SocketException socketException) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            object6 = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
                        }
                        break;
                    }
                    ((ObjectOutputStream)object4).writeObject(objectArray[n]);
                    ++n;
                }
                object3 = ((Socket)object6).getOutputStream();
                ((OutputStream)object3).write(((ByteArrayOutputStream)object5).toByteArray());
                ((OutputStream)object3).flush();
                object2 = new PushbackInputStream(((Socket)object6).getInputStream());
                int n4 = ((PushbackInputStream)object2).read();
                if (n4 >= 0) {
                    ((PushbackInputStream)object2).unread(n4);
                }
                object = object2;
                Object var17_21 = null;
                if (object6 == null) return object;
            }
            catch (UnauthorizedSecurityException unauthorizedSecurityException) {
                if (this.authSchemeInfoList == null) throw unauthorizedSecurityException;
                if (bl) {
                    throw unauthorizedSecurityException;
                }
                object4 = this.sendHttp(objectArray, true);
                Object var17_22 = null;
                if (object6 == null) return object4;
                try {
                    try {
                        ((Socket)object6).close();
                        return object4;
                    }
                    catch (IOException iOException) {
                        return object4;
                    }
                }
                catch (Throwable throwable) {
                    Object var20_29 = null;
                    object6 = null;
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_23 = null;
            if (object6 == null) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var20_32 = null;
                object6 = null;
                throw throwable2;
            }
            try {}
            catch (IOException iOException) {
                Object var20_31 = null;
                object6 = null;
                throw throwable;
            }
            ((Socket)object6).close();
            Object var20_30 = null;
            object6 = null;
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var20_26 = null;
            object6 = null;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return object;
        }
        ((Socket)object6).close();
        return object;
    }

    public String connect(ConnectorAddress connectorAddress) {
        if (this.isTraceOn()) {
            this.trace("connect", "connect");
        }
        if (connectorAddress == null) {
            throw new IllegalArgumentException("mbeanServerAddress cannot be null");
        }
        if (!(connectorAddress instanceof GenericHttpConnectorAddress)) {
            throw new IllegalArgumentException("mbeanServerAddress must be an instance of GenericHttpConnectorAddress");
        }
        if (this.connected) {
            throw new CommunicationException("ConnectorClient already connected to RemoteMBeanServer");
        }
        this.httpConnAddr = (GenericHttpConnectorAddress)((GenericHttpConnectorAddress)connectorAddress).clone();
        AuthInfo authInfo = this.httpConnAddr.getAuthInfo();
        if (authInfo != null) {
            if (authInfo.getLogin() == null || authInfo.getPassword() == null) {
                throw new IllegalArgumentException("Login/Password cannot be null");
            }
            this.authSchemeInfoList = new Hashtable();
        }
        this.supportsOperationContext = this.supports("OperationContext");
        String string = null;
        try {
            string = this.getMBeanServerId2();
        }
        catch (UnauthorizedSecurityException unauthorizedSecurityException) {
            throw unauthorizedSecurityException;
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception, "Connection failed");
        }
        if (this.mbeanServerId != null) {
            if (!this.mbeanServerId.equals(string)) {
                throw new IllegalArgumentException("ConnectorClient trying to connect to a different RemoteMBeanServer");
            }
        } else {
            this.mbeanServerId = string;
        }
        this.connected = true;
        this.heartbeatClientHandler.notifyConnectionEstablished();
        this.heartbeatClientHandler.startPinging();
        return this.mbeanServerId;
    }

    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean bl) {
        if (this.isTraceOn()) {
            this.trace("disconnect", "disconnect");
        }
        if (this.connected) {
            this.notificationClientHandler.stopListening(bl);
            this.heartbeatClientHandler.stopPinging(-1, bl);
            this.heartbeatClientHandler.notifyConnectionTerminated();
            this.httpConnAddr = null;
            this.authSchemeInfoList = null;
            this.connected = false;
        }
    }

    public boolean isConnected() {
        if (this.isTraceOn()) {
            this.trace("isConnected", "isConnected");
        }
        return this.connected;
    }

    public ConnectorAddress getMBeanServerAddress() {
        if (this.isTraceOn()) {
            this.trace("getMBeanServerAddress", "getMBeanServerAddress");
        }
        if (!this.connected) {
            return null;
        }
        return this.httpConnAddr;
    }

    public String getMBeanServerId() {
        if (this.isTraceOn()) {
            this.trace("getMBeanServerId", "getMBeanServerId");
        }
        return this.mbeanServerId;
    }

    private String getMBeanServerId2() {
        Object[] objectArray = new Object[]{"getMBeanServerId"};
        return (String)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object[] objectArray = new Object[]{"createMBean", string, objectName};
        return this.createMBeanWithoutLoader(objectArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object[] objectArray = new Object[]{"createMBeanLoader", string, objectName, objectName2};
        return this.createMBeanWithLoader(objectArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object[] objectArray2 = new Object[]{"createMBeanParams", string, objectName, objectArray, stringArray};
        return this.createMBeanWithoutLoader(objectArray2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object[] objectArray2 = new Object[]{"createMBeanLoaderParams", string, objectName, objectName2, objectArray, stringArray};
        return this.createMBeanWithLoader(objectArray2);
    }

    private ObjectInstance createMBeanWithoutLoader(Object[] objectArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        try {
            return (ObjectInstance)this.invokeRemoteOperation(objectArray);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    private ObjectInstance createMBeanWithLoader(Object[] objectArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        try {
            return (ObjectInstance)this.invokeRemoteOperation(objectArray);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"unregisterMBean", objectName};
        try {
            this.invokeRemoteOperation(objectArray);
            this.proxyHandles.remove(objectName);
            this.genericHandles.remove(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"queryNames", objectName, queryExp};
        return (Set)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"queryMBeans", objectName, queryExp};
        return (Set)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public boolean isRegistered(ObjectName objectName) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"isRegistered", objectName};
        Boolean bl = (Boolean)this.invokeRemoteOperationNoExceptions(objectArray);
        return bl;
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getAttribute", objectName, string};
        try {
            return this.invokeRemoteOperation(objectArray);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getAttributes", objectName, stringArray};
        return (AttributeList)this.invokeRemoteOperationOnInstance(objectArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"setAttribute", objectName, attribute};
        try {
            this.invokeRemoteOperation(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw invalidAttributeValueException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"setAttributes", objectName, attributeList};
        return (AttributeList)this.invokeRemoteOperationOnInstance(objectArray);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray2 = new Object[]{"invoke", objectName, string, objectArray, stringArray};
        try {
            return this.invokeRemoteOperation(objectArray2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getMBeanInfo", objectName};
        try {
            return (MBeanInfo)this.invokeRemoteOperation(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (IntrospectionException introspectionException) {
            throw introspectionException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getObjectInstance", objectName};
        return (ObjectInstance)this.invokeRemoteOperationOnInstance(objectArray);
    }

    public Integer getMBeanCount() {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getMBeanCount"};
        return (Integer)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public String getDefaultDomain() {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getDefaultDomain"};
        return (String)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"isInstanceOf", objectName, string};
        Boolean bl = (Boolean)this.invokeRemoteOperationOnInstance(objectArray);
        return bl;
    }

    public boolean supports(String string) {
        Object[] objectArray = new Object[]{"supports", string};
        try {
            Boolean bl = (Boolean)this.invokeRemoteOperationNoExceptions(objectArray);
            return bl;
        }
        catch (CommunicationException communicationException) {
            return false;
        }
    }

    public String getClassForProxyMBean(ObjectInstance objectInstance) throws ProxyMBeanInstantiationException {
        if (this.isTraceOn()) {
            this.trace("getClassForProxyMBean", "getClassForProxyMBean");
        }
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        return this.mapper.getClassForProxyMBean(objectInstance);
    }

    public void setMode(int n) throws IllegalArgumentException {
        if (this.isTraceOn()) {
            this.trace("setMode", "setMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setMode(n);
    }

    public int getMode() {
        if (this.isTraceOn()) {
            this.trace("getMode", "getMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getMode();
    }

    public void getNotifications() {
        if (this.isTraceOn()) {
            this.trace("getNotifications", "getNotifications");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.getNotifications();
    }

    public void setPeriod(int n) {
        if (this.isTraceOn()) {
            this.trace("setPeriod", "setPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setPeriod(n);
    }

    public int getPeriod() {
        if (this.isTraceOn()) {
            this.trace("getPeriod", "getPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getPeriod();
    }

    public void clearCache() {
        if (this.isTraceOn()) {
            this.trace("clearCache", "clearCache");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.clearCache();
    }

    public int setCacheSize(int n, boolean bl) throws JMRuntimeException {
        if (this.isTraceOn()) {
            this.trace("setCacheSize", "setCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.setCacheSize(n, bl);
    }

    public int getCacheSize() {
        if (this.isTraceOn()) {
            this.trace("getCacheSize", "getCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getCacheSize();
    }

    public void setOverflowCount(int n) {
        if (this.isTraceOn()) {
            this.trace("setOverflowCount", "setOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowCount(n);
    }

    public int getOverflowCount() {
        if (this.isTraceOn()) {
            this.trace("getOverflowCount", "getOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowCount();
    }

    public void setOverflowMode(int n) throws IllegalArgumentException {
        if (this.isTraceOn()) {
            this.trace("setOverflowMode", "setOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowMode(n);
    }

    public int getOverflowMode() {
        if (this.isTraceOn()) {
            this.trace("getOverflowMode", "getOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowMode();
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("addNotificationListener", "addNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.isTraceOn()) {
            this.trace("removeNotificationListener", "removeNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.removeNotificationListener(objectName, notificationListener);
    }

    Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray2 = new Object[]{"remoteRequest", new Integer(n), objectArray};
        try {
            return (Object[])this.invokeRemoteOperation(objectArray2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    ConnectorAddress startPush() {
        if (this.isTraceOn()) {
            this.trace("startPush", "startPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver == null) {
            try {
                if (this.isDebugOn()) {
                    this.debug("startPush", "Create new NotificationReceiver");
                }
                this.notificationReceiver = this.getNotificationReceiver(this, this.notificationClientHandler);
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (Exception exception) {
                throw new CommunicationException(exception);
            }
        }
        if (this.isDebugOn()) {
            this.debug("startPush", "Start receiving events");
        }
        this.notificationReceiver.startListening();
        return this.notificationReceiver.getConnectorAddress();
    }

    void stopPush() {
        if (this.isTraceOn()) {
            this.trace("stopPush", "stopPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver != null) {
            this.notificationReceiver.stopListening();
        }
    }

    public int getHeartBeatPeriod() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatPeriod", "getHeartBeatPeriod");
        }
        return this.heartbeatClientHandler.getHeartBeatPeriod();
    }

    public void setHeartBeatPeriod(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatPeriod", "setHeartBeatPeriod");
        }
        this.heartbeatClientHandler.setHeartBeatPeriod(n);
    }

    public int getHeartBeatRetries() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatRetries", "getHeartBeatRetries");
        }
        return this.heartbeatClientHandler.getHeartBeatRetries();
    }

    public void setHeartBeatRetries(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatRetries", "setHeartBeatRetries");
        }
        this.heartbeatClientHandler.setHeartBeatRetries(n);
    }

    public void addHeartBeatNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (this.isTraceOn()) {
            this.trace("addHeartBeatNotificationListener", "addHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.addHeartBeatNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeHeartBeatNotificationListener(NotificationListener notificationListener) {
        if (this.isTraceOn()) {
            this.trace("removeHeartBeatNotificationListener", "removeHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.removeHeartBeatNotificationListener(notificationListener);
    }

    String pingHeartBeatServer(String string, int n, int n2, Long l) {
        Object[] objectArray = new Object[]{"pingHeartBeatServer", string, new Integer(n), new Integer(n2), l};
        return (String)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    String getHost() {
        return this.localHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteOperation(Object[] objectArray) throws Exception {
        Object object;
        Object object2;
        if (this.isTraceOn()) {
            object2 = (String)objectArray[0];
            this.trace("invokeRemoteOperation", (String)object2);
        }
        object2 = this.sendHttp(objectArray, false);
        try {
            object = this.readObjectValue((InputStream)object2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)object2).close();
            throw throwable;
        }
        ((InputStream)object2).close();
        return object;
    }

    private Object invokeRemoteOperationNoExceptions(Object[] objectArray) {
        try {
            return this.invokeRemoteOperationOnInstance(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new CommunicationException(instanceNotFoundException);
        }
    }

    private Object invokeRemoteOperationOnInstance(Object[] objectArray) throws InstanceNotFoundException {
        try {
            return this.invokeRemoteOperation(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    private Object readObjectValue(InputStream inputStream) throws Exception {
        Object object;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        String string = (String)objectInputStream.readObject();
        if (this.isDebugOn()) {
            this.debug("readObjectValue", "Received object of type " + string);
        }
        if ((object = objectInputStream.readObject()) instanceof Exception && string.equals("Exception")) {
            throw (Exception)object;
        }
        return object;
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)3856);
    }

    private void trace(String string, String string2) {
        Trace.send((int)1, (int)3856, (String)"GenericHttpConnectorClient", (String)string, (String)string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)3856, (String)string, (String)string2, (String)string3);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)3856);
    }

    private void debug(String string, String string2) {
        Trace.send((int)2, (int)3856, (String)"GenericHttpConnectorClient", (String)string, (String)string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)3856, (String)string, (String)string2, (String)string3);
    }

    private class HeartBeatInternalClientHandlerImpl
    implements HeartBeatInternalClientHandler {
        private GenericHttpConnectorClient connector;

        public HeartBeatInternalClientHandlerImpl(GenericHttpConnectorClient genericHttpConnectorClient2) {
            this.connector = genericHttpConnectorClient2;
        }

        public RemoteMBeanServer getRemoteMBeanServer() {
            return this.connector;
        }

        public String pingHeartBeatServer(String string, int n, int n2, Long l) {
            return this.connector.pingHeartBeatServer(string, n, n2, l);
        }
    }

    private class NotificationHandlerInternal
    implements ClientNotificationHandlerInternal {
        private GenericHttpConnectorClient connector;

        public NotificationHandlerInternal(GenericHttpConnectorClient genericHttpConnectorClient2) {
            this.connector = genericHttpConnectorClient2;
        }

        public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
            return this.connector.remoteRequest(n, objectArray);
        }

        public ConnectorAddress startPush() {
            return this.connector.startPush();
        }

        public void stopPush(ConnectorAddress connectorAddress) {
            this.connector.stopPush();
        }
    }
}

