/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;

abstract class GenericHttpClientHandler
extends ClientHandler {
    private static final AuthInfo nullAuthInfo = new AuthInfo(){

        public void setLogin(String string) {
            throw new IllegalArgumentException("unsupported operation");
        }

        public void setPassword(String string) {
            throw new IllegalArgumentException("unsupported operation");
        }
    };
    private GenericHttpSocket sockClient = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public GenericHttpClientHandler(CommunicatorServer communicatorServer, int n, GenericHttpSocket genericHttpSocket, MBeanServer mBeanServer, ObjectName objectName) {
        super(communicatorServer, n, mBeanServer, objectName);
        this.sockClient = genericHttpSocket;
        this.thread.start();
    }

    protected abstract AuthInfo authenticateRequest(HttpRequest var1) throws IOException;

    protected abstract HttpResponse processPostRequest(HttpRequest var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRun() {
        try {
            try {
                HttpRequest httpRequest = new HttpRequest(new HttpBody());
                boolean bl = true;
                while (bl) {
                    HttpResponse httpResponse = null;
                    try {
                        httpRequest.readFrom(this.sockClient.doGetInputStream());
                        httpResponse = this.processRequest(httpRequest);
                    }
                    catch (MalformedHttpException malformedHttpException) {
                        if (this.isDebugOn()) {
                            this.debug("doRun", "Malformed HTTP request rejected");
                        }
                        httpResponse = this.makeErrorResponse(400, "Bad Request");
                    }
                    httpResponse.setHeader(3, httpRequest.getHeader(3));
                    httpResponse.writeTo(this.sockClient.doGetOutputStream());
                    bl = httpResponse.hasKeepAliveFlag() && !this.interruptCalled;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.isDebugOn()) {
                    this.debug("doRun", "Request handler interrupted");
                }
                Object var6_10 = null;
                this.closeClient();
                if (!this.isDebugOn()) return;
                this.debug("doRun", "Socket is now closed");
                return;
            }
            catch (EOFException eOFException) {
                if (this.isDebugOn()) {
                    this.debug("doRun", "Connection closed by peer");
                }
                Object var6_11 = null;
                this.closeClient();
                if (!this.isDebugOn()) return;
                this.debug("doRun", "Socket is now closed");
                return;
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                    if (this.isDebugOn()) {
                        this.debug("doRun", "Request handler interrupted");
                    }
                } else if (this.isDebugOn()) {
                    this.debug("doRun", "I/O exception " + socketException);
                }
                Object var6_12 = null;
                this.closeClient();
                if (!this.isDebugOn()) return;
                this.debug("doRun", "Socket is now closed");
                return;
            }
            catch (IOException iOException) {
                if (this.isDebugOn()) {
                    this.debug("doRun", "I/O exception " + iOException);
                }
                Object var6_13 = null;
                this.closeClient();
                if (!this.isDebugOn()) return;
                this.debug("doRun", "Socket is now closed");
                return;
            }
            Object var6_9 = null;
            this.closeClient();
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            this.closeClient();
            if (!this.isDebugOn()) throw throwable;
            this.debug("doRun", "Socket is now closed");
            throw throwable;
        }
        if (!this.isDebugOn()) return;
        this.debug("doRun", "Socket is now closed");
    }

    protected HttpResponse processRequest(HttpRequest httpRequest) throws IOException {
        if (this.isTraceOn()) {
            this.trace("processRequest", "Process the HTTP request");
        }
        HttpResponse httpResponse = null;
        AuthInfo authInfo = this.authenticateRequest(httpRequest);
        if (authInfo == null) {
            httpResponse = this.makeErrorResponse(401, "Unauthorized");
        } else if (httpRequest.method == 2) {
            httpResponse = this.processPostRequest(httpRequest);
        } else {
            if (this.isDebugOn()) {
                this.debug("processRequest", "Bad request: Request method not supported");
            }
            httpResponse = this.makeErrorResponse(400, "Bad Request");
        }
        return httpResponse;
    }

    protected HttpResponse makeOkResponse(byte[] byArray) {
        return this.makeResponse(200, "OK", byArray);
    }

    protected HttpResponse makeExceptionResponse(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = this.serialize("Exception", exception);
        }
        catch (IOException iOException) {
            return this.makeErrorResponse(400, "Bad Request");
        }
        return this.makeResponse(400, "Bad Request", byteArrayOutputStream.toByteArray());
    }

    protected HttpResponse makeErrorResponse(int n, String string) {
        return this.makeResponse(n, string, null);
    }

    protected HttpResponse makeResponse(int n, String string, byte[] byArray) {
        HttpBody httpBody = byArray == null ? new HttpBody() : new HttpBody(byArray);
        HttpResponse httpResponse = new HttpResponse(httpBody);
        httpResponse.statusCode = n;
        httpResponse.reasonPhrase = string;
        httpResponse.setHeader(1, "application/octet-stream");
        httpResponse.setHeader(2, new Date().toString());
        httpResponse.setHeader(4, this.getChallenge());
        return httpResponse;
    }

    protected AuthInfo makeNullAuthInfo() {
        return nullAuthInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeClient() {
        block7: {
            if (this.isTraceOn()) {
                this.trace("closeClient", "Close client ...");
            }
            if (this.sockClient != null) {
                try {
                    try {
                        this.sockClient.doDisconnect();
                    }
                    catch (IOException iOException) {
                        Object var4_2 = null;
                        this.sockClient = null;
                        break block7;
                    }
                    catch (CommunicationException communicationException) {
                        Object var4_3 = null;
                        this.sockClient = null;
                    }
                    Object var4_1 = null;
                    this.sockClient = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.sockClient = null;
                    throw throwable;
                }
            }
        }
    }

    protected ByteArrayOutputStream serialize(String string, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(string);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream;
    }

    protected abstract String getChallenge();
}

