/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.trace.Trace;
import javax.management.MBeanServer;
import javax.management.ObjectName;

abstract class ClientHandler
implements Runnable {
    protected CommunicatorServer adaptorServer = null;
    protected int requestId = -1;
    protected MBeanServer mbs = null;
    protected ObjectName objectName = null;
    protected Thread thread = null;
    protected boolean interruptCalled = false;
    protected String dbgTag = null;

    public ClientHandler(CommunicatorServer communicatorServer, int n, MBeanServer mBeanServer, ObjectName objectName) {
        this.adaptorServer = communicatorServer;
        this.requestId = n;
        this.mbs = mBeanServer;
        this.objectName = objectName;
        this.interruptCalled = false;
        this.dbgTag = this.makeDebugTag();
        this.thread = this.createThread(this);
    }

    Thread createThread(Runnable runnable) {
        return new Thread(this);
    }

    public void interrupt() {
        if (this.isTraceOn()) {
            this.trace("interrupt", "start");
        }
        this.interruptCalled = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (this.isTraceOn()) {
            this.trace("interrupt", "end");
        }
    }

    public void join() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.adaptorServer.notifyClientHandlerCreated(this);
            this.doRun();
            Object var2_1 = null;
            this.adaptorServer.notifyClientHandlerDeleted(this);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.adaptorServer.notifyClientHandlerDeleted(this);
            throw throwable;
        }
    }

    public abstract void doRun();

    protected boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)16);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)16, (String)string, (String)string2, (String)string3);
    }

    protected boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)16);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)16, (String)string, (String)string2, (String)string3);
    }

    protected void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    protected void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    protected String makeDebugTag() {
        return "ClientHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }
}

