/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.cascading;

import com.sun.jdmk.GenericProxy;
import com.sun.jdmk.cascading.CascadeGenericProxy;
import com.sun.jdmk.cascading.CascadingAgentMBean;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatNotification;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.HttpsConnectorAddress;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorClient;
import com.sun.jdmk.trace.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;

public class CascadingAgent
implements Serializable,
NotificationListener,
MBeanRegistration,
CascadingAgentMBean,
NotificationFilter {
    private int timeout = 0;
    private boolean timeoutedSocket = false;
    private static final Class[] sig = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CascadingAgent.class$("java.lang.String")) : class$java$lang$String};
    private MBeanServer mserver = null;
    private ConnectorAddress address = new RmiConnectorAddress("localhost", 1099, "name=RmiConnectorServer");
    private String conClName = null;
    private final String localHost;
    private transient boolean isActive = false;
    private transient boolean isStopping = false;
    private transient RemoteMBeanServer conClient = null;
    private transient Vector registeredRemoteObjs = new Vector();
    private transient QueryExp query = null;
    private transient ObjectName pattern = null;
    private String dbgTag = "CascadingAgent";
    static /* synthetic */ Class class$java$lang$String;

    public CascadingAgent() {
        this.localHost = null;
    }

    public CascadingAgent(ConnectorAddress connectorAddress, String string) {
        this.localHost = null;
        this.address = connectorAddress;
        this.conClName = string;
    }

    public CascadingAgent(String string, ConnectorAddress connectorAddress, String string2) {
        this.localHost = string;
        this.address = connectorAddress;
        this.conClName = string2;
    }

    public CascadingAgent(ConnectorAddress connectorAddress, String string, ObjectName objectName, QueryExp queryExp) {
        this.localHost = null;
        this.address = connectorAddress;
        this.conClName = string;
        this.pattern = objectName;
        this.query = queryExp;
    }

    public CascadingAgent(ConnectorAddress connectorAddress, String string, ObjectName objectName, QueryExp queryExp, int n) throws IOException {
        this.localHost = null;
        this.address = connectorAddress;
        this.conClName = string;
        this.pattern = objectName;
        this.query = queryExp;
        this.timeoutedSocket = true;
        Object var6_6 = null;
        if (n <= 0) {
            System.out.println("timeout<=0");
            throw var6_6;
        }
        this.timeout = n;
    }

    public CascadingAgent(String string, ConnectorAddress connectorAddress, String string2, ObjectName objectName, QueryExp queryExp) {
        this.localHost = string;
        this.address = connectorAddress;
        this.conClName = string2;
        this.pattern = objectName;
        this.query = queryExp;
    }

    public CascadingAgent(ConnectorAddress connectorAddress, RemoteMBeanServer remoteMBeanServer, ObjectName objectName, QueryExp queryExp) {
        this.localHost = null;
        this.address = connectorAddress;
        this.conClient = remoteMBeanServer;
        this.conClName = remoteMBeanServer.getClass().getName();
        this.pattern = objectName;
        this.query = queryExp;
    }

    public CascadingAgent(ConnectorAddress connectorAddress) {
        this.localHost = null;
        this.address = connectorAddress;
        this.conClName = this.findConnectorClientClassName(connectorAddress);
    }

    public CascadingAgent(String string, ConnectorAddress connectorAddress) {
        this.localHost = string;
        this.address = connectorAddress;
        this.conClName = this.findConnectorClientClassName(connectorAddress);
    }

    public CascadingAgent(ConnectorAddress connectorAddress, ObjectName objectName, QueryExp queryExp) {
        this.localHost = null;
        this.address = connectorAddress;
        this.conClName = this.findConnectorClientClassName(connectorAddress);
        this.pattern = objectName;
        this.query = queryExp;
    }

    public CascadingAgent(String string, ConnectorAddress connectorAddress, ObjectName objectName, QueryExp queryExp) {
        this.localHost = string;
        this.address = connectorAddress;
        this.conClName = this.findConnectorClientClassName(connectorAddress);
        this.pattern = objectName;
        this.query = queryExp;
    }

    public boolean isNotificationEnabled(Notification notification) {
        ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
        return this.registeredRemoteObjs.contains(objectName);
    }

    private final RemoteMBeanServer createConnector() throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class clazz = this.loadClass(this.getClientConnectorClassName());
        if (this.localHost == null) {
            return (RemoteMBeanServer)clazz.newInstance();
        }
        Constructor constructor = clazz.getConstructor(sig);
        Object[] objectArray = new Object[]{this.localHost};
        if (constructor == null) {
            throw new IllegalArgumentException("No constructor available");
        }
        return (RemoteMBeanServer)constructor.newInstance(objectArray);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mserver = mBeanServer;
        if (this.conClient == null) {
            try {
                this.conClient = this.createConnector();
                if (this.timeoutedSocket && this.conClient instanceof RmiConnectorClient) {
                    ((RmiConnectorClient)this.conClient).setTimeout(this.timeout);
                }
            }
            catch (Exception exception) {
                throw new ServiceNotFoundException(exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public RemoteMBeanServer getRemoteMBeanServer() {
        return this.conClient;
    }

    public ConnectorAddress getAddress() {
        return this.address;
    }

    public void setAddress(ConnectorAddress connectorAddress) {
        if (this.isActive) {
            throw new IllegalStateException("The cascading agent is active");
        }
        this.address = connectorAddress;
    }

    public String getClientConnectorClassName() {
        if (this.conClName != null) {
            return this.conClName;
        }
        return "com.sun.jdmk.comm.RmiConnectorClient";
    }

    public void setClientConnectorClassName(String string) {
        if (this.isActive) {
            throw new IllegalStateException("The cascading agent is active");
        }
        this.conClName = string;
    }

    public Integer getNbOfRemoteMBeans() {
        return new Integer(this.registeredRemoteObjs.size());
    }

    public synchronized Set getRemoteMBeans() {
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        ObjectInstance objectInstance = null;
        Enumeration enumeration = this.registeredRemoteObjs.elements();
        while (enumeration.hasMoreElements()) {
            try {
                objectInstance = this.conClient.getObjectInstance((ObjectName)enumeration.nextElement());
            }
            catch (Exception exception) {
                // empty catch block
            }
            hashSet.add(objectInstance);
        }
        return hashSet;
    }

    public ObjectName getPattern() {
        return this.pattern;
    }

    public QueryExp getQuery() {
        return this.query;
    }

    public void handleNotification(Notification notification, Object object) {
        if (object == null) {
            if (notification instanceof HeartBeatNotification) {
                this.handleHeartbeatNotification(notification);
            } else {
                this.handleRemoteNotification(notification);
            }
        } else {
            this.handleLocalNotification(notification);
        }
    }

    public void postDeregister() {
        block2: {
            try {
                this.stop();
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block2;
                this.debugex("postDeregister", exception);
            }
        }
    }

    public synchronized void start() {
        block21: {
            if (!this.isActive) {
                block20: {
                    block19: {
                        block18: {
                            if (this.conClient == null || !this.conClient.getClass().getName().equals(this.getClientConnectorClassName())) {
                                try {
                                    this.conClient = this.createConnector();
                                    if (this.timeoutedSocket && this.conClient instanceof RmiConnectorClient) {
                                        ((RmiConnectorClient)this.conClient).setTimeout(this.timeout);
                                    }
                                }
                                catch (Exception exception) {
                                    throw new JMRuntimeException(exception.getClass().getName() + ": " + exception.getMessage());
                                }
                            }
                            this.conClient.connect(this.address);
                            if (this.conClient instanceof HeartBeatClientHandler) {
                                try {
                                    ((HeartBeatClientHandler)((Object)this.conClient)).setHeartBeatPeriod(2000);
                                    ((HeartBeatClientHandler)((Object)this.conClient)).addHeartBeatNotificationListener(this, null, null);
                                }
                                catch (Exception exception) {
                                    if (!this.isDebugOn()) break block18;
                                    this.debug("start", "Failed to become listener of heartbeat notifications on the remote MBean Server " + exception.getMessage());
                                }
                            }
                        }
                        try {
                            this.conClient.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, null);
                        }
                        catch (Exception exception) {
                            if (!this.isDebugOn()) break block19;
                            this.debug("start", "Failed to become listener of the remote MBean Server " + exception.getMessage());
                        }
                    }
                    try {
                        this.loadRemoteObjects(this.pattern, this.query);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block20;
                        this.debug("start", exception.getMessage());
                    }
                }
                this.isActive = true;
                this.isStopping = false;
            } else if (this.isTraceOn()) {
                this.trace("start", "The CascadingAgent is already activated.");
            }
            try {
                this.mserver.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, (NotificationFilter)this, (Object)"local");
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block21;
                this.debug("start", "Failed to become listener of the local MBean Server " + exception.getMessage());
            }
        }
    }

    public synchronized void stop() {
        block16: {
            if (this.isActive) {
                try {
                    this.conClient.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.conClient instanceof HeartBeatClientHandler) {
                    try {
                        ((HeartBeatClientHandler)((Object)this.conClient)).removeHeartBeatNotificationListener(this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    block15: {
                        this.isStopping = true;
                        while (!this.registeredRemoteObjs.isEmpty()) {
                            Object e = this.registeredRemoteObjs.firstElement();
                            try {
                                this.unregister((ObjectName)e);
                            }
                            catch (InstanceNotFoundException instanceNotFoundException) {
                                this.registeredRemoteObjs.removeElement(e);
                            }
                            catch (MBeanRegistrationException mBeanRegistrationException) {
                                this.registeredRemoteObjs.removeElement(e);
                            }
                        }
                        if (!this.conClient.isConnected()) break block15;
                        this.conClient.disconnect();
                    }
                    Object var5_7 = null;
                    this.isActive = false;
                    this.isStopping = false;
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.isActive = false;
                    this.isStopping = false;
                    throw throwable;
                }
            }
            if (this.isTraceOn()) {
                this.trace("stop", "The CascadingAgent is already deactivated.");
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    private boolean wildmatch(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        while (n2 < n4) {
            char c;
            if ((c = string2.charAt(n2++)) == '?') {
                if (++n <= n3) continue;
                return false;
            }
            if (c == '*') {
                if (n2 >= n4) {
                    return true;
                }
                do {
                    if (!this.wildmatch(string.substring(n), string2.substring(n2))) continue;
                    return true;
                } while (++n < n3);
                return false;
            }
            if (n < n3 && c == string.charAt(n++)) continue;
            return false;
        }
        return n == n3;
    }

    static boolean containsProperties(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        String string3 = stringTokenizer.nextToken();
        vector.add(string3);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            vector.add(string3);
        }
        int n = 0;
        while (n < vector.size()) {
            if (string.indexOf(vector.elementAt(n).toString()) == -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void handleRemoteNotification(Notification notification) {
        block13: {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (this.pattern != null) {
                String string = this.pattern.getDomain().equals("") ? this.conClient.getDefaultDomain() : this.pattern.getDomain();
                if (!this.wildmatch(objectName.getDomain(), string) || !this.pattern.getCanonicalKeyPropertyListString().equals("") && !CascadingAgent.containsProperties(objectName.getCanonicalKeyPropertyListString(), this.pattern.getCanonicalKeyPropertyListString())) {
                    return;
                }
            }
            if (notification.getType().equals("JMX.mbean.registered")) {
                try {
                    HashSet hashSet = (HashSet)this.conClient.queryNames(objectName, this.query);
                    if (hashSet.size() != 1) break block13;
                    Object var5_7 = null;
                    ObjectInstance objectInstance = null;
                    GenericProxy genericProxy = null;
                    try {
                        objectInstance = this.conClient.getObjectInstance(objectName);
                        genericProxy = new GenericProxy(objectInstance, this.conClient);
                        this.register(new CascadeGenericProxy(genericProxy), objectName);
                        break block13;
                    }
                    catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                        if (this.isActive && this.isDebugOn()) {
                            this.debug("handleRemoteNotification", "Could not get GenericProxy for object " + objectName + " " + instanceAlreadyExistsException.getMessage());
                        }
                        break block13;
                    }
                }
                catch (Exception exception) {
                    if (this.isDebugOn()) {
                        this.debug("handleRemoteNotification", exception.getMessage());
                    }
                    break block13;
                }
            }
            if (notification.getType().equals("JMX.mbean.unregistered")) {
                try {
                    if (this.isTraceOn()) {
                        this.trace("handleRemoteNotification", "Remove deleted MBean " + objectName);
                    }
                    this.unregister(objectName);
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block13;
                    this.debug("handleRemoteNotification", "Could not unregister object  " + objectName + " " + exception.getMessage());
                }
            }
        }
    }

    private void handleLocalNotification(Notification notification) {
        block3: {
            ObjectName objectName;
            if (!this.isStopping && notification.getType().equals("JMX.mbean.unregistered") && this.registeredRemoteObjs.contains(objectName = ((MBeanServerNotification)notification).getMBeanName())) {
                try {
                    this.conClient.unregisterMBean(objectName);
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block3;
                    this.debug("handleLocalNotification", "Could not unregister object  " + objectName + " " + exception.getMessage());
                }
            }
        }
    }

    private void handleHeartbeatNotification(Notification notification) {
        if (!this.isStopping && notification.getType().equals("jdmk.connector.heartbeat.connection.lost")) {
            this.stop();
        }
    }

    private Boolean getConnected() {
        boolean bl = this.conClient == null ? false : this.conClient.isConnected();
        return new Boolean(bl);
    }

    private synchronized void register(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.mserver.registerMBean(object, objectName);
        this.registeredRemoteObjs.addElement(objectName);
    }

    private synchronized void unregister(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.registeredRemoteObjs.removeElement(objectName);
        this.mserver.unregisterMBean(objectName);
    }

    private void loadRemoteObjects(ObjectName objectName, QueryExp queryExp) throws ServiceNotFoundException, CommunicationException, IllegalAccessException {
        HashSet hashSet = null;
        hashSet = (HashSet)this.conClient.queryMBeans(objectName, queryExp);
        if (this.isDebugOn()) {
            this.debug("loadRemoteObjects", "Found " + hashSet.size() + " names");
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance;
            block13: {
                CascadeGenericProxy cascadeGenericProxy;
                GenericProxy genericProxy;
                block12: {
                    objectInstance = (ObjectInstance)iterator.next();
                    genericProxy = null;
                    cascadeGenericProxy = null;
                    try {
                        genericProxy = new GenericProxy(objectInstance, this.conClient);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block12;
                        this.debug("loadRemoteObjects", "Could not get GenericProxy for object " + objectInstance + " " + exception.getMessage());
                    }
                }
                if (cascadeGenericProxy == null) {
                    cascadeGenericProxy = new CascadeGenericProxy(genericProxy);
                }
                if (objectInstance.getObjectName().getDomain().equals("JMImplementation")) continue;
                try {
                    this.register(cascadeGenericProxy, objectInstance.getObjectName());
                    if (this.isTraceOn()) {
                        this.trace("loadRemoteObjects", "Proxy MBean " + objectInstance.getObjectName() + " has been registered");
                    }
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                    if (this.isActive && this.isDebugOn()) {
                        this.debugex("loadRemoteObjects", instanceAlreadyExistsException);
                    }
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                    if (this.isDebugOn()) {
                        this.debugex("loadRemoteObjects", mBeanRegistrationException);
                    }
                }
                catch (NotCompliantMBeanException notCompliantMBeanException) {
                    if (!this.isDebugOn()) break block13;
                    this.debugex("loadRemoteObjects", notCompliantMBeanException);
                }
            }
            if (!this.isTraceOn()) continue;
            this.trace("loadRemoteObjects", "Proxy MBean " + objectInstance.getObjectName() + " has been registered");
        }
    }

    private String findConnectorClientClassName(ConnectorAddress connectorAddress) {
        if (connectorAddress instanceof RmiConnectorAddress) {
            return "com.sun.jdmk.comm.RmiConnectorClient";
        }
        if (connectorAddress instanceof HttpConnectorAddress) {
            return "com.sun.jdmk.comm.HttpConnectorClient";
        }
        if (connectorAddress instanceof HttpsConnectorAddress) {
            return "com.sun.jdmk.comm.HttpsConnectorClient";
        }
        throw new IllegalArgumentException("The ConnectorAddress passed in parameter does not correspond to a Java DMK ConnectorAddress implementation");
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)32);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)32, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)32);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)32, (String)string, (String)string2, (String)string3);
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    private void debugex(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)32, (String)string, (String)string2, (Throwable)throwable);
    }

    private void debugex(String string, Throwable throwable) {
        this.debugex(this.dbgTag, string, throwable);
    }

    private Class loadClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoaderRepository classLoaderRepository = MBeanServerFactory.getClassLoaderRepository(this.mserver);
            if (classLoaderRepository == null) {
                throw new ClassNotFoundException(string);
            }
            return classLoaderRepository.loadClass(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

