/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.Unsigned;
import com.sun.jdmk.UnsignedByte;
import com.sun.jdmk.UnsignedInt;
import com.sun.jdmk.UnsignedShort;

public class UnsignedLong
extends Unsigned {
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(-1L);
    public static final UnsignedByte ZERO = new UnsignedByte(0);
    public static final UnsignedByte ONE = new UnsignedByte(1);
    public static final UnsignedByte TWO = new UnsignedByte(2);
    long value;

    public UnsignedLong(long l) {
        this.value = l;
    }

    public static UnsignedLong make(long l) {
        if (l >= 0L) {
            if (l < 256L) {
                if (l == 0L) {
                    return ZERO;
                }
                if (l == 1L) {
                    return ONE;
                }
                return new UnsignedByte((byte)l);
            }
            if (l < 65536L) {
                return new UnsignedShort((short)l);
            }
            if (l < 0x100000000L) {
                return new UnsignedInt((int)l);
            }
        }
        return new UnsignedLong(l);
    }

    UnsignedLong makeIfDifferent(long l) {
        if (this.value == l) {
            return this;
        }
        return UnsignedLong.make(l);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public double doubleValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (double)this.value - -1.8446744073709552E19;
    }

    public float floatValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (float)this.value - -1.8446744E19f;
    }

    public UnsignedInt unsignedIntValue() {
        return (UnsignedInt)this.makeIfDifferent(this.value & 0xFFFFFFFFL);
    }

    public UnsignedShort unsignedShortValue() {
        return (UnsignedShort)this.makeIfDifferent(this.value & 0xFFFFL);
    }

    public UnsignedByte unsignedByteValue() {
        return (UnsignedByte)this.makeIfDifferent(this.value & 0xFFL);
    }

    public int compareTo(Object object) {
        UnsignedLong unsignedLong = (UnsignedLong)object;
        return UnsignedLong.unsignedCompare(this.value, unsignedLong.value);
    }

    public int compareTo(long l) {
        if (l < 0L || this.value < 0L || this.value > l) {
            return 1;
        }
        if (this.value == l) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object object) {
        return object instanceof UnsignedLong && this.value == ((UnsignedLong)object).value;
    }

    public int hashCode() {
        return (int)(this.value >>> 32 ^ this.value);
    }

    public String toString() {
        return UnsignedLong.unsignedToString(this.value);
    }

    public static String toHexString(UnsignedLong unsignedLong) {
        return Long.toHexString(unsignedLong.value);
    }

    public static String toOctalString(UnsignedLong unsignedLong) {
        return Long.toOctalString(unsignedLong.value);
    }

    public static String toBinaryString(UnsignedLong unsignedLong) {
        return Long.toBinaryString(unsignedLong.value);
    }

    public static UnsignedLong valueOf(String string) throws NumberFormatException {
        return UnsignedLong.valueOf(string, 10);
    }

    public static UnsignedLong valueOf(String string, int n) throws NumberFormatException {
        return UnsignedLong.make(UnsignedLong.parseUnsignedLong(string, n));
    }

    public static UnsignedLong decode(String string) throws NumberFormatException {
        int n;
        if (string.startsWith("#")) {
            n = 16;
            string = string.substring(1);
        } else if (string.startsWith("0x")) {
            n = 16;
            string = string.substring(2);
        } else if (string.startsWith("0") && string.length() > 1) {
            n = 8;
            string = string.substring(1);
        } else {
            n = 10;
        }
        return UnsignedLong.valueOf(string, n);
    }

    public UnsignedLong add(UnsignedLong unsignedLong) {
        return this.makeIfDifferent(this.value + unsignedLong.value);
    }

    public UnsignedLong subtract(UnsignedLong unsignedLong) {
        return this.makeIfDifferent(this.value - unsignedLong.value);
    }

    public UnsignedLong multiply(UnsignedLong unsignedLong) {
        return this.makeIfDifferent(this.value * unsignedLong.value);
    }

    public UnsignedLong divide(UnsignedLong unsignedLong) throws ArithmeticException {
        return this.makeIfDifferent(UnsignedLong.unsignedDivide(this.value, unsignedLong.value));
    }

    public UnsignedLong mod(UnsignedLong unsignedLong) throws ArithmeticException {
        return this.makeIfDifferent(UnsignedLong.unsignedMod(this.value, unsignedLong.value));
    }

    public UnsignedLong shiftLeft(int n) {
        if (n < 0) {
            return this.shiftRight(-n);
        }
        if (n >= 64) {
            return ZERO;
        }
        return this.makeIfDifferent(this.value << n);
    }

    public UnsignedLong shiftRight(int n) {
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        if (n >= 64) {
            return ZERO;
        }
        return this.makeIfDifferent(this.value >>> n);
    }

    public UnsignedLong and(UnsignedLong unsignedLong) {
        return this.makeIfDifferent(this.value & unsignedLong.value);
    }

    public UnsignedLong or(UnsignedLong unsignedLong) {
        return this.makeIfDifferent(this.value | unsignedLong.value);
    }

    public UnsignedLong xor(UnsignedLong unsignedLong) {
        return this.makeIfDifferent(this.value ^ unsignedLong.value);
    }

    public UnsignedLong not() {
        return UnsignedLong.make(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean testBit(int n) {
        if (n < 0 || n >= 64) {
            return false;
        }
        return (this.value & 1L << n) != 0L;
    }

    public UnsignedLong setBit(int n) {
        if (n < 0 || n >= 64) {
            return this;
        }
        return this.makeIfDifferent(this.value | (long)(1 << n));
    }

    public UnsignedLong clearBit(int n) {
        if (n < 0 || n >= 64) {
            return this;
        }
        return this.makeIfDifferent(this.value & (long)(~(1 << n)));
    }

    public UnsignedLong min(UnsignedLong unsignedLong) {
        if (UnsignedLong.unsignedCompare(this.value, unsignedLong.value) < 0) {
            return this;
        }
        return unsignedLong;
    }

    public UnsignedLong max(UnsignedLong unsignedLong) {
        if (UnsignedLong.unsignedCompare(this.value, unsignedLong.value) > 0) {
            return this;
        }
        return unsignedLong;
    }

    static int unsignedCompare(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l + Long.MIN_VALUE < l2 + Long.MIN_VALUE) {
            return -1;
        }
        return 1;
    }

    static long unsignedMultiply(long l, long l2) {
        return l * l2;
    }

    static long unsignedDivide(long l, long l2) throws ArithmeticException {
        if (l >= 0L) {
            if (l2 >= 0L) {
                return l / l2;
            }
            return 0L;
        }
        if (l2 < 0L) {
            if (l < l2) {
                return 0L;
            }
            return 1L;
        }
        if ((l2 & 1L) == 0L) {
            long l3 = l >>> 1;
            long l4 = l2 >>> 1;
            return l3 / l4;
        }
        if (l2 == 1L) {
            return l;
        }
        long l5 = l & Long.MAX_VALUE;
        long l6 = l5 / l2;
        long l7 = l5 % l2;
        long l8 = Long.MAX_VALUE / l2;
        long l9 = Long.MAX_VALUE % l2 + 1L;
        long l10 = l8 + l6;
        if (l9 + l7 >= l2) {
            ++l10;
        }
        return l10;
    }

    static long unsignedMod(long l, long l2) {
        return l - l2 * UnsignedLong.unsignedDivide(l, l2);
    }

    static String unsignedToString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        long l2 = l & 1L;
        long l3 = l >>> 1;
        long l4 = l3 % 5L * 2L + l2;
        long l5 = l3 / 5L;
        return Long.toString(l5) + Long.toString(l4);
    }

    static long parseUnsignedLong(String string, int n) throws NumberFormatException {
        if (string.startsWith("-")) {
            throw new NumberFormatException("negative unsigned");
        }
        try {
            return Long.parseLong(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            int n2 = string.length();
            long l = Long.parseLong(string.substring(0, n2 - 1), n);
            if (l > UnsignedLong.unsignedDivide(-1L, n)) {
                throw new NumberFormatException("unrepresentable unsigned");
            }
            long l2 = l * (long)n;
            long l3 = Long.parseLong(string.substring(n2 - 1), n);
            long l4 = l2 + l3;
            if (l4 >= 0L) {
                throw new NumberFormatException("unrepresentable unsigned");
            }
            return l4;
        }
    }
}

