/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.Trace;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ObjectName;
import javax.management.loading.MLet;

public final class ClassLoaderRepositorySupport
implements ModifiableClassLoaderRepository {
    private ClassLoader[] loaders = new ClassLoader[0];
    private final Hashtable search = new Hashtable(10);
    private final Hashtable loadersWithNames = new Hashtable(10);
    private static final String dbgTag = "ClassLoaderRepositorySupport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean add(ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        ClassLoaderRepositorySupport classLoaderRepositorySupport = this;
        synchronized (classLoaderRepositorySupport) {
            int n = this.loaders.length;
            ClassLoader[] classLoaderArray = new ClassLoader[n + 1];
            System.arraycopy(this.loaders, 0, classLoaderArray, 0, n);
            classLoaderArray[n] = classLoader;
            this.loaders = classLoaderArray;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        ClassLoaderRepositorySupport classLoaderRepositorySupport = this;
        synchronized (classLoaderRepositorySupport) {
            int n = this.loaders.length;
            ClassLoader[] classLoaderArray = this.loaders;
            int n2 = 0;
            while (n2 < n) {
                ClassLoader classLoader = classLoaderArray[n2];
                if (classLoader != null && (classLoader == object || classLoader.equals(object))) {
                    int n3 = n - 1;
                    ClassLoader[] classLoaderArray2 = new ClassLoader[n3];
                    if (n2 > 0) {
                        System.arraycopy(classLoaderArray, 0, classLoaderArray2, 0, n2);
                    }
                    if (n2 < n3) {
                        System.arraycopy(classLoaderArray, n2 + 1, classLoaderArray2, n2, n3 - n2);
                    }
                    this.loaders = classLoaderArray2;
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public final Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(this.loaders, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("loadClassWithout", string + "\twithout " + classLoader);
        }
        if (classLoader == null) {
            return this.loadClass(this.loaders, string, classLoader);
        }
        this.startValidSearch(classLoader, string);
        try {
            Class clazz = this.loadClass(this.loaders, string, classLoader);
            Object var5_4 = null;
            this.stopValidSearch(classLoader, string);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stopValidSearch(classLoader, string);
            throw throwable;
        }
    }

    private final Class loadClass(ClassLoader[] classLoaderArray, String string, ClassLoader classLoader) throws ClassNotFoundException {
        int n = classLoaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                ClassLoader classLoader2 = classLoaderArray[n2];
                if (!(classLoader2 == null || classLoader2 == classLoader || classLoader != null && classLoader.equals(classLoader2))) {
                    if (ClassLoaderRepositorySupport.isTraceOn()) {
                        ClassLoaderRepositorySupport.trace("loadClass", "trying loader = " + classLoader2);
                    }
                    if (classLoader2 instanceof MLet) {
                        return ((MLet)classLoader2).loadClass(string, null);
                    }
                    return classLoader2.loadClass(string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++n2;
        }
        throw new ClassNotFoundException(string);
    }

    private final synchronized void startValidSearch(ClassLoader classLoader, String string) throws ClassNotFoundException {
        Vector<ClassLoader> vector = (Vector<ClassLoader>)this.search.get(string);
        if (vector != null && vector.contains(classLoader)) {
            if (ClassLoaderRepositorySupport.isTraceOn()) {
                ClassLoaderRepositorySupport.trace("startValidSearch", "already requested loader=" + classLoader + " class= " + string);
            }
            throw new ClassNotFoundException(string);
        }
        if (vector == null) {
            vector = new Vector<ClassLoader>(1);
            this.search.put(string, vector);
        }
        vector.addElement(classLoader);
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("startValidSearch", "loader=" + classLoader + " class= " + string);
        }
    }

    private final synchronized void stopValidSearch(ClassLoader classLoader, String string) {
        Vector vector = (Vector)this.search.get(string);
        if (vector != null) {
            vector.removeElement(classLoader);
            if (ClassLoaderRepositorySupport.isTraceOn()) {
                ClassLoaderRepositorySupport.trace("stopValidSearch", "loader=" + classLoader + " class= " + string);
            }
        }
    }

    public final void addClassLoader(ClassLoader classLoader) {
        this.add(classLoader);
    }

    public final void removeClassLoader(ClassLoader classLoader) {
        this.remove(classLoader);
    }

    public final synchronized void addClassLoader(ObjectName objectName, ClassLoader classLoader) {
        this.loadersWithNames.put(objectName, classLoader);
        this.add(classLoader);
    }

    public final synchronized void removeClassLoader(ObjectName objectName) {
        ClassLoader classLoader = (ClassLoader)this.loadersWithNames.remove(objectName);
        this.remove(classLoader);
    }

    public final ClassLoader getClassLoader(ObjectName objectName) {
        return (ClassLoader)this.loadersWithNames.get(objectName);
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        ClassLoaderRepositorySupport.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        ClassLoaderRepositorySupport.debug(dbgTag, string, string2);
    }
}

