/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager.usm;

import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.snmp.usm.SnmpUsm;
import com.sun.jdmk.snmp.usm.SnmpUsmEnginePeer;
import com.sun.jdmk.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.jdmk.trace.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpUnknownModelException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParams;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;
import javax.management.snmp.manager.SnmpV3Parameters;
import javax.management.snmp.manager.usm.SnmpUsmParameters;

public class SnmpUsmPeer
extends SnmpPeer {
    SnmpUsmEnginePeer peer = null;
    SnmpEngineImpl engine = null;
    SnmpUsm model = null;
    private boolean authoritative = false;
    String dbgTag = "SnmpUsmPeer";

    public SnmpUsmPeer(SnmpEngine snmpEngine, String string) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(string);
        this.init(snmpEngine, null, true);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, InetAddress inetAddress) throws SnmpUnknownModelException, SnmpStatusException {
        super(inetAddress);
        this.init(snmpEngine, null, true);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, String string, int n) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(string, n);
        this.init(snmpEngine, null, true);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, String string, SnmpEngineId snmpEngineId) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(string);
        if (snmpEngineId == null) {
            this.authoritative = true;
        }
        this.init(snmpEngine, snmpEngineId, false);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, InetAddress inetAddress, SnmpEngineId snmpEngineId) throws SnmpUnknownModelException, SnmpStatusException {
        super(inetAddress);
        if (snmpEngineId == null) {
            this.authoritative = true;
        }
        this.init(snmpEngine, snmpEngineId, false);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, String string, int n, SnmpEngineId snmpEngineId) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(string, n);
        if (snmpEngineId == null) {
            this.authoritative = true;
        }
        this.init(snmpEngine, snmpEngineId, false);
    }

    private void init(SnmpEngine snmpEngine, SnmpEngineId snmpEngineId, boolean bl) throws SnmpUnknownModelException, SnmpStatusException {
        this.engine = (SnmpEngineImpl)snmpEngine;
        this.model = (SnmpUsm)this.engine.getSecuritySubSystem().getModel(3);
        if (bl) {
            this.processEngineIdDiscovery();
        } else {
            this.setEngineId(snmpEngineId);
        }
        if (this.engine.getEngineId().equals(this.getEngineId())) {
            if (this.isTraceOn()) {
                this.trace("init", "Warning, discovered engine id [" + this.getEngineId() + "] is equal to local one [" + this.engine.getEngineId() + "] \n");
            }
            throw new SnmpStatusException("Discovered engine id [ " + this.getEngineId() + "] is equal to local one [" + this.engine.getEngineId() + "]");
        }
    }

    public boolean isTimelinessSynchronized() {
        if (this.peer == null) {
            return false;
        }
        return this.peer.getAuthoritativeEngineBoots() != 0 || this.peer.getAuthoritativeEngineTime() != 0;
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public int getEngineBoots() {
        if (this.peer == null) {
            return 0;
        }
        return this.peer.getAuthoritativeEngineBoots();
    }

    public int getEngineTime() {
        if (this.peer == null) {
            return 0;
        }
        return this.peer.getAuthoritativeEngineTime();
    }

    private void setEngineId(SnmpEngineId snmpEngineId) {
        if (snmpEngineId != null) {
            this.peer = this.model.getEnginePeer(snmpEngineId);
        }
    }

    public SnmpEngineId getEngineId() {
        if (this.peer == null) {
            return null;
        }
        return this.peer.getAuthoritativeEngineId();
    }

    public void processUsmTimelinessDiscovery() throws SnmpStatusException {
        if (this.peer == null) {
            throw new IllegalArgumentException("No engine Id, this peer can't be used for timeliness discovery.");
        }
        if (this.getParams() instanceof SnmpUsmParameters) {
            SnmpUsmParameters snmpUsmParameters = (SnmpUsmParameters)this.getParams();
            if ((snmpUsmParameters.getSecurityLevel() & 1) != 0) {
                if (snmpUsmParameters.getPrincipal() != null) {
                    this.processUsmDiscovery(snmpUsmParameters.getPrincipal());
                    return;
                }
            } else {
                if (this.isDebugOn()) {
                    this.debug("processUsmTimelinessDiscovery", "Discovery must be done in an authenticated way.");
                }
                throw new SnmpStatusException(249, 0);
            }
        }
        if (this.isDebugOn()) {
            this.debug("processUsmTimelinessDiscovery", "Parameters are not SnmpUsmParameters. Can't process discovery");
        }
        throw new SnmpStatusException("Parameters are not SnmpUsmParameters. Can't process discovery");
    }

    public void setParams(SnmpParams snmpParams) {
        if (snmpParams instanceof SnmpUsmParameters) {
            SnmpUsmParameters snmpUsmParameters = (SnmpUsmParameters)snmpParams;
            snmpUsmParameters.setEngineId(this.getEngineId());
        }
        super.setParams(snmpParams);
    }

    SnmpUsm getSecurityModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEngineIdDiscovery() throws SnmpStatusException {
        SnmpParams snmpParams = null;
        SnmpSession snmpSession = null;
        if (this.peer == null) {
            try {
                snmpParams = this.getParams();
                SnmpUsmParameters snmpUsmParameters = null;
                try {
                    snmpUsmParameters = new SnmpUsmParameters(this.engine);
                }
                catch (SnmpUnknownModelException snmpUnknownModelException) {
                    if (this.isTraceOn()) {
                        this.trace("processEngineIdDiscovery", "Failed " + snmpUnknownModelException);
                    }
                    Object var6_6 = null;
                    this.setParams(snmpParams);
                    snmpSession.destroySession();
                    return;
                }
                SnmpUsmSecurityParameters snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpUsmParameters.getSecurityParameters();
                this.setParams(snmpUsmParameters);
                snmpSession = new SnmpSession(this.engine, "Discovery session", this);
                this.discoverEngineId(snmpSession, snmpUsmParameters);
                if (this.isTraceOn()) {
                    this.trace("processEngineIdDiscovery", "Engine Id : " + this.getEngineId());
                }
                Object var6_7 = null;
                this.setParams(snmpParams);
                snmpSession.destroySession();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.setParams(snmpParams);
                snmpSession.destroySession();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUsmDiscovery(String string) throws SnmpStatusException {
        SnmpParams snmpParams = this.getParams();
        SnmpUsmParameters snmpUsmParameters = null;
        try {
            snmpUsmParameters = new SnmpUsmParameters(this.engine, string);
        }
        catch (SnmpUnknownModelException snmpUnknownModelException) {
            if (this.isTraceOn()) {
                this.trace("processUsmDiscovery", "Failed. Can't happen." + snmpUnknownModelException);
            }
            return;
        }
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpUsmParameters.getSecurityParameters();
        this.setParams(snmpUsmParameters);
        SnmpSession snmpSession = new SnmpSession(this.engine, "Discovery session", this);
        try {
            if (this.peer == null) {
                this.discoverEngineId(snmpSession, snmpUsmParameters);
            } else {
                this.peer.reset();
            }
            snmpUsmSecurityParameters.setAuthoritativeEngineId(this.getEngineId());
            this.discoverTimelinessParams(snmpSession, snmpUsmParameters);
            if (this.isTraceOn()) {
                this.trace("processUsmDiscovery", "Result :\nEngine Id : " + this.getEngineId() + "\n" + "Engine nb boots : " + this.getEngineBoots() + "\n" + "Engine time : " + this.getEngineTime());
            }
            Object var7_7 = null;
            this.setParams(snmpParams);
            snmpSession.destroySession();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setParams(snmpParams);
            snmpSession.destroySession();
            throw throwable;
        }
    }

    private void discoverEngineId(SnmpSession snmpSession, SnmpV3Parameters snmpV3Parameters) throws SnmpStatusException {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpV3Parameters.getSecurityParameters();
        snmpUsmSecurityParameters.setAuthoritativeEngineBoots(0);
        snmpUsmSecurityParameters.setAuthoritativeEngineTime(0);
        snmpV3Parameters.setSecurityLevel(0);
        SnmpRequest snmpRequest = snmpSession.snmpGetRequest(this, null, snmpVarBindList);
        boolean bl = snmpRequest.waitForCompletion(this.getTimeout());
        if (!bl || snmpRequest.getErrorStatus() != 0 || !snmpRequest.isReport()) {
            if (this.isDebugOn()) {
                this.debug("discoverEngineId", "An error occured when processing Engine discovery. Request status : " + SnmpRequest.snmpErrorToString(snmpRequest.getErrorStatus()));
            }
            if (snmpRequest.getErrorStatus() == 247 && this.isDebugOn()) {
                this.debug("discoverEngineId", "The received engine Id is invalid or is equal to the local one.");
            }
            throw new SnmpStatusException(snmpRequest.getErrorStatus());
        }
        SnmpUsmSecurityParameters snmpUsmSecurityParameters2 = (SnmpUsmSecurityParameters)snmpRequest.getResponseSecurityParameters();
        this.setEngineId(snmpUsmSecurityParameters2.getAuthoritativeEngineId());
        if (this.isDebugOn()) {
            this.debug("discoverEngineId", "Result :\nEngine Id : " + this.getEngineId());
        }
    }

    private void discoverTimelinessParams(SnmpSession snmpSession, SnmpV3Parameters snmpV3Parameters) throws SnmpStatusException {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpV3Parameters.getSecurityParameters();
        snmpUsmSecurityParameters.setAuthoritativeEngineBoots(0);
        snmpUsmSecurityParameters.setAuthoritativeEngineTime(0);
        snmpV3Parameters.setSecurityLevel(1);
        SnmpRequest snmpRequest = snmpSession.snmpGetRequest(this, null, snmpVarBindList);
        boolean bl = snmpRequest.waitForCompletion(this.getTimeout());
        if (!bl || snmpRequest.getErrorStatus() != 0 || !snmpRequest.isReport()) {
            if (this.isDebugOn()) {
                this.debug("discoverTimelinessParams", "An error occured when processing Engine discovery. Request status : " + SnmpRequest.snmpErrorToString(snmpRequest.getErrorStatus()));
            }
            throw new SnmpStatusException(snmpRequest.getErrorStatus());
        }
        if (snmpRequest.isReport()) {
            SnmpVarBind snmpVarBind;
            SnmpOid snmpOid;
            SnmpOid snmpOid2;
            SnmpVarBindList snmpVarBindList2 = snmpRequest.getReportVarBindList();
            if (snmpVarBindList2.size() == 0) {
                throw new SnmpStatusException("Received an empty report");
            }
            if (this.isDebugOn()) {
                this.debug("discoverTimelinessParams", "Received a report, list size is : " + snmpVarBindList2.size());
            }
            if ((snmpOid2 = new SnmpOid("1.3.6.1.6.3.15.1.1.2.0")).equals(snmpOid = (snmpVarBind = snmpVarBindList2.getVarBindAt(0)).getOid())) {
                if (this.isDebugOn()) {
                    this.debug("discoverTimelinessParams", "Received a notInTimeWindow report. Discovery suceeded.");
                }
            } else {
                throw new SnmpStatusException("An error occured when processing Engine discovery. Not received the right report : " + snmpOid + ". Expected notInTimeWindow [1.3.6.1.6.3.15.1.1.2.0]");
            }
        }
        if (this.isDebugOn()) {
            this.debug("discoverTimelinessParams", "Result :\nEngine nb boots : " + this.getEngineBoots() + "\n" + "Engine time : " + this.getEngineTime());
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

