/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.snmp.JdmkEngineFactory;
import com.sun.jdmk.snmp.SnmpPduFactoryBER;
import com.sun.jdmk.trace.Trace;
import java.io.Serializable;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineFactory;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpEngineParameters;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTimeticks;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpOptions;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpPollRequest;
import javax.management.snmp.manager.SnmpQManager;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpRequestHandler;
import javax.management.snmp.manager.SnmpResponseHandler;
import javax.management.snmp.manager.SnmpSocket;

public class SnmpSession
implements SnmpDefinitions,
Runnable,
Serializable {
    private SnmpEngine engine = null;
    private SnmpPduFactory pduFactory = new SnmpPduFactoryBER();
    private boolean hide = true;
    String usedThread = null;
    SnmpResponseHandler snmpRespHdlr = null;
    boolean isBeingDestroyed = false;
    private Thread _myThread = null;
    private Stack _respq = new Stack();
    private SnmpSocket _theSocket = null;
    private SnmpPeer _defaultPeer = null;
    private SnmpRequest _syncReq;
    public String sessionName;
    private Hashtable _requestList = new Hashtable();
    public SnmpOptions snmpOptions = new SnmpOptions();
    private static final SnmpOid sysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    private static final SnmpOid snmpTrapOidOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");
    private transient long startUpTime = 0L;
    SnmpQManager snmpQman = null;
    String dbgTag = "SnmpSession";

    public SnmpSession(SnmpEngine snmpEngine, String string, SnmpPeer snmpPeer) throws SnmpStatusException, IllegalArgumentException {
        if (snmpEngine == null) {
            throw new IllegalArgumentException("Engine can't be null");
        }
        this.engine = snmpEngine;
        this.initialize(string, snmpPeer);
    }

    public SnmpSession(String string, SnmpPeer snmpPeer) throws SnmpStatusException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), string, snmpPeer);
    }

    public SnmpSession(String string) throws SnmpStatusException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), string, null);
    }

    public SnmpSession(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory, String string, SnmpPeer snmpPeer) throws SnmpStatusException, IllegalArgumentException {
        if (snmpEngineFactory == null) {
            snmpEngineFactory = new JdmkEngineFactory();
        }
        if (snmpEngineParameters == null) {
            snmpEngineParameters = new SnmpEngineParameters();
        }
        this.engine = snmpEngineFactory.createEngine(snmpEngineParameters);
        this.initialize(string, snmpPeer);
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public final String getName() {
        return this.sessionName;
    }

    public final SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public final synchronized void setPduFactory(SnmpPduFactory snmpPduFactory) {
        if (snmpPduFactory == null) {
            snmpPduFactory = new SnmpPduFactoryBER();
        }
        this.pduFactory = snmpPduFactory;
    }

    public synchronized void hideInvalidResponseError(boolean bl) {
        this.hide = bl;
    }

    public synchronized boolean isInvalidResponseErrorHidden() {
        return this.hide;
    }

    public final void setName(String string) {
        if (string == null) {
            string = "UnnamedSession";
        } else {
            this.sessionName = string;
        }
    }

    public final SnmpPeer getDefaultPeer() {
        return this._defaultPeer;
    }

    public final void setDefaultPeer(SnmpPeer snmpPeer) {
        this._defaultPeer = snmpPeer;
    }

    public final synchronized SnmpEngineId getEngineId() {
        return this.engine.getEngineId();
    }

    public final int getResponsePktSize() {
        return this._theSocket.getResponsePktSize();
    }

    public final void setResponsePktSize(int n) {
        this._theSocket.setResponsePktSize(n);
    }

    public final synchronized int getPktsErrors() {
        return this._theSocket.getPktsErrors();
    }

    public final synchronized int getInPkts() {
        return this._theSocket.getInPkts();
    }

    public final synchronized int getOutPkts() {
        return this._theSocket.getOutPkts();
    }

    public final synchronized void performResetPktStatistics() {
        this._theSocket.performResetPktStatistics();
    }

    public final String toString() {
        return "SnmpSession : " + this.sessionName;
    }

    final SnmpSocket getSocket() {
        return this._theSocket;
    }

    final void setSocket(SnmpSocket snmpSocket) throws SocketException {
        if (!snmpSocket.isValid()) {
            throw new SocketException("Cannot set an invalid socket.");
        }
        this._theSocket = snmpSocket;
    }

    final synchronized boolean isEquivalent(SnmpSession snmpSession) {
        return this == snmpSession;
    }

    public final synchronized boolean isSessionActive() {
        return this._myThread != null && this._myThread.isAlive();
    }

    public synchronized boolean syncInProgress() {
        return this._syncReq != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroySession() {
        this.isBeingDestroyed = true;
        this._theSocket.isBeingDestroyed = true;
        this.cancelAllRequests();
        this.cancelAllResponses();
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            this._theSocket.close();
            this._theSocket = null;
        }
        SnmpQManager.decNbSessions();
        this.killSessionThread();
    }

    public synchronized Vector getAllRequestsForPeer(SnmpPeer snmpPeer) {
        Vector<SnmpRequest> vector = new Vector<SnmpRequest>();
        Enumeration enumeration = this._requestList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpRequest snmpRequest = (SnmpRequest)enumeration.nextElement();
            if (snmpRequest.getPeer() != snmpPeer) continue;
            vector.addElement(snmpRequest);
        }
        return vector;
    }

    public final void cancelAllRequests() {
        if (this._requestList.isEmpty()) {
            return;
        }
        Enumeration enumeration = this._requestList.elements();
        while (enumeration.hasMoreElements()) {
            ((SnmpRequest)enumeration.nextElement()).cancelRequest();
        }
        this._requestList.clear();
    }

    public boolean checkResponseFor(SnmpRequest snmpRequest) {
        return this._respq.contains(snmpRequest);
    }

    public boolean thisSessionContext() {
        return Thread.currentThread() == this.getDispatcher();
    }

    public final SnmpRequest snmpGetRequest(SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        return this.makeAsyncRequest(snmpPeer, 160, snmpRequestHandler, snmpVarBindList);
    }

    public final SnmpRequest snmpGetRequest(SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        return this.snmpGetRequest(this._defaultPeer, snmpRequestHandler, snmpVarBindList);
    }

    public final SnmpRequest snmpGetNextRequest(SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        return this.makeAsyncRequest(snmpPeer, 161, snmpRequestHandler, snmpVarBindList);
    }

    public final SnmpRequest snmpGetNextRequest(SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        return this.snmpGetNextRequest(this._defaultPeer, snmpRequestHandler, snmpVarBindList);
    }

    public final SnmpRequest snmpGetBulkRequest(SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList, int n, int n2) throws SnmpStatusException {
        return this.makeAsyncBulkRequest(snmpPeer, snmpRequestHandler, snmpVarBindList, n, n2);
    }

    public final SnmpRequest snmpGetBulkRequest(SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList, int n, int n2) throws SnmpStatusException {
        return this.snmpGetBulkRequest(this._defaultPeer, snmpRequestHandler, snmpVarBindList, n, n2);
    }

    public final SnmpRequest snmpSetRequest(SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        if (snmpVarBindList.isEmpty()) {
            throw new SnmpStatusException("VarBindList is empty for SNMP Set.");
        }
        if (!snmpPeer.allowSnmpSets()) {
            throw new SnmpStatusException("Parameters may not have been configured for doing SNMP SET's.");
        }
        if (!snmpVarBindList.checkForValidValues()) {
            throw new SnmpStatusException("One or more variable binding has no valid value.");
        }
        return this.makeAsyncRequest(snmpPeer, 163, snmpRequestHandler, snmpVarBindList);
    }

    public final SnmpRequest snmpSetRequest(SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        return this.snmpSetRequest(this._defaultPeer, snmpRequestHandler, snmpVarBindList);
    }

    public final SnmpRequest snmpGetPollRequest(SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList, int n) throws SnmpStatusException {
        return this.makeAsyncPollRequest(snmpPeer, 160, snmpRequestHandler, n, snmpVarBindList);
    }

    public final SnmpRequest snmpGetPollRequest(SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList, int n) throws SnmpStatusException {
        return this.snmpGetPollRequest(this._defaultPeer, snmpRequestHandler, snmpVarBindList, n);
    }

    public final SnmpRequest snmpGetNextPollRequest(SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList, int n) throws SnmpStatusException {
        return this.makeAsyncPollRequest(snmpPeer, 161, snmpRequestHandler, n, snmpVarBindList);
    }

    public final SnmpRequest snmpGetNextPollRequest(SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList, int n) throws SnmpStatusException {
        return this.snmpGetNextPollRequest(this._defaultPeer, snmpRequestHandler, snmpVarBindList, n);
    }

    public final SnmpRequest snmpInformRequest(SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? (SnmpVarBindList)snmpVarBindList.clone() : new SnmpVarBindList();
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        return this.makeAsyncRequest(snmpPeer, 166, snmpRequestHandler, snmpVarBindList2);
    }

    public final SnmpRequest snmpInformRequest(SnmpRequestHandler snmpRequestHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        return this.snmpInformRequest(this._defaultPeer, snmpRequestHandler, snmpOid, snmpVarBindList);
    }

    public final SnmpRequest snmpWalkUntilRequest(SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList, SnmpOid snmpOid) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        SnmpPollRequest snmpPollRequest = new SnmpPollRequest(this, snmpPeer, snmpRequestHandler, 253);
        snmpPollRequest.setOptions(this.snmpOptions.getOptions());
        snmpPollRequest.startPoll(snmpVarBindList, snmpOid, true, 0);
        return snmpPollRequest;
    }

    public final SnmpRequest snmpWalkUntilRequest(SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList, SnmpOid snmpOid) throws SnmpStatusException {
        return this.snmpWalkUntilRequest(this._defaultPeer, snmpRequestHandler, snmpVarBindList, snmpOid);
    }

    final synchronized void addRequest(SnmpRequest snmpRequest) throws SnmpStatusException {
        if (this.isBeingDestroyed) {
            return;
        }
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        this._requestList.put(snmpRequest, snmpRequest);
    }

    final synchronized void deleteRequest(SnmpRequest snmpRequest) {
        this._requestList.remove(snmpRequest);
        if (this._syncReq != null && this._syncReq == snmpRequest) {
            this.resetSyncMode();
        }
    }

    private synchronized void setSyncMode(SnmpRequest snmpRequest) {
        this._syncReq = snmpRequest;
    }

    private synchronized void resetSyncMode() {
        if (this._syncReq == null) {
            return;
        }
        this._syncReq = null;
        if (this.thisSessionContext()) {
            return;
        }
        this.notifyAll();
    }

    final SnmpRequest makeAsyncRequest(SnmpPeer snmpPeer, int n, SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        SnmpRequest snmpRequest = new SnmpRequest(this, snmpPeer, snmpRequestHandler, n);
        snmpRequest.setOptions(this.snmpOptions.getOptions());
        snmpRequest.start(snmpVarBindList, true, 0L);
        return snmpRequest;
    }

    final SnmpRequest makeAsyncBulkRequest(SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, SnmpVarBindList snmpVarBindList, int n, int n2) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        SnmpRequest snmpRequest = new SnmpRequest(this, snmpPeer, snmpRequestHandler, n, n2);
        snmpRequest.setOptions(this.snmpOptions.getOptions());
        snmpRequest.start(snmpVarBindList, true, 0L);
        return snmpRequest;
    }

    final SnmpPollRequest makeAsyncPollRequest(SnmpPeer snmpPeer, int n, SnmpRequestHandler snmpRequestHandler, int n2, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        SnmpPollRequest snmpPollRequest = new SnmpPollRequest(this, snmpPeer, snmpRequestHandler, n);
        snmpPollRequest.setPollFrequency(n2);
        snmpPollRequest.setOptions(this.snmpOptions.getOptions());
        snmpPollRequest.startPoll(snmpVarBindList, true, 0);
        return snmpPollRequest;
    }

    public boolean anyPendingResponses() {
        return !this._respq.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            if (this._myThread == null) {
                return;
            }
            this._myThread = Thread.currentThread();
            this.usedThread = this._myThread.toString();
            this._myThread.setPriority(5);
        }
        SnmpRequest snmpRequest = null;
        while (true) {
            SnmpSession snmpSession2 = this;
            synchronized (snmpSession2) {
                if (this._myThread == null) {
                    break;
                }
                try {
                    snmpRequest = this.nextResponse(0L);
                }
                catch (ThreadDeath threadDeath) {
                    this._myThread = null;
                    if (this.isDebugOn()) {
                        this.debug("run", "Session thread unexpectedly shutting down " + this.sessionName);
                    }
                    throw threadDeath;
                }
            }
            if (snmpRequest == null) continue;
            this.processResponse(snmpRequest);
        }
        if (this.isTraceOn()) {
            this.trace("run", "Session thread shutting down " + this.sessionName);
        }
        this._myThread = null;
    }

    private void processResponse(SnmpRequest snmpRequest) {
        while (snmpRequest != null && this._myThread != null) {
            try {
                if (snmpRequest == null) continue;
                if (this.isTraceOn()) {
                    this.trace("processResponse", "Processing response to req = " + snmpRequest.getRequestId());
                }
                snmpRequest.processResponse();
                snmpRequest = null;
            }
            catch (Exception exception) {
                if (this.isDebugOn()) {
                    this.debug("processResponse", exception);
                }
                snmpRequest = null;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (this.isDebugOn()) {
                    this.debug("processResponse", "Out of memory error in session thread " + this.sessionName);
                    this.debug("processResponse", outOfMemoryError);
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
    }

    public void finalize() {
        if (this._respq != null) {
            this._respq.removeAllElements();
        }
        this._respq = null;
        if (this._theSocket != null) {
            this._theSocket.close();
        }
        this._theSocket = null;
        if (this.isTraceOn()) {
            this.trace("finalize", "Shutting all servers");
        }
        this.snmpQman = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForResponse(SnmpRequest snmpRequest, long l) {
        if (!snmpRequest.inProgress()) {
            return;
        }
        this.setSyncMode(snmpRequest);
        if (this.isTraceOn()) {
            this.trace("waitForResponse", "Session switching to sync mode for request " + snmpRequest.getRequestId());
        }
        long l2 = l <= 0L ? System.currentTimeMillis() + 6000000L : System.currentTimeMillis() + l;
        while (snmpRequest.inProgress() || this.syncInProgress()) {
            l = l2 - System.currentTimeMillis();
            if (l <= 0L) break;
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                if (!this._respq.removeElement(snmpRequest)) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                this.processResponse(snmpRequest);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("waitForResponse", exception);
            }
        }
        this.resetSyncMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResponse(SnmpRequest snmpRequest) {
        if (this.isBeingDestroyed) {
            return;
        }
        SnmpRequest snmpRequest2 = snmpRequest;
        if (this.isSessionActive()) {
            if (this.syncInProgress() && (snmpRequest2 = snmpRequest).isInternalRequest()) {
                if (this.isTraceOn()) {
                    this.trace("addResponse", "Session in sync mode. processing internal request only: " + snmpRequest.getRequestId());
                }
                this.processResponse(snmpRequest);
                return;
            }
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                this._respq.push(snmpRequest);
                this.notifyAll();
            }
        } else if (this.isDebugOn()) {
            this.debug("addResponse", "Peer thread dead. So response is dropped..." + snmpRequest.getRequestId());
        }
    }

    private synchronized void cancelAllResponses() {
        if (this._respq != null) {
            this._syncReq = null;
            this._respq.removeAllElements();
            this.notifyAll();
        }
    }

    private final Thread getDispatcher() {
        return this._myThread;
    }

    private synchronized void initialize(String string, SnmpPeer snmpPeer) throws SnmpStatusException, IllegalArgumentException {
        if (this.engine == null) {
            throw new IllegalArgumentException("The factory returned a null lengine. SnmpSession initilization failed");
        }
        this._defaultPeer = snmpPeer;
        this.sessionName = string;
        if (this.isTraceOn()) {
            this.trace("initialize", "Initializing SNMP session internals");
        }
        if (this._theSocket == null) {
            this.snmpQman = SnmpQManager.incNbSessions();
            this.snmpRespHdlr = new SnmpResponseHandler(this.snmpQman, this);
            this.snmpRespHdlr.setEngine(this.engine);
            try {
                SnmpSocket snmpSocket = new SnmpSocket(this.snmpRespHdlr);
                this.setSocket(snmpSocket);
            }
            catch (SocketException socketException) {
                if (this.isDebugOn()) {
                    this.debug("initialize", "Unable to initialize Snmp Datagram socket");
                    this.debug("initialize", socketException);
                }
                throw new SnmpStatusException("Unable to initialize Snmp Datagram Socket");
            }
        }
        if (this._myThread == null) {
            this._myThread = new Thread(this);
        }
        if (!this._myThread.isAlive()) {
            this._myThread.start();
        }
        this.startUpTime = System.currentTimeMillis();
        if (this.isTraceOn()) {
            this.trace("initialize", "SNMP session internals initialized OK");
        }
    }

    synchronized SnmpRequest nextResponse(long l) {
        if (this._respq.isEmpty()) {
            try {
                if (this.isTraceOn()) {
                    this.trace("nextResponse", "Blocking for response");
                }
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._respq.isEmpty()) {
            return null;
        }
        SnmpRequest snmpRequest = (SnmpRequest)this._respq.firstElement();
        this._respq.removeElementAt(0);
        return snmpRequest;
    }

    private synchronized void killSessionThread() {
        if (this.isSessionActive()) {
            if (this.isTraceOn()) {
                this.trace("killSessionThread", "Destroying session " + this.sessionName);
            }
            if (Thread.currentThread() != this._myThread) {
                this._myThread = null;
                this.notifyAll();
            } else {
                this._myThread = null;
            }
        }
    }

    private long getSysUpTime() {
        return (System.currentTimeMillis() - this.startUpTime) / 10L;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

