/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.trace.Trace;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.manager.MultiplexRequest;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpQManager;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

final class SnmpSendServer
extends Thread
implements Runnable {
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpSendServer";
    private boolean tryMultiplexing = false;
    private int intervalRange = 5000;
    private Vector readyPool;
    private Vector assortedReqList = new Vector();
    boolean isBeingDestroyed = false;

    public SnmpSendServer(ThreadGroup threadGroup, SnmpQManager snmpQManager) {
        super(threadGroup, "SnmpSendServer");
        this.snmpq = snmpQManager;
        this.start();
    }

    public final synchronized void activateMultiplex(boolean bl) {
        this.tryMultiplexing = bl;
    }

    public final synchronized boolean multiplex() {
        return this.tryMultiplexing;
    }

    public synchronized void stopSendServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (this.isTraceOn()) {
            this.trace("run", "Thread Started");
        }
        while (true) {
            try {
                do {
                    this.prepareAndSendRequest();
                } while (!this.isBeingDestroyed);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("run", "Exception in send server");
                this.debug("run", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (this.isDebugOn()) {
                    this.debug("run", "Exiting... Fatal error");
                }
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!this.isDebugOn()) continue;
                this.debug("run", "Out of memory");
                continue;
            }
            catch (Error error) {
                if (this.isDebugOn()) {
                    this.debug("run", error);
                }
                throw error;
            }
            break;
        }
    }

    void fireRequest(SnmpRequest snmpRequest) {
        if (snmpRequest != null && snmpRequest.inProgress()) {
            if (this.isTraceOn()) {
                this.trace("fireRequest", "Firing request directly. -> " + snmpRequest.getRequestId());
            }
            snmpRequest.action();
        }
    }

    void fireRequestList(Vector vector) {
        while (!vector.isEmpty()) {
            SnmpRequest snmpRequest = (SnmpRequest)vector.lastElement();
            if (snmpRequest != null && snmpRequest.inProgress()) {
                this.fireRequest(snmpRequest);
            }
            vector.removeElementAt(vector.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (this.isTraceOn()) {
                this.trace("prepareAndSendRequest", "Blocking for requests");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
            if (this.isBeingDestroyed) {
                return;
            }
        } else if (this.isDebugOn()) {
            this.debug("prepareAndSendRequest", "Requests from a previous block left unprocessed. Will try again");
        }
        if (this.isTraceOn()) {
            this.trace("prepareAndSendRequest", "List of requests to send : " + this.reqListToString(this.readyPool));
        }
        var1_1 = this;
        synchronized (var1_1) {
            if (this.multiplex() && this.readyPool.size() >= 2) ** GOTO lbl25
            this.fireRequestList(this.readyPool);
            return;
lbl-1000:
            // 1 sources

            {
                var2_2 = (SnmpRequest)this.readyPool.lastElement();
                if (var2_2 != null && var2_2.inProgress()) {
                    if (var2_2.allowMultiplex()) {
                        this.addToAssortedList(var2_2);
                    } else {
                        this.fireRequest(var2_2);
                    }
                }
                this.readyPool.removeElementAt(this.readyPool.size() - 1);
lbl25:
                // 2 sources

                ** while (!this.readyPool.isEmpty())
            }
lbl26:
            // 1 sources

            this.fireAssortedRequests();
            this.readyPool.removeAllElements();
        }
    }

    void fireAssortedRequests() {
        if (this.isTraceOn()) {
            this.trace("fireAssortedRequests", "Firing Assorted requests");
        }
        while (!this.assortedReqList.isEmpty()) {
            SimilarRequestList similarRequestList = (SimilarRequestList)this.assortedReqList.lastElement();
            similarRequestList.action();
            this.assortedReqList.removeElementAt(this.assortedReqList.size() - 1);
        }
    }

    void addToAssortedList(SnmpRequest snmpRequest) {
        SimilarRequestList similarRequestList;
        if (this.assortedReqList.isEmpty()) {
            SimilarRequestList similarRequestList2 = new SimilarRequestList(snmpRequest);
            this.assortedReqList.addElement(similarRequestList2);
            return;
        }
        Enumeration enumeration = this.assortedReqList.elements();
        while (enumeration.hasMoreElements()) {
            similarRequestList = (SimilarRequestList)enumeration.nextElement();
            if (!similarRequestList.belongsHere(snmpRequest)) continue;
            similarRequestList.addElement(snmpRequest);
            return;
        }
        similarRequestList = new SimilarRequestList(snmpRequest);
        this.assortedReqList.addElement(similarRequestList);
    }

    final String reqListToString(Vector vector) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(vector.size() * 100);
        Enumeration enumeration = vector.elements();
        stringBuffer.append("RequestId/Options -> ");
        while (enumeration.hasMoreElements()) {
            object = (SnmpRequest)enumeration.nextElement();
            stringBuffer.append(((SnmpRequest)object).getRequestId() + "/" + ((SnmpRequest)object).getOptions() + " ");
        }
        object = stringBuffer.toString();
        stringBuffer = null;
        return object;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    private void takeAnap(long l) {
        try {
            this.wait(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final class SimilarRequestList
    extends Vector {
        SnmpPeer _peer;
        SnmpSession _session;
        int _cmd;
        MultiplexRequest _currentMuxReq;

        SimilarRequestList(SnmpRequest snmpRequest) {
            this._peer = snmpRequest.getPeer();
            this._session = snmpRequest.getSnmpSession();
            this._cmd = snmpRequest.getCommand();
            this.addElement(snmpRequest);
        }

        public SnmpPeer getPeer() {
            return this._peer;
        }

        public SnmpSession getSession() {
            return this._session;
        }

        public int getCommand() {
            return this._cmd;
        }

        public boolean belongsHere(SnmpRequest snmpRequest) {
            if (this._cmd != snmpRequest.getCommand()) {
                return false;
            }
            return this._peer.equals(snmpRequest.getPeer()) && this._session.isEquivalent(snmpRequest.getSnmpSession());
        }

        public String describe() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(this._peer.toString() + " -> ");
            int n = this.size();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(((SnmpRequest)this.elementData[n2]).getRequestId() + " ");
                ++n2;
            }
            return stringBuffer.toString();
        }

        void fireRequestDirect(SnmpRequest snmpRequest) {
            if (snmpRequest != null && snmpRequest.inProgress()) {
                if (SnmpSendServer.this.isTraceOn()) {
                    SnmpSendServer.this.trace("fireRequestDirect", "Firing request directly. -> " + snmpRequest.getRequestId());
                }
                snmpRequest.action();
            }
        }

        public void action() {
            if (SnmpSendServer.this.isTraceOn()) {
                SnmpSendServer.this.trace("action", "List of requests directed to peer : " + this.describe());
            }
            while (!this.isEmpty()) {
                SnmpRequest snmpRequest;
                if (this._currentMuxReq == null) {
                    if (this.size() < 2) {
                        this.fireRequestDirect((SnmpRequest)this.firstElement());
                        this.removeAllElements();
                        break;
                    }
                    this._currentMuxReq = new MultiplexRequest(this.getPeer(), this.getSession(), this.getCommand());
                }
                if (this._currentMuxReq.addRequest(snmpRequest = (SnmpRequest)this.lastElement())) {
                    --this.elementCount;
                    continue;
                }
                this._currentMuxReq.action();
                this._currentMuxReq = null;
            }
            if (this._currentMuxReq != null) {
                this._currentMuxReq.action();
                this._currentMuxReq = null;
            }
        }
    }
}

