/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.internal.snmp.SnmpIncomingResponse;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.trace.Trace;
import java.net.DatagramPacket;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpMsg;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduRequestType;
import javax.management.snmp.SnmpSecurityException;
import javax.management.snmp.manager.SnmpQManager;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

class SnmpResponseHandler {
    SnmpQManager snmpq = null;
    SnmpSession session = null;
    SnmpEngineImpl engine = null;
    String dbgTag = "SnmpResponseHandler";

    public SnmpResponseHandler(SnmpSession snmpSession) {
        this.snmpq = SnmpQManager.getTheInstance();
        this.session = snmpSession;
    }

    public SnmpResponseHandler(SnmpQManager snmpQManager, SnmpSession snmpSession) {
        this.snmpq = snmpQManager;
        this.session = snmpSession;
    }

    public void setEngine(SnmpEngine snmpEngine) {
        this.engine = (SnmpEngineImpl)snmpEngine;
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        if (this.isTraceOn()) {
            this.trace("processDatagram", "Received from peer " + datagramPacket.getAddress().toString() + " Length = " + n + "\nDump : \n" + SnmpMsg.dumpHexBuffer(byArray, 0, n));
        }
        SnmpRequest snmpRequest = null;
        try {
            int n2 = SnmpMsg.getProtocolVersion(datagramPacket.getData());
            SnmpPduFactory snmpPduFactory = this.snmpq.findPduFactory(datagramPacket.getAddress(), datagramPacket.getPort());
            if (snmpPduFactory == null) {
                if (this.isDebugOn()) {
                    this.debug("processDatagram", "Use the SnmpSession pdu factory.");
                }
                snmpPduFactory = this.session.getPduFactory();
            } else if (this.isDebugOn()) {
                this.debug("processDatagram", "Use the SnmpPeer pdu factory.");
            }
            SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = this.engine.getMsgProcessingSubSystem();
            SnmpIncomingResponse snmpIncomingResponse = snmpMsgProcessingSubSystem.getIncomingResponse(n2, snmpPduFactory);
            int n3 = snmpIncomingResponse.getRequestId(byArray);
            if (snmpPduFactory == null) {
                if (this.isDebugOn()) {
                    this.debug("processDatagram", "Dropping packet. Unable to find the pdu factory for = " + datagramPacket.getAddress() + ":" + datagramPacket.getPort());
                }
                return;
            }
            snmpRequest = this.snmpq.removeRequest(n3);
            if (snmpRequest == null) {
                if (this.isDebugOn()) {
                    this.debug("processDatagram", "Dropping packet. Unable to find corresponding for requestId = " + n3);
                }
                return;
            }
            snmpIncomingResponse.setSecurityCache(snmpRequest.getSecurityCache());
            SnmpPdu snmpPdu = null;
            try {
                snmpIncomingResponse.decodeMessage(byArray, n, datagramPacket.getAddress(), datagramPacket.getPort());
                snmpPdu = snmpIncomingResponse.decodeSnmpPdu();
            }
            catch (SnmpSecurityException snmpSecurityException) {
                if (this.isDebugOn()) {
                    this.debug("processDatagram", " Security Exception when unmarshalling, status : " + snmpSecurityException.status);
                }
                snmpRequest.setErrorStatusAndIndex(snmpSecurityException.status, 0);
                snmpRequest.invokeOnResponse(null);
                return;
            }
            if (snmpPdu == null) {
                if (this.isDebugOn()) {
                    this.debug("processDatagram", "Dropping packet. Pdu factory returned a null value");
                }
                return;
            }
            if (!(snmpPdu instanceof SnmpPduRequestType)) {
                if (this.isDebugOn()) {
                    this.debug("processDatagram", "Dropping packet. The packet does not contain a response");
                }
                snmpPdu = null;
                return;
            }
            SnmpPdu snmpPdu2 = snmpPdu;
            snmpRequest.setResponseSecurityParameters(snmpIncomingResponse.getSecurityParameters());
            snmpRequest.invokeOnResponse(snmpPdu2);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("processDatagram", "Exception while processing");
                this.debug("processDatagram", exception);
            }
            if (!this.session.isInvalidResponseErrorHidden()) {
                if (this.isDebugOn()) {
                    this.debug("processDatagram", "Error are not hidden.throw genErr.");
                }
                snmpRequest.setErrorStatusAndIndex(5, 0);
                snmpRequest.invokeOnResponse(null);
            }
            return;
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

