/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpRequestHandler;
import javax.management.snmp.manager.SnmpSession;

final class SnmpPollRequest
extends SnmpRequest {
    private SnmpOid oidKey = null;
    private SnmpVarBindList initialVarBindList = null;
    private int freq = -1;
    static int WALK_ROW_INTERVAL = 100;

    public SnmpPollRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, int n) throws SnmpStatusException {
        super(snmpSession, snmpPeer, snmpRequestHandler, n);
    }

    public final synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(super.toString() + "\n");
        if (this.oidKey == null) {
            stringBuffer.append("Polling Mode. Frequency = " + this.freq);
        } else {
            stringBuffer.append("Mib walking facility");
        }
        return stringBuffer.toString();
    }

    public final synchronized void setPollFrequency(int n, int n2) {
        this.freq = n * 1000 + n2;
    }

    public final synchronized void setPollFrequency(int n) {
        this.setPollFrequency(n, 0);
    }

    public synchronized int getPollFrequency() {
        return this.freq;
    }

    public final synchronized void startPoll(SnmpVarBindList snmpVarBindList, boolean bl, int n) throws SnmpStatusException {
        this.oidKey = null;
        this.initialVarBindList = snmpVarBindList.cloneWithoutValue();
        this.start(snmpVarBindList, true, n);
    }

    public final synchronized void startPoll(SnmpVarBindList snmpVarBindList, SnmpOid snmpOid, boolean bl, int n) throws SnmpStatusException {
        this.oidKey = snmpOid;
        this.initialVarBindList = snmpVarBindList.cloneWithoutValue();
        super.start(snmpVarBindList, true, n);
    }

    synchronized void handleSuccess() {
        SnmpVarBindList snmpVarBindList = this.initialVarBindList;
        long l = this.getPollFrequency();
        if (this.oidKey != null) {
            if (!this.checkIfEndOfTable()) {
                snmpVarBindList = this.getVarBindList();
                l = WALK_ROW_INTERVAL;
            } else {
                l = -1L;
            }
        }
        super.handleSuccess();
        if (this.isAborted() || this.inProgress()) {
            return;
        }
        if (l < 0L) {
            this.deleteRequest();
            return;
        }
        l += this.getPollTimestamp();
        this.setErrorStatusAndIndex(0, 0);
        try {
            super.start(snmpVarBindList, true, l);
        }
        catch (SnmpStatusException snmpStatusException) {
            this.handleInternalError(snmpStatusException.getMessage() + "  While trying to continue polling.");
        }
    }

    final synchronized boolean checkIfEndOfTable() {
        SnmpVarBind snmpVarBind = this.varBindList.getVarBindAt(0);
        if (snmpVarBind.hasVarBindException() || snmpVarBind.oid.compareTo(this.oidKey) >= 0) {
            this.errorStatus = 229;
            return true;
        }
        return false;
    }

    private void init() {
        this.oidKey = null;
        this.initialVarBindList = null;
    }
}

