/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.internal.snmp.SnmpIncomingRequest;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.snmp.JdmkEngineFactory;
import com.sun.jdmk.snmp.SnmpBadSecurityLevelException;
import com.sun.jdmk.snmp.SnmpPduFactoryBER;
import com.sun.jdmk.snmp.SnmpUnknownMsgProcModelException;
import com.sun.jdmk.snmp.SnmpUnknownSecModelException;
import com.sun.jdmk.trace.Trace;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.management.snmp.SnmpAckPdu;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineFactory;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpEngineParameters;
import javax.management.snmp.SnmpMsg;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduRequestType;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.manager.SnmpEventReportHandler;
import javax.management.snmp.manager.SnmpInformListener;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpTrapListener;

public class SnmpEventReportDispatcher
implements Runnable {
    private int snmpInTraps = 0;
    private int snmpInInforms = 0;
    private int snmpInPkts = 0;
    private int snmpInASNParseErrs = 0;
    private int snmpInBadVersions = 0;
    private int snmpInvalidMsgs = 0;
    private int snmpUnknownSecurityModels = 0;
    private int port = 162;
    private final DatagramSocket dSocket;
    private final ObjectList trapListeners = new ObjectList();
    private final ObjectList informListeners = new ObjectList();
    private SnmpPduFactory pduFactory = new SnmpPduFactoryBER();
    private SnmpEngineImpl engine = null;
    private boolean enabled = true;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    String dbgTag = "SnmpEventReportDispatcher";

    public SnmpEventReportDispatcher() throws SocketException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), 162, null);
    }

    public SnmpEventReportDispatcher(int n) throws SocketException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), n, null);
    }

    public SnmpEventReportDispatcher(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory, int n) throws SocketException, IllegalArgumentException {
        this(SnmpEventReportDispatcher.createEngine(snmpEngineParameters, snmpEngineFactory), n, null);
    }

    public SnmpEventReportDispatcher(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory, int n, InetAddress inetAddress) throws SocketException, IllegalArgumentException {
        this(SnmpEventReportDispatcher.createEngine(snmpEngineParameters, snmpEngineFactory), n, inetAddress);
    }

    public SnmpEventReportDispatcher(SnmpEngine snmpEngine, int n) throws SocketException, IllegalArgumentException {
        this(snmpEngine, n, null);
    }

    public SnmpEventReportDispatcher(SnmpEngine snmpEngine, int n, InetAddress inetAddress) throws SocketException, IllegalArgumentException {
        if (snmpEngine == null) {
            throw new IllegalArgumentException("Engine can't be null");
        }
        this.engine = (SnmpEngineImpl)snmpEngine;
        this.port = n;
        this.dSocket = inetAddress != null ? new DatagramSocket(this.port, inetAddress) : new DatagramSocket(this.port);
    }

    public Long getSnmpInTraps() {
        return new Long(this.snmpInTraps);
    }

    public Long getSnmpInInforms() {
        return new Long(this.snmpInInforms);
    }

    public Long getSnmpInPkts() {
        return new Long(this.snmpInPkts);
    }

    public Long getSnmpInASNParseErrs() {
        return new Long(this.snmpInASNParseErrs);
    }

    public Long getSnmpInBadVersions() {
        return new Long(this.snmpInBadVersions);
    }

    public Long getSnmpInvalidMsgs() {
        return new Long(this.snmpInvalidMsgs);
    }

    public Long getSnmpUnknownSecurityModels() {
        return new Long(this.snmpUnknownSecurityModels);
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public SnmpEngineId getEngineId() {
        return this.engine.getEngineId();
    }

    public void close() throws IOException {
        this.enabled(false);
        if (this.dSocket != null) {
            this.dSocket.close();
        }
    }

    private synchronized void incSnmpInBadVersions(int n) {
        this.snmpInBadVersions += n;
    }

    private synchronized void incSnmpInASNParseErrs(int n) {
        this.snmpInASNParseErrs += n;
    }

    private synchronized void incSnmpInPkts(int n) {
        this.snmpInPkts += n;
    }

    private synchronized void incSnmpInInforms(int n) {
        this.snmpInInforms += n;
    }

    private synchronized void incSnmpInTraps(int n) {
        this.snmpInTraps += n;
    }

    private synchronized void incSnmpInvalidMsgs(int n) {
        this.snmpInvalidMsgs += n;
    }

    private synchronized void incSnmpUnknownSecurityModels(int n) {
        this.snmpUnknownSecurityModels += n;
    }

    private synchronized boolean enabled() {
        return this.enabled;
    }

    private synchronized boolean enabled(boolean bl) {
        this.enabled = bl;
        return bl;
    }

    private static SnmpEngine createEngine(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory) throws IllegalArgumentException {
        SnmpEngine snmpEngine;
        if (snmpEngineFactory == null) {
            snmpEngineFactory = new JdmkEngineFactory();
        }
        if (snmpEngineParameters == null) {
            snmpEngineParameters = new SnmpEngineParameters();
        }
        if ((snmpEngine = snmpEngineFactory.createEngine(snmpEngineParameters)) == null) {
            throw new IllegalArgumentException("The factory returned a null lengine. SnmpEventReportDispatcher initilization failed");
        }
        return snmpEngine;
    }

    private final SnmpIncomingRequest getIncomingReq(int n, DatagramPacket datagramPacket) throws SnmpStatusException, SnmpUnknownMsgProcModelException {
        SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = this.engine.getMsgProcessingSubSystem();
        return snmpMsgProcessingSubSystem.getIncomingRequest(n, this.pduFactory);
    }

    private final SnmpPdu decodePdu(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket) throws SnmpStatusException, SnmpUnknownSecModelException, SnmpBadSecurityLevelException {
        snmpIncomingRequest.decodeMessage(datagramPacket.getData(), datagramPacket.getLength(), datagramPacket.getAddress(), datagramPacket.getPort());
        SnmpPdu snmpPdu = null;
        if (!snmpIncomingRequest.isReport()) {
            snmpPdu = snmpIncomingRequest.decodeSnmpPdu();
        }
        return snmpPdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleTrap(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        SnmpPdu snmpPdu2 = snmpPdu;
        this.incSnmpInTraps(1);
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            int n2 = this.trapListeners.size;
            Object[] objectArray = this.trapListeners.list;
            int n3 = 0;
            while (n3 < n2) {
                SnmpTrapListener snmpTrapListener = (SnmpTrapListener)objectArray[n3];
                SnmpEventReportHandler snmpEventReportHandler = new SnmpEventReportHandler(snmpTrapListener, snmpPdu2);
                this.handleCallback(snmpEventReportHandler);
                ++n3;
            }
        }
    }

    private final void acknowledgeInform(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        DatagramPacket datagramPacket2 = this.makeResponsePacket(snmpIncomingRequest, datagramPacket, snmpPdu);
        if (datagramPacket2 == null) {
            return;
        }
        this.sendPacket(datagramPacket2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInform(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        SnmpPdu snmpPdu2 = snmpPdu;
        this.incSnmpInInforms(1);
        this.acknowledgeInform(n, snmpIncomingRequest, datagramPacket, snmpPdu);
        snmpPdu2.type = 166;
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            int n2 = this.informListeners.size;
            Object[] objectArray = this.informListeners.list;
            int n3 = 0;
            while (n3 < n2) {
                SnmpInformListener snmpInformListener = (SnmpInformListener)objectArray[n3];
                SnmpEventReportHandler snmpEventReportHandler = new SnmpEventReportHandler(snmpInformListener, snmpPdu2);
                this.handleCallback(snmpEventReportHandler);
                ++n3;
            }
        }
    }

    private final void sendPacket(DatagramPacket datagramPacket) {
        block10: {
            if (datagramPacket == null) {
                return;
            }
            try {
                if (this.isTraceOn()) {
                    this.trace("run", "Response packet to be sent:\n" + SnmpMsg.dumpHexBuffer(datagramPacket.getData(), 0, datagramPacket.getLength()));
                }
                this.dSocket.send(datagramPacket);
            }
            catch (SocketException socketException) {
                if (this.isDebugOn()) {
                    if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                        this.debug("run", "interrupted");
                    } else {
                        this.debug("run", "i/o exception");
                        this.debug("run", socketException);
                    }
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.isDebugOn()) {
                    this.debug("run", "interrupted");
                }
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block10;
                this.debug("run", "failure when sending response");
                this.debug("run", exception);
            }
        }
    }

    private final void handleV3GetRequest(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        DatagramPacket datagramPacket2;
        if (!snmpIncomingRequest.isReport() && this.isDebugOn()) {
            this.debug("run", "trashed the packet:  no report to send back to received request.");
        }
        if (this.isDebugOn()) {
            this.debug("run", "Received a getRequest, send back the report");
        }
        if ((datagramPacket2 = this.makeResponsePacket(snmpIncomingRequest, datagramPacket, snmpPdu)) == null) {
            return;
        }
        this.sendPacket(datagramPacket2);
    }

    protected void handleCallback(Runnable runnable) {
        runnable.run();
    }

    protected void handlePacket(Runnable runnable) {
        new Thread(runnable).start();
    }

    private final void doHandlePacket(int n, DatagramPacket datagramPacket) {
        try {
            SnmpPdu snmpPdu;
            SnmpIncomingRequest snmpIncomingRequest = this.getIncomingReq(n, datagramPacket);
            try {
                snmpPdu = this.decodePdu(n, snmpIncomingRequest, datagramPacket);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (this.isDebugOn()) {
                    this.debug("handlePacket", "Rejecting trap : " + snmpStatusException);
                }
                this.incSnmpInASNParseErrs(1);
                return;
            }
            if (snmpIncomingRequest.isReport()) {
                DatagramPacket datagramPacket2;
                if (this.isDebugOn()) {
                    this.debug("handlePacket", "Report to send back");
                }
                if ((datagramPacket2 = this.makeResponsePacket(snmpIncomingRequest, datagramPacket, null)) == null) {
                    return;
                }
                this.sendPacket(datagramPacket2);
                return;
            }
            if (snmpPdu.type == 164 || snmpPdu.type == 167) {
                if (this.isTraceOn()) {
                    if (snmpPdu.type == 164) {
                        this.trace("run", "Received an SNMP trap V1");
                    } else {
                        this.trace("run", "Received an SNMP trap V2 or V3");
                    }
                }
                this.handleTrap(n, snmpIncomingRequest, datagramPacket, snmpPdu);
            } else if (snmpPdu.type == 166) {
                if (this.isTraceOn()) {
                    this.trace("run", "Received an Inform Request");
                }
                this.handleInform(n, snmpIncomingRequest, datagramPacket, snmpPdu);
            } else if (snmpPdu.type == 160 && n == 3) {
                if (this.isTraceOn()) {
                    this.trace("run", "Received a V3 Get Request (timeliness discovery)");
                }
                this.handleV3GetRequest(n, snmpIncomingRequest, datagramPacket, snmpPdu);
            } else {
                if (this.isTraceOn()) {
                    this.trace("run", "trashed the packet: bad PDU type.");
                }
                if (this.isDebugOn()) {
                    this.debug("run", "trashed the packet because it's not an SNMP event report or get request (timeliness discovery)");
                }
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            if (this.isDebugOn()) {
                this.debug("run", "Response packet encoding failed " + snmpStatusException);
            }
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (this.isDebugOn()) {
                this.debug("run", "packet decoding failed " + snmpUnknownSecModelException);
            }
            this.incSnmpUnknownSecurityModels(1);
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (this.isDebugOn()) {
                this.debug("run", "Unknown Msg processing model " + snmpUnknownMsgProcModelException);
            }
            this.incSnmpInBadVersions(1);
        }
        catch (SnmpBadSecurityLevelException snmpBadSecurityLevelException) {
            if (this.isDebugOn()) {
                this.debug("run", "Invalid msg, bad security level " + snmpBadSecurityLevelException);
            }
            this.incSnmpInvalidMsgs(1);
        }
    }

    public void run() {
        while (this.enabled()) {
            try {
                byte[] byArray = new byte[SnmpPeer.defaultSnmpRequestPktSize];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, SnmpPeer.defaultSnmpRequestPktSize);
                this.dSocket.setSoTimeout(0);
                if (this.isTraceOn()) {
                    this.trace("run", "Now waiting for event reports...");
                }
                this.dSocket.receive(datagramPacket);
                if (this.isTraceOn()) {
                    this.trace("run", "Received a packet from : " + datagramPacket.getAddress().toString() + ", Length = " + datagramPacket.getLength());
                }
                this.incSnmpInPkts(1);
                int n = SnmpMsg.getProtocolVersion(datagramPacket.getData());
                this.handlePacket(new PacketHandler(n, datagramPacket));
            }
            catch (SnmpStatusException snmpStatusException) {
                if (this.isDebugOn()) {
                    this.debug("run", "packet decoding failed");
                }
                this.incSnmpInASNParseErrs(1);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("run", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrapListener(SnmpTrapListener snmpTrapListener) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            this.trapListeners.add(snmpTrapListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInformListener(SnmpInformListener snmpInformListener) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            this.informListeners.add(snmpInformListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrapListener(SnmpTrapListener snmpTrapListener) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            this.trapListeners.remove(snmpTrapListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInformListener(SnmpInformListener snmpInformListener) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            this.informListeners.remove(snmpInformListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTrapListener(SnmpTrapListener snmpTrapListener) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            boolean bl = this.trapListeners.contains(snmpTrapListener);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsInformListener(SnmpInformListener snmpInformListener) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            boolean bl = this.informListeners.contains(snmpInformListener);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getTrapListeners() {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            Enumeration enumeration = this.trapListeners.elements();
            return enumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInformListeners() {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            Enumeration enumeration = this.informListeners.elements();
            return enumeration;
        }
    }

    public SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public void setPduFactory(SnmpPduFactory snmpPduFactory) {
        if (snmpPduFactory == null) {
            snmpPduFactory = new SnmpPduFactoryBER();
        }
        this.pduFactory = snmpPduFactory;
    }

    private DatagramPacket makeResponsePacket(SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        DatagramPacket datagramPacket2;
        block7: {
            datagramPacket2 = null;
            SnmpMsg snmpMsg = this.makeResponseMessage(snmpIncomingRequest, datagramPacket, snmpPdu);
            try {
                if (snmpIncomingRequest.isReport() || snmpMsg != null) {
                    datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponsePacket", "response message is too big");
                }
                try {
                    SnmpPdu snmpPdu2 = this.newTooBigPdu(snmpPdu);
                    snmpMsg = snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, datagramPacket.getData().length);
                    datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpStatusException snmpStatusException) {
                    throw new InternalError();
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (!this.isDebugOn()) break block7;
                    this.debug("makeResponsePacket", "'too big' is 'too big' !!!");
                }
            }
        }
        return datagramPacket2;
    }

    private SnmpMsg makeResponseMessage(SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        SnmpMsg snmpMsg = null;
        SnmpPdu snmpPdu2 = null;
        if (!snmpIncomingRequest.isReport() && snmpPdu != null) {
            snmpPdu2 = this.makeResponsePdu(snmpPdu);
        }
        if (snmpPdu2 != null) {
            try {
                snmpMsg = snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, datagramPacket.getData().length);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "failure when encoding the response message");
                    this.debug("makeResponseMessage", snmpStatusException);
                }
                snmpMsg = null;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "response message is too big");
                }
                try {
                    snmpPdu2 = this.newTooBigPdu(snmpPdu);
                    snmpMsg = snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, datagramPacket.getData().length);
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (this.isDebugOn()) {
                        this.debug("makeResponseMessage", "'too big' is 'too big' !!!");
                    }
                    snmpMsg = null;
                }
                catch (Exception exception) {
                    snmpMsg = null;
                }
            }
        }
        return snmpMsg;
    }

    private SnmpPdu makeResponsePdu(SnmpPdu snmpPdu) {
        SnmpPdu snmpPdu2 = null;
        if (this.checkPduType(snmpPdu)) {
            snmpPdu2 = snmpPdu;
            snmpPdu2.type = 162;
        }
        return snmpPdu2;
    }

    private boolean checkPduType(SnmpPdu snmpPdu) {
        if (snmpPdu.type == 166) {
            return true;
        }
        if (this.isDebugOn()) {
            this.debug("checkPduType", "cannot respond to this kind of PDU");
        }
        return false;
    }

    private SnmpPdu newTooBigPdu(SnmpPdu snmpPdu) {
        SnmpAckPdu snmpAckPdu = (SnmpAckPdu)((Object)snmpPdu);
        SnmpPdu snmpPdu2 = snmpAckPdu.getResponsePdu();
        snmpPdu2.varBindList = null;
        SnmpPduRequestType snmpPduRequestType = (SnmpPduRequestType)((Object)snmpPdu2);
        snmpPduRequestType.setErrorStatus(1);
        snmpPduRequestType.setErrorIndex(0);
        return snmpPdu2;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    private final class PacketHandler
    implements Runnable {
        private final int version;
        private final DatagramPacket packet;

        PacketHandler(int n, DatagramPacket datagramPacket) {
            this.version = n;
            this.packet = datagramPacket;
        }

        public void run() {
            block2: {
                try {
                    SnmpEventReportDispatcher.this.doHandlePacket(this.version, this.packet);
                }
                catch (Exception exception) {
                    if (!SnmpEventReportDispatcher.this.isDebugOn()) break block2;
                    SnmpEventReportDispatcher.this.debug("Unexpected exception, failed to handle packet: ", exception);
                }
            }
        }
    }

    private static class ObjectList {
        public static int DEFAULT_CAPACITY = 10;
        public static int DEFAULT_INCREMENT = 10;
        private final int DELTA;
        private int size = 0;
        public Object[] list;

        ObjectList() {
            this(DEFAULT_CAPACITY, DEFAULT_INCREMENT);
        }

        ObjectList(int n) {
            this(n, DEFAULT_INCREMENT);
        }

        ObjectList(int n, int n2) {
            this.DELTA = n2;
            this.list = this.allocate(n);
        }

        public final int size() {
            return this.size;
        }

        public final boolean add(Object object) {
            if (object == null) {
                return false;
            }
            if (this.size >= this.list.length) {
                this.resize();
            }
            this.list[this.size++] = object;
            return true;
        }

        public final void add(int n, Object object) {
            if (n > this.size) {
                throw new IndexOutOfBoundsException();
            }
            if (n >= this.list.length) {
                this.resize();
            }
            if (n == this.size) {
                this.list[this.size++] = object;
                return;
            }
            System.arraycopy(this.list, n, this.list, n + 1, this.size - n);
            this.list[n] = object;
            ++this.size;
        }

        public final boolean remove(Object object) {
            if (object == null) {
                return false;
            }
            int n = this.size;
            Object[] objectArray = this.list;
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2] == object) {
                    this.remove(n2);
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public final Object remove(int n) {
            if (n >= this.size) {
                return null;
            }
            Object object = this.list[n];
            this.list[n] = null;
            if (n == --this.size) {
                return object;
            }
            System.arraycopy(this.list, n + 1, this.list, n, this.size - n);
            return object;
        }

        public final int indexOf(Object object) {
            if (object == null) {
                return -1;
            }
            int n = this.size;
            Object[] objectArray = this.list;
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2] == object) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public final boolean contains(Object object) {
            return this.indexOf(object) > -1;
        }

        public final java.util.Enumeration elements() {
            return new Enumeration();
        }

        private final void resize() {
            Object[] objectArray = this.allocate(this.list.length + this.DELTA);
            System.arraycopy(this.list, 0, objectArray, 0, this.size);
            this.list = objectArray;
        }

        private final Object[] allocate(int n) {
            return new Object[n];
        }

        private final class Enumeration
        implements java.util.Enumeration {
            private int next = 0;

            private Enumeration() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasMoreElements() {
                ObjectList objectList = ObjectList.this;
                synchronized (objectList) {
                    boolean bl = this.next < ObjectList.this.size();
                    return bl;
                }
            }

            public Object nextElement() {
                ObjectList objectList = ObjectList.this;
                synchronized (objectList) {
                    block4: {
                        if (this.next >= ObjectList.this.size()) break block4;
                        Object object = ObjectList.this.list[this.next++];
                        return object;
                    }
                    throw new NoSuchElementException();
                }
            }
        }
    }
}

