/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp;

import com.sun.jdmk.UnsignedLong;
import java.net.InetAddress;
import java.util.Vector;
import javax.management.snmp.BerDecoder;
import javax.management.snmp.BerEncoder;
import javax.management.snmp.BerException;
import javax.management.snmp.SnmpCounter;
import javax.management.snmp.SnmpCounter64;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpGauge;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpIpAddress;
import javax.management.snmp.SnmpNull;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOpaque;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpSecurityParameters;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpTimeticks;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public abstract class SnmpMsg
implements SnmpDefinitions {
    public int version = 0;
    public byte[] data = null;
    public int dataLength = 0;
    public InetAddress address = null;
    public int port = 0;
    public SnmpSecurityParameters securityParameters = null;

    public static int getProtocolVersion(byte[] byArray) throws SnmpStatusException {
        int n = 0;
        BerDecoder berDecoder = null;
        try {
            berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            n = berDecoder.fetchInteger();
        }
        catch (BerException berException) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            // empty catch block
        }
        return n;
    }

    public abstract int getRequestId(byte[] var1) throws SnmpStatusException;

    public abstract int encodeMessage(byte[] var1) throws SnmpTooBigException;

    public abstract void decodeMessage(byte[] var1, int var2) throws SnmpStatusException;

    public abstract void encodeSnmpPdu(SnmpPdu var1, int var2) throws SnmpStatusException, SnmpTooBigException;

    public abstract SnmpPdu decodeSnmpPdu() throws SnmpStatusException;

    public static String dumpHexBuffer(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 << 1);
        int n3 = 1;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            int n6 = byArray[n5] & 0xFF;
            stringBuffer.append(Character.forDigit(n6 >>> 4, 16));
            stringBuffer.append(Character.forDigit(n6 & 0xF, 16));
            if (++n3 % 16 == 0) {
                stringBuffer.append('\n');
                n3 = 1;
            } else {
                stringBuffer.append(' ');
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    public String printMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: ");
        stringBuffer.append(this.version);
        stringBuffer.append("\n");
        if (this.data == null) {
            stringBuffer.append("Data: null");
        } else {
            stringBuffer.append("Data: {\n");
            stringBuffer.append(SnmpMsg.dumpHexBuffer(this.data, 0, this.dataLength));
            stringBuffer.append("\n}\n");
        }
        return stringBuffer.toString();
    }

    public void encodeVarBindList(BerEncoder berEncoder, SnmpVarBind[] snmpVarBindArray) throws SnmpStatusException, SnmpTooBigException {
        int n = 0;
        try {
            berEncoder.openSequence();
            if (snmpVarBindArray != null) {
                int n2 = snmpVarBindArray.length - 1;
                while (n2 >= 0) {
                    SnmpVarBind snmpVarBind = snmpVarBindArray[n2];
                    if (snmpVarBind != null) {
                        berEncoder.openSequence();
                        this.encodeVarBindValue(berEncoder, snmpVarBind.value);
                        berEncoder.putOid(snmpVarBind.oid.longValue());
                        berEncoder.closeSequence();
                        ++n;
                    }
                    --n2;
                }
            }
            berEncoder.closeSequence();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException(n);
        }
    }

    void encodeVarBindValue(BerEncoder berEncoder, SnmpValue snmpValue) throws SnmpStatusException {
        if (snmpValue == null) {
            berEncoder.putNull();
        } else if (snmpValue instanceof SnmpIpAddress) {
            berEncoder.putOctetString(((SnmpIpAddress)snmpValue).byteValue(), 64);
        } else if (snmpValue instanceof SnmpCounter) {
            berEncoder.putInteger(((SnmpCounter)snmpValue).longValue(), 65);
        } else if (snmpValue instanceof SnmpGauge) {
            berEncoder.putInteger(((SnmpGauge)snmpValue).longValue(), 66);
        } else if (snmpValue instanceof SnmpTimeticks) {
            berEncoder.putInteger(((SnmpTimeticks)snmpValue).longValue(), 67);
        } else if (snmpValue instanceof SnmpOpaque) {
            berEncoder.putOctetString(((SnmpOpaque)snmpValue).byteValue(), 68);
        } else if (snmpValue instanceof SnmpInt) {
            berEncoder.putInteger(((SnmpInt)snmpValue).intValue());
        } else if (snmpValue instanceof SnmpString) {
            berEncoder.putOctetString(((SnmpString)snmpValue).byteValue());
        } else if (snmpValue instanceof SnmpOid) {
            berEncoder.putOid(((SnmpOid)snmpValue).longValue());
        } else if (snmpValue instanceof SnmpCounter64) {
            if (this.version == 0) {
                throw new SnmpStatusException("Invalid value for SNMP v1 : " + snmpValue);
            }
            berEncoder.putUnsignedLong(((SnmpCounter64)snmpValue).longValue(), 70);
        } else if (snmpValue instanceof SnmpNull) {
            int n = ((SnmpNull)snmpValue).getTag();
            if (this.version == 0 && n != 5) {
                throw new SnmpStatusException("Invalid value for SNMP v1 : " + snmpValue);
            }
            if (this.version == 1 && n != 5 && n != 128 && n != 129 && n != 130) {
                throw new SnmpStatusException("Invalid value " + snmpValue);
            }
            berEncoder.putNull(n);
        } else {
            throw new SnmpStatusException("Invalid value " + snmpValue);
        }
    }

    public SnmpVarBind[] decodeVarBindList(BerDecoder berDecoder) throws BerException {
        Object[] objectArray;
        berDecoder.openSequence();
        Vector<Object[]> vector = new Vector<Object[]>();
        while (berDecoder.cannotCloseSequence()) {
            objectArray = new SnmpVarBind();
            berDecoder.openSequence();
            objectArray.oid = new SnmpOid(berDecoder.fetchOid());
            objectArray.setSnmpValue(this.decodeVarBindValue(berDecoder));
            berDecoder.closeSequence();
            vector.addElement(objectArray);
        }
        berDecoder.closeSequence();
        objectArray = new SnmpVarBind[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    SnmpValue decodeVarBindValue(BerDecoder berDecoder) throws BerException {
        SnmpValue snmpValue = null;
        int n = berDecoder.getTag();
        switch (n) {
            case 2: {
                try {
                    snmpValue = new SnmpInt(berDecoder.fetchInteger());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 4: {
                try {
                    snmpValue = new SnmpString(berDecoder.fetchOctetString());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 6: {
                try {
                    snmpValue = new SnmpOid(berDecoder.fetchOid());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 5: {
                berDecoder.fetchNull();
                try {
                    snmpValue = new SnmpNull();
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 64: {
                try {
                    snmpValue = new SnmpIpAddress(berDecoder.fetchOctetString(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 65: {
                try {
                    snmpValue = new SnmpCounter(berDecoder.fetchIntegerAsLong(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 66: {
                try {
                    snmpValue = new SnmpGauge(berDecoder.fetchIntegerAsLong(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 67: {
                try {
                    snmpValue = new SnmpTimeticks(berDecoder.fetchIntegerAsLong(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 68: {
                try {
                    snmpValue = new SnmpOpaque(berDecoder.fetchOctetString(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 70: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                try {
                    snmpValue = new SnmpCounter64(UnsignedLong.make((long)berDecoder.fetchIntegerAsLong(n)));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 128: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                berDecoder.fetchNull(n);
                snmpValue = SnmpVarBind.noSuchObject;
                break;
            }
            case 129: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                berDecoder.fetchNull(n);
                snmpValue = SnmpVarBind.noSuchInstance;
                break;
            }
            case 130: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                berDecoder.fetchNull(n);
                snmpValue = SnmpVarBind.endOfMibView;
                break;
            }
            default: {
                throw new BerException();
            }
        }
        return snmpValue;
    }
}

